/*****************************************************************************
* SPSSload_KID_2022_Core.SPS
* This program will load the KID_2022_Core ASCII File into SPSS.
* Created on 11/07/2024.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2022_Core.ASC' FIXED / 
    HOSP_KID                    1-   5
    RECNUM                      6-  13
    AGE                        14-  16
    AGE_NEONATE                17-  18
    AMONTH                     19-  20
    AWEEKEND                   21-  22
    DIED                       23-  24
    DISCWT                     25-  35
    DISPUNIFORM                36-  37
    DQTR                       38-  39
    DRG                        40-  42
    DRGVER                     43-  44
    DRG_NoPOA                  45-  47
    ELECTIVE                   48-  49
    FEMALE                     50-  51
    HCUP_ED                    52-  54
    HOSP_REGION                55-  56
    I10_BIRTH                  57-  59
    I10_DELIVERY               60-  62
    I10_DX1                    63-  69 (A)
    I10_DX2                    70-  76 (A)
    I10_DX3                    77-  83 (A)
    I10_DX4                    84-  90 (A)
    I10_DX5                    91-  97 (A)
    I10_DX6                    98- 104 (A)
    I10_DX7                   105- 111 (A)
    I10_DX8                   112- 118 (A)
    I10_DX9                   119- 125 (A)
    I10_DX10                  126- 132 (A)
    I10_DX11                  133- 139 (A)
    I10_DX12                  140- 146 (A)
    I10_DX13                  147- 153 (A)
    I10_DX14                  154- 160 (A)
    I10_DX15                  161- 167 (A)
    I10_DX16                  168- 174 (A)
    I10_DX17                  175- 181 (A)
    I10_DX18                  182- 188 (A)
    I10_DX19                  189- 195 (A)
    I10_DX20                  196- 202 (A)
    I10_DX21                  203- 209 (A)
    I10_DX22                  210- 216 (A)
    I10_DX23                  217- 223 (A)
    I10_DX24                  224- 230 (A)
    I10_DX25                  231- 237 (A)
    I10_DX26                  238- 244 (A)
    I10_DX27                  245- 251 (A)
    I10_DX28                  252- 258 (A)
    I10_DX29                  259- 265 (A)
    I10_DX30                  266- 272 (A)
    I10_DX31                  273- 279 (A)
    I10_DX32                  280- 286 (A)
    I10_DX33                  287- 293 (A)
    I10_DX34                  294- 300 (A)
    I10_DX35                  301- 307 (A)
    I10_DX36                  308- 314 (A)
    I10_DX37                  315- 321 (A)
    I10_DX38                  322- 328 (A)
    I10_DX39                  329- 335 (A)
    I10_DX40                  336- 342 (A)
    I10_HOSPBRTH              343- 344
    I10_INJURY                345- 346
    I10_MULTINJURY            347- 348
    I10_NDX                   349- 350
    I10_NPR                   351- 352
    I10_PR1                   353- 359 (A)
    I10_PR2                   360- 366 (A)
    I10_PR3                   367- 373 (A)
    I10_PR4                   374- 380 (A)
    I10_PR5                   381- 387 (A)
    I10_PR6                   388- 394 (A)
    I10_PR7                   395- 401 (A)
    I10_PR8                   402- 408 (A)
    I10_PR9                   409- 415 (A)
    I10_PR10                  416- 422 (A)
    I10_PR11                  423- 429 (A)
    I10_PR12                  430- 436 (A)
    I10_PR13                  437- 443 (A)
    I10_PR14                  444- 450 (A)
    I10_PR15                  451- 457 (A)
    I10_PR16                  458- 464 (A)
    I10_PR17                  465- 471 (A)
    I10_PR18                  472- 478 (A)
    I10_PR19                  479- 485 (A)
    I10_PR20                  486- 492 (A)
    I10_PR21                  493- 499 (A)
    I10_PR22                  500- 506 (A)
    I10_PR23                  507- 513 (A)
    I10_PR24                  514- 520 (A)
    I10_PR25                  521- 527 (A)
    I10_SERVICELINE           528- 530
    I10_UNCBRTH               531- 532
    KID_STRATUM               533- 536
    LOS                       537- 541
    MDC                       542- 543
    MDC_NoPOA                 544- 545
    PAY1                      546- 547
    PCLASS_ORPROC             548- 549
    PL_NCHS                   550- 552
    PRDAY1                    553- 555
    PRDAY2                    556- 558
    PRDAY3                    559- 561
    PRDAY4                    562- 564
    PRDAY5                    565- 567
    PRDAY6                    568- 570
    PRDAY7                    571- 573
    PRDAY8                    574- 576
    PRDAY9                    577- 579
    PRDAY10                   580- 582
    PRDAY11                   583- 585
    PRDAY12                   586- 588
    PRDAY13                   589- 591
    PRDAY14                   592- 594
    PRDAY15                   595- 597
    PRDAY16                   598- 600
    PRDAY17                   601- 603
    PRDAY18                   604- 606
    PRDAY19                   607- 609
    PRDAY20                   610- 612
    PRDAY21                   613- 615
    PRDAY22                   616- 618
    PRDAY23                   619- 621
    PRDAY24                   622- 624
    PRDAY25                   625- 627
    RACE                      628- 629
    TOTCHG                    630- 639
    TRAN_IN                   640- 641
    TRAN_OUT                  642- 643
    YEAR                      644- 647
    ZIPINC_QRTL               648- 649.

***  Specify write formats  ***.
FORMATS
    HOSP_KID                 (F5.0) /
    RECNUM                   (F8.0) /
    AGE                      (F3.0) /
    AGE_NEONATE              (F2.0) /
    AMONTH                   (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DRG                      (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    ELECTIVE                 (F2.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSP_REGION              (F2.0) /
    I10_BIRTH                (F3.0) /
    I10_DELIVERY             (F3.0) /
    I10_HOSPBRTH             (F2.0) /
    I10_INJURY               (F2.0) /
    I10_MULTINJURY           (F2.0) /
    I10_NDX                  (F2.0) /
    I10_NPR                  (F2.0) /
    I10_SERVICELINE          (F3.0) /
    I10_UNCBRTH              (F2.0) /
    KID_STRATUM              (F4.0) /
    LOS                      (F5.0) /
    MDC                      (F2.0) /
    MDC_NoPOA                (F2.0) /
    PAY1                     (F2.0) /
    PCLASS_ORPROC            (F2.0) /
    PL_NCHS                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    PRDAY16                  (F3.0) /
    PRDAY17                  (F3.0) /
    PRDAY18                  (F3.0) /
    PRDAY19                  (F3.0) /
    PRDAY20                  (F3.0) /
    PRDAY21                  (F3.0) /
    PRDAY22                  (F3.0) /
    PRDAY23                  (F3.0) /
    PRDAY24                  (F3.0) /
    PRDAY25                  (F3.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TRAN_IN                  (F2.0) /
    TRAN_OUT                 (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_KID                 "KID hospital number"
    RECNUM                   "KID record number"
    AGE                      "Age in years at admission"
    AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "KID discharge weight"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    ELECTIVE                 "Elective versus non-elective admission"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSP_REGION              "Region of hospital"
    I10_BIRTH                "ICD-10-CM Birth Indicator"
    I10_DELIVERY             "ICD-10-CM Delivery Indicator"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_DX31                 "ICD-10-CM Diagnosis 31"
    I10_DX32                 "ICD-10-CM Diagnosis 32"
    I10_DX33                 "ICD-10-CM Diagnosis 33"
    I10_DX34                 "ICD-10-CM Diagnosis 34"
    I10_DX35                 "ICD-10-CM Diagnosis 35"
    I10_DX36                 "ICD-10-CM Diagnosis 36"
    I10_DX37                 "ICD-10-CM Diagnosis 37"
    I10_DX38                 "ICD-10-CM Diagnosis 38"
    I10_DX39                 "ICD-10-CM Diagnosis 39"
    I10_DX40                 "ICD-10-CM Diagnosis 40"
    I10_HOSPBRTH             "ICD-10-CM Indicator of birth in this hospital"
    I10_INJURY
    "Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)"
    I10_MULTINJURY           "Multiple ICD-10-CM injuries reported on record"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NPR                  "ICD-10-PCS Number of procedures on this record"
    I10_PR1                  "ICD-10-PCS Procedure 1"
    I10_PR2                  "ICD-10-PCS Procedure 2"
    I10_PR3                  "ICD-10-PCS Procedure 3"
    I10_PR4                  "ICD-10-PCS Procedure 4"
    I10_PR5                  "ICD-10-PCS Procedure 5"
    I10_PR6                  "ICD-10-PCS Procedure 6"
    I10_PR7                  "ICD-10-PCS Procedure 7"
    I10_PR8                  "ICD-10-PCS Procedure 8"
    I10_PR9                  "ICD-10-PCS Procedure 9"
    I10_PR10                 "ICD-10-PCS Procedure 10"
    I10_PR11                 "ICD-10-PCS Procedure 11"
    I10_PR12                 "ICD-10-PCS Procedure 12"
    I10_PR13                 "ICD-10-PCS Procedure 13"
    I10_PR14                 "ICD-10-PCS Procedure 14"
    I10_PR15                 "ICD-10-PCS Procedure 15"
    I10_PR16                 "ICD-10-PCS Procedure 16"
    I10_PR17                 "ICD-10-PCS Procedure 17"
    I10_PR18                 "ICD-10-PCS Procedure 18"
    I10_PR19                 "ICD-10-PCS Procedure 19"
    I10_PR20                 "ICD-10-PCS Procedure 20"
    I10_PR21                 "ICD-10-PCS Procedure 21"
    I10_PR22                 "ICD-10-PCS Procedure 22"
    I10_PR23                 "ICD-10-PCS Procedure 23"
    I10_PR24                 "ICD-10-PCS Procedure 24"
    I10_PR25                 "ICD-10-PCS Procedure 25"
    I10_SERVICELINE          "ICD-10-CM/PCS Hospital Service Line"
    I10_UNCBRTH              "ICD-10-CM Indicator of normal newborn born in hospital"
    KID_STRATUM              "Stratum used to sample hospital"
    LOS                      "Length of stay (cleaned)"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    PAY1                     "Primary expected payer (uniform)"
    PCLASS_ORPROC            "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    PRDAY1                   "Number of days from admission to I10_PR1"
    PRDAY2                   "Number of days from admission to I10_PR2"
    PRDAY3                   "Number of days from admission to I10_PR3"
    PRDAY4                   "Number of days from admission to I10_PR4"
    PRDAY5                   "Number of days from admission to I10_PR5"
    PRDAY6                   "Number of days from admission to I10_PR6"
    PRDAY7                   "Number of days from admission to I10_PR7"
    PRDAY8                   "Number of days from admission to I10_PR8"
    PRDAY9                   "Number of days from admission to I10_PR9"
    PRDAY10                  "Number of days from admission to I10_PR10"
    PRDAY11                  "Number of days from admission to I10_PR11"
    PRDAY12                  "Number of days from admission to I10_PR12"
    PRDAY13                  "Number of days from admission to I10_PR13"
    PRDAY14                  "Number of days from admission to I10_PR14"
    PRDAY15                  "Number of days from admission to I10_PR15"
    PRDAY16                  "Number of days from admission to I10_PR16"
    PRDAY17                  "Number of days from admission to I10_PR17"
    PRDAY18                  "Number of days from admission to I10_PR18"
    PRDAY19                  "Number of days from admission to I10_PR19"
    PRDAY20                  "Number of days from admission to I10_PR20"
    PRDAY21                  "Number of days from admission to I10_PR21"
    PRDAY22                  "Number of days from admission to I10_PR22"
    PRDAY23                  "Number of days from admission to I10_PR23"
    PRDAY24                  "Number of days from admission to I10_PR24"
    PRDAY25                  "Number of days from admission to I10_PR25"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TRAN_IN                  "Transfer in indicator"
    TRAN_OUT                 "Transfer out indicator"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE HOSP_KID                 (-9999 -8888 -6666=SYSMIS).
RECODE RECNUM                   (-9999999 -8888888 -6666666=SYSMIS).
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGE_NEONATE              (-9 -8 -6 -5=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE I10_BIRTH                (-99 -88 -66=SYSMIS).
RECODE I10_DELIVERY             (-99 -88 -66=SYSMIS).
RECODE I10_HOSPBRTH             (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY               (-9 -8 -6 -5=SYSMIS).
RECODE I10_MULTINJURY           (-9 -8 -6 -5=SYSMIS).
RECODE I10_NDX                  (-9 -8 -6 -5=SYSMIS).
RECODE I10_NPR                  (-9 -8 -6 -5=SYSMIS).
RECODE I10_SERVICELINE          (-99 -88 -66=SYSMIS).
RECODE I10_UNCBRTH              (-9 -8 -6 -5=SYSMIS).
RECODE KID_STRATUM              (-999 -888 -666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PCLASS_ORPROC            (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY16                  (-99 -88 -66=SYSMIS).
RECODE PRDAY17                  (-99 -88 -66=SYSMIS).
RECODE PRDAY18                  (-99 -88 -66=SYSMIS).
RECODE PRDAY19                  (-99 -88 -66=SYSMIS).
RECODE PRDAY20                  (-99 -88 -66=SYSMIS).
RECODE PRDAY21                  (-99 -88 -66=SYSMIS).
RECODE PRDAY22                  (-99 -88 -66=SYSMIS).
RECODE PRDAY23                  (-99 -88 -66=SYSMIS).
RECODE PRDAY24                  (-99 -88 -66=SYSMIS).
RECODE PRDAY25                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE TRAN_OUT                 (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'KID_2022_Core.SAV' / COMPRESSED.
