/*****************************************************************************
* SASload_NEDS_2006_ED.SAS
* This program will load the 2006 NEDS csv ED File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA NEDS_2006_ED; 
INFILE 'NEDS_2006_ED.csv' dsd dlm=',' LRECL = 253 ;                                                                                                                                                                                                    

*** Define data element attributes ***;
ATTRIB 
  DISCWT                     LENGTH=8
  LABEL="Weight to ED Visits in AHA universe"

  HCUPFILE                   LENGTH=$4
  LABEL="Source of HCUP Record (SID or SEDD)"

  HOSP_ED                    LENGTH=4            FORMAT=Z5.
  LABEL="HCUP ED hospital identifier"

  KEY_ED                     LENGTH=8            FORMAT=Z14.
  LABEL="HCUP NEDS record identifier"

  CPT1                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 1"

  CPT2                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 2"

  CPT3                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 3"

  CPT4                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 4"

  CPT5                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 5"

  CPT6                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 6"

  CPT7                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 7"

  CPT8                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 8"

  CPT9                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 9"

  CPT10                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 10"

  CPT11                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 11"

  CPT12                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 12"

  CPT13                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 13"

  CPT14                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 14"

  CPT15                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 15"

  NCPT                       LENGTH=3
  LABEL="Number of CPT/HCPCS procedures on this record"

  NPR_ED                     LENGTH=3
  LABEL="Number of procedures from ED"

  PCLASS_ED1                 LENGTH=3
  LABEL="Principal procedure class for ED procedure"

  PCLASS_ED2                 LENGTH=3
  LABEL="Procedure class 2 for ED procedure"

  PCLASS_ED3                 LENGTH=3
  LABEL="Procedure class 3 for ED procedure"

  PCLASS_ED4                 LENGTH=3
  LABEL="Procedure class 4 for ED procedure"

  PCLASS_ED5                 LENGTH=3
  LABEL="Procedure class 5 for ED procedure"

  PCLASS_ED6                 LENGTH=3
  LABEL="Procedure class 6 for ED procedure"

  PCLASS_ED7                 LENGTH=3
  LABEL="Procedure class 7 for ED procedure"

  PCLASS_ED8                 LENGTH=3
  LABEL="Procedure class 8 for ED procedure"

  PCLASS_ED9                 LENGTH=3
  LABEL="Procedure class 9 for ED procedure"

  PR_ED1                     LENGTH=$4
  LABEL="Principal procedure from ED"

  PR_ED2                     LENGTH=$4
  LABEL="Procedure 2 from ED"

  PR_ED3                     LENGTH=$4
  LABEL="Procedure 3 from ED"

  PR_ED4                     LENGTH=$4
  LABEL="Procedure 4 from ED"

  PR_ED5                     LENGTH=$4
  LABEL="Procedure 5 from ED"

  PR_ED6                     LENGTH=$4
  LABEL="Procedure 6 from ED"

  PR_ED7                     LENGTH=$4
  LABEL="Procedure 7 from ED"

  PR_ED8                     LENGTH=$4
  LABEL="Procedure 8 from ED"

  PR_ED9                     LENGTH=$4
  LABEL="Procedure 9 from ED"

  PRCCS_ED1                  LENGTH=3
  LABEL="CCS: principal procedure from ED"

  PRCCS_ED2                  LENGTH=3
  LABEL="CCS: procedure 2 from ED"

  PRCCS_ED3                  LENGTH=3
  LABEL="CCS: procedure 3 from ED"

  PRCCS_ED4                  LENGTH=3
  LABEL="CCS: procedure 4 from ED"

  PRCCS_ED5                  LENGTH=3
  LABEL="CCS: procedure 5 from ED"

  PRCCS_ED6                  LENGTH=3
  LABEL="CCS: procedure 6 from ED"

  PRCCS_ED7                  LENGTH=3
  LABEL="CCS: procedure 7 from ED"

  PRCCS_ED8                  LENGTH=3
  LABEL="CCS: procedure 8 from ED"

  PRCCS_ED9                  LENGTH=3
  LABEL="CCS: procedure 9 from ED"
  ;

*** Read data elements from the CSV file ***;
INPUT 
      DISCWT                   :N11P7F.
      HCUPFILE                 :$CHAR4.
      HOSP_ED                  :5.
      KEY_ED                   :16.
      CPT1                     :$CHAR5.
      CPT2                     :$CHAR5.
      CPT3                     :$CHAR5.
      CPT4                     :$CHAR5.
      CPT5                     :$CHAR5.
      CPT6                     :$CHAR5.
      CPT7                     :$CHAR5.
      CPT8                     :$CHAR5.
      CPT9                     :$CHAR5.
      CPT10                    :$CHAR5.
      CPT11                    :$CHAR5.
      CPT12                    :$CHAR5.
      CPT13                    :$CHAR5.
      CPT14                    :$CHAR5.
      CPT15                    :$CHAR5.
      NCPT                     :N2PF.
      NPR_ED                   :N2PF.
      PCLASS_ED1               :N3PF.
      PCLASS_ED2               :N3PF.
      PCLASS_ED3               :N3PF.
      PCLASS_ED4               :N3PF.
      PCLASS_ED5               :N3PF.
      PCLASS_ED6               :N3PF.
      PCLASS_ED7               :N3PF.
      PCLASS_ED8               :N3PF.
      PCLASS_ED9               :N3PF.
      PR_ED1                   :$CHAR4.
      PR_ED2                   :$CHAR4.
      PR_ED3                   :$CHAR4.
      PR_ED4                   :$CHAR4.
      PR_ED5                   :$CHAR4.
      PR_ED6                   :$CHAR4.
      PR_ED7                   :$CHAR4.
      PR_ED8                   :$CHAR4.
      PR_ED9                   :$CHAR4.
      PRCCS_ED1                :N3PF.
      PRCCS_ED2                :N3PF.
      PRCCS_ED3                :N3PF.
      PRCCS_ED4                :N3PF.
      PRCCS_ED5                :N3PF.
      PRCCS_ED6                :N3PF.
      PRCCS_ED7                :N3PF.
      PRCCS_ED8                :N3PF.
      PRCCS_ED9                :N3PF.
      ;
RUN;
