/*****************************************************************************/
/* SPSSload_NEDS_2016_Core.SPS                                          */
/* This program will load the NEDS 2016 Core csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2016_Core.csv"
    /delimiters = ',' 
    /variables = 
    AGE                      F3.0
    AMONTH                   F2.0
    AWEEKEND                 F2.0
    DIED_VISIT               F2.0
    DISCWT                   F11.7
    DISP_ED                  F2.0
    DQTR                     F2.0
    DXVER                    F2.0
    EDEVENT                  F2.0
    FEMALE                   F2.0
    HCUPFILE                 A4
    HOSP_ED                  F5.0
    I10_DX1                  A7
    I10_DX2                  A7
    I10_DX3                  A7
    I10_DX4                  A7
    I10_DX5                  A7
    I10_DX6                  A7
    I10_DX7                  A7
    I10_DX8                  A7
    I10_DX9                  A7
    I10_DX10                 A7
    I10_DX11                 A7
    I10_DX12                 A7
    I10_DX13                 A7
    I10_DX14                 A7
    I10_DX15                 A7
    I10_DX16                 A7
    I10_DX17                 A7
    I10_DX18                 A7
    I10_DX19                 A7
    I10_DX20                 A7
    I10_DX21                 A7
    I10_DX22                 A7
    I10_DX23                 A7
    I10_DX24                 A7
    I10_DX25                 A7
    I10_DX26                 A7
    I10_DX27                 A7
    I10_DX28                 A7
    I10_DX29                 A7
    I10_DX30                 A7
    I10_ECAUSE1              A7
    I10_ECAUSE2              A7
    I10_ECAUSE3              A7
    I10_ECAUSE4              A7
    I10_NDX                  F3.0
    I10_NECAUSE              F3.0
    KEY_ED                   F16.0
    NEDS_STRATUM             F5.0
    PAY1                     F2.0
    PAY2                     F2.0
    PL_NCHS                  F3.0
    TOTCHG_ED                F12.2
    YEAR                     F4.0
    ZIPINC_QRTL              F2.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED_VISIT               "Died in the ED (1), Died in the hospital (2), did not die (0)"
    DISCWT                   "Weight to ED Visits in AHA universe"
    DISP_ED                  "Disposition of patient (uniform) from ED"
    DQTR                     "Discharge quarter"
    DXVER                    "Diagnosis Version"
    EDEVENT                  "Type of ED Event"
    FEMALE                   "Indicator of sex"
    HCUPFILE                 "Source of HCUP Record (SID or SEDD)"
    HOSP_ED                  "HCUP ED hospital identifier"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_ECAUSE1              "ICD-10-CM E Cause 1"
    I10_ECAUSE2              "ICD-10-CM E Cause 2"
    I10_ECAUSE3              "ICD-10-CM E Cause 3"
    I10_ECAUSE4              "ICD-10-CM E Cause 4"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NECAUSE              "ICD-10-CM Number of E Causes on this record"
    KEY_ED                   "HCUP NEDS record identifier"
    NEDS_STRATUM             "Stratum used to sample hospital"
    PAY1                     "Primary expected payer (uniform)"
    PAY2                     "Secondary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    TOTCHG_ED                "Total charge for ED services"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

/* Convert special values to system missing values */
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED_VISIT               (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISP_ED                  (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DXVER                    (-9 -8 -6 -5=SYSMIS).
RECODE EDEVENT                  (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE I10_NDX                  (-99 -88 -66=SYSMIS).
RECODE I10_NECAUSE              (-99 -88 -66=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE NEDS_STRATUM             (-9999 -8888 -6666=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE TOTCHG_ED                (-99999999.99 -88888888.88 -66666666.66=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NEDS_2016_Core.SAV' / COMPRESSED.
