/*****************************************************************************
* Stataload_NEDS_2006_IP.Do
* This program will load the 2006 NEDS CSV IP File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the csv file ***
insheet      DISCWT                              ///
             HCUPFILE                            ///
             HOSP_ED                             ///
             KEY_ED                              ///
             DISP_IP                             ///
             DRG                                 ///
             DRGVER                              ///
             LOS_IP                              ///
             MDC                                 ///
             NPR_IP                              ///
             PCLS_IP1                            ///
             PCLS_IP2                            ///
             PCLS_IP3                            ///
             PCLS_IP4                            ///
             PCLS_IP5                            ///
             PCLS_IP6                            ///
             PCLS_IP7                            ///
             PCLS_IP8                            ///
             PCLS_IP9                            ///
             PR_IP1                              ///
             PR_IP2                              ///
             PR_IP3                              ///
             PR_IP4                              ///
             PR_IP5                              ///
             PR_IP6                              ///
             PR_IP7                              ///
             PR_IP8                              ///
             PR_IP9                              ///
             PRCCSIP1                            ///
             PRCCSIP2                            ///
             PRCCSIP3                            ///
             PRCCSIP4                            ///
             PRCCSIP5                            ///
             PRCCSIP6                            ///
             PRCCSIP7                            ///
             PRCCSIP8                            ///
             PRCCSIP9                            ///
             TOTCHGIP                            ///
      using  "NEDS_2006_IP.csv"

***  Assign labels to the data elements ***
label var discwt                   "Weight to ED Visits in AHA universe"
label var hcupfile                 "Source of HCUP Record (SID or SEDD)"
label var hosp_ed                  "HCUP ED hospital identifier"
label var key_ed                   "HCUP NEDS record identifier"
label var disp_ip                  "Disposition of patient (uniform) from IP"
label var drg                      "DRG in effect on discharge date"
label var drgver                   "DRG grouper version used on discharge date"
label var los_ip                   "Length of stay (cleaned) from IP"
label var mdc                      "MDC in effect on discharge date"
label var npr_ip                   "Number of procedures from inpatient discharge record"
label var pcls_ip1                 "Principal procedure class for inpatient procedure"
label var pcls_ip2                 "Procedure class 2 for inpatient procedure"
label var pcls_ip3                 "Procedure class 3 for inpatient procedure"
label var pcls_ip4                 "Procedure class 4 for inpatient procedure"
label var pcls_ip5                 "Procedure class 5 for inpatient procedure"
label var pcls_ip6                 "Procedure class 6 for inpatient procedure"
label var pcls_ip7                 "Procedure class 7 for inpatient procedure"
label var pcls_ip8                 "Procedure class 8 for inpatient procedure"
label var pcls_ip9                 "Procedure class 9 for inpatient procedure"
label var pr_ip1                   "Principal procedure from inpatient discharge record"
label var pr_ip2                   "Procedure 2 from inpatient discharge record"
label var pr_ip3                   "Procedure 3 from inpatient discharge record"
label var pr_ip4                   "Procedure 4 from inpatient discharge record"
label var pr_ip5                   "Procedure 5 from inpatient discharge record"
label var pr_ip6                   "Procedure 6 from inpatient discharge record"
label var pr_ip7                   "Procedure 7 from inpatient discharge record"
label var pr_ip8                   "Procedure 8 from inpatient discharge record"
label var pr_ip9                   "Procedure 9 from inpatient discharge record"
label var prccsip1                 "CCS: principal procedure from inpatient discharge record"
label var prccsip2                 "CCS: procedure 2 from inpatient discharge record"
label var prccsip3                 "CCS: procedure 3 from inpatient discharge record"
label var prccsip4                 "CCS: procedure 4 from inpatient discharge record"
label var prccsip5                 "CCS: procedure 5 from inpatient discharge record"
label var prccsip6                 "CCS: procedure 6 from inpatient discharge record"
label var prccsip7                 "CCS: procedure 7 from inpatient discharge record"
label var prccsip8                 "CCS: procedure 8 from inpatient discharge record"
label var prccsip9                 "CCS: procedure 9 from inpatient discharge record"
label var totchgip                 "Total charge for ED and inpatient services"

*** Convert special values to missing values ***
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.)
recode hosp_ed                   (-9999 -8888 -6666=.)
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.)
recode disp_ip                   (-9 -8 -6 -5=.)
recode drg                       (-99 -88 -66=.)
recode drgver                    (-9 -8 -6 -5=.)
recode los_ip                    (-9999 -8888 -6666=.)
recode mdc                       (-9 -8 -6 -5=.)
recode npr_ip                    (-9 -8 -6 -5=.)
recode pcls_ip1                  (-99 -88 -66=.)
recode pcls_ip2                  (-99 -88 -66=.)
recode pcls_ip3                  (-99 -88 -66=.)
recode pcls_ip4                  (-99 -88 -66=.)
recode pcls_ip5                  (-99 -88 -66=.)
recode pcls_ip6                  (-99 -88 -66=.)
recode pcls_ip7                  (-99 -88 -66=.)
recode pcls_ip8                  (-99 -88 -66=.)
recode pcls_ip9                  (-99 -88 -66=.)
recode prccsip1                  (-99 -88 -66=.)
recode prccsip2                  (-99 -88 -66=.)
recode prccsip3                  (-99 -88 -66=.)
recode prccsip4                  (-99 -88 -66=.)
recode prccsip5                  (-99 -88 -66=.)
recode prccsip6                  (-99 -88 -66=.)
recode prccsip7                  (-99 -88 -66=.)
recode prccsip8                  (-99 -88 -66=.)
recode prccsip9                  (-99 -88 -66=.)
recode totchgip                  (-99999999.99 -88888888.88 -66666666.66=.)

save "NEDS_2006_IP.dta", replace
