/*****************************************************************************
* Stataload_NEDS_2007_Core.Do
* This program will load the 2007 NEDS CSV Core File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 1100m

*** Read data elements from the csv file ***
insheet      AGE                                 ///
             AMONTH                              ///
             AWEEKEND                            ///
             CHRON1                              ///
             CHRON2                              ///
             CHRON3                              ///
             CHRON4                              ///
             CHRON5                              ///
             CHRON6                              ///
             CHRON7                              ///
             CHRON8                              ///
             CHRON9                              ///
             CHRON10                             ///
             CHRON11                             ///
             CHRON12                             ///
             CHRON13                             ///
             CHRON14                             ///
             CHRON15                             ///
             DIED_VIS                            ///
             DISCWT                              ///
             DISP_ED                             ///
             DQTR                                ///
             DX1                                 ///
             DX2                                 ///
             DX3                                 ///
             DX4                                 ///
             DX5                                 ///
             DX6                                 ///
             DX7                                 ///
             DX8                                 ///
             DX9                                 ///
             DX10                                ///
             DX11                                ///
             DX12                                ///
             DX13                                ///
             DX14                                ///
             DX15                                ///
             DXCCS1                              ///
             DXCCS2                              ///
             DXCCS3                              ///
             DXCCS4                              ///
             DXCCS5                              ///
             DXCCS6                              ///
             DXCCS7                              ///
             DXCCS8                              ///
             DXCCS9                              ///
             DXCCS10                             ///
             DXCCS11                             ///
             DXCCS12                             ///
             DXCCS13                             ///
             DXCCS14                             ///
             DXCCS15                             ///
             ECODE1                              ///
             ECODE2                              ///
             ECODE3                              ///
             ECODE4                              ///
             EDEVENT                             ///
             E_CCS1                              ///
             E_CCS2                              ///
             E_CCS3                              ///
             E_CCS4                              ///
             FEMALE                              ///
             HCUPFILE                            ///
             HOSP_ED                             ///
             REGION                              ///
             INTENT_S                            ///
             KEY_ED                              ///
             NDX                                 ///
             NECODE                              ///
             NEDS_STR                            ///
             PAY1                                ///
             PAY2                                ///
             PL_NCHS2                            ///
             TOTCHGED                            ///
             YEAR                                ///
             ZIPINC_Q                            ///
      using  "NEDS_2007_Core.csv"

***  Assign labels to the data elements ***
label var age                      "Age in years at admission"
label var amonth                   "Admission month"
label var aweekend                 "Admission day is a weekend"
label var chron1                   "Chronic condition indicator 1"
label var chron2                   "Chronic condition indicator 2"
label var chron3                   "Chronic condition indicator 3"
label var chron4                   "Chronic condition indicator 4"
label var chron5                   "Chronic condition indicator 5"
label var chron6                   "Chronic condition indicator 6"
label var chron7                   "Chronic condition indicator 7"
label var chron8                   "Chronic condition indicator 8"
label var chron9                   "Chronic condition indicator 9"
label var chron10                  "Chronic condition indicator 10"
label var chron11                  "Chronic condition indicator 11"
label var chron12                  "Chronic condition indicator 12"
label var chron13                  "Chronic condition indicator 13"
label var chron14                  "Chronic condition indicator 14"
label var chron15                  "Chronic condition indicator 15"
label var died_vis                 "Died in the ED (1), Died in the hospital (2), did not die (0)"
label var discwt                   "Weight to ED Visits in AHA universe"
label var disp_ed                  "Disposition of patient (uniform) from ED"
label var dqtr                     "Discharge quarter"
label var dx1                      "Diagnosis 1"
label var dx2                      "Diagnosis 2"
label var dx3                      "Diagnosis 3"
label var dx4                      "Diagnosis 4"
label var dx5                      "Diagnosis 5"
label var dx6                      "Diagnosis 6"
label var dx7                      "Diagnosis 7"
label var dx8                      "Diagnosis 8"
label var dx9                      "Diagnosis 9"
label var dx10                     "Diagnosis 10"
label var dx11                     "Diagnosis 11"
label var dx12                     "Diagnosis 12"
label var dx13                     "Diagnosis 13"
label var dx14                     "Diagnosis 14"
label var dx15                     "Diagnosis 15"
label var dxccs1                   "CCS: diagnosis 1"
label var dxccs2                   "CCS: diagnosis 2"
label var dxccs3                   "CCS: diagnosis 3"
label var dxccs4                   "CCS: diagnosis 4"
label var dxccs5                   "CCS: diagnosis 5"
label var dxccs6                   "CCS: diagnosis 6"
label var dxccs7                   "CCS: diagnosis 7"
label var dxccs8                   "CCS: diagnosis 8"
label var dxccs9                   "CCS: diagnosis 9"
label var dxccs10                  "CCS: diagnosis 10"
label var dxccs11                  "CCS: diagnosis 11"
label var dxccs12                  "CCS: diagnosis 12"
label var dxccs13                  "CCS: diagnosis 13"
label var dxccs14                  "CCS: diagnosis 14"
label var dxccs15                  "CCS: diagnosis 15"
label var ecode1                   "E code 1"
label var ecode2                   "E code 2"
label var ecode3                   "E code 3"
label var ecode4                   "E code 4"
label var edevent                  "Type of ED Event"
label var e_ccs1                   "CCS: E Code 1"
label var e_ccs2                   "CCS: E Code 2"
label var e_ccs3                   "CCS: E Code 3"
label var e_ccs4                   "CCS: E Code 4"
label var female                   "Indicator of sex"
label var hcupfile                 "Source of HCUP Record (SID or SEDD)"
label var hosp_ed                  "HCUP ED hospital identifier"
label var region                   "Region of hospital"
label var intent_s                 "Intentional self harm indicated on the record (by diagnosis and/or E codes)"
label var key_ed                   "HCUP NEDS record identifier"
label var ndx                      "Number of diagnoses on this record"
label var necode                   "Number of E codes on this record"
label var neds_str                 "Stratum used to sample hospital"
label var pay1                     "Primary expected payer (uniform)"
label var pay2                     "Secondary expected payer (uniform)"
label var pl_nchs2                 "Patient Location: NCHS Urban-Rural Code (V2006)"
label var totchged                 "Total charge for ED services"
label var year                     "Calendar year"
label var zipinc_q                 "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode age                       (-99 -88 -66=.)
recode amonth                    (-9 -8 -6 -5=.)
recode aweekend                  (-9 -8 -6 -5=.)
recode chron1                    (-99 -88 -66=.)
recode chron2                    (-99 -88 -66=.)
recode chron3                    (-99 -88 -66=.)
recode chron4                    (-99 -88 -66=.)
recode chron5                    (-99 -88 -66=.)
recode chron6                    (-99 -88 -66=.)
recode chron7                    (-99 -88 -66=.)
recode chron8                    (-99 -88 -66=.)
recode chron9                    (-99 -88 -66=.)
recode chron10                   (-99 -88 -66=.)
recode chron11                   (-99 -88 -66=.)
recode chron12                   (-99 -88 -66=.)
recode chron13                   (-99 -88 -66=.)
recode chron14                   (-99 -88 -66=.)
recode chron15                   (-99 -88 -66=.)
recode died_vis                  (-9 -8 -6 -5=.)
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.)
recode disp_ed                   (-9 -8 -6 -5=.)
recode dqtr                      (-9 -8 -6 -5=.)
recode dxccs1                    (-999 -888 -666=.)
recode dxccs2                    (-999 -888 -666=.)
recode dxccs3                    (-999 -888 -666=.)
recode dxccs4                    (-999 -888 -666=.)
recode dxccs5                    (-999 -888 -666=.)
recode dxccs6                    (-999 -888 -666=.)
recode dxccs7                    (-999 -888 -666=.)
recode dxccs8                    (-999 -888 -666=.)
recode dxccs9                    (-999 -888 -666=.)
recode dxccs10                   (-999 -888 -666=.)
recode dxccs11                   (-999 -888 -666=.)
recode dxccs12                   (-999 -888 -666=.)
recode dxccs13                   (-999 -888 -666=.)
recode dxccs14                   (-999 -888 -666=.)
recode dxccs15                   (-999 -888 -666=.)
recode edevent                   (-9 -8 -6 -5=.)
recode e_ccs1                    (-999 -888 -666=.)
recode e_ccs2                    (-999 -888 -666=.)
recode e_ccs3                    (-999 -888 -666=.)
recode e_ccs4                    (-999 -888 -666=.)
recode female                    (-9 -8 -6 -5=.)
recode hosp_ed                   (-9999 -8888 -6666=.)
recode region                    (-9 -8 -6 -5=.)
recode intent_s                  (-9 -8 -6 -5=.)
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.)
recode ndx                       (-99 -88 -66=.)
recode necode                    (-99 -88 -66=.)
recode neds_str                  (-9999 -8888 -6666=.)
recode pay1                      (-9 -8 -6 -5=.)
recode pay2                      (-9 -8 -6 -5=.)
recode pl_nchs2                  (-99 -88 -66=.)
recode totchged                  (-99999999.99 -88888888.88 -66666666.66=.)
recode year                      (-999 -888 -666=.)
recode zipinc_q                  (-9 -8 -6 -5=.)

save "NEDS_2007_Core.dta", replace
