/*****************************************************************************
 * Stataload_NEDS_2008_Hospital.Do
 * This program will load the 2008 NEDS CSV Hospital File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.            
 * or use "in" option after "using NEDS_2008_Hospital.csv" to read a subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      double discwt
      double hospwt
      byte   control
      long   hosp_ed
      byte   region
      byte   trauma
      byte   urcat4
      byte   ur_teach
      long   neds_str
      long   n_disc_u
      int    n_hosp_u
      long   s_disc_u
      long   s_hosp_u
      long   edvisits
      int    year
using  "NEDS_2008_Hospital.csv";

/*  Assign labels to the data elements */
label var discwt                   "Weight to ED Visits in AHA universe" ;
label var hospwt                   "Weight to hospitals in AHA universe" ;
label var control                  "Control/ownership of hospital" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var region                   "Region of hospital" ;
label var trauma                   "Trauma level designation" ;
label var urcat4                   "Hospital urban-rural designation" ;
label var ur_teach                 "Teaching status of hospital" ;
label var neds_str                 "Stratum used to sample hospital" ;
label var n_disc_u                 "Number of AHA universe ED visits in NEDS_STRATUM" ;
label var n_hosp_u                 "Number of AHA universe hospitals in NEDS_STRATUM" ;
label var s_disc_u                 "Number of sample discharges in NEDS_STRATUM" ;
label var s_hosp_u                 "Number of sample hospitals in NEDS_STRATUM" ;
label var edvisits                 "Total number of ED visits from this hospital in the NEDS" ;
label var year                     "Calendar Year" ;

/* Convert special values to missing values */
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode hospwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode control                   (-9 -8 -6 -5=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode region                    (-9 -8 -6 -5=.) ;
recode trauma                    (-9 -8 -6 -5=.) ;
recode urcat4                    (-9 -8 -6 -5=.) ;
recode ur_teach                  (-9 -8 -6 -5=.) ;
recode neds_str                  (-9999 -8888 -6666=.) ;
recode n_disc_u                  (-9999999 -8888888 -6666666=.) ;
recode n_hosp_u                  (-999 -888 -666=.) ;
recode s_disc_u                  (-9999999 -8888888 -6666666=.) ;
recode s_hosp_u                  (-99999 -88888 -66666=.) ;
recode edvisits                  (-9999999 -8888888 -6666666=.) ;
recode year                      (-999 -888 -666=.) ;

describe;

save "NEDS_2008_Hospital.dta", replace;
#delimit cr
