/*****************************************************************************
 * Stataload_NEDS_2015Q4_ED.Do
 * This program will load the NEDS 2015 Q4 ED csv File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2015Q4_ED.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      str5   cpt1
      str5   cpt2
      str5   cpt3
      str5   cpt4
      str5   cpt5
      str5   cpt6
      str5   cpt7
      str5   cpt8
      str5   cpt9
      str5   cpt10
      str5   cpt11
      str5   cpt12
      str5   cpt13
      str5   cpt14
      str5   cpt15
      int    cptccs1
      int    cptccs2
      int    cptccs3
      int    cptccs4
      int    cptccs5
      int    cptccs6
      int    cptccs7
      int    cptccs8
      int    cptccs9
      int    cptccs10
      int    cptccs11
      int    cptccs12
      int    cptccs13
      int    cptccs14
      int    cptccs15
      byte   dxver
      str4   hcupfile
      long   hosp_ed
      str7   i10_dx1
      str7   i10_dx2
      str7   i10_dx3
      str7   i10_dx4
      str7   i10_dx5
      str7   i10_dx6
      str7   i10_dx7
      str7   i10_dx8
      str7   i10_dx9
      str7   i10_dx10
      str7   i10_dx11
      str7   i10_dx12
      str7   i10_dx13
      str7   i10_dx14
      str7   i10_dx15
      str7   i10_dx16
      str7   i10_dx17
      str7   i10_dx18
      str7   i10_dx19
      str7   i10_dx20
      str7   i10_dx21
      str7   i10_dx22
      str7   i10_dx23
      str7   i10_dx24
      str7   i10_dx25
      str7   i10_dx26
      str7   i10_dx27
      str7   i10_dx28
      str7   i10_dx29
      str7   i10_dx30
      str7   i10_ecause1
      str7   i10_ecause2
      str7   i10_ecause3
      str7   i10_ecause4
      int    i10_ndx
      int    i10_necause
      double key_ed
      int    ncpt
using NEDS_2015Q4_ED.csv;

/*  Assign labels to the data elements */
label var cpt1                     "CPT/HCPCS procedure code 1" ;
label var cpt2                     "CPT/HCPCS procedure code 2" ;
label var cpt3                     "CPT/HCPCS procedure code 3" ;
label var cpt4                     "CPT/HCPCS procedure code 4" ;
label var cpt5                     "CPT/HCPCS procedure code 5" ;
label var cpt6                     "CPT/HCPCS procedure code 6" ;
label var cpt7                     "CPT/HCPCS procedure code 7" ;
label var cpt8                     "CPT/HCPCS procedure code 8" ;
label var cpt9                     "CPT/HCPCS procedure code 9" ;
label var cpt10                    "CPT/HCPCS procedure code 10" ;
label var cpt11                    "CPT/HCPCS procedure code 11" ;
label var cpt12                    "CPT/HCPCS procedure code 12" ;
label var cpt13                    "CPT/HCPCS procedure code 13" ;
label var cpt14                    "CPT/HCPCS procedure code 14" ;
label var cpt15                    "CPT/HCPCS procedure code 15" ;
label var cptccs1                  "CCS: CPT 1" ;
label var cptccs2                  "CCS: CPT 2" ;
label var cptccs3                  "CCS: CPT 3" ;
label var cptccs4                  "CCS: CPT 4" ;
label var cptccs5                  "CCS: CPT 5" ;
label var cptccs6                  "CCS: CPT 6" ;
label var cptccs7                  "CCS: CPT 7" ;
label var cptccs8                  "CCS: CPT 8" ;
label var cptccs9                  "CCS: CPT 9" ;
label var cptccs10                 "CCS: CPT 10" ;
label var cptccs11                 "CCS: CPT 11" ;
label var cptccs12                 "CCS: CPT 12" ;
label var cptccs13                 "CCS: CPT 13" ;
label var cptccs14                 "CCS: CPT 14" ;
label var cptccs15                 "CCS: CPT 15" ;
label var dxver                    "Diagnosis Version" ;
label var hcupfile                 "Source of HCUP Record (SID or SEDD)" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var i10_dx1                  "ICD-10-CM Diagnosis 1" ;
label var i10_dx2                  "ICD-10-CM Diagnosis 2" ;
label var i10_dx3                  "ICD-10-CM Diagnosis 3" ;
label var i10_dx4                  "ICD-10-CM Diagnosis 4" ;
label var i10_dx5                  "ICD-10-CM Diagnosis 5" ;
label var i10_dx6                  "ICD-10-CM Diagnosis 6" ;
label var i10_dx7                  "ICD-10-CM Diagnosis 7" ;
label var i10_dx8                  "ICD-10-CM Diagnosis 8" ;
label var i10_dx9                  "ICD-10-CM Diagnosis 9" ;
label var i10_dx10                 "ICD-10-CM Diagnosis 10" ;
label var i10_dx11                 "ICD-10-CM Diagnosis 11" ;
label var i10_dx12                 "ICD-10-CM Diagnosis 12" ;
label var i10_dx13                 "ICD-10-CM Diagnosis 13" ;
label var i10_dx14                 "ICD-10-CM Diagnosis 14" ;
label var i10_dx15                 "ICD-10-CM Diagnosis 15" ;
label var i10_dx16                 "ICD-10-CM Diagnosis 16" ;
label var i10_dx17                 "ICD-10-CM Diagnosis 17" ;
label var i10_dx18                 "ICD-10-CM Diagnosis 18" ;
label var i10_dx19                 "ICD-10-CM Diagnosis 19" ;
label var i10_dx20                 "ICD-10-CM Diagnosis 20" ;
label var i10_dx21                 "ICD-10-CM Diagnosis 21" ;
label var i10_dx22                 "ICD-10-CM Diagnosis 22" ;
label var i10_dx23                 "ICD-10-CM Diagnosis 23" ;
label var i10_dx24                 "ICD-10-CM Diagnosis 24" ;
label var i10_dx25                 "ICD-10-CM Diagnosis 25" ;
label var i10_dx26                 "ICD-10-CM Diagnosis 26" ;
label var i10_dx27                 "ICD-10-CM Diagnosis 27" ;
label var i10_dx28                 "ICD-10-CM Diagnosis 28" ;
label var i10_dx29                 "ICD-10-CM Diagnosis 29" ;
label var i10_dx30                 "ICD-10-CM Diagnosis 30" ;
label var i10_ecause1              "ICD-10-CM External cause 1" ;
label var i10_ecause2              "ICD-10-CM External cause 2" ;
label var i10_ecause3              "ICD-10-CM External cause 3" ;
label var i10_ecause4              "ICD-10-CM External cause 4" ;
label var i10_ndx                  "ICD-10-CM Number of diagnoses on this record" ;
label var i10_necause              "ICD-10-CM Number of external cause codes on this record" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var ncpt                     "Number of CPT/HCPCS procedures for this visit" ;

/* Convert special values to missing values */
recode cptccs1                   (-999 -888 -666=.) ;
recode cptccs2                   (-999 -888 -666=.) ;
recode cptccs3                   (-999 -888 -666=.) ;
recode cptccs4                   (-999 -888 -666=.) ;
recode cptccs5                   (-999 -888 -666=.) ;
recode cptccs6                   (-999 -888 -666=.) ;
recode cptccs7                   (-999 -888 -666=.) ;
recode cptccs8                   (-999 -888 -666=.) ;
recode cptccs9                   (-999 -888 -666=.) ;
recode cptccs10                  (-999 -888 -666=.) ;
recode cptccs11                  (-999 -888 -666=.) ;
recode cptccs12                  (-999 -888 -666=.) ;
recode cptccs13                  (-999 -888 -666=.) ;
recode cptccs14                  (-999 -888 -666=.) ;
recode cptccs15                  (-999 -888 -666=.) ;
recode dxver                     (-9 -8 -6 -5=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode i10_ndx                   (-99 -88 -66=.) ;
recode i10_necause               (-99 -88 -66=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode ncpt                      (-999 -888 -666=.) ;

describe;

save "NEDS_2015Q4_ED.dta", replace;
#delimit cr
