/*****************************************************************************
 * Stataload_NEDS_2017_IP.Do
 * This program will load the NEDS 2017 IP csv File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2017_IP.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      long   hosp_ed
      double key_ed
      byte   disp_ip
      int    drg
      byte   drgver
      int    drg_nopoa
      int    i10_npr_ip
      str7   i10_pr_ip1
      str7   i10_pr_ip2
      str7   i10_pr_ip3
      str7   i10_pr_ip4
      str7   i10_pr_ip5
      str7   i10_pr_ip6
      str7   i10_pr_ip7
      str7   i10_pr_ip8
      str7   i10_pr_ip9
      str7   i10_pr_ip10
      str7   i10_pr_ip11
      str7   i10_pr_ip12
      str7   i10_pr_ip13
      str7   i10_pr_ip14
      str7   i10_pr_ip15
      long   los_ip
      byte   mdc
      byte   mdc_nopoa
      byte   prver
      double totchg_ip
using NEDS_2017_IP.csv;

/*  Assign labels to the data elements */
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var disp_ip                  "Disposition of patient (uniform) from IP" ;
label var drg                      "DRG in effect on discharge date" ;
label var drgver                   "DRG grouper version used on discharge date" ;
label var drg_nopoa                "DRG in use on discharge date, calculated without POA" ;
label var i10_npr_ip               "Number of ICD-10-PCS procedures from inpatient discharge record" ;
label var i10_pr_ip1               "ICD-10-PCS Procedure 1 from inpatient discharge record" ;
label var i10_pr_ip2               "ICD-10-PCS Procedure 2 from inpatient discharge record" ;
label var i10_pr_ip3               "ICD-10-PCS Procedure 3 from inpatient discharge record" ;
label var i10_pr_ip4               "ICD-10-PCS Procedure 4 from inpatient discharge record" ;
label var i10_pr_ip5               "ICD-10-PCS Procedure 5 from inpatient discharge record" ;
label var i10_pr_ip6               "ICD-10-PCS Procedure 6 from inpatient discharge record" ;
label var i10_pr_ip7               "ICD-10-PCS Procedure 7 from inpatient discharge record" ;
label var i10_pr_ip8               "ICD-10-PCS Procedure 8 from inpatient discharge record" ;
label var i10_pr_ip9               "ICD-10-PCS Procedure 9 from inpatient discharge record" ;
label var i10_pr_ip10              "ICD-10-PCS Procedure 10 from inpatient discharge record" ;
label var i10_pr_ip11              "ICD-10-PCS Procedure 11 from inpatient discharge record" ;
label var i10_pr_ip12              "ICD-10-PCS Procedure 12 from inpatient discharge record" ;
label var i10_pr_ip13              "ICD-10-PCS Procedure 13 from inpatient discharge record" ;
label var i10_pr_ip14              "ICD-10-PCS Procedure 14 from inpatient discharge record" ;
label var i10_pr_ip15              "ICD-10-PCS Procedure 15 from inpatient discharge record" ;
label var los_ip                   "Length of stay (cleaned) from IP" ;
label var mdc                      "MDC in effect on discharge date" ;
label var mdc_nopoa                "MDC in use on discharge date, calculated without POA" ;
label var prver                    "Procedure Version" ;
label var totchg_ip                "Total charge for ED and inpatient services" ;

/* Convert special values to missing values */
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode disp_ip                   (-9 -8 -6 -5=.) ;
recode drg                       (-99 -88 -66=.) ;
recode drgver                    (-9 -8 -6 -5=.) ;
recode drg_nopoa                 (-99 -88 -66=.) ;
recode i10_npr_ip                (-99 -88 -66=.) ;
recode los_ip                    (-9999 -8888 -6666=.) ;
recode mdc                       (-9 -8 -6 -5=.) ;
recode mdc_nopoa                 (-9 -8 -6 -5=.) ;
recode prver                     (-9 -8 -6 -5=.) ;
recode totchg_ip                 (-99999999.99 -88888888.88 -66666666.66=.) ;

describe;

save "NEDS_2017_IP.dta", replace;
#delimit cr
