/*****************************************************************************
 * Stataload_NEDS_2020_DX_PR_GRPS.Do
 * This program will load the NEDS 2020 DX PR GRPS csv File into Stata.
 * created on 09/09/2022.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2020_DX_PR_GRPS.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      byte   cmr_aids
      byte   cmr_alcohol
      byte   cmr_autoimmune
      byte   cmr_cancer_leuk
      byte   cmr_cancer_lymph
      byte   cmr_cancer_mets
      byte   cmr_cancer_nsitu
      byte   cmr_cancer_solid
      byte   cmr_dementia
      byte   cmr_depress
      byte   cmr_diab_cx
      byte   cmr_diab_uncx
      byte   cmr_drug_abuse
      byte   cmr_htn_cx
      byte   cmr_htn_uncx
      byte   cmr_lung_chronic
      byte   cmr_obese
      byte   cmr_perivasc
      byte   cmr_thyroid_hypo
      byte   cmr_thyroid_oth
      str6   cmr_version
      byte   dxccsr_bld001
      byte   dxccsr_bld002
      byte   dxccsr_bld003
      byte   dxccsr_bld004
      byte   dxccsr_bld005
      byte   dxccsr_bld006
      byte   dxccsr_bld007
      byte   dxccsr_bld008
      byte   dxccsr_bld009
      byte   dxccsr_bld010
      byte   dxccsr_cir001
      byte   dxccsr_cir002
      byte   dxccsr_cir003
      byte   dxccsr_cir004
      byte   dxccsr_cir005
      byte   dxccsr_cir006
      byte   dxccsr_cir007
      byte   dxccsr_cir008
      byte   dxccsr_cir009
      byte   dxccsr_cir010
      byte   dxccsr_cir011
      byte   dxccsr_cir012
      byte   dxccsr_cir013
      byte   dxccsr_cir014
      byte   dxccsr_cir015
      byte   dxccsr_cir016
      byte   dxccsr_cir017
      byte   dxccsr_cir018
      byte   dxccsr_cir019
      byte   dxccsr_cir020
      byte   dxccsr_cir021
      byte   dxccsr_cir022
      byte   dxccsr_cir023
      byte   dxccsr_cir024
      byte   dxccsr_cir025
      byte   dxccsr_cir026
      byte   dxccsr_cir027
      byte   dxccsr_cir028
      byte   dxccsr_cir029
      byte   dxccsr_cir030
      byte   dxccsr_cir031
      byte   dxccsr_cir032
      byte   dxccsr_cir033
      byte   dxccsr_cir034
      byte   dxccsr_cir035
      byte   dxccsr_cir036
      byte   dxccsr_cir037
      byte   dxccsr_cir038
      byte   dxccsr_cir039
      byte   dxccsr_dig001
      byte   dxccsr_dig002
      byte   dxccsr_dig003
      byte   dxccsr_dig004
      byte   dxccsr_dig005
      byte   dxccsr_dig006
      byte   dxccsr_dig007
      byte   dxccsr_dig008
      byte   dxccsr_dig009
      byte   dxccsr_dig010
      byte   dxccsr_dig011
      byte   dxccsr_dig012
      byte   dxccsr_dig013
      byte   dxccsr_dig014
      byte   dxccsr_dig015
      byte   dxccsr_dig016
      byte   dxccsr_dig017
      byte   dxccsr_dig018
      byte   dxccsr_dig019
      byte   dxccsr_dig020
      byte   dxccsr_dig021
      byte   dxccsr_dig022
      byte   dxccsr_dig023
      byte   dxccsr_dig024
      byte   dxccsr_dig025
      str6   dxccsr_default_dx1
      byte   dxccsr_ear001
      byte   dxccsr_ear002
      byte   dxccsr_ear003
      byte   dxccsr_ear004
      byte   dxccsr_ear005
      byte   dxccsr_ear006
      byte   dxccsr_end001
      byte   dxccsr_end002
      byte   dxccsr_end003
      byte   dxccsr_end004
      byte   dxccsr_end005
      byte   dxccsr_end006
      byte   dxccsr_end007
      byte   dxccsr_end008
      byte   dxccsr_end009
      byte   dxccsr_end010
      byte   dxccsr_end011
      byte   dxccsr_end012
      byte   dxccsr_end013
      byte   dxccsr_end014
      byte   dxccsr_end015
      byte   dxccsr_end016
      byte   dxccsr_end017
      byte   dxccsr_ext001
      byte   dxccsr_ext002
      byte   dxccsr_ext003
      byte   dxccsr_ext004
      byte   dxccsr_ext005
      byte   dxccsr_ext006
      byte   dxccsr_ext007
      byte   dxccsr_ext008
      byte   dxccsr_ext009
      byte   dxccsr_ext010
      byte   dxccsr_ext011
      byte   dxccsr_ext012
      byte   dxccsr_ext013
      byte   dxccsr_ext014
      byte   dxccsr_ext015
      byte   dxccsr_ext016
      byte   dxccsr_ext017
      byte   dxccsr_ext018
      byte   dxccsr_ext019
      byte   dxccsr_ext020
      byte   dxccsr_ext021
      byte   dxccsr_ext022
      byte   dxccsr_ext023
      byte   dxccsr_ext024
      byte   dxccsr_ext025
      byte   dxccsr_ext026
      byte   dxccsr_ext027
      byte   dxccsr_ext028
      byte   dxccsr_ext029
      byte   dxccsr_ext030
      byte   dxccsr_eye001
      byte   dxccsr_eye002
      byte   dxccsr_eye003
      byte   dxccsr_eye004
      byte   dxccsr_eye005
      byte   dxccsr_eye006
      byte   dxccsr_eye007
      byte   dxccsr_eye008
      byte   dxccsr_eye009
      byte   dxccsr_eye010
      byte   dxccsr_eye011
      byte   dxccsr_eye012
      byte   dxccsr_fac001
      byte   dxccsr_fac002
      byte   dxccsr_fac003
      byte   dxccsr_fac004
      byte   dxccsr_fac005
      byte   dxccsr_fac006
      byte   dxccsr_fac007
      byte   dxccsr_fac008
      byte   dxccsr_fac009
      byte   dxccsr_fac010
      byte   dxccsr_fac011
      byte   dxccsr_fac012
      byte   dxccsr_fac013
      byte   dxccsr_fac014
      byte   dxccsr_fac015
      byte   dxccsr_fac016
      byte   dxccsr_fac017
      byte   dxccsr_fac018
      byte   dxccsr_fac019
      byte   dxccsr_fac020
      byte   dxccsr_fac021
      byte   dxccsr_fac022
      byte   dxccsr_fac023
      byte   dxccsr_fac024
      byte   dxccsr_fac025
      byte   dxccsr_gen001
      byte   dxccsr_gen002
      byte   dxccsr_gen003
      byte   dxccsr_gen004
      byte   dxccsr_gen005
      byte   dxccsr_gen006
      byte   dxccsr_gen007
      byte   dxccsr_gen008
      byte   dxccsr_gen009
      byte   dxccsr_gen010
      byte   dxccsr_gen011
      byte   dxccsr_gen012
      byte   dxccsr_gen013
      byte   dxccsr_gen014
      byte   dxccsr_gen015
      byte   dxccsr_gen016
      byte   dxccsr_gen017
      byte   dxccsr_gen018
      byte   dxccsr_gen019
      byte   dxccsr_gen020
      byte   dxccsr_gen021
      byte   dxccsr_gen022
      byte   dxccsr_gen023
      byte   dxccsr_gen024
      byte   dxccsr_gen025
      byte   dxccsr_gen026
      byte   dxccsr_inf001
      byte   dxccsr_inf002
      byte   dxccsr_inf003
      byte   dxccsr_inf004
      byte   dxccsr_inf005
      byte   dxccsr_inf006
      byte   dxccsr_inf007
      byte   dxccsr_inf008
      byte   dxccsr_inf009
      byte   dxccsr_inf010
      byte   dxccsr_inf011
      byte   dxccsr_inf012
      byte   dxccsr_inj001
      byte   dxccsr_inj002
      byte   dxccsr_inj003
      byte   dxccsr_inj004
      byte   dxccsr_inj005
      byte   dxccsr_inj006
      byte   dxccsr_inj007
      byte   dxccsr_inj008
      byte   dxccsr_inj009
      byte   dxccsr_inj010
      byte   dxccsr_inj011
      byte   dxccsr_inj012
      byte   dxccsr_inj013
      byte   dxccsr_inj014
      byte   dxccsr_inj015
      byte   dxccsr_inj016
      byte   dxccsr_inj017
      byte   dxccsr_inj018
      byte   dxccsr_inj019
      byte   dxccsr_inj020
      byte   dxccsr_inj021
      byte   dxccsr_inj022
      byte   dxccsr_inj023
      byte   dxccsr_inj024
      byte   dxccsr_inj025
      byte   dxccsr_inj026
      byte   dxccsr_inj027
      byte   dxccsr_inj028
      byte   dxccsr_inj029
      byte   dxccsr_inj030
      byte   dxccsr_inj031
      byte   dxccsr_inj032
      byte   dxccsr_inj033
      byte   dxccsr_inj034
      byte   dxccsr_inj035
      byte   dxccsr_inj036
      byte   dxccsr_inj037
      byte   dxccsr_inj038
      byte   dxccsr_inj039
      byte   dxccsr_inj040
      byte   dxccsr_inj041
      byte   dxccsr_inj042
      byte   dxccsr_inj043
      byte   dxccsr_inj044
      byte   dxccsr_inj045
      byte   dxccsr_inj046
      byte   dxccsr_inj047
      byte   dxccsr_inj048
      byte   dxccsr_inj049
      byte   dxccsr_inj050
      byte   dxccsr_inj051
      byte   dxccsr_inj052
      byte   dxccsr_inj053
      byte   dxccsr_inj054
      byte   dxccsr_inj055
      byte   dxccsr_inj056
      byte   dxccsr_inj057
      byte   dxccsr_inj058
      byte   dxccsr_inj059
      byte   dxccsr_inj060
      byte   dxccsr_inj061
      byte   dxccsr_inj062
      byte   dxccsr_inj063
      byte   dxccsr_inj064
      byte   dxccsr_inj065
      byte   dxccsr_inj066
      byte   dxccsr_inj067
      byte   dxccsr_inj068
      byte   dxccsr_inj069
      byte   dxccsr_inj070
      byte   dxccsr_inj071
      byte   dxccsr_inj072
      byte   dxccsr_inj073
      byte   dxccsr_inj074
      byte   dxccsr_inj075
      byte   dxccsr_inj076
      byte   dxccsr_mal001
      byte   dxccsr_mal002
      byte   dxccsr_mal003
      byte   dxccsr_mal004
      byte   dxccsr_mal005
      byte   dxccsr_mal006
      byte   dxccsr_mal007
      byte   dxccsr_mal008
      byte   dxccsr_mal009
      byte   dxccsr_mal010
      byte   dxccsr_mbd001
      byte   dxccsr_mbd002
      byte   dxccsr_mbd003
      byte   dxccsr_mbd004
      byte   dxccsr_mbd005
      byte   dxccsr_mbd006
      byte   dxccsr_mbd007
      byte   dxccsr_mbd008
      byte   dxccsr_mbd009
      byte   dxccsr_mbd010
      byte   dxccsr_mbd011
      byte   dxccsr_mbd012
      byte   dxccsr_mbd013
      byte   dxccsr_mbd014
      byte   dxccsr_mbd017
      byte   dxccsr_mbd018
      byte   dxccsr_mbd019
      byte   dxccsr_mbd020
      byte   dxccsr_mbd021
      byte   dxccsr_mbd022
      byte   dxccsr_mbd023
      byte   dxccsr_mbd024
      byte   dxccsr_mbd025
      byte   dxccsr_mbd026
      byte   dxccsr_mbd027
      byte   dxccsr_mbd028
      byte   dxccsr_mbd029
      byte   dxccsr_mbd030
      byte   dxccsr_mbd031
      byte   dxccsr_mbd032
      byte   dxccsr_mbd033
      byte   dxccsr_mbd034
      byte   dxccsr_mus001
      byte   dxccsr_mus002
      byte   dxccsr_mus003
      byte   dxccsr_mus004
      byte   dxccsr_mus005
      byte   dxccsr_mus006
      byte   dxccsr_mus007
      byte   dxccsr_mus008
      byte   dxccsr_mus009
      byte   dxccsr_mus010
      byte   dxccsr_mus011
      byte   dxccsr_mus012
      byte   dxccsr_mus013
      byte   dxccsr_mus014
      byte   dxccsr_mus015
      byte   dxccsr_mus016
      byte   dxccsr_mus017
      byte   dxccsr_mus018
      byte   dxccsr_mus019
      byte   dxccsr_mus020
      byte   dxccsr_mus021
      byte   dxccsr_mus022
      byte   dxccsr_mus023
      byte   dxccsr_mus024
      byte   dxccsr_mus025
      byte   dxccsr_mus026
      byte   dxccsr_mus027
      byte   dxccsr_mus028
      byte   dxccsr_mus029
      byte   dxccsr_mus030
      byte   dxccsr_mus031
      byte   dxccsr_mus032
      byte   dxccsr_mus033
      byte   dxccsr_mus034
      byte   dxccsr_mus035
      byte   dxccsr_mus036
      byte   dxccsr_mus037
      byte   dxccsr_mus038
      byte   dxccsr_neo001
      byte   dxccsr_neo002
      byte   dxccsr_neo003
      byte   dxccsr_neo004
      byte   dxccsr_neo005
      byte   dxccsr_neo006
      byte   dxccsr_neo007
      byte   dxccsr_neo008
      byte   dxccsr_neo009
      byte   dxccsr_neo010
      byte   dxccsr_neo011
      byte   dxccsr_neo012
      byte   dxccsr_neo013
      byte   dxccsr_neo014
      byte   dxccsr_neo015
      byte   dxccsr_neo016
      byte   dxccsr_neo017
      byte   dxccsr_neo018
      byte   dxccsr_neo019
      byte   dxccsr_neo020
      byte   dxccsr_neo021
      byte   dxccsr_neo022
      byte   dxccsr_neo023
      byte   dxccsr_neo024
      byte   dxccsr_neo025
      byte   dxccsr_neo026
      byte   dxccsr_neo027
      byte   dxccsr_neo028
      byte   dxccsr_neo029
      byte   dxccsr_neo030
      byte   dxccsr_neo031
      byte   dxccsr_neo032
      byte   dxccsr_neo033
      byte   dxccsr_neo034
      byte   dxccsr_neo035
      byte   dxccsr_neo036
      byte   dxccsr_neo037
      byte   dxccsr_neo038
      byte   dxccsr_neo039
      byte   dxccsr_neo040
      byte   dxccsr_neo041
      byte   dxccsr_neo042
      byte   dxccsr_neo043
      byte   dxccsr_neo044
      byte   dxccsr_neo045
      byte   dxccsr_neo046
      byte   dxccsr_neo047
      byte   dxccsr_neo048
      byte   dxccsr_neo049
      byte   dxccsr_neo050
      byte   dxccsr_neo051
      byte   dxccsr_neo052
      byte   dxccsr_neo053
      byte   dxccsr_neo054
      byte   dxccsr_neo055
      byte   dxccsr_neo056
      byte   dxccsr_neo057
      byte   dxccsr_neo058
      byte   dxccsr_neo059
      byte   dxccsr_neo060
      byte   dxccsr_neo061
      byte   dxccsr_neo062
      byte   dxccsr_neo063
      byte   dxccsr_neo064
      byte   dxccsr_neo065
      byte   dxccsr_neo066
      byte   dxccsr_neo067
      byte   dxccsr_neo068
      byte   dxccsr_neo069
      byte   dxccsr_neo070
      byte   dxccsr_neo071
      byte   dxccsr_neo072
      byte   dxccsr_neo073
      byte   dxccsr_neo074
      byte   dxccsr_nvs001
      byte   dxccsr_nvs002
      byte   dxccsr_nvs003
      byte   dxccsr_nvs004
      byte   dxccsr_nvs005
      byte   dxccsr_nvs006
      byte   dxccsr_nvs007
      byte   dxccsr_nvs008
      byte   dxccsr_nvs009
      byte   dxccsr_nvs010
      byte   dxccsr_nvs011
      byte   dxccsr_nvs012
      byte   dxccsr_nvs013
      byte   dxccsr_nvs014
      byte   dxccsr_nvs015
      byte   dxccsr_nvs016
      byte   dxccsr_nvs017
      byte   dxccsr_nvs018
      byte   dxccsr_nvs019
      byte   dxccsr_nvs020
      byte   dxccsr_nvs021
      byte   dxccsr_nvs022
      byte   dxccsr_pnl001
      byte   dxccsr_pnl002
      byte   dxccsr_pnl003
      byte   dxccsr_pnl004
      byte   dxccsr_pnl005
      byte   dxccsr_pnl006
      byte   dxccsr_pnl007
      byte   dxccsr_pnl008
      byte   dxccsr_pnl009
      byte   dxccsr_pnl010
      byte   dxccsr_pnl011
      byte   dxccsr_pnl012
      byte   dxccsr_pnl013
      byte   dxccsr_pnl014
      byte   dxccsr_pnl015
      byte   dxccsr_prg001
      byte   dxccsr_prg002
      byte   dxccsr_prg003
      byte   dxccsr_prg004
      byte   dxccsr_prg005
      byte   dxccsr_prg006
      byte   dxccsr_prg007
      byte   dxccsr_prg008
      byte   dxccsr_prg009
      byte   dxccsr_prg010
      byte   dxccsr_prg011
      byte   dxccsr_prg012
      byte   dxccsr_prg013
      byte   dxccsr_prg014
      byte   dxccsr_prg015
      byte   dxccsr_prg016
      byte   dxccsr_prg017
      byte   dxccsr_prg018
      byte   dxccsr_prg019
      byte   dxccsr_prg020
      byte   dxccsr_prg021
      byte   dxccsr_prg022
      byte   dxccsr_prg023
      byte   dxccsr_prg024
      byte   dxccsr_prg025
      byte   dxccsr_prg026
      byte   dxccsr_prg027
      byte   dxccsr_prg028
      byte   dxccsr_prg029
      byte   dxccsr_prg030
      byte   dxccsr_rsp001
      byte   dxccsr_rsp002
      byte   dxccsr_rsp003
      byte   dxccsr_rsp004
      byte   dxccsr_rsp005
      byte   dxccsr_rsp006
      byte   dxccsr_rsp007
      byte   dxccsr_rsp008
      byte   dxccsr_rsp009
      byte   dxccsr_rsp010
      byte   dxccsr_rsp011
      byte   dxccsr_rsp012
      byte   dxccsr_rsp013
      byte   dxccsr_rsp014
      byte   dxccsr_rsp015
      byte   dxccsr_rsp016
      byte   dxccsr_rsp017
      byte   dxccsr_skn001
      byte   dxccsr_skn002
      byte   dxccsr_skn003
      byte   dxccsr_skn004
      byte   dxccsr_skn005
      byte   dxccsr_skn006
      byte   dxccsr_skn007
      byte   dxccsr_sym001
      byte   dxccsr_sym002
      byte   dxccsr_sym003
      byte   dxccsr_sym004
      byte   dxccsr_sym005
      byte   dxccsr_sym006
      byte   dxccsr_sym007
      byte   dxccsr_sym008
      byte   dxccsr_sym009
      byte   dxccsr_sym010
      byte   dxccsr_sym011
      byte   dxccsr_sym012
      byte   dxccsr_sym013
      byte   dxccsr_sym014
      byte   dxccsr_sym015
      byte   dxccsr_sym016
      byte   dxccsr_sym017
      str6   dxccsr_version
      long   hosp_ed
      double key_ed
using NEDS_2020_DX_PR_GRPS.csv;

/*  Assign labels to the data elements */
label var cmr_aids                 "Acquired immune deficiency syndrome" ;
label var cmr_alcohol              "Alcohol abuse" ;
label var cmr_autoimmune           "Autoimmune conditions" ;
label var cmr_cancer_leuk          "Leukemia" ;
label var cmr_cancer_lymph         "Lymphoma" ;
label var cmr_cancer_mets          "Metastatic cancer" ;
label var cmr_cancer_nsitu         "Solid tumor without metastasis, in situ" ;
label var cmr_cancer_solid         "Solid tumor without metastasis, malignant" ;
label var cmr_dementia             "Dementia" ;
label var cmr_depress              "Depression" ;
label var cmr_diab_cx              "Diabetes with chronic complications" ;
label var cmr_diab_uncx            "Diabetes without chronic complications" ;
label var cmr_drug_abuse           "Drug abuse" ;
label var cmr_htn_cx               "Hypertension, complicated" ;
label var cmr_htn_uncx             "Hypertension, uncomplicated" ;
label var cmr_lung_chronic         "Chronic pulmonary disease" ;
label var cmr_obese                "Obesity" ;
label var cmr_perivasc             "Peripheral vascular disease" ;
label var cmr_thyroid_hypo         "Hypothyroidism" ;
label var cmr_thyroid_oth          "Other thyroid disorders" ;
label var cmr_version              "Version of Elixhauser Comorbidity Software Refined" ;
label var dxccsr_bld001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD001" ;
label var dxccsr_bld002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD002" ;
label var dxccsr_bld003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD003" ;
label var dxccsr_bld004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD004" ;
label var dxccsr_bld005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD005" ;
label var dxccsr_bld006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD006" ;
label var dxccsr_bld007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD007" ;
label var dxccsr_bld008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD008" ;
label var dxccsr_bld009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD009" ;
label var dxccsr_bld010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD010" ;
label var dxccsr_cir001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR001" ;
label var dxccsr_cir002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR002" ;
label var dxccsr_cir003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR003" ;
label var dxccsr_cir004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR004" ;
label var dxccsr_cir005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR005" ;
label var dxccsr_cir006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR006" ;
label var dxccsr_cir007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR007" ;
label var dxccsr_cir008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR008" ;
label var dxccsr_cir009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR009" ;
label var dxccsr_cir010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR010" ;
label var dxccsr_cir011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR011" ;
label var dxccsr_cir012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR012" ;
label var dxccsr_cir013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR013" ;
label var dxccsr_cir014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR014" ;
label var dxccsr_cir015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR015" ;
label var dxccsr_cir016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR016" ;
label var dxccsr_cir017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR017" ;
label var dxccsr_cir018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR018" ;
label var dxccsr_cir019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR019" ;
label var dxccsr_cir020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR020" ;
label var dxccsr_cir021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR021" ;
label var dxccsr_cir022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR022" ;
label var dxccsr_cir023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR023" ;
label var dxccsr_cir024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR024" ;
label var dxccsr_cir025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR025" ;
label var dxccsr_cir026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR026" ;
label var dxccsr_cir027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR027" ;
label var dxccsr_cir028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR028" ;
label var dxccsr_cir029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR029" ;
label var dxccsr_cir030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR030" ;
label var dxccsr_cir031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR031" ;
label var dxccsr_cir032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR032" ;
label var dxccsr_cir033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR033" ;
label var dxccsr_cir034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR034" ;
label var dxccsr_cir035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR035" ;
label var dxccsr_cir036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR036" ;
label var dxccsr_cir037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR037" ;
label var dxccsr_cir038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR038" ;
label var dxccsr_cir039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR039" ;
label var dxccsr_dig001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG001" ;
label var dxccsr_dig002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG002" ;
label var dxccsr_dig003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG003" ;
label var dxccsr_dig004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG004" ;
label var dxccsr_dig005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG005" ;
label var dxccsr_dig006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG006" ;
label var dxccsr_dig007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG007" ;
label var dxccsr_dig008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG008" ;
label var dxccsr_dig009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG009" ;
label var dxccsr_dig010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG010" ;
label var dxccsr_dig011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG011" ;
label var dxccsr_dig012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG012" ;
label var dxccsr_dig013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG013" ;
label var dxccsr_dig014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG014" ;
label var dxccsr_dig015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG015" ;
label var dxccsr_dig016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG016" ;
label var dxccsr_dig017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG017" ;
label var dxccsr_dig018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG018" ;
label var dxccsr_dig019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG019" ;
label var dxccsr_dig020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG020" ;
label var dxccsr_dig021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG021" ;
label var dxccsr_dig022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG022" ;
label var dxccsr_dig023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG023" ;
label var dxccsr_dig024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG024" ;
label var dxccsr_dig025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG025" ;
label var dxccsr_default_dx1       "Default CCSR for principal/first-listed ICD-10-CM diagnosis" ;
label var dxccsr_ear001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR001" ;
label var dxccsr_ear002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR002" ;
label var dxccsr_ear003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR003" ;
label var dxccsr_ear004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR004" ;
label var dxccsr_ear005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR005" ;
label var dxccsr_ear006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR006" ;
label var dxccsr_end001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END001" ;
label var dxccsr_end002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END002" ;
label var dxccsr_end003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END003" ;
label var dxccsr_end004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END004" ;
label var dxccsr_end005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END005" ;
label var dxccsr_end006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END006" ;
label var dxccsr_end007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END007" ;
label var dxccsr_end008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END008" ;
label var dxccsr_end009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END009" ;
label var dxccsr_end010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END010" ;
label var dxccsr_end011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END011" ;
label var dxccsr_end012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END012" ;
label var dxccsr_end013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END013" ;
label var dxccsr_end014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END014" ;
label var dxccsr_end015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END015" ;
label var dxccsr_end016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END016" ;
label var dxccsr_end017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END017" ;
label var dxccsr_ext001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT001" ;
label var dxccsr_ext002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT002" ;
label var dxccsr_ext003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT003" ;
label var dxccsr_ext004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT004" ;
label var dxccsr_ext005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT005" ;
label var dxccsr_ext006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT006" ;
label var dxccsr_ext007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT007" ;
label var dxccsr_ext008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT008" ;
label var dxccsr_ext009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT009" ;
label var dxccsr_ext010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT010" ;
label var dxccsr_ext011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT011" ;
label var dxccsr_ext012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT012" ;
label var dxccsr_ext013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT013" ;
label var dxccsr_ext014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT014" ;
label var dxccsr_ext015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT015" ;
label var dxccsr_ext016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT016" ;
label var dxccsr_ext017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT017" ;
label var dxccsr_ext018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT018" ;
label var dxccsr_ext019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT019" ;
label var dxccsr_ext020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT020" ;
label var dxccsr_ext021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT021" ;
label var dxccsr_ext022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT022" ;
label var dxccsr_ext023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT023" ;
label var dxccsr_ext024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT024" ;
label var dxccsr_ext025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT025" ;
label var dxccsr_ext026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT026" ;
label var dxccsr_ext027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT027" ;
label var dxccsr_ext028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT028" ;
label var dxccsr_ext029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT029" ;
label var dxccsr_ext030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT030" ;
label var dxccsr_eye001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE001" ;
label var dxccsr_eye002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE002" ;
label var dxccsr_eye003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE003" ;
label var dxccsr_eye004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE004" ;
label var dxccsr_eye005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE005" ;
label var dxccsr_eye006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE006" ;
label var dxccsr_eye007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE007" ;
label var dxccsr_eye008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE008" ;
label var dxccsr_eye009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE009" ;
label var dxccsr_eye010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE010" ;
label var dxccsr_eye011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE011" ;
label var dxccsr_eye012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE012" ;
label var dxccsr_fac001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC001" ;
label var dxccsr_fac002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC002" ;
label var dxccsr_fac003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC003" ;
label var dxccsr_fac004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC004" ;
label var dxccsr_fac005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC005" ;
label var dxccsr_fac006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC006" ;
label var dxccsr_fac007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC007" ;
label var dxccsr_fac008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC008" ;
label var dxccsr_fac009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC009" ;
label var dxccsr_fac010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC010" ;
label var dxccsr_fac011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC011" ;
label var dxccsr_fac012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC012" ;
label var dxccsr_fac013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC013" ;
label var dxccsr_fac014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC014" ;
label var dxccsr_fac015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC015" ;
label var dxccsr_fac016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC016" ;
label var dxccsr_fac017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC017" ;
label var dxccsr_fac018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC018" ;
label var dxccsr_fac019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC019" ;
label var dxccsr_fac020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC020" ;
label var dxccsr_fac021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC021" ;
label var dxccsr_fac022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC022" ;
label var dxccsr_fac023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC023" ;
label var dxccsr_fac024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC024" ;
label var dxccsr_fac025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC025" ;
label var dxccsr_gen001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN001" ;
label var dxccsr_gen002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN002" ;
label var dxccsr_gen003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN003" ;
label var dxccsr_gen004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN004" ;
label var dxccsr_gen005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN005" ;
label var dxccsr_gen006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN006" ;
label var dxccsr_gen007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN007" ;
label var dxccsr_gen008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN008" ;
label var dxccsr_gen009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN009" ;
label var dxccsr_gen010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN010" ;
label var dxccsr_gen011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN011" ;
label var dxccsr_gen012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN012" ;
label var dxccsr_gen013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN013" ;
label var dxccsr_gen014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN014" ;
label var dxccsr_gen015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN015" ;
label var dxccsr_gen016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN016" ;
label var dxccsr_gen017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN017" ;
label var dxccsr_gen018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN018" ;
label var dxccsr_gen019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN019" ;
label var dxccsr_gen020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN020" ;
label var dxccsr_gen021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN021" ;
label var dxccsr_gen022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN022" ;
label var dxccsr_gen023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN023" ;
label var dxccsr_gen024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN024" ;
label var dxccsr_gen025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN025" ;
label var dxccsr_gen026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN026" ;
label var dxccsr_inf001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF001" ;
label var dxccsr_inf002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF002" ;
label var dxccsr_inf003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF003" ;
label var dxccsr_inf004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF004" ;
label var dxccsr_inf005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF005" ;
label var dxccsr_inf006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF006" ;
label var dxccsr_inf007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF007" ;
label var dxccsr_inf008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF008" ;
label var dxccsr_inf009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF009" ;
label var dxccsr_inf010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF010" ;
label var dxccsr_inf011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF011" ;
label var dxccsr_inf012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF012" ;
label var dxccsr_inj001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ001" ;
label var dxccsr_inj002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ002" ;
label var dxccsr_inj003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ003" ;
label var dxccsr_inj004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ004" ;
label var dxccsr_inj005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ005" ;
label var dxccsr_inj006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ006" ;
label var dxccsr_inj007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ007" ;
label var dxccsr_inj008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ008" ;
label var dxccsr_inj009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ009" ;
label var dxccsr_inj010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ010" ;
label var dxccsr_inj011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ011" ;
label var dxccsr_inj012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ012" ;
label var dxccsr_inj013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ013" ;
label var dxccsr_inj014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ014" ;
label var dxccsr_inj015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ015" ;
label var dxccsr_inj016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ016" ;
label var dxccsr_inj017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ017" ;
label var dxccsr_inj018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ018" ;
label var dxccsr_inj019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ019" ;
label var dxccsr_inj020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ020" ;
label var dxccsr_inj021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ021" ;
label var dxccsr_inj022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ022" ;
label var dxccsr_inj023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ023" ;
label var dxccsr_inj024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ024" ;
label var dxccsr_inj025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ025" ;
label var dxccsr_inj026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ026" ;
label var dxccsr_inj027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ027" ;
label var dxccsr_inj028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ028" ;
label var dxccsr_inj029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ029" ;
label var dxccsr_inj030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ030" ;
label var dxccsr_inj031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ031" ;
label var dxccsr_inj032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ032" ;
label var dxccsr_inj033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ033" ;
label var dxccsr_inj034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ034" ;
label var dxccsr_inj035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ035" ;
label var dxccsr_inj036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ036" ;
label var dxccsr_inj037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ037" ;
label var dxccsr_inj038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ038" ;
label var dxccsr_inj039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ039" ;
label var dxccsr_inj040            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ040" ;
label var dxccsr_inj041            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ041" ;
label var dxccsr_inj042            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ042" ;
label var dxccsr_inj043            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ043" ;
label var dxccsr_inj044            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ044" ;
label var dxccsr_inj045            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ045" ;
label var dxccsr_inj046            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ046" ;
label var dxccsr_inj047            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ047" ;
label var dxccsr_inj048            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ048" ;
label var dxccsr_inj049            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ049" ;
label var dxccsr_inj050            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ050" ;
label var dxccsr_inj051            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ051" ;
label var dxccsr_inj052            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ052" ;
label var dxccsr_inj053            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ053" ;
label var dxccsr_inj054            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ054" ;
label var dxccsr_inj055            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ055" ;
label var dxccsr_inj056            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ056" ;
label var dxccsr_inj057            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ057" ;
label var dxccsr_inj058            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ058" ;
label var dxccsr_inj059            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ059" ;
label var dxccsr_inj060            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ060" ;
label var dxccsr_inj061            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ061" ;
label var dxccsr_inj062            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ062" ;
label var dxccsr_inj063            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ063" ;
label var dxccsr_inj064            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ064" ;
label var dxccsr_inj065            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ065" ;
label var dxccsr_inj066            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ066" ;
label var dxccsr_inj067            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ067" ;
label var dxccsr_inj068            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ068" ;
label var dxccsr_inj069            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ069" ;
label var dxccsr_inj070            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ070" ;
label var dxccsr_inj071            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ071" ;
label var dxccsr_inj072            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ072" ;
label var dxccsr_inj073            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ073" ;
label var dxccsr_inj074            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ074" ;
label var dxccsr_inj075            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ075" ;
label var dxccsr_inj076            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ076" ;
label var dxccsr_mal001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL001" ;
label var dxccsr_mal002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL002" ;
label var dxccsr_mal003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL003" ;
label var dxccsr_mal004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL004" ;
label var dxccsr_mal005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL005" ;
label var dxccsr_mal006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL006" ;
label var dxccsr_mal007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL007" ;
label var dxccsr_mal008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL008" ;
label var dxccsr_mal009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL009" ;
label var dxccsr_mal010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL010" ;
label var dxccsr_mbd001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD001" ;
label var dxccsr_mbd002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD002" ;
label var dxccsr_mbd003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD003" ;
label var dxccsr_mbd004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD004" ;
label var dxccsr_mbd005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD005" ;
label var dxccsr_mbd006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD006" ;
label var dxccsr_mbd007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD007" ;
label var dxccsr_mbd008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD008" ;
label var dxccsr_mbd009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD009" ;
label var dxccsr_mbd010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD010" ;
label var dxccsr_mbd011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD011" ;
label var dxccsr_mbd012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD012" ;
label var dxccsr_mbd013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD013" ;
label var dxccsr_mbd014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD014" ;
label var dxccsr_mbd017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD017" ;
label var dxccsr_mbd018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD018" ;
label var dxccsr_mbd019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD019" ;
label var dxccsr_mbd020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD020" ;
label var dxccsr_mbd021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD021" ;
label var dxccsr_mbd022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD022" ;
label var dxccsr_mbd023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD023" ;
label var dxccsr_mbd024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD024" ;
label var dxccsr_mbd025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD025" ;
label var dxccsr_mbd026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD026" ;
label var dxccsr_mbd027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD027" ;
label var dxccsr_mbd028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD028" ;
label var dxccsr_mbd029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD029" ;
label var dxccsr_mbd030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD030" ;
label var dxccsr_mbd031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD031" ;
label var dxccsr_mbd032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD032" ;
label var dxccsr_mbd033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD033" ;
label var dxccsr_mbd034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD034" ;
label var dxccsr_mus001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS001" ;
label var dxccsr_mus002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS002" ;
label var dxccsr_mus003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS003" ;
label var dxccsr_mus004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS004" ;
label var dxccsr_mus005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS005" ;
label var dxccsr_mus006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS006" ;
label var dxccsr_mus007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS007" ;
label var dxccsr_mus008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS008" ;
label var dxccsr_mus009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS009" ;
label var dxccsr_mus010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS010" ;
label var dxccsr_mus011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS011" ;
label var dxccsr_mus012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS012" ;
label var dxccsr_mus013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS013" ;
label var dxccsr_mus014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS014" ;
label var dxccsr_mus015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS015" ;
label var dxccsr_mus016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS016" ;
label var dxccsr_mus017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS017" ;
label var dxccsr_mus018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS018" ;
label var dxccsr_mus019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS019" ;
label var dxccsr_mus020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS020" ;
label var dxccsr_mus021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS021" ;
label var dxccsr_mus022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS022" ;
label var dxccsr_mus023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS023" ;
label var dxccsr_mus024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS024" ;
label var dxccsr_mus025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS025" ;
label var dxccsr_mus026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS026" ;
label var dxccsr_mus027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS027" ;
label var dxccsr_mus028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS028" ;
label var dxccsr_mus029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS029" ;
label var dxccsr_mus030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS030" ;
label var dxccsr_mus031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS031" ;
label var dxccsr_mus032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS032" ;
label var dxccsr_mus033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS033" ;
label var dxccsr_mus034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS034" ;
label var dxccsr_mus035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS035" ;
label var dxccsr_mus036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS036" ;
label var dxccsr_mus037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS037" ;
label var dxccsr_mus038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS038" ;
label var dxccsr_neo001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO001" ;
label var dxccsr_neo002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO002" ;
label var dxccsr_neo003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO003" ;
label var dxccsr_neo004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO004" ;
label var dxccsr_neo005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO005" ;
label var dxccsr_neo006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO006" ;
label var dxccsr_neo007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO007" ;
label var dxccsr_neo008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO008" ;
label var dxccsr_neo009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO009" ;
label var dxccsr_neo010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO010" ;
label var dxccsr_neo011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO011" ;
label var dxccsr_neo012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO012" ;
label var dxccsr_neo013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO013" ;
label var dxccsr_neo014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO014" ;
label var dxccsr_neo015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO015" ;
label var dxccsr_neo016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO016" ;
label var dxccsr_neo017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO017" ;
label var dxccsr_neo018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO018" ;
label var dxccsr_neo019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO019" ;
label var dxccsr_neo020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO020" ;
label var dxccsr_neo021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO021" ;
label var dxccsr_neo022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO022" ;
label var dxccsr_neo023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO023" ;
label var dxccsr_neo024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO024" ;
label var dxccsr_neo025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO025" ;
label var dxccsr_neo026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO026" ;
label var dxccsr_neo027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO027" ;
label var dxccsr_neo028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO028" ;
label var dxccsr_neo029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO029" ;
label var dxccsr_neo030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO030" ;
label var dxccsr_neo031            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO031" ;
label var dxccsr_neo032            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO032" ;
label var dxccsr_neo033            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO033" ;
label var dxccsr_neo034            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO034" ;
label var dxccsr_neo035            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO035" ;
label var dxccsr_neo036            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO036" ;
label var dxccsr_neo037            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO037" ;
label var dxccsr_neo038            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO038" ;
label var dxccsr_neo039            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO039" ;
label var dxccsr_neo040            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO040" ;
label var dxccsr_neo041            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO041" ;
label var dxccsr_neo042            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO042" ;
label var dxccsr_neo043            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO043" ;
label var dxccsr_neo044            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO044" ;
label var dxccsr_neo045            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO045" ;
label var dxccsr_neo046            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO046" ;
label var dxccsr_neo047            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO047" ;
label var dxccsr_neo048            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO048" ;
label var dxccsr_neo049            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO049" ;
label var dxccsr_neo050            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO050" ;
label var dxccsr_neo051            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO051" ;
label var dxccsr_neo052            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO052" ;
label var dxccsr_neo053            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO053" ;
label var dxccsr_neo054            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO054" ;
label var dxccsr_neo055            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO055" ;
label var dxccsr_neo056            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO056" ;
label var dxccsr_neo057            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO057" ;
label var dxccsr_neo058            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO058" ;
label var dxccsr_neo059            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO059" ;
label var dxccsr_neo060            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO060" ;
label var dxccsr_neo061            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO061" ;
label var dxccsr_neo062            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO062" ;
label var dxccsr_neo063            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO063" ;
label var dxccsr_neo064            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO064" ;
label var dxccsr_neo065            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO065" ;
label var dxccsr_neo066            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO066" ;
label var dxccsr_neo067            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO067" ;
label var dxccsr_neo068            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO068" ;
label var dxccsr_neo069            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO069" ;
label var dxccsr_neo070            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO070" ;
label var dxccsr_neo071            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO071" ;
label var dxccsr_neo072            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO072" ;
label var dxccsr_neo073            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO073" ;
label var dxccsr_neo074            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO074" ;
label var dxccsr_nvs001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS001" ;
label var dxccsr_nvs002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS002" ;
label var dxccsr_nvs003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS003" ;
label var dxccsr_nvs004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS004" ;
label var dxccsr_nvs005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS005" ;
label var dxccsr_nvs006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS006" ;
label var dxccsr_nvs007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS007" ;
label var dxccsr_nvs008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS008" ;
label var dxccsr_nvs009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS009" ;
label var dxccsr_nvs010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS010" ;
label var dxccsr_nvs011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS011" ;
label var dxccsr_nvs012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS012" ;
label var dxccsr_nvs013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS013" ;
label var dxccsr_nvs014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS014" ;
label var dxccsr_nvs015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS015" ;
label var dxccsr_nvs016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS016" ;
label var dxccsr_nvs017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS017" ;
label var dxccsr_nvs018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS018" ;
label var dxccsr_nvs019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS019" ;
label var dxccsr_nvs020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS020" ;
label var dxccsr_nvs021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS021" ;
label var dxccsr_nvs022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS022" ;
label var dxccsr_pnl001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL001" ;
label var dxccsr_pnl002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL002" ;
label var dxccsr_pnl003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL003" ;
label var dxccsr_pnl004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL004" ;
label var dxccsr_pnl005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL005" ;
label var dxccsr_pnl006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL006" ;
label var dxccsr_pnl007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL007" ;
label var dxccsr_pnl008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL008" ;
label var dxccsr_pnl009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL009" ;
label var dxccsr_pnl010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL010" ;
label var dxccsr_pnl011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL011" ;
label var dxccsr_pnl012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL012" ;
label var dxccsr_pnl013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL013" ;
label var dxccsr_pnl014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL014" ;
label var dxccsr_pnl015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL015" ;
label var dxccsr_prg001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG001" ;
label var dxccsr_prg002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG002" ;
label var dxccsr_prg003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG003" ;
label var dxccsr_prg004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG004" ;
label var dxccsr_prg005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG005" ;
label var dxccsr_prg006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG006" ;
label var dxccsr_prg007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG007" ;
label var dxccsr_prg008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG008" ;
label var dxccsr_prg009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG009" ;
label var dxccsr_prg010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG010" ;
label var dxccsr_prg011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG011" ;
label var dxccsr_prg012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG012" ;
label var dxccsr_prg013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG013" ;
label var dxccsr_prg014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG014" ;
label var dxccsr_prg015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG015" ;
label var dxccsr_prg016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG016" ;
label var dxccsr_prg017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG017" ;
label var dxccsr_prg018            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG018" ;
label var dxccsr_prg019            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG019" ;
label var dxccsr_prg020            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG020" ;
label var dxccsr_prg021            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG021" ;
label var dxccsr_prg022            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG022" ;
label var dxccsr_prg023            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG023" ;
label var dxccsr_prg024            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG024" ;
label var dxccsr_prg025            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG025" ;
label var dxccsr_prg026            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG026" ;
label var dxccsr_prg027            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG027" ;
label var dxccsr_prg028            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG028" ;
label var dxccsr_prg029            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG029" ;
label var dxccsr_prg030            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG030" ;
label var dxccsr_rsp001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP001" ;
label var dxccsr_rsp002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP002" ;
label var dxccsr_rsp003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP003" ;
label var dxccsr_rsp004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP004" ;
label var dxccsr_rsp005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP005" ;
label var dxccsr_rsp006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP006" ;
label var dxccsr_rsp007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP007" ;
label var dxccsr_rsp008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP008" ;
label var dxccsr_rsp009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP009" ;
label var dxccsr_rsp010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP010" ;
label var dxccsr_rsp011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP011" ;
label var dxccsr_rsp012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP012" ;
label var dxccsr_rsp013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP013" ;
label var dxccsr_rsp014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP014" ;
label var dxccsr_rsp015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP015" ;
label var dxccsr_rsp016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP016" ;
label var dxccsr_rsp017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP017" ;
label var dxccsr_skn001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN001" ;
label var dxccsr_skn002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN002" ;
label var dxccsr_skn003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN003" ;
label var dxccsr_skn004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN004" ;
label var dxccsr_skn005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN005" ;
label var dxccsr_skn006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN006" ;
label var dxccsr_skn007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN007" ;
label var dxccsr_sym001            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM001" ;
label var dxccsr_sym002            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM002" ;
label var dxccsr_sym003            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM003" ;
label var dxccsr_sym004            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM004" ;
label var dxccsr_sym005            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM005" ;
label var dxccsr_sym006            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM006" ;
label var dxccsr_sym007            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM007" ;
label var dxccsr_sym008            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM008" ;
label var dxccsr_sym009            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM009" ;
label var dxccsr_sym010            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM010" ;
label var dxccsr_sym011            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM011" ;
label var dxccsr_sym012            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM012" ;
label var dxccsr_sym013            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM013" ;
label var dxccsr_sym014            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM014" ;
label var dxccsr_sym015            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM015" ;
label var dxccsr_sym016            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM016" ;
label var dxccsr_sym017            "Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM017" ;
label var dxccsr_version           "Version of CCSR for ICD-10-CM diagnoses" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var key_ed                   "HCUP NEDS record identifier" ;

/* Convert special values to missing values */
recode cmr_aids                  (-9 -8 -6 -5=.) ;
recode cmr_alcohol               (-9 -8 -6 -5=.) ;
recode cmr_autoimmune            (-9 -8 -6 -5=.) ;
recode cmr_cancer_leuk           (-9 -8 -6 -5=.) ;
recode cmr_cancer_lymph          (-9 -8 -6 -5=.) ;
recode cmr_cancer_mets           (-9 -8 -6 -5=.) ;
recode cmr_cancer_nsitu          (-9 -8 -6 -5=.) ;
recode cmr_cancer_solid          (-9 -8 -6 -5=.) ;
recode cmr_dementia              (-9 -8 -6 -5=.) ;
recode cmr_depress               (-9 -8 -6 -5=.) ;
recode cmr_diab_cx               (-9 -8 -6 -5=.) ;
recode cmr_diab_uncx             (-9 -8 -6 -5=.) ;
recode cmr_drug_abuse            (-9 -8 -6 -5=.) ;
recode cmr_htn_cx                (-9 -8 -6 -5=.) ;
recode cmr_htn_uncx              (-9 -8 -6 -5=.) ;
recode cmr_lung_chronic          (-9 -8 -6 -5=.) ;
recode cmr_obese                 (-9 -8 -6 -5=.) ;
recode cmr_perivasc              (-9 -8 -6 -5=.) ;
recode cmr_thyroid_hypo          (-9 -8 -6 -5=.) ;
recode cmr_thyroid_oth           (-9 -8 -6 -5=.) ;
recode dxccsr_bld001             (-9 -8 -6 -5=.) ;
recode dxccsr_bld002             (-9 -8 -6 -5=.) ;
recode dxccsr_bld003             (-9 -8 -6 -5=.) ;
recode dxccsr_bld004             (-9 -8 -6 -5=.) ;
recode dxccsr_bld005             (-9 -8 -6 -5=.) ;
recode dxccsr_bld006             (-9 -8 -6 -5=.) ;
recode dxccsr_bld007             (-9 -8 -6 -5=.) ;
recode dxccsr_bld008             (-9 -8 -6 -5=.) ;
recode dxccsr_bld009             (-9 -8 -6 -5=.) ;
recode dxccsr_bld010             (-9 -8 -6 -5=.) ;
recode dxccsr_cir001             (-9 -8 -6 -5=.) ;
recode dxccsr_cir002             (-9 -8 -6 -5=.) ;
recode dxccsr_cir003             (-9 -8 -6 -5=.) ;
recode dxccsr_cir004             (-9 -8 -6 -5=.) ;
recode dxccsr_cir005             (-9 -8 -6 -5=.) ;
recode dxccsr_cir006             (-9 -8 -6 -5=.) ;
recode dxccsr_cir007             (-9 -8 -6 -5=.) ;
recode dxccsr_cir008             (-9 -8 -6 -5=.) ;
recode dxccsr_cir009             (-9 -8 -6 -5=.) ;
recode dxccsr_cir010             (-9 -8 -6 -5=.) ;
recode dxccsr_cir011             (-9 -8 -6 -5=.) ;
recode dxccsr_cir012             (-9 -8 -6 -5=.) ;
recode dxccsr_cir013             (-9 -8 -6 -5=.) ;
recode dxccsr_cir014             (-9 -8 -6 -5=.) ;
recode dxccsr_cir015             (-9 -8 -6 -5=.) ;
recode dxccsr_cir016             (-9 -8 -6 -5=.) ;
recode dxccsr_cir017             (-9 -8 -6 -5=.) ;
recode dxccsr_cir018             (-9 -8 -6 -5=.) ;
recode dxccsr_cir019             (-9 -8 -6 -5=.) ;
recode dxccsr_cir020             (-9 -8 -6 -5=.) ;
recode dxccsr_cir021             (-9 -8 -6 -5=.) ;
recode dxccsr_cir022             (-9 -8 -6 -5=.) ;
recode dxccsr_cir023             (-9 -8 -6 -5=.) ;
recode dxccsr_cir024             (-9 -8 -6 -5=.) ;
recode dxccsr_cir025             (-9 -8 -6 -5=.) ;
recode dxccsr_cir026             (-9 -8 -6 -5=.) ;
recode dxccsr_cir027             (-9 -8 -6 -5=.) ;
recode dxccsr_cir028             (-9 -8 -6 -5=.) ;
recode dxccsr_cir029             (-9 -8 -6 -5=.) ;
recode dxccsr_cir030             (-9 -8 -6 -5=.) ;
recode dxccsr_cir031             (-9 -8 -6 -5=.) ;
recode dxccsr_cir032             (-9 -8 -6 -5=.) ;
recode dxccsr_cir033             (-9 -8 -6 -5=.) ;
recode dxccsr_cir034             (-9 -8 -6 -5=.) ;
recode dxccsr_cir035             (-9 -8 -6 -5=.) ;
recode dxccsr_cir036             (-9 -8 -6 -5=.) ;
recode dxccsr_cir037             (-9 -8 -6 -5=.) ;
recode dxccsr_cir038             (-9 -8 -6 -5=.) ;
recode dxccsr_cir039             (-9 -8 -6 -5=.) ;
recode dxccsr_dig001             (-9 -8 -6 -5=.) ;
recode dxccsr_dig002             (-9 -8 -6 -5=.) ;
recode dxccsr_dig003             (-9 -8 -6 -5=.) ;
recode dxccsr_dig004             (-9 -8 -6 -5=.) ;
recode dxccsr_dig005             (-9 -8 -6 -5=.) ;
recode dxccsr_dig006             (-9 -8 -6 -5=.) ;
recode dxccsr_dig007             (-9 -8 -6 -5=.) ;
recode dxccsr_dig008             (-9 -8 -6 -5=.) ;
recode dxccsr_dig009             (-9 -8 -6 -5=.) ;
recode dxccsr_dig010             (-9 -8 -6 -5=.) ;
recode dxccsr_dig011             (-9 -8 -6 -5=.) ;
recode dxccsr_dig012             (-9 -8 -6 -5=.) ;
recode dxccsr_dig013             (-9 -8 -6 -5=.) ;
recode dxccsr_dig014             (-9 -8 -6 -5=.) ;
recode dxccsr_dig015             (-9 -8 -6 -5=.) ;
recode dxccsr_dig016             (-9 -8 -6 -5=.) ;
recode dxccsr_dig017             (-9 -8 -6 -5=.) ;
recode dxccsr_dig018             (-9 -8 -6 -5=.) ;
recode dxccsr_dig019             (-9 -8 -6 -5=.) ;
recode dxccsr_dig020             (-9 -8 -6 -5=.) ;
recode dxccsr_dig021             (-9 -8 -6 -5=.) ;
recode dxccsr_dig022             (-9 -8 -6 -5=.) ;
recode dxccsr_dig023             (-9 -8 -6 -5=.) ;
recode dxccsr_dig024             (-9 -8 -6 -5=.) ;
recode dxccsr_dig025             (-9 -8 -6 -5=.) ;
recode dxccsr_ear001             (-9 -8 -6 -5=.) ;
recode dxccsr_ear002             (-9 -8 -6 -5=.) ;
recode dxccsr_ear003             (-9 -8 -6 -5=.) ;
recode dxccsr_ear004             (-9 -8 -6 -5=.) ;
recode dxccsr_ear005             (-9 -8 -6 -5=.) ;
recode dxccsr_ear006             (-9 -8 -6 -5=.) ;
recode dxccsr_end001             (-9 -8 -6 -5=.) ;
recode dxccsr_end002             (-9 -8 -6 -5=.) ;
recode dxccsr_end003             (-9 -8 -6 -5=.) ;
recode dxccsr_end004             (-9 -8 -6 -5=.) ;
recode dxccsr_end005             (-9 -8 -6 -5=.) ;
recode dxccsr_end006             (-9 -8 -6 -5=.) ;
recode dxccsr_end007             (-9 -8 -6 -5=.) ;
recode dxccsr_end008             (-9 -8 -6 -5=.) ;
recode dxccsr_end009             (-9 -8 -6 -5=.) ;
recode dxccsr_end010             (-9 -8 -6 -5=.) ;
recode dxccsr_end011             (-9 -8 -6 -5=.) ;
recode dxccsr_end012             (-9 -8 -6 -5=.) ;
recode dxccsr_end013             (-9 -8 -6 -5=.) ;
recode dxccsr_end014             (-9 -8 -6 -5=.) ;
recode dxccsr_end015             (-9 -8 -6 -5=.) ;
recode dxccsr_end016             (-9 -8 -6 -5=.) ;
recode dxccsr_end017             (-9 -8 -6 -5=.) ;
recode dxccsr_ext001             (-9 -8 -6 -5=.) ;
recode dxccsr_ext002             (-9 -8 -6 -5=.) ;
recode dxccsr_ext003             (-9 -8 -6 -5=.) ;
recode dxccsr_ext004             (-9 -8 -6 -5=.) ;
recode dxccsr_ext005             (-9 -8 -6 -5=.) ;
recode dxccsr_ext006             (-9 -8 -6 -5=.) ;
recode dxccsr_ext007             (-9 -8 -6 -5=.) ;
recode dxccsr_ext008             (-9 -8 -6 -5=.) ;
recode dxccsr_ext009             (-9 -8 -6 -5=.) ;
recode dxccsr_ext010             (-9 -8 -6 -5=.) ;
recode dxccsr_ext011             (-9 -8 -6 -5=.) ;
recode dxccsr_ext012             (-9 -8 -6 -5=.) ;
recode dxccsr_ext013             (-9 -8 -6 -5=.) ;
recode dxccsr_ext014             (-9 -8 -6 -5=.) ;
recode dxccsr_ext015             (-9 -8 -6 -5=.) ;
recode dxccsr_ext016             (-9 -8 -6 -5=.) ;
recode dxccsr_ext017             (-9 -8 -6 -5=.) ;
recode dxccsr_ext018             (-9 -8 -6 -5=.) ;
recode dxccsr_ext019             (-9 -8 -6 -5=.) ;
recode dxccsr_ext020             (-9 -8 -6 -5=.) ;
recode dxccsr_ext021             (-9 -8 -6 -5=.) ;
recode dxccsr_ext022             (-9 -8 -6 -5=.) ;
recode dxccsr_ext023             (-9 -8 -6 -5=.) ;
recode dxccsr_ext024             (-9 -8 -6 -5=.) ;
recode dxccsr_ext025             (-9 -8 -6 -5=.) ;
recode dxccsr_ext026             (-9 -8 -6 -5=.) ;
recode dxccsr_ext027             (-9 -8 -6 -5=.) ;
recode dxccsr_ext028             (-9 -8 -6 -5=.) ;
recode dxccsr_ext029             (-9 -8 -6 -5=.) ;
recode dxccsr_ext030             (-9 -8 -6 -5=.) ;
recode dxccsr_eye001             (-9 -8 -6 -5=.) ;
recode dxccsr_eye002             (-9 -8 -6 -5=.) ;
recode dxccsr_eye003             (-9 -8 -6 -5=.) ;
recode dxccsr_eye004             (-9 -8 -6 -5=.) ;
recode dxccsr_eye005             (-9 -8 -6 -5=.) ;
recode dxccsr_eye006             (-9 -8 -6 -5=.) ;
recode dxccsr_eye007             (-9 -8 -6 -5=.) ;
recode dxccsr_eye008             (-9 -8 -6 -5=.) ;
recode dxccsr_eye009             (-9 -8 -6 -5=.) ;
recode dxccsr_eye010             (-9 -8 -6 -5=.) ;
recode dxccsr_eye011             (-9 -8 -6 -5=.) ;
recode dxccsr_eye012             (-9 -8 -6 -5=.) ;
recode dxccsr_fac001             (-9 -8 -6 -5=.) ;
recode dxccsr_fac002             (-9 -8 -6 -5=.) ;
recode dxccsr_fac003             (-9 -8 -6 -5=.) ;
recode dxccsr_fac004             (-9 -8 -6 -5=.) ;
recode dxccsr_fac005             (-9 -8 -6 -5=.) ;
recode dxccsr_fac006             (-9 -8 -6 -5=.) ;
recode dxccsr_fac007             (-9 -8 -6 -5=.) ;
recode dxccsr_fac008             (-9 -8 -6 -5=.) ;
recode dxccsr_fac009             (-9 -8 -6 -5=.) ;
recode dxccsr_fac010             (-9 -8 -6 -5=.) ;
recode dxccsr_fac011             (-9 -8 -6 -5=.) ;
recode dxccsr_fac012             (-9 -8 -6 -5=.) ;
recode dxccsr_fac013             (-9 -8 -6 -5=.) ;
recode dxccsr_fac014             (-9 -8 -6 -5=.) ;
recode dxccsr_fac015             (-9 -8 -6 -5=.) ;
recode dxccsr_fac016             (-9 -8 -6 -5=.) ;
recode dxccsr_fac017             (-9 -8 -6 -5=.) ;
recode dxccsr_fac018             (-9 -8 -6 -5=.) ;
recode dxccsr_fac019             (-9 -8 -6 -5=.) ;
recode dxccsr_fac020             (-9 -8 -6 -5=.) ;
recode dxccsr_fac021             (-9 -8 -6 -5=.) ;
recode dxccsr_fac022             (-9 -8 -6 -5=.) ;
recode dxccsr_fac023             (-9 -8 -6 -5=.) ;
recode dxccsr_fac024             (-9 -8 -6 -5=.) ;
recode dxccsr_fac025             (-9 -8 -6 -5=.) ;
recode dxccsr_gen001             (-9 -8 -6 -5=.) ;
recode dxccsr_gen002             (-9 -8 -6 -5=.) ;
recode dxccsr_gen003             (-9 -8 -6 -5=.) ;
recode dxccsr_gen004             (-9 -8 -6 -5=.) ;
recode dxccsr_gen005             (-9 -8 -6 -5=.) ;
recode dxccsr_gen006             (-9 -8 -6 -5=.) ;
recode dxccsr_gen007             (-9 -8 -6 -5=.) ;
recode dxccsr_gen008             (-9 -8 -6 -5=.) ;
recode dxccsr_gen009             (-9 -8 -6 -5=.) ;
recode dxccsr_gen010             (-9 -8 -6 -5=.) ;
recode dxccsr_gen011             (-9 -8 -6 -5=.) ;
recode dxccsr_gen012             (-9 -8 -6 -5=.) ;
recode dxccsr_gen013             (-9 -8 -6 -5=.) ;
recode dxccsr_gen014             (-9 -8 -6 -5=.) ;
recode dxccsr_gen015             (-9 -8 -6 -5=.) ;
recode dxccsr_gen016             (-9 -8 -6 -5=.) ;
recode dxccsr_gen017             (-9 -8 -6 -5=.) ;
recode dxccsr_gen018             (-9 -8 -6 -5=.) ;
recode dxccsr_gen019             (-9 -8 -6 -5=.) ;
recode dxccsr_gen020             (-9 -8 -6 -5=.) ;
recode dxccsr_gen021             (-9 -8 -6 -5=.) ;
recode dxccsr_gen022             (-9 -8 -6 -5=.) ;
recode dxccsr_gen023             (-9 -8 -6 -5=.) ;
recode dxccsr_gen024             (-9 -8 -6 -5=.) ;
recode dxccsr_gen025             (-9 -8 -6 -5=.) ;
recode dxccsr_gen026             (-9 -8 -6 -5=.) ;
recode dxccsr_inf001             (-9 -8 -6 -5=.) ;
recode dxccsr_inf002             (-9 -8 -6 -5=.) ;
recode dxccsr_inf003             (-9 -8 -6 -5=.) ;
recode dxccsr_inf004             (-9 -8 -6 -5=.) ;
recode dxccsr_inf005             (-9 -8 -6 -5=.) ;
recode dxccsr_inf006             (-9 -8 -6 -5=.) ;
recode dxccsr_inf007             (-9 -8 -6 -5=.) ;
recode dxccsr_inf008             (-9 -8 -6 -5=.) ;
recode dxccsr_inf009             (-9 -8 -6 -5=.) ;
recode dxccsr_inf010             (-9 -8 -6 -5=.) ;
recode dxccsr_inf011             (-9 -8 -6 -5=.) ;
recode dxccsr_inf012             (-9 -8 -6 -5=.) ;
recode dxccsr_inj001             (-9 -8 -6 -5=.) ;
recode dxccsr_inj002             (-9 -8 -6 -5=.) ;
recode dxccsr_inj003             (-9 -8 -6 -5=.) ;
recode dxccsr_inj004             (-9 -8 -6 -5=.) ;
recode dxccsr_inj005             (-9 -8 -6 -5=.) ;
recode dxccsr_inj006             (-9 -8 -6 -5=.) ;
recode dxccsr_inj007             (-9 -8 -6 -5=.) ;
recode dxccsr_inj008             (-9 -8 -6 -5=.) ;
recode dxccsr_inj009             (-9 -8 -6 -5=.) ;
recode dxccsr_inj010             (-9 -8 -6 -5=.) ;
recode dxccsr_inj011             (-9 -8 -6 -5=.) ;
recode dxccsr_inj012             (-9 -8 -6 -5=.) ;
recode dxccsr_inj013             (-9 -8 -6 -5=.) ;
recode dxccsr_inj014             (-9 -8 -6 -5=.) ;
recode dxccsr_inj015             (-9 -8 -6 -5=.) ;
recode dxccsr_inj016             (-9 -8 -6 -5=.) ;
recode dxccsr_inj017             (-9 -8 -6 -5=.) ;
recode dxccsr_inj018             (-9 -8 -6 -5=.) ;
recode dxccsr_inj019             (-9 -8 -6 -5=.) ;
recode dxccsr_inj020             (-9 -8 -6 -5=.) ;
recode dxccsr_inj021             (-9 -8 -6 -5=.) ;
recode dxccsr_inj022             (-9 -8 -6 -5=.) ;
recode dxccsr_inj023             (-9 -8 -6 -5=.) ;
recode dxccsr_inj024             (-9 -8 -6 -5=.) ;
recode dxccsr_inj025             (-9 -8 -6 -5=.) ;
recode dxccsr_inj026             (-9 -8 -6 -5=.) ;
recode dxccsr_inj027             (-9 -8 -6 -5=.) ;
recode dxccsr_inj028             (-9 -8 -6 -5=.) ;
recode dxccsr_inj029             (-9 -8 -6 -5=.) ;
recode dxccsr_inj030             (-9 -8 -6 -5=.) ;
recode dxccsr_inj031             (-9 -8 -6 -5=.) ;
recode dxccsr_inj032             (-9 -8 -6 -5=.) ;
recode dxccsr_inj033             (-9 -8 -6 -5=.) ;
recode dxccsr_inj034             (-9 -8 -6 -5=.) ;
recode dxccsr_inj035             (-9 -8 -6 -5=.) ;
recode dxccsr_inj036             (-9 -8 -6 -5=.) ;
recode dxccsr_inj037             (-9 -8 -6 -5=.) ;
recode dxccsr_inj038             (-9 -8 -6 -5=.) ;
recode dxccsr_inj039             (-9 -8 -6 -5=.) ;
recode dxccsr_inj040             (-9 -8 -6 -5=.) ;
recode dxccsr_inj041             (-9 -8 -6 -5=.) ;
recode dxccsr_inj042             (-9 -8 -6 -5=.) ;
recode dxccsr_inj043             (-9 -8 -6 -5=.) ;
recode dxccsr_inj044             (-9 -8 -6 -5=.) ;
recode dxccsr_inj045             (-9 -8 -6 -5=.) ;
recode dxccsr_inj046             (-9 -8 -6 -5=.) ;
recode dxccsr_inj047             (-9 -8 -6 -5=.) ;
recode dxccsr_inj048             (-9 -8 -6 -5=.) ;
recode dxccsr_inj049             (-9 -8 -6 -5=.) ;
recode dxccsr_inj050             (-9 -8 -6 -5=.) ;
recode dxccsr_inj051             (-9 -8 -6 -5=.) ;
recode dxccsr_inj052             (-9 -8 -6 -5=.) ;
recode dxccsr_inj053             (-9 -8 -6 -5=.) ;
recode dxccsr_inj054             (-9 -8 -6 -5=.) ;
recode dxccsr_inj055             (-9 -8 -6 -5=.) ;
recode dxccsr_inj056             (-9 -8 -6 -5=.) ;
recode dxccsr_inj057             (-9 -8 -6 -5=.) ;
recode dxccsr_inj058             (-9 -8 -6 -5=.) ;
recode dxccsr_inj059             (-9 -8 -6 -5=.) ;
recode dxccsr_inj060             (-9 -8 -6 -5=.) ;
recode dxccsr_inj061             (-9 -8 -6 -5=.) ;
recode dxccsr_inj062             (-9 -8 -6 -5=.) ;
recode dxccsr_inj063             (-9 -8 -6 -5=.) ;
recode dxccsr_inj064             (-9 -8 -6 -5=.) ;
recode dxccsr_inj065             (-9 -8 -6 -5=.) ;
recode dxccsr_inj066             (-9 -8 -6 -5=.) ;
recode dxccsr_inj067             (-9 -8 -6 -5=.) ;
recode dxccsr_inj068             (-9 -8 -6 -5=.) ;
recode dxccsr_inj069             (-9 -8 -6 -5=.) ;
recode dxccsr_inj070             (-9 -8 -6 -5=.) ;
recode dxccsr_inj071             (-9 -8 -6 -5=.) ;
recode dxccsr_inj072             (-9 -8 -6 -5=.) ;
recode dxccsr_inj073             (-9 -8 -6 -5=.) ;
recode dxccsr_inj074             (-9 -8 -6 -5=.) ;
recode dxccsr_inj075             (-9 -8 -6 -5=.) ;
recode dxccsr_inj076             (-9 -8 -6 -5=.) ;
recode dxccsr_mal001             (-9 -8 -6 -5=.) ;
recode dxccsr_mal002             (-9 -8 -6 -5=.) ;
recode dxccsr_mal003             (-9 -8 -6 -5=.) ;
recode dxccsr_mal004             (-9 -8 -6 -5=.) ;
recode dxccsr_mal005             (-9 -8 -6 -5=.) ;
recode dxccsr_mal006             (-9 -8 -6 -5=.) ;
recode dxccsr_mal007             (-9 -8 -6 -5=.) ;
recode dxccsr_mal008             (-9 -8 -6 -5=.) ;
recode dxccsr_mal009             (-9 -8 -6 -5=.) ;
recode dxccsr_mal010             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd001             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd002             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd003             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd004             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd005             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd006             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd007             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd008             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd009             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd010             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd011             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd012             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd013             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd014             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd017             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd018             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd019             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd020             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd021             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd022             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd023             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd024             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd025             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd026             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd027             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd028             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd029             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd030             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd031             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd032             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd033             (-9 -8 -6 -5=.) ;
recode dxccsr_mbd034             (-9 -8 -6 -5=.) ;
recode dxccsr_mus001             (-9 -8 -6 -5=.) ;
recode dxccsr_mus002             (-9 -8 -6 -5=.) ;
recode dxccsr_mus003             (-9 -8 -6 -5=.) ;
recode dxccsr_mus004             (-9 -8 -6 -5=.) ;
recode dxccsr_mus005             (-9 -8 -6 -5=.) ;
recode dxccsr_mus006             (-9 -8 -6 -5=.) ;
recode dxccsr_mus007             (-9 -8 -6 -5=.) ;
recode dxccsr_mus008             (-9 -8 -6 -5=.) ;
recode dxccsr_mus009             (-9 -8 -6 -5=.) ;
recode dxccsr_mus010             (-9 -8 -6 -5=.) ;
recode dxccsr_mus011             (-9 -8 -6 -5=.) ;
recode dxccsr_mus012             (-9 -8 -6 -5=.) ;
recode dxccsr_mus013             (-9 -8 -6 -5=.) ;
recode dxccsr_mus014             (-9 -8 -6 -5=.) ;
recode dxccsr_mus015             (-9 -8 -6 -5=.) ;
recode dxccsr_mus016             (-9 -8 -6 -5=.) ;
recode dxccsr_mus017             (-9 -8 -6 -5=.) ;
recode dxccsr_mus018             (-9 -8 -6 -5=.) ;
recode dxccsr_mus019             (-9 -8 -6 -5=.) ;
recode dxccsr_mus020             (-9 -8 -6 -5=.) ;
recode dxccsr_mus021             (-9 -8 -6 -5=.) ;
recode dxccsr_mus022             (-9 -8 -6 -5=.) ;
recode dxccsr_mus023             (-9 -8 -6 -5=.) ;
recode dxccsr_mus024             (-9 -8 -6 -5=.) ;
recode dxccsr_mus025             (-9 -8 -6 -5=.) ;
recode dxccsr_mus026             (-9 -8 -6 -5=.) ;
recode dxccsr_mus027             (-9 -8 -6 -5=.) ;
recode dxccsr_mus028             (-9 -8 -6 -5=.) ;
recode dxccsr_mus029             (-9 -8 -6 -5=.) ;
recode dxccsr_mus030             (-9 -8 -6 -5=.) ;
recode dxccsr_mus031             (-9 -8 -6 -5=.) ;
recode dxccsr_mus032             (-9 -8 -6 -5=.) ;
recode dxccsr_mus033             (-9 -8 -6 -5=.) ;
recode dxccsr_mus034             (-9 -8 -6 -5=.) ;
recode dxccsr_mus035             (-9 -8 -6 -5=.) ;
recode dxccsr_mus036             (-9 -8 -6 -5=.) ;
recode dxccsr_mus037             (-9 -8 -6 -5=.) ;
recode dxccsr_mus038             (-9 -8 -6 -5=.) ;
recode dxccsr_neo001             (-9 -8 -6 -5=.) ;
recode dxccsr_neo002             (-9 -8 -6 -5=.) ;
recode dxccsr_neo003             (-9 -8 -6 -5=.) ;
recode dxccsr_neo004             (-9 -8 -6 -5=.) ;
recode dxccsr_neo005             (-9 -8 -6 -5=.) ;
recode dxccsr_neo006             (-9 -8 -6 -5=.) ;
recode dxccsr_neo007             (-9 -8 -6 -5=.) ;
recode dxccsr_neo008             (-9 -8 -6 -5=.) ;
recode dxccsr_neo009             (-9 -8 -6 -5=.) ;
recode dxccsr_neo010             (-9 -8 -6 -5=.) ;
recode dxccsr_neo011             (-9 -8 -6 -5=.) ;
recode dxccsr_neo012             (-9 -8 -6 -5=.) ;
recode dxccsr_neo013             (-9 -8 -6 -5=.) ;
recode dxccsr_neo014             (-9 -8 -6 -5=.) ;
recode dxccsr_neo015             (-9 -8 -6 -5=.) ;
recode dxccsr_neo016             (-9 -8 -6 -5=.) ;
recode dxccsr_neo017             (-9 -8 -6 -5=.) ;
recode dxccsr_neo018             (-9 -8 -6 -5=.) ;
recode dxccsr_neo019             (-9 -8 -6 -5=.) ;
recode dxccsr_neo020             (-9 -8 -6 -5=.) ;
recode dxccsr_neo021             (-9 -8 -6 -5=.) ;
recode dxccsr_neo022             (-9 -8 -6 -5=.) ;
recode dxccsr_neo023             (-9 -8 -6 -5=.) ;
recode dxccsr_neo024             (-9 -8 -6 -5=.) ;
recode dxccsr_neo025             (-9 -8 -6 -5=.) ;
recode dxccsr_neo026             (-9 -8 -6 -5=.) ;
recode dxccsr_neo027             (-9 -8 -6 -5=.) ;
recode dxccsr_neo028             (-9 -8 -6 -5=.) ;
recode dxccsr_neo029             (-9 -8 -6 -5=.) ;
recode dxccsr_neo030             (-9 -8 -6 -5=.) ;
recode dxccsr_neo031             (-9 -8 -6 -5=.) ;
recode dxccsr_neo032             (-9 -8 -6 -5=.) ;
recode dxccsr_neo033             (-9 -8 -6 -5=.) ;
recode dxccsr_neo034             (-9 -8 -6 -5=.) ;
recode dxccsr_neo035             (-9 -8 -6 -5=.) ;
recode dxccsr_neo036             (-9 -8 -6 -5=.) ;
recode dxccsr_neo037             (-9 -8 -6 -5=.) ;
recode dxccsr_neo038             (-9 -8 -6 -5=.) ;
recode dxccsr_neo039             (-9 -8 -6 -5=.) ;
recode dxccsr_neo040             (-9 -8 -6 -5=.) ;
recode dxccsr_neo041             (-9 -8 -6 -5=.) ;
recode dxccsr_neo042             (-9 -8 -6 -5=.) ;
recode dxccsr_neo043             (-9 -8 -6 -5=.) ;
recode dxccsr_neo044             (-9 -8 -6 -5=.) ;
recode dxccsr_neo045             (-9 -8 -6 -5=.) ;
recode dxccsr_neo046             (-9 -8 -6 -5=.) ;
recode dxccsr_neo047             (-9 -8 -6 -5=.) ;
recode dxccsr_neo048             (-9 -8 -6 -5=.) ;
recode dxccsr_neo049             (-9 -8 -6 -5=.) ;
recode dxccsr_neo050             (-9 -8 -6 -5=.) ;
recode dxccsr_neo051             (-9 -8 -6 -5=.) ;
recode dxccsr_neo052             (-9 -8 -6 -5=.) ;
recode dxccsr_neo053             (-9 -8 -6 -5=.) ;
recode dxccsr_neo054             (-9 -8 -6 -5=.) ;
recode dxccsr_neo055             (-9 -8 -6 -5=.) ;
recode dxccsr_neo056             (-9 -8 -6 -5=.) ;
recode dxccsr_neo057             (-9 -8 -6 -5=.) ;
recode dxccsr_neo058             (-9 -8 -6 -5=.) ;
recode dxccsr_neo059             (-9 -8 -6 -5=.) ;
recode dxccsr_neo060             (-9 -8 -6 -5=.) ;
recode dxccsr_neo061             (-9 -8 -6 -5=.) ;
recode dxccsr_neo062             (-9 -8 -6 -5=.) ;
recode dxccsr_neo063             (-9 -8 -6 -5=.) ;
recode dxccsr_neo064             (-9 -8 -6 -5=.) ;
recode dxccsr_neo065             (-9 -8 -6 -5=.) ;
recode dxccsr_neo066             (-9 -8 -6 -5=.) ;
recode dxccsr_neo067             (-9 -8 -6 -5=.) ;
recode dxccsr_neo068             (-9 -8 -6 -5=.) ;
recode dxccsr_neo069             (-9 -8 -6 -5=.) ;
recode dxccsr_neo070             (-9 -8 -6 -5=.) ;
recode dxccsr_neo071             (-9 -8 -6 -5=.) ;
recode dxccsr_neo072             (-9 -8 -6 -5=.) ;
recode dxccsr_neo073             (-9 -8 -6 -5=.) ;
recode dxccsr_neo074             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs001             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs002             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs003             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs004             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs005             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs006             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs007             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs008             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs009             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs010             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs011             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs012             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs013             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs014             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs015             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs016             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs017             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs018             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs019             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs020             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs021             (-9 -8 -6 -5=.) ;
recode dxccsr_nvs022             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl001             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl002             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl003             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl004             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl005             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl006             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl007             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl008             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl009             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl010             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl011             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl012             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl013             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl014             (-9 -8 -6 -5=.) ;
recode dxccsr_pnl015             (-9 -8 -6 -5=.) ;
recode dxccsr_prg001             (-9 -8 -6 -5=.) ;
recode dxccsr_prg002             (-9 -8 -6 -5=.) ;
recode dxccsr_prg003             (-9 -8 -6 -5=.) ;
recode dxccsr_prg004             (-9 -8 -6 -5=.) ;
recode dxccsr_prg005             (-9 -8 -6 -5=.) ;
recode dxccsr_prg006             (-9 -8 -6 -5=.) ;
recode dxccsr_prg007             (-9 -8 -6 -5=.) ;
recode dxccsr_prg008             (-9 -8 -6 -5=.) ;
recode dxccsr_prg009             (-9 -8 -6 -5=.) ;
recode dxccsr_prg010             (-9 -8 -6 -5=.) ;
recode dxccsr_prg011             (-9 -8 -6 -5=.) ;
recode dxccsr_prg012             (-9 -8 -6 -5=.) ;
recode dxccsr_prg013             (-9 -8 -6 -5=.) ;
recode dxccsr_prg014             (-9 -8 -6 -5=.) ;
recode dxccsr_prg015             (-9 -8 -6 -5=.) ;
recode dxccsr_prg016             (-9 -8 -6 -5=.) ;
recode dxccsr_prg017             (-9 -8 -6 -5=.) ;
recode dxccsr_prg018             (-9 -8 -6 -5=.) ;
recode dxccsr_prg019             (-9 -8 -6 -5=.) ;
recode dxccsr_prg020             (-9 -8 -6 -5=.) ;
recode dxccsr_prg021             (-9 -8 -6 -5=.) ;
recode dxccsr_prg022             (-9 -8 -6 -5=.) ;
recode dxccsr_prg023             (-9 -8 -6 -5=.) ;
recode dxccsr_prg024             (-9 -8 -6 -5=.) ;
recode dxccsr_prg025             (-9 -8 -6 -5=.) ;
recode dxccsr_prg026             (-9 -8 -6 -5=.) ;
recode dxccsr_prg027             (-9 -8 -6 -5=.) ;
recode dxccsr_prg028             (-9 -8 -6 -5=.) ;
recode dxccsr_prg029             (-9 -8 -6 -5=.) ;
recode dxccsr_prg030             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp001             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp002             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp003             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp004             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp005             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp006             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp007             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp008             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp009             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp010             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp011             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp012             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp013             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp014             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp015             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp016             (-9 -8 -6 -5=.) ;
recode dxccsr_rsp017             (-9 -8 -6 -5=.) ;
recode dxccsr_skn001             (-9 -8 -6 -5=.) ;
recode dxccsr_skn002             (-9 -8 -6 -5=.) ;
recode dxccsr_skn003             (-9 -8 -6 -5=.) ;
recode dxccsr_skn004             (-9 -8 -6 -5=.) ;
recode dxccsr_skn005             (-9 -8 -6 -5=.) ;
recode dxccsr_skn006             (-9 -8 -6 -5=.) ;
recode dxccsr_skn007             (-9 -8 -6 -5=.) ;
recode dxccsr_sym001             (-9 -8 -6 -5=.) ;
recode dxccsr_sym002             (-9 -8 -6 -5=.) ;
recode dxccsr_sym003             (-9 -8 -6 -5=.) ;
recode dxccsr_sym004             (-9 -8 -6 -5=.) ;
recode dxccsr_sym005             (-9 -8 -6 -5=.) ;
recode dxccsr_sym006             (-9 -8 -6 -5=.) ;
recode dxccsr_sym007             (-9 -8 -6 -5=.) ;
recode dxccsr_sym008             (-9 -8 -6 -5=.) ;
recode dxccsr_sym009             (-9 -8 -6 -5=.) ;
recode dxccsr_sym010             (-9 -8 -6 -5=.) ;
recode dxccsr_sym011             (-9 -8 -6 -5=.) ;
recode dxccsr_sym012             (-9 -8 -6 -5=.) ;
recode dxccsr_sym013             (-9 -8 -6 -5=.) ;
recode dxccsr_sym014             (-9 -8 -6 -5=.) ;
recode dxccsr_sym015             (-9 -8 -6 -5=.) ;
recode dxccsr_sym016             (-9 -8 -6 -5=.) ;
recode dxccsr_sym017             (-9 -8 -6 -5=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;

describe;

save "NEDS_2020_DX_PR_GRPS.dta", replace;
#delimit cr
