/*****************************************************************************
* SASload_NIS_2006_Core.SAS
* This program will load the 2006 NIS ASCII Core File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA NIS_2006_Core; 
INFILE 'NIS_2006_Core.ASC' LRECL = 510;                                                                                                                                                                                                    

*** Define data element attributes ***;
ATTRIB 
  AGE                        LENGTH=3
  LABEL="Age in years at admission"

  AGEDAY                     LENGTH=3
  LABEL="Age in days (when age < 1 year)"

  AMONTH                     LENGTH=3
  LABEL="Admission month"

  ASOURCE                    LENGTH=3
  LABEL="Admission source (uniform)"

  ASOURCEUB92                LENGTH=$1
  LABEL="Admission source (UB-92 standard coding)"

  ASOURCE_X                  LENGTH=$8
  LABEL="Admission source (as received from source)"

  ATYPE                      LENGTH=3
  LABEL="Admission type"

  AWEEKEND                   LENGTH=3
  LABEL="Admission day is a weekend"

  DIED                       LENGTH=3
  LABEL="Died during hospitalization"

  DISCWT                     LENGTH=8
  LABEL="Weight to discharges in AHA universe"

  DISPUB92                   LENGTH=3
  LABEL="Disposition of patient (UB-92 standard coding)"

  DISPUNIFORM                LENGTH=3
  LABEL="Disposition of patient (uniform)"

  DQTR                       LENGTH=3
  LABEL="Discharge quarter"

  DQTR_X                     LENGTH=3
  LABEL="Discharge quarter (as received from source)"

  DRG                        LENGTH=3
  LABEL="DRG in effect on discharge date"

  DRG24                      LENGTH=3
  LABEL="DRG, version 24"

  DRGVER                     LENGTH=3
  LABEL="DRG grouper version used on discharge date"

  DSHOSPID                   LENGTH=$13
  LABEL="Data source hospital identifier"

  DX1                        LENGTH=$5
  LABEL="Principal diagnosis"

  DX2                        LENGTH=$5
  LABEL="Diagnosis 2"

  DX3                        LENGTH=$5
  LABEL="Diagnosis 3"

  DX4                        LENGTH=$5
  LABEL="Diagnosis 4"

  DX5                        LENGTH=$5
  LABEL="Diagnosis 5"

  DX6                        LENGTH=$5
  LABEL="Diagnosis 6"

  DX7                        LENGTH=$5
  LABEL="Diagnosis 7"

  DX8                        LENGTH=$5
  LABEL="Diagnosis 8"

  DX9                        LENGTH=$5
  LABEL="Diagnosis 9"

  DX10                       LENGTH=$5
  LABEL="Diagnosis 10"

  DX11                       LENGTH=$5
  LABEL="Diagnosis 11"

  DX12                       LENGTH=$5
  LABEL="Diagnosis 12"

  DX13                       LENGTH=$5
  LABEL="Diagnosis 13"

  DX14                       LENGTH=$5
  LABEL="Diagnosis 14"

  DX15                       LENGTH=$5
  LABEL="Diagnosis 15"

  DXCCS1                     LENGTH=4
  LABEL="CCS: principal diagnosis"

  DXCCS2                     LENGTH=4
  LABEL="CCS: diagnosis 2"

  DXCCS3                     LENGTH=4
  LABEL="CCS: diagnosis 3"

  DXCCS4                     LENGTH=4
  LABEL="CCS: diagnosis 4"

  DXCCS5                     LENGTH=4
  LABEL="CCS: diagnosis 5"

  DXCCS6                     LENGTH=4
  LABEL="CCS: diagnosis 6"

  DXCCS7                     LENGTH=4
  LABEL="CCS: diagnosis 7"

  DXCCS8                     LENGTH=4
  LABEL="CCS: diagnosis 8"

  DXCCS9                     LENGTH=4
  LABEL="CCS: diagnosis 9"

  DXCCS10                    LENGTH=4
  LABEL="CCS: diagnosis 10"

  DXCCS11                    LENGTH=4
  LABEL="CCS: diagnosis 11"

  DXCCS12                    LENGTH=4
  LABEL="CCS: diagnosis 12"

  DXCCS13                    LENGTH=4
  LABEL="CCS: diagnosis 13"

  DXCCS14                    LENGTH=4
  LABEL="CCS: diagnosis 14"

  DXCCS15                    LENGTH=4
  LABEL="CCS: diagnosis 15"

  ECODE1                     LENGTH=$5
  LABEL="E code 1"

  ECODE2                     LENGTH=$5
  LABEL="E code 2"

  ECODE3                     LENGTH=$5
  LABEL="E code 3"

  ECODE4                     LENGTH=$5
  LABEL="E code 4"

  ELECTIVE                   LENGTH=3
  LABEL="Elective versus non-elective admission"

  E_CCS1                     LENGTH=3
  LABEL="CCS: E Code 1"

  E_CCS2                     LENGTH=3
  LABEL="CCS: E Code 2"

  E_CCS3                     LENGTH=3
  LABEL="CCS: E Code 3"

  E_CCS4                     LENGTH=3
  LABEL="CCS: E Code 4"

  FEMALE                     LENGTH=3
  LABEL="Indicator of sex"

  HOSPBRTH                   LENGTH=3
  LABEL="Indicator of birth in this hospital"

  HOSPID                     LENGTH=4            FORMAT=Z5.
  LABEL="HCUP hospital identification number"

  HOSPST                     LENGTH=$2
  LABEL="Hospital state postal code"

  KEY                        LENGTH=8            FORMAT=Z14.
  LABEL="HCUP record identifier"

  LOS                        LENGTH=4
  LABEL="Length of stay (cleaned)"

  LOS_X                      LENGTH=4
  LABEL="Length of stay (as received from source)"

  MDC                        LENGTH=3
  LABEL="MDC in effect on discharge date"

  MDC24                      LENGTH=3
  LABEL="MDC, version 24"

  MDNUM1_R                   LENGTH=5
  LABEL="Physician 1 number (re-identified)"

  MDNUM2_R                   LENGTH=5
  LABEL="Physician 2 number (re-identified)"

  NDX                        LENGTH=3
  LABEL="Number of diagnoses on this record"

  NECODE                     LENGTH=3
  LABEL="Number of E codes on this record"

  NEOMAT                     LENGTH=3
  LABEL="Neonatal and/or maternal DX and/or PR"

  NIS_STRATUM                LENGTH=3            FORMAT=4.
  LABEL="Stratum used to sample hospital"

  NPR                        LENGTH=3
  LABEL="Number of procedures on this record"

  PAY1                       LENGTH=3
  LABEL="Primary expected payer (uniform)"

  PAY1_X                     LENGTH=$10
  LABEL="Primary expected payer (as received from source)"

  PAY2                       LENGTH=3
  LABEL="Secondary expected payer (uniform)"

  PAY2_X                     LENGTH=$10
  LABEL="Secondary expected payer (as received from source)"

  PL_UR_CAT4                 LENGTH=3
  LABEL="Patient Location: Urban-Rural 4 Categories"

  PR1                        LENGTH=$4
  LABEL="Principal procedure"

  PR2                        LENGTH=$4
  LABEL="Procedure 2"

  PR3                        LENGTH=$4
  LABEL="Procedure 3"

  PR4                        LENGTH=$4
  LABEL="Procedure 4"

  PR5                        LENGTH=$4
  LABEL="Procedure 5"

  PR6                        LENGTH=$4
  LABEL="Procedure 6"

  PR7                        LENGTH=$4
  LABEL="Procedure 7"

  PR8                        LENGTH=$4
  LABEL="Procedure 8"

  PR9                        LENGTH=$4
  LABEL="Procedure 9"

  PR10                       LENGTH=$4
  LABEL="Procedure 10"

  PR11                       LENGTH=$4
  LABEL="Procedure 11"

  PR12                       LENGTH=$4
  LABEL="Procedure 12"

  PR13                       LENGTH=$4
  LABEL="Procedure 13"

  PR14                       LENGTH=$4
  LABEL="Procedure 14"

  PR15                       LENGTH=$4
  LABEL="Procedure 15"

  PRCCS1                     LENGTH=3
  LABEL="CCS: principal procedure"

  PRCCS2                     LENGTH=3
  LABEL="CCS: procedure 2"

  PRCCS3                     LENGTH=3
  LABEL="CCS: procedure 3"

  PRCCS4                     LENGTH=3
  LABEL="CCS: procedure 4"

  PRCCS5                     LENGTH=3
  LABEL="CCS: procedure 5"

  PRCCS6                     LENGTH=3
  LABEL="CCS: procedure 6"

  PRCCS7                     LENGTH=3
  LABEL="CCS: procedure 7"

  PRCCS8                     LENGTH=3
  LABEL="CCS: procedure 8"

  PRCCS9                     LENGTH=3
  LABEL="CCS: procedure 9"

  PRCCS10                    LENGTH=3
  LABEL="CCS: procedure 10"

  PRCCS11                    LENGTH=3
  LABEL="CCS: procedure 11"

  PRCCS12                    LENGTH=3
  LABEL="CCS: procedure 12"

  PRCCS13                    LENGTH=3
  LABEL="CCS: procedure 13"

  PRCCS14                    LENGTH=3
  LABEL="CCS: procedure 14"

  PRCCS15                    LENGTH=3
  LABEL="CCS: procedure 15"

  PRDAY1                     LENGTH=4
  LABEL="Number of days from admission to PR1"

  PRDAY2                     LENGTH=4
  LABEL="Number of days from admission to PR2"

  PRDAY3                     LENGTH=4
  LABEL="Number of days from admission to PR3"

  PRDAY4                     LENGTH=4
  LABEL="Number of days from admission to PR4"

  PRDAY5                     LENGTH=4
  LABEL="Number of days from admission to PR5"

  PRDAY6                     LENGTH=4
  LABEL="Number of days from admission to PR6"

  PRDAY7                     LENGTH=4
  LABEL="Number of days from admission to PR7"

  PRDAY8                     LENGTH=4
  LABEL="Number of days from admission to PR8"

  PRDAY9                     LENGTH=4
  LABEL="Number of days from admission to PR9"

  PRDAY10                    LENGTH=4
  LABEL="Number of days from admission to PR10"

  PRDAY11                    LENGTH=4
  LABEL="Number of days from admission to PR11"

  PRDAY12                    LENGTH=4
  LABEL="Number of days from admission to PR12"

  PRDAY13                    LENGTH=4
  LABEL="Number of days from admission to PR13"

  PRDAY14                    LENGTH=4
  LABEL="Number of days from admission to PR14"

  PRDAY15                    LENGTH=4
  LABEL="Number of days from admission to PR15"

  RACE                       LENGTH=3
  LABEL="Race (uniform)"

  TOTCHG                     LENGTH=6
  LABEL="Total charges (cleaned)"

  TOTCHG_X                   LENGTH=7
  LABEL="Total charges (as received from source)"

  YEAR                       LENGTH=3
  LABEL="Calendar year"

  ZIPINC_QRTL                LENGTH=3
  LABEL="Median household income national quartile for patient ZIP Code"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      AGE                      N3PF.
      @4      AGEDAY                   N3PF.
      @7      AMONTH                   N2PF.
      @9      ASOURCE                  N2PF.
      @11     ASOURCEUB92              $CHAR1.
      @12     ASOURCE_X                $CHAR8.
      @20     ATYPE                    N2PF.
      @22     AWEEKEND                 N2PF.
      @24     DIED                     N2PF.
      @26     DISCWT                   N11P7F.
      @37     DISPUB92                 N2PF.
      @39     DISPUNIFORM              N2PF.
      @41     DQTR                     N2PF.
      @43     DQTR_X                   N2PF.
      @45     DRG                      N3PF.
      @48     DRG24                    N3PF.
      @51     DRGVER                   N2PF.
      @53     DSHOSPID                 $CHAR13.
      @66     DX1                      $CHAR5.
      @71     DX2                      $CHAR5.
      @76     DX3                      $CHAR5.
      @81     DX4                      $CHAR5.
      @86     DX5                      $CHAR5.
      @91     DX6                      $CHAR5.
      @96     DX7                      $CHAR5.
      @101    DX8                      $CHAR5.
      @106    DX9                      $CHAR5.
      @111    DX10                     $CHAR5.
      @116    DX11                     $CHAR5.
      @121    DX12                     $CHAR5.
      @126    DX13                     $CHAR5.
      @131    DX14                     $CHAR5.
      @136    DX15                     $CHAR5.
      @141    DXCCS1                   N4PF.
      @145    DXCCS2                   N4PF.
      @149    DXCCS3                   N4PF.
      @153    DXCCS4                   N4PF.
      @157    DXCCS5                   N4PF.
      @161    DXCCS6                   N4PF.
      @165    DXCCS7                   N4PF.
      @169    DXCCS8                   N4PF.
      @173    DXCCS9                   N4PF.
      @177    DXCCS10                  N4PF.
      @181    DXCCS11                  N4PF.
      @185    DXCCS12                  N4PF.
      @189    DXCCS13                  N4PF.
      @193    DXCCS14                  N4PF.
      @197    DXCCS15                  N4PF.
      @201    ECODE1                   $CHAR5.
      @206    ECODE2                   $CHAR5.
      @211    ECODE3                   $CHAR5.
      @216    ECODE4                   $CHAR5.
      @221    ELECTIVE                 N2PF.
      @223    E_CCS1                   N4PF.
      @227    E_CCS2                   N4PF.
      @231    E_CCS3                   N4PF.
      @235    E_CCS4                   N4PF.
      @239    FEMALE                   N2PF.
      @241    HOSPBRTH                 N2PF.
      @243    HOSPID                   5.
      @248    HOSPST                   $CHAR2.
      @250    KEY                      14.
      @264    LOS                      N5PF.
      @269    LOS_X                    N6PF.
      @275    MDC                      N2PF.
      @277    MDC24                    N2PF.
      @279    MDNUM1_R                 N5PF.
      @284    MDNUM2_R                 N5PF.
      @289    NDX                      N2PF.
      @291    NECODE                   N3PF.
      @294    NEOMAT                   N2PF.
      @296    NIS_STRATUM              N4PF.
      @300    NPR                      N2PF.
      @302    PAY1                     N2PF.
      @304    PAY1_X                   $CHAR10.
      @314    PAY2                     N2PF.
      @316    PAY2_X                   $CHAR10.
      @326    PL_UR_CAT4               N2PF.
      @328    PR1                      $CHAR4.
      @332    PR2                      $CHAR4.
      @336    PR3                      $CHAR4.
      @340    PR4                      $CHAR4.
      @344    PR5                      $CHAR4.
      @348    PR6                      $CHAR4.
      @352    PR7                      $CHAR4.
      @356    PR8                      $CHAR4.
      @360    PR9                      $CHAR4.
      @364    PR10                     $CHAR4.
      @368    PR11                     $CHAR4.
      @372    PR12                     $CHAR4.
      @376    PR13                     $CHAR4.
      @380    PR14                     $CHAR4.
      @384    PR15                     $CHAR4.
      @388    PRCCS1                   N3PF.
      @391    PRCCS2                   N3PF.
      @394    PRCCS3                   N3PF.
      @397    PRCCS4                   N3PF.
      @400    PRCCS5                   N3PF.
      @403    PRCCS6                   N3PF.
      @406    PRCCS7                   N3PF.
      @409    PRCCS8                   N3PF.
      @412    PRCCS9                   N3PF.
      @415    PRCCS10                  N3PF.
      @418    PRCCS11                  N3PF.
      @421    PRCCS12                  N3PF.
      @424    PRCCS13                  N3PF.
      @427    PRCCS14                  N3PF.
      @430    PRCCS15                  N3PF.
      @433    PRDAY1                   N3PF.
      @436    PRDAY2                   N3PF.
      @439    PRDAY3                   N3PF.
      @442    PRDAY4                   N3PF.
      @445    PRDAY5                   N3PF.
      @448    PRDAY6                   N3PF.
      @451    PRDAY7                   N3PF.
      @454    PRDAY8                   N3PF.
      @457    PRDAY9                   N3PF.
      @460    PRDAY10                  N3PF.
      @463    PRDAY11                  N3PF.
      @466    PRDAY12                  N3PF.
      @469    PRDAY13                  N3PF.
      @472    PRDAY14                  N3PF.
      @475    PRDAY15                  N3PF.
      @478    RACE                     N2PF.
      @480    TOTCHG                   N10PF.
      @490    TOTCHG_X                 N15P2F.
      @505    YEAR                     N4PF.
      @509    ZIPINC_QRTL              N2PF.
      ;
RUN;
