/*****************************************************************************
* SASload_NIS_1996_Supplemental.SAS
* This program will load the 1996 NIS ASCII Supplemental File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA NIS_1996_Supplemental; 
INFILE 'NIS_1996_Supplemental.ASC' LRECL = 352;

*** Define data element attributes ***;
ATTRIB 
  TRENDWT                    LENGTH=8
  LABEL="Trend weight to discharges in the universe"

  SEQ                        LENGTH=7            FORMAT=Z13.
  LABEL="I:HCUP-3 record sequence number"

  AWEEKEND                   LENGTH=3
  LABEL="Admission day is a weekend"

  DISPUNIFORM                LENGTH=3
  LABEL="Disposition of patient (uniform)"

  FEMALE                     LENGTH=3
  LABEL="Indicator of sex"

  PRCCS1                     LENGTH=3
  LABEL="CCS: principal procedure"

  PRCCS2                     LENGTH=3
  LABEL="CCS: procedure 2"

  PRCCS3                     LENGTH=3
  LABEL="CCS: procedure 3"

  PRCCS4                     LENGTH=3
  LABEL="CCS: procedure 4"

  PRCCS5                     LENGTH=3
  LABEL="CCS: procedure 5"

  PRCCS6                     LENGTH=3
  LABEL="CCS: procedure 6"

  PRCCS7                     LENGTH=3
  LABEL="CCS: procedure 7"

  PRCCS8                     LENGTH=3
  LABEL="CCS: procedure 8"

  PRCCS9                     LENGTH=3
  LABEL="CCS: procedure 9"

  PRCCS10                    LENGTH=3
  LABEL="CCS: procedure 10"

  PRCCS11                    LENGTH=3
  LABEL="CCS: procedure 11"

  PRCCS12                    LENGTH=3
  LABEL="CCS: procedure 12"

  PRCCS13                    LENGTH=3
  LABEL="CCS: procedure 13"

  PRCCS14                    LENGTH=3
  LABEL="CCS: procedure 14"

  PRCCS15                    LENGTH=3
  LABEL="CCS: procedure 15"

  NIS_STRATUM                LENGTH=4
  LABEL="H:Stratum used to post-stratify hospital"

  TOTAL_DISC                 LENGTH=4
  LABEL="H:Total hospital discharges"

  HOSP_BEDSIZE               LENGTH=3            FORMAT=1.
  LABEL="Bed size of hospital"

  HOSP_CONTROL               LENGTH=3            FORMAT=1.
  LABEL="Control/ownership of hospital"

  HOSP_LOCATION              LENGTH=3            FORMAT=1.
  LABEL="Location (urban/rural) of hospital"

  HOSP_LOCTEACH              LENGTH=3            FORMAT=1.
  LABEL="Location/teaching status of hospital"

  HOSP_REGION                LENGTH=3            FORMAT=1.
  LABEL="Region of hospital"

  HOSP_TEACH                 LENGTH=3            FORMAT=1.
  LABEL="Teaching status of hospital"

  NDX                        LENGTH=3
  LABEL="I:Number of diagnoses on this discharge"

  DXCCS1                     LENGTH=3
  LABEL="CCS: principal diagnosis"

  DXCCS2                     LENGTH=3
  LABEL="CCS: diagnosis 2"

  DXCCS3                     LENGTH=3
  LABEL="CCS: diagnosis 3"

  DXCCS4                     LENGTH=3
  LABEL="CCS: diagnosis 4"

  DXCCS5                     LENGTH=3
  LABEL="CCS: diagnosis 5"

  DXCCS6                     LENGTH=3
  LABEL="CCS: diagnosis 6"

  DXCCS7                     LENGTH=3
  LABEL="CCS: diagnosis 7"

  DXCCS8                     LENGTH=3
  LABEL="CCS: diagnosis 8"

  DXCCS9                     LENGTH=3
  LABEL="CCS: diagnosis 9"

  DXCCS10                    LENGTH=3
  LABEL="CCS: diagnosis 10"

  DXCCS11                    LENGTH=3
  LABEL="CCS: diagnosis 11"

  DXCCS12                    LENGTH=3
  LABEL="CCS: diagnosis 12"

  DXCCS13                    LENGTH=3
  LABEL="CCS: diagnosis 13"

  DXCCS14                    LENGTH=3
  LABEL="CCS: diagnosis 14"

  DXCCS15                    LENGTH=3
  LABEL="CCS: diagnosis 15"

  E_CCS1                     LENGTH=3
  LABEL="CCS: E Code 1"

  E_CCS2                     LENGTH=3
  LABEL="CCS: E Code 2"

  E_CCS3                     LENGTH=3
  LABEL="CCS: E Code 3"

  E_CCS4                     LENGTH=3
  LABEL="CCS: E Code 4"

  ELECTIVE                   LENGTH=3
  LABEL="Elective versus non-elective admission"

  NECODE                     LENGTH=3
  LABEL="Number of E codes on this record"

  DX1                        LENGTH=$5
  LABEL="I:Principal diagnosis"

  DX2                        LENGTH=$5
  LABEL="I:Diagnosis 2"

  DX3                        LENGTH=$5
  LABEL="I:Diagnosis 3"

  DX4                        LENGTH=$5
  LABEL="I:Diagnosis 4"

  DX5                        LENGTH=$5
  LABEL="I:Diagnosis 5"

  DX6                        LENGTH=$5
  LABEL="I:Diagnosis 6"

  DX7                        LENGTH=$5
  LABEL="I:Diagnosis 7"

  DX8                        LENGTH=$5
  LABEL="I:Diagnosis 8"

  DX9                        LENGTH=$5
  LABEL="I:Diagnosis 9"

  DX10                       LENGTH=$5
  LABEL="I:Diagnosis 10"

  DX11                       LENGTH=$5
  LABEL="I:Diagnosis 11"

  DX12                       LENGTH=$5
  LABEL="I:Diagnosis 12"

  DX13                       LENGTH=$5
  LABEL="I:Diagnosis 13"

  DX14                       LENGTH=$5
  LABEL="I:Diagnosis 14"

  DX15                       LENGTH=$5
  LABEL="I:Diagnosis 15"

  PR1                        LENGTH=$4
  LABEL="I:Principal procedure"

  PR2                        LENGTH=$4
  LABEL="I:Procedure 2"

  PR3                        LENGTH=$4
  LABEL="I:Procedure 3"

  PR4                        LENGTH=$4
  LABEL="I:Procedure 4"

  PR5                        LENGTH=$4
  LABEL="I:Procedure 5"

  PR6                        LENGTH=$4
  LABEL="I:Procedure 6"

  PR7                        LENGTH=$4
  LABEL="I:Procedure 7"

  PR8                        LENGTH=$4
  LABEL="I:Procedure 8"

  PR9                        LENGTH=$4
  LABEL="I:Procedure 9"

  PR10                       LENGTH=$4
  LABEL="I:Procedure 10"

  PR11                       LENGTH=$4
  LABEL="I:Procedure 11"

  PR12                       LENGTH=$4
  LABEL="I:Procedure 12"

  PR13                       LENGTH=$4
  LABEL="I:Procedure 13"

  PR14                       LENGTH=$4
  LABEL="I:Procedure 14"

  PR15                       LENGTH=$4
  LABEL="I:Procedure 15"

  ECODE1                     LENGTH=$5
  LABEL="E code 1"

  ECODE2                     LENGTH=$5
  LABEL="E code 2"

  ECODE3                     LENGTH=$5
  LABEL="E code 3"

  ECODE4                     LENGTH=$5
  LABEL="E code 4"

  MDNUM1_S                   LENGTH=$16
  LABEL="Physician 1 number (synthetic)"

  MDNUM2_S                   LENGTH=$16
  LABEL="Physician 2 number (synthetic)"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      TRENDWT                  N11P7F.
      @12     SEQ                      N13PF.
      @25     AWEEKEND                 N2PF.
      @27     DISPUNIFORM              N2PF.
      @29     FEMALE                   N2PF.
      @31     PRCCS1                   N3PF.
      @34     PRCCS2                   N3PF.
      @37     PRCCS3                   N3PF.
      @40     PRCCS4                   N3PF.
      @43     PRCCS5                   N3PF.
      @46     PRCCS6                   N3PF.
      @49     PRCCS7                   N3PF.
      @52     PRCCS8                   N3PF.
      @55     PRCCS9                   N3PF.
      @58     PRCCS10                  N3PF.
      @61     PRCCS11                  N3PF.
      @64     PRCCS12                  N3PF.
      @67     PRCCS13                  N3PF.
      @70     PRCCS14                  N3PF.
      @73     PRCCS15                  N3PF.
      @76     NIS_STRATUM              N4PF.
      @80     TOTAL_DISC               N6PF.
      @86     HOSP_BEDSIZE             N2PF.
      @88     HOSP_CONTROL             N2PF.
      @90     HOSP_LOCATION            N2PF.
      @92     HOSP_LOCTEACH            N2PF.
      @94     HOSP_REGION              N2PF.
      @96     HOSP_TEACH               N2PF.
      @98     NDX                      N2PF.
      @100    DXCCS1                   N3PF.
      @103    DXCCS2                   N3PF.
      @106    DXCCS3                   N3PF.
      @109    DXCCS4                   N3PF.
      @112    DXCCS5                   N3PF.
      @115    DXCCS6                   N3PF.
      @118    DXCCS7                   N3PF.
      @121    DXCCS8                   N3PF.
      @124    DXCCS9                   N3PF.
      @127    DXCCS10                  N3PF.
      @130    DXCCS11                  N3PF.
      @133    DXCCS12                  N3PF.
      @136    DXCCS13                  N3PF.
      @139    DXCCS14                  N3PF.
      @142    DXCCS15                  N3PF.
      @145    E_CCS1                   N4PF.
      @149    E_CCS2                   N4PF.
      @153    E_CCS3                   N4PF.
      @157    E_CCS4                   N4PF.
      @161    ELECTIVE                 N2PF.
      @163    NECODE                   N3PF.
      @166    DX1                      $CHAR5.
      @171    DX2                      $CHAR5.
      @176    DX3                      $CHAR5.
      @181    DX4                      $CHAR5.
      @186    DX5                      $CHAR5.
      @191    DX6                      $CHAR5.
      @196    DX7                      $CHAR5.
      @201    DX8                      $CHAR5.
      @206    DX9                      $CHAR5.
      @211    DX10                     $CHAR5.
      @216    DX11                     $CHAR5.
      @221    DX12                     $CHAR5.
      @226    DX13                     $CHAR5.
      @231    DX14                     $CHAR5.
      @236    DX15                     $CHAR5.
      @241    PR1                      $CHAR4.
      @245    PR2                      $CHAR4.
      @249    PR3                      $CHAR4.
      @253    PR4                      $CHAR4.
      @257    PR5                      $CHAR4.
      @261    PR6                      $CHAR4.
      @265    PR7                      $CHAR4.
      @269    PR8                      $CHAR4.
      @273    PR9                      $CHAR4.
      @277    PR10                     $CHAR4.
      @281    PR11                     $CHAR4.
      @285    PR12                     $CHAR4.
      @289    PR13                     $CHAR4.
      @293    PR14                     $CHAR4.
      @297    PR15                     $CHAR4.
      @301    ECODE1                   $CHAR5.
      @306    ECODE2                   $CHAR5.
      @311    ECODE3                   $CHAR5.
      @316    ECODE4                   $CHAR5.
      @321    MDNUM1_S                 $CHAR16.
      @337    MDNUM2_S                 $CHAR16.
      ;
RUN;
