/*****************************************************************************
* Stataload_NIS_2006_Core.Do
* This program will load the 2006 NIS ASCII Core File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    AGE                         1-  3   ///
      int    AGEDAY                      4-  6   ///
      byte   AMONTH                      7-  8   ///
      byte   ASOURCE                     9- 10   ///
      str    ASOURCEUB92                11       ///
      str    ASOURCE_X                  12- 19   ///
      byte   ATYPE                      20- 21   ///
      byte   AWEEKEND                   22- 23   ///
      byte   DIED                       24- 25   ///
      double DISCWT                     26- 36   ///
      byte   DISPUB92                   37- 38   ///
      byte   DISPUNIFORM                39- 40   ///
      byte   DQTR                       41- 42   ///
      byte   DQTR_X                     43- 44   ///
      int    DRG                        45- 47   ///
      int    DRG24                      48- 50   ///
      byte   DRGVER                     51- 52   ///
      str    DSHOSPID                   53- 65   ///
      str    DX1                        66- 70   ///
      str    DX2                        71- 75   ///
      str    DX3                        76- 80   ///
      str    DX4                        81- 85   ///
      str    DX5                        86- 90   ///
      str    DX6                        91- 95   ///
      str    DX7                        96-100   ///
      str    DX8                       101-105   ///
      str    DX9                       106-110   ///
      str    DX10                      111-115   ///
      str    DX11                      116-120   ///
      str    DX12                      121-125   ///
      str    DX13                      126-130   ///
      str    DX14                      131-135   ///
      str    DX15                      136-140   ///
      int    DXCCS1                    141-144   ///
      int    DXCCS2                    145-148   ///
      int    DXCCS3                    149-152   ///
      int    DXCCS4                    153-156   ///
      int    DXCCS5                    157-160   ///
      int    DXCCS6                    161-164   ///
      int    DXCCS7                    165-168   ///
      int    DXCCS8                    169-172   ///
      int    DXCCS9                    173-176   ///
      int    DXCCS10                   177-180   ///
      int    DXCCS11                   181-184   ///
      int    DXCCS12                   185-188   ///
      int    DXCCS13                   189-192   ///
      int    DXCCS14                   193-196   ///
      int    DXCCS15                   197-200   ///
      str    ECODE1                    201-205   ///
      str    ECODE2                    206-210   ///
      str    ECODE3                    211-215   ///
      str    ECODE4                    216-220   ///
      byte   ELECTIVE                  221-222   ///
      int    E_CCS1                    223-226   ///
      int    E_CCS2                    227-230   ///
      int    E_CCS3                    231-234   ///
      int    E_CCS4                    235-238   ///
      byte   FEMALE                    239-240   ///
      byte   HOSPBRTH                  241-242   ///
      long   HOSPID                    243-247   ///
      str    HOSPST                    248-249   ///
      double KEY                       250-263   ///
      long   LOS                       264-268   ///
      long   LOS_X                     269-274   ///
      byte   MDC                       275-276   ///
      byte   MDC24                     277-278   ///
      long   MDNUM1_R                  279-283   ///
      long   MDNUM2_R                  284-288   ///
      byte   NDX                       289-290   ///
      int    NECODE                    291-293   ///
      byte   NEOMAT                    294-295   ///
      int    NIS_STRATUM               296-299   ///
      byte   NPR                       300-301   ///
      byte   PAY1                      302-303   ///
      str    PAY1_X                    304-313   ///
      byte   PAY2                      314-315   ///
      str    PAY2_X                    316-325   ///
      byte   PL_UR_CAT4                326-327   ///
      str    PR1                       328-331   ///
      str    PR2                       332-335   ///
      str    PR3                       336-339   ///
      str    PR4                       340-343   ///
      str    PR5                       344-347   ///
      str    PR6                       348-351   ///
      str    PR7                       352-355   ///
      str    PR8                       356-359   ///
      str    PR9                       360-363   ///
      str    PR10                      364-367   ///
      str    PR11                      368-371   ///
      str    PR12                      372-375   ///
      str    PR13                      376-379   ///
      str    PR14                      380-383   ///
      str    PR15                      384-387   ///
      int    PRCCS1                    388-390   ///
      int    PRCCS2                    391-393   ///
      int    PRCCS3                    394-396   ///
      int    PRCCS4                    397-399   ///
      int    PRCCS5                    400-402   ///
      int    PRCCS6                    403-405   ///
      int    PRCCS7                    406-408   ///
      int    PRCCS8                    409-411   ///
      int    PRCCS9                    412-414   ///
      int    PRCCS10                   415-417   ///
      int    PRCCS11                   418-420   ///
      int    PRCCS12                   421-423   ///
      int    PRCCS13                   424-426   ///
      int    PRCCS14                   427-429   ///
      int    PRCCS15                   430-432   ///
      int    PRDAY1                    433-435   ///
      int    PRDAY2                    436-438   ///
      int    PRDAY3                    439-441   ///
      int    PRDAY4                    442-444   ///
      int    PRDAY5                    445-447   ///
      int    PRDAY6                    448-450   ///
      int    PRDAY7                    451-453   ///
      int    PRDAY8                    454-456   ///
      int    PRDAY9                    457-459   ///
      int    PRDAY10                   460-462   ///
      int    PRDAY11                   463-465   ///
      int    PRDAY12                   466-468   ///
      int    PRDAY13                   469-471   ///
      int    PRDAY14                   472-474   ///
      int    PRDAY15                   475-477   ///
      byte   RACE                      478-479   ///
      double TOTCHG                    480-489   ///
      double TOTCHG_X                  490-504   ///
      int    YEAR                      505-508   ///
      byte   ZIPINC_QRTL               509-510   ///
      using  "NIS_2006_Core.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AMONTH                   "Admission month"
label var ASOURCE                  "Admission source (uniform)"
label var ASOURCEUB92              "Admission source (UB-92 standard coding)"
label var ASOURCE_X                "Admission source (as received from source)"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "Weight to discharges in AHA universe"
label var DISPUB92                 "Disposition of patient (UB-92 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DQTR_X                   "Discharge quarter (as received from source)"
label var DRG                      "DRG in effect on discharge date"
label var DRG24                    "DRG, version 24"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DSHOSPID                 "Data source hospital identifier"
label var DX1                      "Principal diagnosis"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DXCCS1                   "CCS: principal diagnosis"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ELECTIVE                 "Elective versus non-elective admission"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var FEMALE                   "Indicator of sex"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSPID                   "HCUP hospital identification number"
label var HOSPST                   "Hospital state postal code"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDC                      "MDC in effect on discharge date"
label var MDC24                    "MDC, version 24"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NIS_STRATUM              "Stratum used to sample hospital"
label var NPR                      "Number of procedures on this record"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var PR1                      "Principal procedure"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PRCCS1                   "CCS: principal procedure"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var RACE                     "Race (uniform)"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ASOURCE                   (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUB92                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DQTR_X                    (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG24                     (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DXCCS1                    (-999 -888 -666=.)
recode DXCCS2                    (-999 -888 -666=.)
recode DXCCS3                    (-999 -888 -666=.)
recode DXCCS4                    (-999 -888 -666=.)
recode DXCCS5                    (-999 -888 -666=.)
recode DXCCS6                    (-999 -888 -666=.)
recode DXCCS7                    (-999 -888 -666=.)
recode DXCCS8                    (-999 -888 -666=.)
recode DXCCS9                    (-999 -888 -666=.)
recode DXCCS10                   (-999 -888 -666=.)
recode DXCCS11                   (-999 -888 -666=.)
recode DXCCS12                   (-999 -888 -666=.)
recode DXCCS13                   (-999 -888 -666=.)
recode DXCCS14                   (-999 -888 -666=.)
recode DXCCS15                   (-999 -888 -666=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HOSPBRTH                  (-9 -8 -6 -5=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC24                     (-9 -8 -6 -5=.)
recode MDNUM1_R                  (-9999 -8888 -6666=.)
recode MDNUM2_R                  (-9999 -8888 -6666=.)
recode NDX                       (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NIS_STRATUM               (-999 -888 -666=.)
recode NPR                       (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode RACE                      (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-9 -8 -6 -5=.)

save "NIS_2006_Core.dta", replace
