/*****************************************************************************
* Stataload_NIS_2016_Core.Do
* This program will load the NIS_2016_Core ASCII File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    AGE                          1-   3   ///
      byte   AGE_NEONATE                  4-   5   ///
      byte   AMONTH                       6-   7   ///
      byte   AWEEKEND                     8-   9   ///
      byte   DIED                        10-  11   ///
      double DISCWT                      12-  22   ///
      byte   DISPUNIFORM                 23-  24   ///
      byte   DQTR                        25-  26   ///
      int    DRG                         27-  29   ///
      byte   DRGVER                      30-  31   ///
      int    DRG_NoPOA                   32-  34   ///
      byte   DXVER                       35-  36   ///
      byte   ELECTIVE                    37-  38   ///
      byte   FEMALE                      39-  40   ///
      int    HCUP_ED                     41-  43   ///
      byte   HOSP_DIVISION               44-  45   ///
      long   HOSP_NIS                    46-  50   ///
      str    I10_DX1                     51-  57   ///
      str    I10_DX2                     58-  64   ///
      str    I10_DX3                     65-  71   ///
      str    I10_DX4                     72-  78   ///
      str    I10_DX5                     79-  85   ///
      str    I10_DX6                     86-  92   ///
      str    I10_DX7                     93-  99   ///
      str    I10_DX8                    100- 106   ///
      str    I10_DX9                    107- 113   ///
      str    I10_DX10                   114- 120   ///
      str    I10_DX11                   121- 127   ///
      str    I10_DX12                   128- 134   ///
      str    I10_DX13                   135- 141   ///
      str    I10_DX14                   142- 148   ///
      str    I10_DX15                   149- 155   ///
      str    I10_DX16                   156- 162   ///
      str    I10_DX17                   163- 169   ///
      str    I10_DX18                   170- 176   ///
      str    I10_DX19                   177- 183   ///
      str    I10_DX20                   184- 190   ///
      str    I10_DX21                   191- 197   ///
      str    I10_DX22                   198- 204   ///
      str    I10_DX23                   205- 211   ///
      str    I10_DX24                   212- 218   ///
      str    I10_DX25                   219- 225   ///
      str    I10_DX26                   226- 232   ///
      str    I10_DX27                   233- 239   ///
      str    I10_DX28                   240- 246   ///
      str    I10_DX29                   247- 253   ///
      str    I10_DX30                   254- 260   ///
      str    I10_ECAUSE1                261- 267   ///
      str    I10_ECAUSE2                268- 274   ///
      str    I10_ECAUSE3                275- 281   ///
      str    I10_ECAUSE4                282- 288   ///
      byte   I10_NDX                    289- 290   ///
      int    I10_NECAUSE                291- 293   ///
      byte   I10_NPR                    294- 295   ///
      str    I10_PR1                    296- 302   ///
      str    I10_PR2                    303- 309   ///
      str    I10_PR3                    310- 316   ///
      str    I10_PR4                    317- 323   ///
      str    I10_PR5                    324- 330   ///
      str    I10_PR6                    331- 337   ///
      str    I10_PR7                    338- 344   ///
      str    I10_PR8                    345- 351   ///
      str    I10_PR9                    352- 358   ///
      str    I10_PR10                   359- 365   ///
      str    I10_PR11                   366- 372   ///
      str    I10_PR12                   373- 379   ///
      str    I10_PR13                   380- 386   ///
      str    I10_PR14                   387- 393   ///
      str    I10_PR15                   394- 400   ///
      double KEY_NIS                    401- 410   ///
      long   LOS                        411- 415   ///
      byte   MDC                        416- 417   ///
      byte   MDC_NoPOA                  418- 419   ///
      int    NIS_STRATUM                420- 423   ///
      byte   PAY1                       424- 425   ///
      int    PL_NCHS                    426- 428   ///
      int    PRDAY1                     429- 431   ///
      int    PRDAY2                     432- 434   ///
      int    PRDAY3                     435- 437   ///
      int    PRDAY4                     438- 440   ///
      int    PRDAY5                     441- 443   ///
      int    PRDAY6                     444- 446   ///
      int    PRDAY7                     447- 449   ///
      int    PRDAY8                     450- 452   ///
      int    PRDAY9                     453- 455   ///
      int    PRDAY10                    456- 458   ///
      int    PRDAY11                    459- 461   ///
      int    PRDAY12                    462- 464   ///
      int    PRDAY13                    465- 467   ///
      int    PRDAY14                    468- 470   ///
      int    PRDAY15                    471- 473   ///
      byte   PRVER                      474- 475   ///
      byte   RACE                       476- 477   ///
      double TOTCHG                     478- 487   ///
      byte   TRAN_IN                    488- 489   ///
      byte   TRAN_OUT                   490- 491   ///
      int    YEAR                       492- 495   ///
      byte   ZIPINC_QRTL                496- 497   ///
      using  "NIS_2016_Core.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
label var AMONTH                   "Admission month"
label var AWEEKEND                 "Admission day is a weekend"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "NIS discharge weight"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
label var DXVER                    "Diagnosis Version"
label var ELECTIVE                 "Elective versus non-elective admission"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HOSP_DIVISION            "Census Division of hospital"
label var HOSP_NIS                 "NIS hospital number"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_DX18                 "ICD-10-CM Diagnosis 18"
label var I10_DX19                 "ICD-10-CM Diagnosis 19"
label var I10_DX20                 "ICD-10-CM Diagnosis 20"
label var I10_DX21                 "ICD-10-CM Diagnosis 21"
label var I10_DX22                 "ICD-10-CM Diagnosis 22"
label var I10_DX23                 "ICD-10-CM Diagnosis 23"
label var I10_DX24                 "ICD-10-CM Diagnosis 24"
label var I10_DX25                 "ICD-10-CM Diagnosis 25"
label var I10_DX26                 "ICD-10-CM Diagnosis 26"
label var I10_DX27                 "ICD-10-CM Diagnosis 27"
label var I10_DX28                 "ICD-10-CM Diagnosis 28"
label var I10_DX29                 "ICD-10-CM Diagnosis 29"
label var I10_DX30                 "ICD-10-CM Diagnosis 30"
label var I10_ECAUSE1              "ICD-10-CM External cause 1"
label var I10_ECAUSE2              "ICD-10-CM External cause 2"
label var I10_ECAUSE3              "ICD-10-CM External cause 3"
label var I10_ECAUSE4              "ICD-10-CM External cause 4"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_NECAUSE              "ICD-10-CM Number of External cause codes on this record"
label var I10_NPR                  "ICD-10-PCS Number of procedures on this record"
label var I10_PR1                  "ICD-10-PCS Procedure 1"
label var I10_PR2                  "ICD-10-PCS Procedure 2"
label var I10_PR3                  "ICD-10-PCS Procedure 3"
label var I10_PR4                  "ICD-10-PCS Procedure 4"
label var I10_PR5                  "ICD-10-PCS Procedure 5"
label var I10_PR6                  "ICD-10-PCS Procedure 6"
label var I10_PR7                  "ICD-10-PCS Procedure 7"
label var I10_PR8                  "ICD-10-PCS Procedure 8"
label var I10_PR9                  "ICD-10-PCS Procedure 9"
label var I10_PR10                 "ICD-10-PCS Procedure 10"
label var I10_PR11                 "ICD-10-PCS Procedure 11"
label var I10_PR12                 "ICD-10-PCS Procedure 12"
label var I10_PR13                 "ICD-10-PCS Procedure 13"
label var I10_PR14                 "ICD-10-PCS Procedure 14"
label var I10_PR15                 "ICD-10-PCS Procedure 15"
label var KEY_NIS                  "NIS record number"
label var LOS                      "Length of stay (cleaned)"
label var MDC                      "MDC in effect on discharge date"
label var MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
label var NIS_STRATUM              "NIS hospital stratum"
label var PAY1                     "Primary expected payer (uniform)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PRDAY1                   "Number of days from admission to I10_PR1"
label var PRDAY2                   "Number of days from admission to I10_PR2"
label var PRDAY3                   "Number of days from admission to I10_PR3"
label var PRDAY4                   "Number of days from admission to I10_PR4"
label var PRDAY5                   "Number of days from admission to I10_PR5"
label var PRDAY6                   "Number of days from admission to I10_PR6"
label var PRDAY7                   "Number of days from admission to I10_PR7"
label var PRDAY8                   "Number of days from admission to I10_PR8"
label var PRDAY9                   "Number of days from admission to I10_PR9"
label var PRDAY10                  "Number of days from admission to I10_PR10"
label var PRDAY11                  "Number of days from admission to I10_PR11"
label var PRDAY12                  "Number of days from admission to I10_PR12"
label var PRDAY13                  "Number of days from admission to I10_PR13"
label var PRDAY14                  "Number of days from admission to I10_PR14"
label var PRDAY15                  "Number of days from admission to I10_PR15"
label var PRVER                    "Procedure Version"
label var RACE                     "Race (uniform)"
label var TOTCHG                   "Total charges (cleaned)"
label var TRAN_IN                  "Transfer in indicator"
label var TRAN_OUT                 "Transfer out indicator"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGE_NEONATE               (-9 -8 -6 -5=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DRG_NoPOA                 (-99 -88 -66=.)
recode DXVER                     (-9 -8 -6 -5=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-99 -88 -66=.)
recode HOSP_DIVISION             (-9 -8 -6 -5=.)
recode HOSP_NIS                  (-9999 -8888 -6666=.)
recode I10_NDX                   (-9 -8 -6 -5=.)
recode I10_NECAUSE               (-99 -88 -66=.)
recode I10_NPR                   (-9 -8 -6 -5=.)
recode KEY_NIS                   (-999999999 -888888888 -666666666=.)
recode LOS                       (-9999 -8888 -6666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC_NoPOA                 (-9 -8 -6 -5=.)
recode NIS_STRATUM               (-999 -888 -666=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_NCHS                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode PRVER                     (-9 -8 -6 -5=.)
recode RACE                      (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TRAN_IN                   (-9 -8 -6 -5=.)
recode TRAN_OUT                  (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-9 -8 -6 -5=.)

save "NIS_2016_Core.dta", replace
