/*****************************************************************************
 * Stataload_NRD_2013_Core.Do
 * This program will load the 2013 NRD CSV Core File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NRD_2013_Core.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    age
      byte   aweekend
      byte   died
      double discwt
      byte   dispuniform
      byte   dmonth
      byte   dqtr
      int    drg
      byte   drgver
      int    drg_nopoa
      str5   dx1
      str5   dx2
      str5   dx3
      str5   dx4
      str5   dx5
      str5   dx6
      str5   dx7
      str5   dx8
      str5   dx9
      str5   dx10
      str5   dx11
      str5   dx12
      str5   dx13
      str5   dx14
      str5   dx15
      str5   dx16
      str5   dx17
      str5   dx18
      str5   dx19
      str5   dx20
      str5   dx21
      str5   dx22
      str5   dx23
      str5   dx24
      str5   dx25
      int    dxccs1
      int    dxccs2
      int    dxccs3
      int    dxccs4
      int    dxccs5
      int    dxccs6
      int    dxccs7
      int    dxccs8
      int    dxccs9
      int    dxccs10
      int    dxccs11
      int    dxccs12
      int    dxccs13
      int    dxccs14
      int    dxccs15
      int    dxccs16
      int    dxccs17
      int    dxccs18
      int    dxccs19
      int    dxccs20
      int    dxccs21
      int    dxccs22
      int    dxccs23
      int    dxccs24
      int    dxccs25
      str5   ecode1
      str5   ecode2
      str5   ecode3
      str5   ecode4
      byte   elective
      int    e_ccs1
      int    e_ccs2
      int    e_ccs3
      int    e_ccs4
      byte   female
      byte   hcup_ed
      long   hosp_nrd
      double key_nrd
      long   los
      byte   mdc
      byte   mdc_nopoa
      byte   nchronic
      int    ndx
      int    necode
      int    npr
      double nrd_daystoevent
      long   nrd_stratum
      str6   nrd_visitlink
      byte   orproc
      byte   pay1
      int    pl_nchs
      str4   pr1
      str4   pr2
      str4   pr3
      str4   pr4
      str4   pr5
      str4   pr6
      str4   pr7
      str4   pr8
      str4   pr9
      str4   pr10
      str4   pr11
      str4   pr12
      str4   pr13
      str4   pr14
      str4   pr15
      int    prccs1
      int    prccs2
      int    prccs3
      int    prccs4
      int    prccs5
      int    prccs6
      int    prccs7
      int    prccs8
      int    prccs9
      int    prccs10
      int    prccs11
      int    prccs12
      int    prccs13
      int    prccs14
      int    prccs15
      byte   rehabtransfer
      byte   resident
      str2   samedayevent
      double totchg
      int    year
      byte   zipinc_qrtl
using NRD_2013_Core.csv;

/*  Assign labels to the data elements */
label var age                      "Age in years at admission" ;
label var aweekend                 "Admission day is a weekend" ;
label var died                     "Died during hospitalization" ;
label var discwt                   "Weight to discharges in AHA universe" ;
label var dispuniform              "Disposition of patient (uniform)" ;
label var dmonth                   "Discharge month" ;
label var dqtr                     "Discharge quarter" ;
label var drg                      "DRG in effect on discharge date" ;
label var drgver                   "DRG grouper version used on discharge date" ;
label var drg_nopoa                "DRG in use on discharge date, calculated without POA" ;
label var dx1                      "Diagnosis 1" ;
label var dx2                      "Diagnosis 2" ;
label var dx3                      "Diagnosis 3" ;
label var dx4                      "Diagnosis 4" ;
label var dx5                      "Diagnosis 5" ;
label var dx6                      "Diagnosis 6" ;
label var dx7                      "Diagnosis 7" ;
label var dx8                      "Diagnosis 8" ;
label var dx9                      "Diagnosis 9" ;
label var dx10                     "Diagnosis 10" ;
label var dx11                     "Diagnosis 11" ;
label var dx12                     "Diagnosis 12" ;
label var dx13                     "Diagnosis 13" ;
label var dx14                     "Diagnosis 14" ;
label var dx15                     "Diagnosis 15" ;
label var dx16                     "Diagnosis 16" ;
label var dx17                     "Diagnosis 17" ;
label var dx18                     "Diagnosis 18" ;
label var dx19                     "Diagnosis 19" ;
label var dx20                     "Diagnosis 20" ;
label var dx21                     "Diagnosis 21" ;
label var dx22                     "Diagnosis 22" ;
label var dx23                     "Diagnosis 23" ;
label var dx24                     "Diagnosis 24" ;
label var dx25                     "Diagnosis 25" ;
label var dxccs1                   "CCS: diagnosis 1" ;
label var dxccs2                   "CCS: diagnosis 2" ;
label var dxccs3                   "CCS: diagnosis 3" ;
label var dxccs4                   "CCS: diagnosis 4" ;
label var dxccs5                   "CCS: diagnosis 5" ;
label var dxccs6                   "CCS: diagnosis 6" ;
label var dxccs7                   "CCS: diagnosis 7" ;
label var dxccs8                   "CCS: diagnosis 8" ;
label var dxccs9                   "CCS: diagnosis 9" ;
label var dxccs10                  "CCS: diagnosis 10" ;
label var dxccs11                  "CCS: diagnosis 11" ;
label var dxccs12                  "CCS: diagnosis 12" ;
label var dxccs13                  "CCS: diagnosis 13" ;
label var dxccs14                  "CCS: diagnosis 14" ;
label var dxccs15                  "CCS: diagnosis 15" ;
label var dxccs16                  "CCS: diagnosis 16" ;
label var dxccs17                  "CCS: diagnosis 17" ;
label var dxccs18                  "CCS: diagnosis 18" ;
label var dxccs19                  "CCS: diagnosis 19" ;
label var dxccs20                  "CCS: diagnosis 20" ;
label var dxccs21                  "CCS: diagnosis 21" ;
label var dxccs22                  "CCS: diagnosis 22" ;
label var dxccs23                  "CCS: diagnosis 23" ;
label var dxccs24                  "CCS: diagnosis 24" ;
label var dxccs25                  "CCS: diagnosis 25" ;
label var ecode1                   "E code 1" ;
label var ecode2                   "E code 2" ;
label var ecode3                   "E code 3" ;
label var ecode4                   "E code 4" ;
label var elective                 "Elective versus non-elective admission" ;
label var e_ccs1                   "CCS: E Code 1" ;
label var e_ccs2                   "CCS: E Code 2" ;
label var e_ccs3                   "CCS: E Code 3" ;
label var e_ccs4                   "CCS: E Code 4" ;
label var female                   "Indicator of sex" ;
label var hcup_ed                  "HCUP Emergency Department service indicator" ;
label var hosp_nrd                 "NRD hospital identifier" ;
label var key_nrd                  "NRD record identifier" ;
label var los                      "Length of stay (cleaned)" ;
label var mdc                      "MDC in effect on discharge date" ;
label var mdc_nopoa                "MDC in use on discharge date, calculated without POA" ;
label var nchronic                 "Number of chronic conditions" ;
label var ndx                      "Number of diagnoses on this record" ;
label var necode                   "Number of E codes on this record" ;
label var npr                      "Number of procedures on this record" ;
label var nrd_daystoevent          "Timing variable used to identify days between admissions" ;
label var nrd_stratum              "NRD stratum used for weighting" ;
label var nrd_visitlink            "NRD visitlink" ;
label var orproc                   "Major operating room procedure indicator" ;
label var pay1                     "Primary expected payer (uniform)" ;
label var pl_nchs                  "Patient Location: NCHS Urban-Rural Code" ;
label var pr1                      "Procedure 1" ;
label var pr2                      "Procedure 2" ;
label var pr3                      "Procedure 3" ;
label var pr4                      "Procedure 4" ;
label var pr5                      "Procedure 5" ;
label var pr6                      "Procedure 6" ;
label var pr7                      "Procedure 7" ;
label var pr8                      "Procedure 8" ;
label var pr9                      "Procedure 9" ;
label var pr10                     "Procedure 10" ;
label var pr11                     "Procedure 11" ;
label var pr12                     "Procedure 12" ;
label var pr13                     "Procedure 13" ;
label var pr14                     "Procedure 14" ;
label var pr15                     "Procedure 15" ;
label var prccs1                   "CCS: procedure 1" ;
label var prccs2                   "CCS: procedure 2" ;
label var prccs3                   "CCS: procedure 3" ;
label var prccs4                   "CCS: procedure 4" ;
label var prccs5                   "CCS: procedure 5" ;
label var prccs6                   "CCS: procedure 6" ;
label var prccs7                   "CCS: procedure 7" ;
label var prccs8                   "CCS: procedure 8" ;
label var prccs9                   "CCS: procedure 9" ;
label var prccs10                  "CCS: procedure 10" ;
label var prccs11                  "CCS: procedure 11" ;
label var prccs12                  "CCS: procedure 12" ;
label var prccs13                  "CCS: procedure 13" ;
label var prccs14                  "CCS: procedure 14" ;
label var prccs15                  "CCS: procedure 15" ;
label var rehabtransfer            "A combined record involving rehab transfer" ;
label var resident                 "Patient State is the same as Hospital State" ;
label var samedayevent             "Transfer flag indicating combination of discharges involve same day events" ;
label var totchg                   "Total charges (cleaned)" ;
label var year                     "Calendar year" ;
label var zipinc_qrtl              "Median household income national quartile for patient ZIP Code" ;

/* Convert special values to missing values */
recode age                       (-99 -88 -66=.) ;
recode aweekend                  (-9 -8 -6 -5=.) ;
recode died                      (-9 -8 -6 -5=.) ;
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode dispuniform               (-9 -8 -6 -5=.) ;
recode dmonth                    (-9 -8 -6 -5=.) ;
recode dqtr                      (-9 -8 -6 -5=.) ;
recode drg                       (-99 -88 -66=.) ;
recode drgver                    (-9 -8 -6 -5=.) ;
recode drg_nopoa                 (-99 -88 -66=.) ;
recode dxccs1                    (-99 -88 -66=.) ;
recode dxccs2                    (-99 -88 -66=.) ;
recode dxccs3                    (-99 -88 -66=.) ;
recode dxccs4                    (-99 -88 -66=.) ;
recode dxccs5                    (-99 -88 -66=.) ;
recode dxccs6                    (-99 -88 -66=.) ;
recode dxccs7                    (-99 -88 -66=.) ;
recode dxccs8                    (-99 -88 -66=.) ;
recode dxccs9                    (-99 -88 -66=.) ;
recode dxccs10                   (-99 -88 -66=.) ;
recode dxccs11                   (-99 -88 -66=.) ;
recode dxccs12                   (-99 -88 -66=.) ;
recode dxccs13                   (-99 -88 -66=.) ;
recode dxccs14                   (-99 -88 -66=.) ;
recode dxccs15                   (-99 -88 -66=.) ;
recode dxccs16                   (-99 -88 -66=.) ;
recode dxccs17                   (-99 -88 -66=.) ;
recode dxccs18                   (-99 -88 -66=.) ;
recode dxccs19                   (-99 -88 -66=.) ;
recode dxccs20                   (-99 -88 -66=.) ;
recode dxccs21                   (-99 -88 -66=.) ;
recode dxccs22                   (-99 -88 -66=.) ;
recode dxccs23                   (-99 -88 -66=.) ;
recode dxccs24                   (-99 -88 -66=.) ;
recode dxccs25                   (-99 -88 -66=.) ;
recode elective                  (-9 -8 -6 -5=.) ;
recode e_ccs1                    (-999 -888 -666=.) ;
recode e_ccs2                    (-999 -888 -666=.) ;
recode e_ccs3                    (-999 -888 -666=.) ;
recode e_ccs4                    (-999 -888 -666=.) ;
recode female                    (-9 -8 -6 -5=.) ;
recode hcup_ed                   (-9 -8 -6 -5=.) ;
recode hosp_nrd                  (-9999 -8888 -6666=.) ;
recode key_nrd                   (-99999999999999 -88888888888888 -66666666666666=.) ;
recode los                       (-9999 -8888 -6666=.) ;
recode mdc                       (-9 -8 -6 -5=.) ;
recode mdc_nopoa                 (-9 -8 -6 -5=.) ;
recode nchronic                  (-9 -8 -6 -5=.) ;
recode ndx                       (-99 -88 -66=.) ;
recode necode                    (-99 -88 -66=.) ;
recode npr                       (-99 -88 -66=.) ;
recode nrd_daystoevent           (-999999999 -888888888 -666666666=.) ;
recode nrd_stratum               (-9999 -8888 -6666=.) ;
recode orproc                    (-9 -8 -6 -5=.) ;
recode pay1                      (-9 -8 -6 -5=.) ;
recode pl_nchs                   (-99 -88 -66=.) ;
recode prccs1                    (-99 -88 -66=.) ;
recode prccs2                    (-99 -88 -66=.) ;
recode prccs3                    (-99 -88 -66=.) ;
recode prccs4                    (-99 -88 -66=.) ;
recode prccs5                    (-99 -88 -66=.) ;
recode prccs6                    (-99 -88 -66=.) ;
recode prccs7                    (-99 -88 -66=.) ;
recode prccs8                    (-99 -88 -66=.) ;
recode prccs9                    (-99 -88 -66=.) ;
recode prccs10                   (-99 -88 -66=.) ;
recode prccs11                   (-99 -88 -66=.) ;
recode prccs12                   (-99 -88 -66=.) ;
recode prccs13                   (-99 -88 -66=.) ;
recode prccs14                   (-99 -88 -66=.) ;
recode prccs15                   (-99 -88 -66=.) ;
recode rehabtransfer             (-9 -8 -6 -5=.) ;
recode resident                  (-9 -8 -6 -5=.) ;
recode totchg                    (-999999999 -888888888 -666666666=.) ;
recode year                      (-999 -888 -666=.) ;
recode zipinc_qrtl               (-9 -8 -6 -5=.) ;

describe;

save "NRD_2013_Core.dta", replace;
#delimit cr
