/*****************************************************************************
 * Stataload_NRD_2020_Core.Do
 * Created on 11/23/2022.
 * This program will load the NRD_2020_Core CSV File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NRD_2020_Core.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    age
      byte   aweekend
      byte   died
      double discwt
      byte   dispuniform
      byte   dmonth
      byte   dqtr
      int    drg
      byte   drgver
      int    drg_nopoa
      byte   elective
      byte   female
      byte   hcup_ed
      long   hosp_nrd
      byte   i10_birth
      byte   i10_delivery
      str7   i10_dx1
      str7   i10_dx2
      str7   i10_dx3
      str7   i10_dx4
      str7   i10_dx5
      str7   i10_dx6
      str7   i10_dx7
      str7   i10_dx8
      str7   i10_dx9
      str7   i10_dx10
      str7   i10_dx11
      str7   i10_dx12
      str7   i10_dx13
      str7   i10_dx14
      str7   i10_dx15
      str7   i10_dx16
      str7   i10_dx17
      str7   i10_dx18
      str7   i10_dx19
      str7   i10_dx20
      str7   i10_dx21
      str7   i10_dx22
      str7   i10_dx23
      str7   i10_dx24
      str7   i10_dx25
      str7   i10_dx26
      str7   i10_dx27
      str7   i10_dx28
      str7   i10_dx29
      str7   i10_dx30
      str7   i10_dx31
      str7   i10_dx32
      str7   i10_dx33
      str7   i10_dx34
      str7   i10_dx35
      str7   i10_dx36
      str7   i10_dx37
      str7   i10_dx38
      str7   i10_dx39
      str7   i10_dx40
      byte   i10_injury
      byte   i10_multinjury
      int    i10_ndx
      int    i10_npr
      str7   i10_pr1
      str7   i10_pr2
      str7   i10_pr3
      str7   i10_pr4
      str7   i10_pr5
      str7   i10_pr6
      str7   i10_pr7
      str7   i10_pr8
      str7   i10_pr9
      str7   i10_pr10
      str7   i10_pr11
      str7   i10_pr12
      str7   i10_pr13
      str7   i10_pr14
      str7   i10_pr15
      str7   i10_pr16
      str7   i10_pr17
      str7   i10_pr18
      str7   i10_pr19
      str7   i10_pr20
      str7   i10_pr21
      str7   i10_pr22
      str7   i10_pr23
      str7   i10_pr24
      str7   i10_pr25
      byte   i10_serviceline
      double key_nrd
      long   los
      byte   mdc
      byte   mdc_nopoa
      double nrd_daystoevent
      long   nrd_stratum
      str7   nrd_visitlink
      byte   pay1
      byte   pclass_orproc
      int    pl_nchs
      int    prday1
      int    prday2
      int    prday3
      int    prday4
      int    prday5
      int    prday6
      int    prday7
      int    prday8
      int    prday9
      int    prday10
      int    prday11
      int    prday12
      int    prday13
      int    prday14
      int    prday15
      int    prday16
      int    prday17
      int    prday18
      int    prday19
      int    prday20
      int    prday21
      int    prday22
      int    prday23
      int    prday24
      int    prday25
      byte   rehabtransfer
      byte   resident
      str2   samedayevent
      double totchg
      int    year
      byte   zipinc_qrtl
using NRD_2020_Core.csv;

/*  Assign labels to the data elements */
label var age                      "Age in years at admission" ;
label var aweekend                 "Admission day is a weekend" ;
label var died                     "Died during hospitalization" ;
label var discwt                   "Weight to discharges in universe" ;
label var dispuniform              "Disposition of patient (uniform)" ;
label var dmonth                   "Discharge month" ;
label var dqtr                     "Discharge quarter" ;
label var drg                      "DRG in effect on discharge date" ;
label var drgver                   "DRG grouper version used on discharge date" ;
label var drg_nopoa                "DRG in use on discharge date, calculated without POA" ;
label var elective                 "Elective versus non-elective admission" ;
label var female                   "Indicator of sex" ;
label var hcup_ed                  "HCUP Emergency Department service indicator" ;
label var hosp_nrd                 "NRD hospital identifier" ;
label var i10_birth                "ICD-10-CM Birth Indicator" ;
label var i10_delivery             "ICD-10-CM Delivery Indicator" ;
label var i10_dx1                  "ICD-10-CM Diagnosis 1" ;
label var i10_dx2                  "ICD-10-CM Diagnosis 2" ;
label var i10_dx3                  "ICD-10-CM Diagnosis 3" ;
label var i10_dx4                  "ICD-10-CM Diagnosis 4" ;
label var i10_dx5                  "ICD-10-CM Diagnosis 5" ;
label var i10_dx6                  "ICD-10-CM Diagnosis 6" ;
label var i10_dx7                  "ICD-10-CM Diagnosis 7" ;
label var i10_dx8                  "ICD-10-CM Diagnosis 8" ;
label var i10_dx9                  "ICD-10-CM Diagnosis 9" ;
label var i10_dx10                 "ICD-10-CM Diagnosis 10" ;
label var i10_dx11                 "ICD-10-CM Diagnosis 11" ;
label var i10_dx12                 "ICD-10-CM Diagnosis 12" ;
label var i10_dx13                 "ICD-10-CM Diagnosis 13" ;
label var i10_dx14                 "ICD-10-CM Diagnosis 14" ;
label var i10_dx15                 "ICD-10-CM Diagnosis 15" ;
label var i10_dx16                 "ICD-10-CM Diagnosis 16" ;
label var i10_dx17                 "ICD-10-CM Diagnosis 17" ;
label var i10_dx18                 "ICD-10-CM Diagnosis 18" ;
label var i10_dx19                 "ICD-10-CM Diagnosis 19" ;
label var i10_dx20                 "ICD-10-CM Diagnosis 20" ;
label var i10_dx21                 "ICD-10-CM Diagnosis 21" ;
label var i10_dx22                 "ICD-10-CM Diagnosis 22" ;
label var i10_dx23                 "ICD-10-CM Diagnosis 23" ;
label var i10_dx24                 "ICD-10-CM Diagnosis 24" ;
label var i10_dx25                 "ICD-10-CM Diagnosis 25" ;
label var i10_dx26                 "ICD-10-CM Diagnosis 26" ;
label var i10_dx27                 "ICD-10-CM Diagnosis 27" ;
label var i10_dx28                 "ICD-10-CM Diagnosis 28" ;
label var i10_dx29                 "ICD-10-CM Diagnosis 29" ;
label var i10_dx30                 "ICD-10-CM Diagnosis 30" ;
label var i10_dx31                 "ICD-10-CM Diagnosis 31" ;
label var i10_dx32                 "ICD-10-CM Diagnosis 32" ;
label var i10_dx33                 "ICD-10-CM Diagnosis 33" ;
label var i10_dx34                 "ICD-10-CM Diagnosis 34" ;
label var i10_dx35                 "ICD-10-CM Diagnosis 35" ;
label var i10_dx36                 "ICD-10-CM Diagnosis 36" ;
label var i10_dx37                 "ICD-10-CM Diagnosis 37" ;
label var i10_dx38                 "ICD-10-CM Diagnosis 38" ;
label var i10_dx39                 "ICD-10-CM Diagnosis 39" ;
label var i10_dx40                 "ICD-10-CM Diagnosis 40" ;
label var i10_injury
"Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)" ;
label var i10_multinjury           "Multiple ICD-10-CM injuries reported on record" ;
label var i10_ndx                  "ICD-10-CM Number of diagnoses on this record" ;
label var i10_npr                  "ICD-10-PCS Number of procedures on this record" ;
label var i10_pr1                  "ICD-10-PCS Procedure 1" ;
label var i10_pr2                  "ICD-10-PCS Procedure 2" ;
label var i10_pr3                  "ICD-10-PCS Procedure 3" ;
label var i10_pr4                  "ICD-10-PCS Procedure 4" ;
label var i10_pr5                  "ICD-10-PCS Procedure 5" ;
label var i10_pr6                  "ICD-10-PCS Procedure 6" ;
label var i10_pr7                  "ICD-10-PCS Procedure 7" ;
label var i10_pr8                  "ICD-10-PCS Procedure 8" ;
label var i10_pr9                  "ICD-10-PCS Procedure 9" ;
label var i10_pr10                 "ICD-10-PCS Procedure 10" ;
label var i10_pr11                 "ICD-10-PCS Procedure 11" ;
label var i10_pr12                 "ICD-10-PCS Procedure 12" ;
label var i10_pr13                 "ICD-10-PCS Procedure 13" ;
label var i10_pr14                 "ICD-10-PCS Procedure 14" ;
label var i10_pr15                 "ICD-10-PCS Procedure 15" ;
label var i10_pr16                 "ICD-10-PCS Procedure 16" ;
label var i10_pr17                 "ICD-10-PCS Procedure 17" ;
label var i10_pr18                 "ICD-10-PCS Procedure 18" ;
label var i10_pr19                 "ICD-10-PCS Procedure 19" ;
label var i10_pr20                 "ICD-10-PCS Procedure 20" ;
label var i10_pr21                 "ICD-10-PCS Procedure 21" ;
label var i10_pr22                 "ICD-10-PCS Procedure 22" ;
label var i10_pr23                 "ICD-10-PCS Procedure 23" ;
label var i10_pr24                 "ICD-10-PCS Procedure 24" ;
label var i10_pr25                 "ICD-10-PCS Procedure 25" ;
label var i10_serviceline          "ICD-10-CM/PCS Hospital Service Line" ;
label var key_nrd                  "NRD record identifier" ;
label var los                      "Length of stay (cleaned)" ;
label var mdc                      "MDC in effect on discharge date" ;
label var mdc_nopoa                "MDC in use on discharge date, calculated without POA" ;
label var nrd_daystoevent          "Timing variable used to identify days between admissions" ;
label var nrd_stratum              "NRD stratum used for weighting" ;
label var nrd_visitlink            "NRD visitlink" ;
label var pay1                     "Primary expected payer (uniform)" ;
label var pclass_orproc            "Indicates operating room (major diagnostic or therapeutic) procedure on the record" ;
label var pl_nchs                  "Patient Location: NCHS Urban-Rural Code" ;
label var prday1                   "Number of days from admission to I10_PR1" ;
label var prday2                   "Number of days from admission to I10_PR2" ;
label var prday3                   "Number of days from admission to I10_PR3" ;
label var prday4                   "Number of days from admission to I10_PR4" ;
label var prday5                   "Number of days from admission to I10_PR5" ;
label var prday6                   "Number of days from admission to I10_PR6" ;
label var prday7                   "Number of days from admission to I10_PR7" ;
label var prday8                   "Number of days from admission to I10_PR8" ;
label var prday9                   "Number of days from admission to I10_PR9" ;
label var prday10                  "Number of days from admission to I10_PR10" ;
label var prday11                  "Number of days from admission to I10_PR11" ;
label var prday12                  "Number of days from admission to I10_PR12" ;
label var prday13                  "Number of days from admission to I10_PR13" ;
label var prday14                  "Number of days from admission to I10_PR14" ;
label var prday15                  "Number of days from admission to I10_PR15" ;
label var prday16                  "Number of days from admission to I10_PR16" ;
label var prday17                  "Number of days from admission to I10_PR17" ;
label var prday18                  "Number of days from admission to I10_PR18" ;
label var prday19                  "Number of days from admission to I10_PR19" ;
label var prday20                  "Number of days from admission to I10_PR20" ;
label var prday21                  "Number of days from admission to I10_PR21" ;
label var prday22                  "Number of days from admission to I10_PR22" ;
label var prday23                  "Number of days from admission to I10_PR23" ;
label var prday24                  "Number of days from admission to I10_PR24" ;
label var prday25                  "Number of days from admission to I10_PR25" ;
label var rehabtransfer            "A combined record involving rehab transfer" ;
label var resident                 "Patient State is the same as Hospital State" ;
label var samedayevent             "Transfer flag indicating combination of discharges involve same day events" ;
label var totchg                   "Total charges (cleaned)" ;
label var year                     "Calendar year" ;
label var zipinc_qrtl              "Median household income national quartile for patient ZIP Code" ;

/* Convert special values to missing values */
recode age                       (-99 -88 -66=.) ;
recode aweekend                  (-9 -8 -6 -5=.) ;
recode died                      (-9 -8 -6 -5=.) ;
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode dispuniform               (-9 -8 -6 -5=.) ;
recode dmonth                    (-9 -8 -6 -5=.) ;
recode dqtr                      (-9 -8 -6 -5=.) ;
recode drg                       (-99 -88 -66=.) ;
recode drgver                    (-9 -8 -6 -5=.) ;
recode drg_nopoa                 (-99 -88 -66=.) ;
recode elective                  (-9 -8 -6 -5=.) ;
recode female                    (-9 -8 -6 -5=.) ;
recode hcup_ed                   (-9 -8 -6 -5=.) ;
recode hosp_nrd                  (-9999 -8888 -6666=.) ;
recode i10_birth                 (-9 -8 -6 -5=.) ;
recode i10_delivery              (-9 -8 -6 -5=.) ;
recode i10_injury                (-9 -8 -6 -5=.) ;
recode i10_multinjury            (-9 -8 -6 -5=.) ;
recode i10_ndx                   (-99 -88 -66=.) ;
recode i10_npr                   (-99 -88 -66=.) ;
recode i10_serviceline           (-9 -8 -6 -5=.) ;
recode key_nrd                   (-99999999999999 -88888888888888 -66666666666666=.) ;
recode los                       (-9999 -8888 -6666=.) ;
recode mdc                       (-9 -8 -6 -5=.) ;
recode mdc_nopoa                 (-9 -8 -6 -5=.) ;
recode nrd_daystoevent           (-999999999 -888888888 -666666666=.) ;
recode nrd_stratum               (-9999 -8888 -6666=.) ;
recode pay1                      (-9 -8 -6 -5=.) ;
recode pclass_orproc             (-9 -8 -6 -5=.) ;
recode pl_nchs                   (-99 -88 -66=.) ;
recode prday1                    (-99 -88 -66=.) ;
recode prday2                    (-99 -88 -66=.) ;
recode prday3                    (-99 -88 -66=.) ;
recode prday4                    (-99 -88 -66=.) ;
recode prday5                    (-99 -88 -66=.) ;
recode prday6                    (-99 -88 -66=.) ;
recode prday7                    (-99 -88 -66=.) ;
recode prday8                    (-99 -88 -66=.) ;
recode prday9                    (-99 -88 -66=.) ;
recode prday10                   (-99 -88 -66=.) ;
recode prday11                   (-99 -88 -66=.) ;
recode prday12                   (-99 -88 -66=.) ;
recode prday13                   (-99 -88 -66=.) ;
recode prday14                   (-99 -88 -66=.) ;
recode prday15                   (-99 -88 -66=.) ;
recode prday16                   (-99 -88 -66=.) ;
recode prday17                   (-99 -88 -66=.) ;
recode prday18                   (-99 -88 -66=.) ;
recode prday19                   (-99 -88 -66=.) ;
recode prday20                   (-99 -88 -66=.) ;
recode prday21                   (-99 -88 -66=.) ;
recode prday22                   (-99 -88 -66=.) ;
recode prday23                   (-99 -88 -66=.) ;
recode prday24                   (-99 -88 -66=.) ;
recode prday25                   (-99 -88 -66=.) ;
recode rehabtransfer             (-9 -8 -6 -5=.) ;
recode resident                  (-9 -8 -6 -5=.) ;
recode totchg                    (-999999999 -888888888 -666666666=.) ;
recode year                      (-999 -888 -666=.) ;
recode zipinc_qrtl               (-9 -8 -6 -5=.) ;

describe;

save "NRD_2020_Core.dta", replace;
#delimit cr
