/*****************************************************************************
 * Stataload_NRD_2022_Severity.Do
 * Created on 11/06/2024.
 * This program will load the NRD_2022_Severity CSV File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NRD_2022_Severity.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    aprdrg
      byte   aprdrg_risk_mortality
      byte   aprdrg_severity
      long   hosp_nrd
      double key_nrd
using NRD_2022_Severity.csv;

/*  Assign labels to the data elements */
label var aprdrg                   "All Patient Refined DRG" ;
label var aprdrg_risk_mortality    "All Patient Refined DRG: Risk of Mortality Subclass" ;
label var aprdrg_severity          "All Patient Refined DRG: Severity of Illness Subclass" ;
label var hosp_nrd                 "NRD hospital identifier" ;
label var key_nrd                  "NRD record identifier" ;

/* Convert special values to missing values */
recode aprdrg                    (-999 -888 -666=.) ;
recode aprdrg_risk_mortality     (-9 -8 -6 -5=.) ;
recode aprdrg_severity           (-9 -8 -6 -5=.) ;
recode hosp_nrd                  (-9999 -8888 -6666=.) ;
recode key_nrd                   (-99999999999999 -88888888888888 -66666666666666=.) ;

describe;

save "NRD_2022_Severity.dta", replace;
#delimit cr
