/*****************************************************************************
* SPSSload_KID_2009_Severity.SPS
* This program will load the 2009 KID ASCII Severity File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2009_Severity.ASC' FIXED / 
    HOSPID                     1-  5
    RECNUM                     6- 13
    APRDRG                    14- 17
    APRDRG_Risk_Mortality     18- 19
    APRDRG_Severity           20- 21
    APSDRG                    22- 26
    APSDRG_Charge_Weight      27- 36
    APSDRG_LOS_Weight         37- 46
    APSDRG_Mortality_Weight   47- 56
    CM_AIDS                   57- 58
    CM_ALCOHOL                59- 60
    CM_ANEMDEF                61- 62
    CM_ARTH                   63- 64
    CM_BLDLOSS                65- 66
    CM_CHF                    67- 68
    CM_CHRNLUNG               69- 70
    CM_COAG                   71- 72
    CM_DEPRESS                73- 74
    CM_DM                     75- 76
    CM_DMCX                   77- 78
    CM_DRUG                   79- 80
    CM_HTN_C                  81- 82
    CM_HYPOTHY                83- 84
    CM_LIVER                  85- 86
    CM_LYMPH                  87- 88
    CM_LYTES                  89- 90
    CM_METS                   91- 92
    CM_NEURO                  93- 94
    CM_OBESE                  95- 96
    CM_PARA                   97- 98
    CM_PERIVASC               99-100
    CM_PSYCH                 101-102
    CM_PULMCIRC              103-104
    CM_RENLFAIL              105-106
    CM_TUMOR                 107-108
    CM_ULCER                 109-110
    CM_VALVE                 111-112
    CM_WGHTLOSS              113-114
    DS_DX_Category1          115-119 (A)
    DS_Stage1                120-124.

***  Specify write formats  ***.
FORMATS
    HOSPID                   (F5.0) /
    RECNUM                   (F8.0) /
    APRDRG                   (F4.0) /
    APRDRG_Risk_Mortality    (F2.0) /
    APRDRG_Severity          (F2.0) /
    APSDRG                   (F5.0) /
    APSDRG_Charge_Weight     (F10.5) /
    APSDRG_LOS_Weight        (F10.5) /
    APSDRG_Mortality_Weight  (F10.5) /
    CM_AIDS                  (F2.0) /
    CM_ALCOHOL               (F2.0) /
    CM_ANEMDEF               (F2.0) /
    CM_ARTH                  (F2.0) /
    CM_BLDLOSS               (F2.0) /
    CM_CHF                   (F2.0) /
    CM_CHRNLUNG              (F2.0) /
    CM_COAG                  (F2.0) /
    CM_DEPRESS               (F2.0) /
    CM_DM                    (F2.0) /
    CM_DMCX                  (F2.0) /
    CM_DRUG                  (F2.0) /
    CM_HTN_C                 (F2.0) /
    CM_HYPOTHY               (F2.0) /
    CM_LIVER                 (F2.0) /
    CM_LYMPH                 (F2.0) /
    CM_LYTES                 (F2.0) /
    CM_METS                  (F2.0) /
    CM_NEURO                 (F2.0) /
    CM_OBESE                 (F2.0) /
    CM_PARA                  (F2.0) /
    CM_PERIVASC              (F2.0) /
    CM_PSYCH                 (F2.0) /
    CM_PULMCIRC              (F2.0) /
    CM_RENLFAIL              (F2.0) /
    CM_TUMOR                 (F2.0) /
    CM_ULCER                 (F2.0) /
    CM_VALVE                 (F2.0) /
    CM_WGHTLOSS              (F2.0) /
    DS_Stage1                (F5.2) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSPID                   "HCUP hospital identification number"
    RECNUM                   "HCUP record number"
    APRDRG                   "All Patient Refined DRG"
    APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
    APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass"
    APSDRG                   "All-Payer Severity-adjusted DRG"
    APSDRG_Charge_Weight     "All-Payer Severity-adjusted DRG: Charge Weight"
    APSDRG_LOS_Weight        "All-Payer Severity-adjusted DRG: Length of Stay Weight"
    APSDRG_Mortality_Weight  "All-Payer Severity-adjusted DRG: Mortality Weight"
    CM_AIDS                  "AHRQ comorbidity measure: Acquired immune deficiency syndrome"
    CM_ALCOHOL               "AHRQ comorbidity measure: Alcohol abuse"
    CM_ANEMDEF               "AHRQ comorbidity measure: Deficiency anemias"
    CM_ARTH                  "AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases"
    CM_BLDLOSS               "AHRQ comorbidity measure: Chronic blood loss anemia"
    CM_CHF                   "AHRQ comorbidity measure: Congestive heart failure"
    CM_CHRNLUNG              "AHRQ comorbidity measure: Chronic pulmonary disease"
    CM_COAG                  "AHRQ comorbidity measure: Coagulopathy"
    CM_DEPRESS               "AHRQ comorbidity measure: Depression"
    CM_DM                    "AHRQ comorbidity measure: Diabetes, uncomplicated"
    CM_DMCX                  "AHRQ comorbidity measure: Diabetes with chronic complications"
    CM_DRUG                  "AHRQ comorbidity measure: Drug abuse"
    CM_HTN_C                 "AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)"
    CM_HYPOTHY               "AHRQ comorbidity measure: Hypothyroidism"
    CM_LIVER                 "AHRQ comorbidity measure: Liver disease"
    CM_LYMPH                 "AHRQ comorbidity measure: Lymphoma"
    CM_LYTES                 "AHRQ comorbidity measure: Fluid and electrolyte disorders"
    CM_METS                  "AHRQ comorbidity measure: Metastatic cancer"
    CM_NEURO                 "AHRQ comorbidity measure: Other neurological disorders"
    CM_OBESE                 "AHRQ comorbidity measure: Obesity"
    CM_PARA                  "AHRQ comorbidity measure: Paralysis"
    CM_PERIVASC              "AHRQ comorbidity measure: Peripheral vascular disorders"
    CM_PSYCH                 "AHRQ comorbidity measure: Psychoses"
    CM_PULMCIRC              "AHRQ comorbidity measure: Pulmonary circulation disorders"
    CM_RENLFAIL              "AHRQ comorbidity measure: Renal failure"
    CM_TUMOR                 "AHRQ comorbidity measure: Solid tumor without metastasis"
    CM_ULCER                 "AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding"
    CM_VALVE                 "AHRQ comorbidity measure: Valvular disease"
    CM_WGHTLOSS              "AHRQ comorbidity measure: Weight loss"
    DS_DX_Category1          "Disease Staging: Principal Disease Category"
    DS_Stage1                "Disease Staging: Principal Stage" .

*** Convert special values to system missing values ***.
RECODE RECNUM                   (-9999999 -8888888 -6666666=SYSMIS).
RECODE APRDRG                   (-999 -888 -666=SYSMIS).
RECODE APRDRG_Risk_Mortality    (-9 -8 -6 -5=SYSMIS).
RECODE APRDRG_Severity          (-9 -8 -6 -5=SYSMIS).
RECODE APSDRG                   (-9999 -8888 -6666=SYSMIS).
RECODE APSDRG_Charge_Weight     (-999.99999 -888.88888 -666.66666=SYSMIS).
RECODE APSDRG_LOS_Weight        (-999.99999 -888.88888 -666.66666=SYSMIS).
RECODE APSDRG_Mortality_Weight  (-999.99999 -888.88888 -666.66666=SYSMIS).
RECODE CM_AIDS                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_ALCOHOL               (-9 -8 -6 -5=SYSMIS).
RECODE CM_ANEMDEF               (-9 -8 -6 -5=SYSMIS).
RECODE CM_ARTH                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_BLDLOSS               (-9 -8 -6 -5=SYSMIS).
RECODE CM_CHF                   (-9 -8 -6 -5=SYSMIS).
RECODE CM_CHRNLUNG              (-9 -8 -6 -5=SYSMIS).
RECODE CM_COAG                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_DEPRESS               (-9 -8 -6 -5=SYSMIS).
RECODE CM_DM                    (-9 -8 -6 -5=SYSMIS).
RECODE CM_DMCX                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_DRUG                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_HTN_C                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_HYPOTHY               (-9 -8 -6 -5=SYSMIS).
RECODE CM_LIVER                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_LYMPH                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_LYTES                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_METS                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_NEURO                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_OBESE                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_PARA                  (-9 -8 -6 -5=SYSMIS).
RECODE CM_PERIVASC              (-9 -8 -6 -5=SYSMIS).
RECODE CM_PSYCH                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_PULMCIRC              (-9 -8 -6 -5=SYSMIS).
RECODE CM_RENLFAIL              (-9 -8 -6 -5=SYSMIS).
RECODE CM_TUMOR                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_ULCER                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_VALVE                 (-9 -8 -6 -5=SYSMIS).
RECODE CM_WGHTLOSS              (-9 -8 -6 -5=SYSMIS).
RECODE DS_Stage1                (-9.99 -8.88 -6.66=SYSMIS).

SAVE OUTFILE = 'KID_2009_Severity.SAV' / COMPRESSED.
