/*****************************************************************************
* Stataload_KID_2006_Core.Do
* This program will load the 2006 KID ASCII Core File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix long   HOSPID                      1-  5   ///
      long   RECNUM                      6- 13   ///
      int    AGE                        14- 16   ///
      int    AGEDAY                     17- 19   ///
      int    AGEMONTH                   20- 22   ///
      byte   AMONTH                     23- 24   ///
      byte   ASOURCE                    25- 26   ///
      str    ASOURCEUB92                27       ///
      str    ASOURCE_X                  28- 35   ///
      byte   ATYPE                      36- 37   ///
      byte   AWEEKEND                   38- 39   ///
      int    BWT                        40- 43   ///
      byte   DIED                       44- 45   ///
      double DISCWT                     46- 56   ///
      byte   DISPUB92                   57- 58   ///
      byte   DISPUNIFORM                59- 60   ///
      byte   DQTR                       61- 62   ///
      byte   DQTR_X                     63- 64   ///
      int    DRG                        65- 67   ///
      int    DRG24                      68- 70   ///
      byte   DRGVER                     71- 72   ///
      str    DSHOSPID                   73- 85   ///
      str    DX1                        86- 90   ///
      str    DX2                        91- 95   ///
      str    DX3                        96-100   ///
      str    DX4                       101-105   ///
      str    DX5                       106-110   ///
      str    DX6                       111-115   ///
      str    DX7                       116-120   ///
      str    DX8                       121-125   ///
      str    DX9                       126-130   ///
      str    DX10                      131-135   ///
      str    DX11                      136-140   ///
      str    DX12                      141-145   ///
      str    DX13                      146-150   ///
      str    DX14                      151-155   ///
      str    DX15                      156-160   ///
      int    DXCCS1                    161-164   ///
      int    DXCCS2                    165-168   ///
      int    DXCCS3                    169-172   ///
      int    DXCCS4                    173-176   ///
      int    DXCCS5                    177-180   ///
      int    DXCCS6                    181-184   ///
      int    DXCCS7                    185-188   ///
      int    DXCCS8                    189-192   ///
      int    DXCCS9                    193-196   ///
      int    DXCCS10                   197-200   ///
      int    DXCCS11                   201-204   ///
      int    DXCCS12                   205-208   ///
      int    DXCCS13                   209-212   ///
      int    DXCCS14                   213-216   ///
      int    DXCCS15                   217-220   ///
      str    ECODE1                    221-225   ///
      str    ECODE2                    226-230   ///
      str    ECODE3                    231-235   ///
      str    ECODE4                    236-240   ///
      byte   ELECTIVE                  241-242   ///
      int    E_CCS1                    243-246   ///
      int    E_CCS2                    247-250   ///
      int    E_CCS3                    251-254   ///
      int    E_CCS4                    255-258   ///
      byte   FEMALE                    259-260   ///
      byte   HOSPBRTH                  261-262   ///
      str    HOSPST                    263-264   ///
      int    KID_STRATUM               265-268   ///
      long   LOS                       269-273   ///
      long   LOS_X                     274-279   ///
      byte   MDC                       280-281   ///
      byte   MDC24                     282-283   ///
      long   MDNUM1_R                  284-288   ///
      long   MDNUM2_R                  289-293   ///
      byte   NDX                       294-295   ///
      int    NECODE                    296-298   ///
      byte   NEOMAT                    299-300   ///
      byte   NPR                       301-302   ///
      byte   PAY1                      303-304   ///
      str    PAY1_X                    305-314   ///
      byte   PAY2                      315-316   ///
      str    PAY2_X                    317-326   ///
      int    PL_NCHS2006               327-329   ///
      str    PR1                       330-333   ///
      str    PR2                       334-337   ///
      str    PR3                       338-341   ///
      str    PR4                       342-345   ///
      str    PR5                       346-349   ///
      str    PR6                       350-353   ///
      str    PR7                       354-357   ///
      str    PR8                       358-361   ///
      str    PR9                       362-365   ///
      str    PR10                      366-369   ///
      str    PR11                      370-373   ///
      str    PR12                      374-377   ///
      str    PR13                      378-381   ///
      str    PR14                      382-385   ///
      str    PR15                      386-389   ///
      int    PRCCS1                    390-392   ///
      int    PRCCS2                    393-395   ///
      int    PRCCS3                    396-398   ///
      int    PRCCS4                    399-401   ///
      int    PRCCS5                    402-404   ///
      int    PRCCS6                    405-407   ///
      int    PRCCS7                    408-410   ///
      int    PRCCS8                    411-413   ///
      int    PRCCS9                    414-416   ///
      int    PRCCS10                   417-419   ///
      int    PRCCS11                   420-422   ///
      int    PRCCS12                   423-425   ///
      int    PRCCS13                   426-428   ///
      int    PRCCS14                   429-431   ///
      int    PRCCS15                   432-434   ///
      int    PRDAY1                    435-437   ///
      int    PRDAY2                    438-440   ///
      int    PRDAY3                    441-443   ///
      int    PRDAY4                    444-446   ///
      int    PRDAY5                    447-449   ///
      int    PRDAY6                    450-452   ///
      int    PRDAY7                    453-455   ///
      int    PRDAY8                    456-458   ///
      int    PRDAY9                    459-461   ///
      int    PRDAY10                   462-464   ///
      int    PRDAY11                   465-467   ///
      int    PRDAY12                   468-470   ///
      int    PRDAY13                   471-473   ///
      int    PRDAY14                   474-476   ///
      int    PRDAY15                   477-479   ///
      byte   RACE                      480-481   ///
      double TOTCHG                    482-491   ///
      double TOTCHG_X                  492-506   ///
      byte   UNCBRTH                   507-508   ///
      int    YEAR                      509-512   ///
      byte   ZIPINC_QRTL               513-514   ///
      using  "KID_2006_Core.ASC"

***  Assign labels to the data elements ***
label var HOSPID                   "HCUP hospital identification number"
label var RECNUM                   "HCUP record number"
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var ASOURCE                  "Admission source (uniform)"
label var ASOURCEUB92              "Admission source (UB-92 standard coding)"
label var ASOURCE_X                "Admission source (as received from source)"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var BWT                      "Birth weight in grams"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "Weight to discharges in AHA universe"
label var DISPUB92                 "Disposition of patient (UB-92 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DQTR_X                   "Discharge quarter (as received from source)"
label var DRG                      "DRG in effect on discharge date"
label var DRG24                    "DRG, version 24"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DSHOSPID                 "Data source hospital identifier"
label var DX1                      "Principal diagnosis"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DXCCS1                   "CCS: principal diagnosis"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ELECTIVE                 "Elective versus non-elective admission"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var FEMALE                   "Indicator of sex"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSPST                   "Hospital state postal code"
label var KID_STRATUM              "Hospital stratum used for weights"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDC                      "MDC in effect on discharge date"
label var MDC24                    "MDC, version 24"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NPR                      "Number of procedures on this record"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PL_NCHS2006              "Patient Location: NCHS Urban-Rural Code (V2006)"
label var PR1                      "Principal procedure"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PRCCS1                   "CCS: principal procedure"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var RACE                     "Race (uniform)"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var UNCBRTH                  "Normal uncomplicated birth in hospital"
label var YEAR                     "Calendar year"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"

*** Convert special values to missing values ***
recode RECNUM                    (-9999999 -8888888 -6666666=.)
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ASOURCE                   (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode BWT                       (-999 -888 -666=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUB92                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DQTR_X                    (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG24                     (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DXCCS1                    (-999 -888 -666=.)
recode DXCCS2                    (-999 -888 -666=.)
recode DXCCS3                    (-999 -888 -666=.)
recode DXCCS4                    (-999 -888 -666=.)
recode DXCCS5                    (-999 -888 -666=.)
recode DXCCS6                    (-999 -888 -666=.)
recode DXCCS7                    (-999 -888 -666=.)
recode DXCCS8                    (-999 -888 -666=.)
recode DXCCS9                    (-999 -888 -666=.)
recode DXCCS10                   (-999 -888 -666=.)
recode DXCCS11                   (-999 -888 -666=.)
recode DXCCS12                   (-999 -888 -666=.)
recode DXCCS13                   (-999 -888 -666=.)
recode DXCCS14                   (-999 -888 -666=.)
recode DXCCS15                   (-999 -888 -666=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HOSPBRTH                  (-9 -8 -6 -5=.)
recode KID_STRATUM               (-999 -888 -666=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC24                     (-9 -8 -6 -5=.)
recode MDNUM1_R                  (-9999 -8888 -6666=.)
recode MDNUM2_R                  (-9999 -8888 -6666=.)
recode NDX                       (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NPR                       (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PL_NCHS2006               (-99 -88 -66=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode RACE                      (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode UNCBRTH                   (-9 -8 -6 -5=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-9 -8 -6 -5=.)

save "KID_2006_Core.dta", replace
