/*****************************************************************************
* Stataload_KID_2019_Hospital.Do
* This program will load the KID_2019_Hospital ASCII File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
* Created on 12/02/2022.
*****************************************************************************/

*** Read data elements from the ASCII file ***
infix long   HOSP_KID                     1-   5   ///
      long   N_BRTH_U                     6-  13   ///
      long   N_DISC_U                    14-  21   ///
      int    N_HOSP_U                    22-  25   ///
      long   S_BRTH_U                    26-  33   ///
      long   S_CHLD_U                    34-  41   ///
      long   S_CMPB_U                    42-  49   ///
      long   S_DISC_U                    50-  57   ///
      int    S_HOSP_U                    58-  61   ///
      long   S_UNCB_U                    62-  69   ///
      byte   HOSP_LOCTEACH               70-  71   ///
      byte   H_CONTRL                    72-  73   ///
      byte   HOSP_REGION                 74-  75   ///
      int    KID_STRATUM                 76-  79   ///
      int    YEAR                        80-  83   ///
      byte   HOSP_BEDSIZE                84-  85   ///
      using  "KID_2019_Hospital.ASC"

***  Assign labels to the data elements ***
label var HOSP_KID                 "KID hospital number"
label var N_BRTH_U                 "Number of universe births in the stratum"
label var N_DISC_U                 "Number of universe discharges in the stratum"
label var N_HOSP_U                 "Number of universe hospitals in the stratum"
label var S_BRTH_U                 "Number of sample births in the stratum"
label var S_CHLD_U                 "Number of sample pediatric non-births in the stratum"
label var S_CMPB_U                 "Number of sample sick newborns in the stratum"
label var S_DISC_U                 "Number of sample births and children in the stratum"
label var S_HOSP_U                 "Number of sample hospitals in the stratum"
label var S_UNCB_U                 "Number of sample normal newborns in the stratum"
label var HOSP_LOCTEACH            "Location/teaching status of hospital"
label var H_CONTRL                 "Control/ownership of hospital"
label var HOSP_REGION              "Region of hospital"
label var KID_STRATUM              "KID hospital stratum"
label var YEAR                     "Calendar year"
label var HOSP_BEDSIZE             "Bedsize of hospital"

*** Convert special values to missing values ***
recode HOSP_KID                  (-9999 -8888 -6666=.)
recode N_BRTH_U                  (-9999999 -8888888 -6666666=.)
recode N_DISC_U                  (-9999999 -8888888 -6666666=.)
recode N_HOSP_U                  (-999 -888 -666=.)
recode S_BRTH_U                  (-9999999 -8888888 -6666666=.)
recode S_CHLD_U                  (-9999999 -8888888 -6666666=.)
recode S_CMPB_U                  (-9999999 -8888888 -6666666=.)
recode S_DISC_U                  (-9999999 -8888888 -6666666=.)
recode S_HOSP_U                  (-999 -888 -666=.)
recode S_UNCB_U                  (-9999999 -8888888 -6666666=.)
recode HOSP_LOCTEACH             (-9 -8 -6 -5=.)
recode H_CONTRL                  (-9 -8 -6 -5=.)
recode HOSP_REGION               (-9 -8 -6 -5=.)
recode KID_STRATUM               (-999 -888 -666=.)
recode YEAR                      (-999 -888 -666=.)
recode HOSP_BEDSIZE              (-9 -8 -6 -5=.)

save "KID_2019_Hospital.dta", replace
