/*****************************************************************************
* Stataload_KID_2006_Hospital.Do
* This program will load the 2006 KID ASCII Hospital File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix str    AHAID                       1-  7   ///
      long   HFIPSSTCO                   8- 12   ///
      str    HOSPADDR                   13- 42   ///
      str    HOSPCITY                   43- 62   ///
      long   HOSPID                     63- 67   ///
      str    HOSPNAME                   68- 97   ///
      str    HOSPST                     98- 99   ///
      long   HOSPSTCO                  100-104   ///
      str    HOSPZIP                   105-109   ///
      byte   HOSP_BEDSIZE              110-111   ///
      byte   HOSP_CONTROL              112-113   ///
      byte   HOSP_LOCATION             114-115   ///
      byte   HOSP_LOCTEACH             116-117   ///
      byte   HOSP_REGION               118-119   ///
      byte   HOSP_TEACH                120-121   ///
      str    IDNUMBER                  122-127   ///
      int    KID_STRATUM               128-131   ///
      byte   NACHTYPE                  132-133   ///
      long   N_BRTH_U                  134-139   ///
      long   N_DISC_U                  140-147   ///
      int    N_HOSP_U                  148-151   ///
      long   PEDS_DISC                 152-157   ///
      double PEDS_PCT                  158-165   ///
      long   S_BRTH_U                  166-171   ///
      long   S_CHLD_U                  172-177   ///
      long   S_CMPB_U                  178-183   ///
      long   S_DISC_U                  184-189   ///
      int    S_HOSP_U                  190-193   ///
      long   S_UNCB_U                  194-199   ///
      long   TOTAL_DISC                200-205   ///
      int    YEAR                      206-209   ///
      using  "KID_2006_Hospital.ASC"

***  Assign labels to the data elements ***
label var AHAID                    "AHA hospital identifier"
label var HFIPSSTCO                "Hospital FIPS state/county code"
label var HOSPADDR                 "Hospital address from AHA Survey (Z011)"
label var HOSPCITY                 "Hospital city from AHA Survey (Z012)"
label var HOSPID                   "HCUP hospital identification number"
label var HOSPNAME                 "Hospital name from AHA Survey (Z000)"
label var HOSPST                   "Hospital state postal code"
label var HOSPSTCO                 "Hospital modified FIPS state/county code"
label var HOSPZIP                  "Hospital ZIP Code from AHA Survey (Z014)"
label var HOSP_BEDSIZE             "Bedsize of hospital"
label var HOSP_CONTROL             "Control/ownership of hospital"
label var HOSP_LOCATION            "Location (urban/rural) of hospital"
label var HOSP_LOCTEACH            "Location/teaching status of hospital"
label var HOSP_REGION              "Region of hospital"
label var HOSP_TEACH               "Teaching status of hospital"
label var IDNUMBER                 "AHA hospital identifier without the leading 6"
label var KID_STRATUM              "Hospital stratum used for weights"
label var NACHTYPE                 "NACHRI hospital type"
label var N_BRTH_U                 "Number of universe births in KID_STRATUM"
label var N_DISC_U                 "Number of universe discharges in KID_STRATUM"
label var N_HOSP_U                 "Number of universe hospitals in KID_STRATUM"
label var PEDS_DISC                "Number of discharges, 20 years old or younger, from this hospital in the SID"
label var PEDS_PCT                 "Percentage of hospital discharges, 20 years old or younger"
label var S_BRTH_U                 "Number of sample births in KID_STRATUM"
label var S_CHLD_U                 "Number of sample pediatric non-births in KID_STRATUM"
label var S_CMPB_U                 "Number of sample complicated births in KID_STRATUM"
label var S_DISC_U                 "Number of sample births and children in KID_STRATUM"
label var S_HOSP_U                 "Number of sample hospitals in KID_STRATUM"
label var S_UNCB_U                 "Number of sample uncomplicated births in KID_STRATUM"
label var TOTAL_DISC               "Total number of discharges from this hospital in the SID"
label var YEAR                     "Calendar year"

*** Convert special values to missing values ***
recode HFIPSSTCO                 (-9999 -8888 -6666=.)
recode HOSPSTCO                  (-9999 -8888 -6666=.)
recode HOSP_BEDSIZE              (-9 -8 -6 -5=.)
recode HOSP_CONTROL              (-9 -8 -6 -5=.)
recode HOSP_LOCATION             (-9 -8 -6 -5=.)
recode HOSP_LOCTEACH             (-9 -8 -6 -5=.)
recode HOSP_REGION               (-9 -8 -6 -5=.)
recode HOSP_TEACH                (-9 -8 -6 -5=.)
recode KID_STRATUM               (-999 -888 -666=.)
recode NACHTYPE                  (-9 -8 -6 -5=.)
recode N_BRTH_U                  (-99999 -88888 -66666=.)
recode N_DISC_U                  (-9999999 -8888888 -6666666=.)
recode N_HOSP_U                  (-999 -888 -666=.)
recode PEDS_DISC                 (-99999 -88888 -66666=.)
recode PEDS_PCT                  (-99.9999 -88.8888 -66.6666=.)
recode S_BRTH_U                  (-99999 -88888 -66666=.)
recode S_CHLD_U                  (-99999 -88888 -66666=.)
recode S_CMPB_U                  (-99999 -88888 -66666=.)
recode S_DISC_U                  (-99999 -88888 -66666=.)
recode S_HOSP_U                  (-999 -888 -666=.)
recode S_UNCB_U                  (-99999 -88888 -66666=.)
recode TOTAL_DISC                (-99999 -88888 -66666=.)
recode YEAR                      (-999 -888 -666=.)

save "KID_2006_Hospital.dta", replace
