/*****************************************************************************
 * SASload_NASS_2022_Supplemental.SAS
 * This program will load the NASS 2022 Supplemental csv File into SAS.
 *****************************************************************************/

/* Create SAS informats for missing values */
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

/* Data Step to load the file */
DATA NASS_2022_Supplemental; 
INFILE 'NASS_2022_Supplemental.csv' dsd dlm=',' LRECL = 354;

/* Define data element attributes */
ATTRIB 
  HOSP_NASS                  LENGTH=4
  LABEL="NASS Hospital Number"

  KEY_NASS                   LENGTH=5            FORMAT=8.
  LABEL="NASS Record Number"

  NCPT_NOTINSCOPE            LENGTH=3
  LABEL="# Out-of-scope CPTs for this encounter"

  SupCPT1                    LENGTH=$5
  LABEL="CPT Procedure 1"

  SupCPT2                    LENGTH=$5
  LABEL="CPT Procedure 2"

  SupCPT3                    LENGTH=$5
  LABEL="CPT Procedure 3"

  SupCPT4                    LENGTH=$5
  LABEL="CPT Procedure 4"

  SupCPT5                    LENGTH=$5
  LABEL="CPT Procedure 5"

  SupCPT6                    LENGTH=$5
  LABEL="CPT Procedure 6"

  SupCPT7                    LENGTH=$5
  LABEL="CPT Procedure 7"

  SupCPT8                    LENGTH=$5
  LABEL="CPT Procedure 8"

  SupCPT9                    LENGTH=$5
  LABEL="CPT Procedure 9"

  SupCPT10                   LENGTH=$5
  LABEL="CPT Procedure 10"

  SupCPT11                   LENGTH=$5
  LABEL="CPT Procedure 11"

  SupCPT12                   LENGTH=$5
  LABEL="CPT Procedure 12"

  SupCPT13                   LENGTH=$5
  LABEL="CPT Procedure 13"

  SupCPT14                   LENGTH=$5
  LABEL="CPT Procedure 14"

  SupCPT15                   LENGTH=$5
  LABEL="CPT Procedure 15"

  SupCPT16                   LENGTH=$5
  LABEL="CPT Procedure 16"

  SupCPT17                   LENGTH=$5
  LABEL="CPT Procedure 17"

  SupCPT18                   LENGTH=$5
  LABEL="CPT Procedure 18"

  SupCPT19                   LENGTH=$5
  LABEL="CPT Procedure 19"

  SupCPT20                   LENGTH=$5
  LABEL="CPT Procedure 20"

  SupCPT21                   LENGTH=$5
  LABEL="CPT Procedure 21"

  SupCPT22                   LENGTH=$5
  LABEL="CPT Procedure 22"

  SupCPT23                   LENGTH=$5
  LABEL="CPT Procedure 23"

  SupCPT24                   LENGTH=$5
  LABEL="CPT Procedure 24"

  SupCPT25                   LENGTH=$5
  LABEL="CPT Procedure 25"

  SupCPT26                   LENGTH=$5
  LABEL="CPT Procedure 26"

  SupCPT27                   LENGTH=$5
  LABEL="CPT Procedure 27"

  SupCPT28                   LENGTH=$5
  LABEL="CPT Procedure 28"

  SupCPT29                   LENGTH=$5
  LABEL="CPT Procedure 29"

  SupCPT30                   LENGTH=$5
  LABEL="CPT Procedure 30"

  SupCPTCCS1                 LENGTH=4
  LABEL="CPT 1 Procedure CCS"

  SupCPTCCS2                 LENGTH=4
  LABEL="CPT 2 Procedure CCS"

  SupCPTCCS3                 LENGTH=4
  LABEL="CPT 3 Procedure CCS"

  SupCPTCCS4                 LENGTH=4
  LABEL="CPT 4 Procedure CCS"

  SupCPTCCS5                 LENGTH=4
  LABEL="CPT 5 Procedure CCS"

  SupCPTCCS6                 LENGTH=4
  LABEL="CPT 6 Procedure CCS"

  SupCPTCCS7                 LENGTH=4
  LABEL="CPT 7 Procedure CCS"

  SupCPTCCS8                 LENGTH=4
  LABEL="CPT 8 Procedure CCS"

  SupCPTCCS9                 LENGTH=4
  LABEL="CPT 9 Procedure CCS"

  SupCPTCCS10                LENGTH=4
  LABEL="CPT 10 Procedure CCS"

  SupCPTCCS11                LENGTH=4
  LABEL="CPT 11 Procedure CCS"

  SupCPTCCS12                LENGTH=4
  LABEL="CPT 12 Procedure CCS"

  SupCPTCCS13                LENGTH=4
  LABEL="CPT 13 Procedure CCS"

  SupCPTCCS14                LENGTH=4
  LABEL="CPT 14 Procedure CCS"

  SupCPTCCS15                LENGTH=4
  LABEL="CPT 15 Procedure CCS"

  SupCPTCCS16                LENGTH=4
  LABEL="CPT 16 Procedure CCS"

  SupCPTCCS17                LENGTH=4
  LABEL="CPT 17 Procedure CCS"

  SupCPTCCS18                LENGTH=4
  LABEL="CPT 18 Procedure CCS"

  SupCPTCCS19                LENGTH=4
  LABEL="CPT 19 Procedure CCS"

  SupCPTCCS20                LENGTH=4
  LABEL="CPT 20 Procedure CCS"

  SupCPTCCS21                LENGTH=4
  LABEL="CPT 21 Procedure CCS"

  SupCPTCCS22                LENGTH=4
  LABEL="CPT 22 Procedure CCS"

  SupCPTCCS23                LENGTH=4
  LABEL="CPT 23 Procedure CCS"

  SupCPTCCS24                LENGTH=4
  LABEL="CPT 24 Procedure CCS"

  SupCPTCCS25                LENGTH=4
  LABEL="CPT 25 Procedure CCS"

  SupCPTCCS26                LENGTH=4
  LABEL="CPT 26 Procedure CCS"

  SupCPTCCS27                LENGTH=4
  LABEL="CPT 27 Procedure CCS"

  SupCPTCCS28                LENGTH=4
  LABEL="CPT 28 Procedure CCS"

  SupCPTCCS29                LENGTH=4
  LABEL="CPT 29 Procedure CCS"

  SupCPTCCS30                LENGTH=4
  LABEL="CPT 30 Procedure CCS"

  YEAR                       LENGTH=3
  LABEL="Data Year"
  ;

/* Read data elements from the CSV file */
INPUT 
      HOSP_NASS                :N5PF.
      KEY_NASS                 :N8PF.
      NCPT_NOTINSCOPE          :N3PF.
      SupCPT1                  :$CHAR5.
      SupCPT2                  :$CHAR5.
      SupCPT3                  :$CHAR5.
      SupCPT4                  :$CHAR5.
      SupCPT5                  :$CHAR5.
      SupCPT6                  :$CHAR5.
      SupCPT7                  :$CHAR5.
      SupCPT8                  :$CHAR5.
      SupCPT9                  :$CHAR5.
      SupCPT10                 :$CHAR5.
      SupCPT11                 :$CHAR5.
      SupCPT12                 :$CHAR5.
      SupCPT13                 :$CHAR5.
      SupCPT14                 :$CHAR5.
      SupCPT15                 :$CHAR5.
      SupCPT16                 :$CHAR5.
      SupCPT17                 :$CHAR5.
      SupCPT18                 :$CHAR5.
      SupCPT19                 :$CHAR5.
      SupCPT20                 :$CHAR5.
      SupCPT21                 :$CHAR5.
      SupCPT22                 :$CHAR5.
      SupCPT23                 :$CHAR5.
      SupCPT24                 :$CHAR5.
      SupCPT25                 :$CHAR5.
      SupCPT26                 :$CHAR5.
      SupCPT27                 :$CHAR5.
      SupCPT28                 :$CHAR5.
      SupCPT29                 :$CHAR5.
      SupCPT30                 :$CHAR5.
      SupCPTCCS1               :N4PF.
      SupCPTCCS2               :N4PF.
      SupCPTCCS3               :N4PF.
      SupCPTCCS4               :N4PF.
      SupCPTCCS5               :N4PF.
      SupCPTCCS6               :N4PF.
      SupCPTCCS7               :N4PF.
      SupCPTCCS8               :N4PF.
      SupCPTCCS9               :N4PF.
      SupCPTCCS10              :N4PF.
      SupCPTCCS11              :N4PF.
      SupCPTCCS12              :N4PF.
      SupCPTCCS13              :N4PF.
      SupCPTCCS14              :N4PF.
      SupCPTCCS15              :N4PF.
      SupCPTCCS16              :N4PF.
      SupCPTCCS17              :N4PF.
      SupCPTCCS18              :N4PF.
      SupCPTCCS19              :N4PF.
      SupCPTCCS20              :N4PF.
      SupCPTCCS21              :N4PF.
      SupCPTCCS22              :N4PF.
      SupCPTCCS23              :N4PF.
      SupCPTCCS24              :N4PF.
      SupCPTCCS25              :N4PF.
      SupCPTCCS26              :N4PF.
      SupCPTCCS27              :N4PF.
      SupCPTCCS28              :N4PF.
      SupCPTCCS29              :N4PF.
      SupCPTCCS30              :N4PF.
      YEAR                     :N4PF.
      ;
RUN;
