/*****************************************************************************/
/* SPSSload_NASS_2022_Supplemental.SPS                                          */
/* This program will load the NASS 2022 Supplemental csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NASS_2022_Supplemental.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_NASS                F5.0
    KEY_NASS                 F8.0
    NCPT_NOTINSCOPE          F3.0
    SupCPT1                  A5
    SupCPT2                  A5
    SupCPT3                  A5
    SupCPT4                  A5
    SupCPT5                  A5
    SupCPT6                  A5
    SupCPT7                  A5
    SupCPT8                  A5
    SupCPT9                  A5
    SupCPT10                 A5
    SupCPT11                 A5
    SupCPT12                 A5
    SupCPT13                 A5
    SupCPT14                 A5
    SupCPT15                 A5
    SupCPT16                 A5
    SupCPT17                 A5
    SupCPT18                 A5
    SupCPT19                 A5
    SupCPT20                 A5
    SupCPT21                 A5
    SupCPT22                 A5
    SupCPT23                 A5
    SupCPT24                 A5
    SupCPT25                 A5
    SupCPT26                 A5
    SupCPT27                 A5
    SupCPT28                 A5
    SupCPT29                 A5
    SupCPT30                 A5
    SupCPTCCS1               F4.0
    SupCPTCCS2               F4.0
    SupCPTCCS3               F4.0
    SupCPTCCS4               F4.0
    SupCPTCCS5               F4.0
    SupCPTCCS6               F4.0
    SupCPTCCS7               F4.0
    SupCPTCCS8               F4.0
    SupCPTCCS9               F4.0
    SupCPTCCS10              F4.0
    SupCPTCCS11              F4.0
    SupCPTCCS12              F4.0
    SupCPTCCS13              F4.0
    SupCPTCCS14              F4.0
    SupCPTCCS15              F4.0
    SupCPTCCS16              F4.0
    SupCPTCCS17              F4.0
    SupCPTCCS18              F4.0
    SupCPTCCS19              F4.0
    SupCPTCCS20              F4.0
    SupCPTCCS21              F4.0
    SupCPTCCS22              F4.0
    SupCPTCCS23              F4.0
    SupCPTCCS24              F4.0
    SupCPTCCS25              F4.0
    SupCPTCCS26              F4.0
    SupCPTCCS27              F4.0
    SupCPTCCS28              F4.0
    SupCPTCCS29              F4.0
    SupCPTCCS30              F4.0
    YEAR                     F4.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_NASS                "NASS Hospital Number"
    KEY_NASS                 "NASS Record Number"
    NCPT_NOTINSCOPE          "# Out-of-scope CPTs for this encounter"
    SupCPT1                  "CPT Procedure 1"
    SupCPT2                  "CPT Procedure 2"
    SupCPT3                  "CPT Procedure 3"
    SupCPT4                  "CPT Procedure 4"
    SupCPT5                  "CPT Procedure 5"
    SupCPT6                  "CPT Procedure 6"
    SupCPT7                  "CPT Procedure 7"
    SupCPT8                  "CPT Procedure 8"
    SupCPT9                  "CPT Procedure 9"
    SupCPT10                 "CPT Procedure 10"
    SupCPT11                 "CPT Procedure 11"
    SupCPT12                 "CPT Procedure 12"
    SupCPT13                 "CPT Procedure 13"
    SupCPT14                 "CPT Procedure 14"
    SupCPT15                 "CPT Procedure 15"
    SupCPT16                 "CPT Procedure 16"
    SupCPT17                 "CPT Procedure 17"
    SupCPT18                 "CPT Procedure 18"
    SupCPT19                 "CPT Procedure 19"
    SupCPT20                 "CPT Procedure 20"
    SupCPT21                 "CPT Procedure 21"
    SupCPT22                 "CPT Procedure 22"
    SupCPT23                 "CPT Procedure 23"
    SupCPT24                 "CPT Procedure 24"
    SupCPT25                 "CPT Procedure 25"
    SupCPT26                 "CPT Procedure 26"
    SupCPT27                 "CPT Procedure 27"
    SupCPT28                 "CPT Procedure 28"
    SupCPT29                 "CPT Procedure 29"
    SupCPT30                 "CPT Procedure 30"
    SupCPTCCS1               "CPT 1 Procedure CCS"
    SupCPTCCS2               "CPT 2 Procedure CCS"
    SupCPTCCS3               "CPT 3 Procedure CCS"
    SupCPTCCS4               "CPT 4 Procedure CCS"
    SupCPTCCS5               "CPT 5 Procedure CCS"
    SupCPTCCS6               "CPT 6 Procedure CCS"
    SupCPTCCS7               "CPT 7 Procedure CCS"
    SupCPTCCS8               "CPT 8 Procedure CCS"
    SupCPTCCS9               "CPT 9 Procedure CCS"
    SupCPTCCS10              "CPT 10 Procedure CCS"
    SupCPTCCS11              "CPT 11 Procedure CCS"
    SupCPTCCS12              "CPT 12 Procedure CCS"
    SupCPTCCS13              "CPT 13 Procedure CCS"
    SupCPTCCS14              "CPT 14 Procedure CCS"
    SupCPTCCS15              "CPT 15 Procedure CCS"
    SupCPTCCS16              "CPT 16 Procedure CCS"
    SupCPTCCS17              "CPT 17 Procedure CCS"
    SupCPTCCS18              "CPT 18 Procedure CCS"
    SupCPTCCS19              "CPT 19 Procedure CCS"
    SupCPTCCS20              "CPT 20 Procedure CCS"
    SupCPTCCS21              "CPT 21 Procedure CCS"
    SupCPTCCS22              "CPT 22 Procedure CCS"
    SupCPTCCS23              "CPT 23 Procedure CCS"
    SupCPTCCS24              "CPT 24 Procedure CCS"
    SupCPTCCS25              "CPT 25 Procedure CCS"
    SupCPTCCS26              "CPT 26 Procedure CCS"
    SupCPTCCS27              "CPT 27 Procedure CCS"
    SupCPTCCS28              "CPT 28 Procedure CCS"
    SupCPTCCS29              "CPT 29 Procedure CCS"
    SupCPTCCS30              "CPT 30 Procedure CCS"
    YEAR                     "Data Year" .

/* Convert special values to system missing values */
RECODE HOSP_NASS                (-9999 -8888 -6666=SYSMIS).
RECODE KEY_NASS                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE NCPT_NOTINSCOPE          (-99 -88 -66=SYSMIS).
RECODE SupCPTCCS1               (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS2               (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS3               (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS4               (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS5               (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS6               (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS7               (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS8               (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS9               (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS10              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS11              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS12              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS13              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS14              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS15              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS16              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS17              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS18              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS19              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS20              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS21              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS22              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS23              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS24              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS25              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS26              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS27              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS28              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS29              (-999 -888 -666=SYSMIS).
RECODE SupCPTCCS30              (-999 -888 -666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NASS_2022_Supplemental.SAV' / COMPRESSED.
