/*****************************************************************************
 * SASload_NEDS_2021_Core.SAS
 * This program will load the NEDS 2021 Core csv File into SAS.
 * created on 03/01/2024.
 *****************************************************************************/

/* Create SAS informats for missing values */
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

/* Data Step to load the file */
DATA NEDS_2021_Core; 
INFILE 'NEDS_2021_Core.csv' dsd dlm=',' LRECL = 480;

/* Define data element attributes */
ATTRIB 
  AGE                        LENGTH=3
  LABEL="Age in years at admission"

  AMONTH                     LENGTH=3
  LABEL="Admission month"

  AWEEKEND                   LENGTH=3
  LABEL="Admission day is a weekend"

  DIED_VISIT                 LENGTH=3
  LABEL="Died in the ED (1), Died in the hospital (2), did not die (0)"

  DISCWT                     LENGTH=8
  LABEL="Weight to ED Visits in AHA universe"

  DISP_ED                    LENGTH=3
  LABEL="Disposition of patient (uniform) from ED"

  DQTR                       LENGTH=3
  LABEL="Discharge quarter"

  EDEVENT                    LENGTH=3
  LABEL="Type of ED Event"

  FEMALE                     LENGTH=3
  LABEL="Indicator of sex"

  HCUPFILE                   LENGTH=$4
  LABEL="Source of HCUP Record (SID or SEDD)"

  HOSP_ED                    LENGTH=4            FORMAT=Z5.
  LABEL="HCUP ED hospital identifier"

  I10_DX1                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 1"

  I10_DX2                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 2"

  I10_DX3                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 3"

  I10_DX4                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 4"

  I10_DX5                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 5"

  I10_DX6                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 6"

  I10_DX7                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 7"

  I10_DX8                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 8"

  I10_DX9                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 9"

  I10_DX10                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 10"

  I10_DX11                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 11"

  I10_DX12                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 12"

  I10_DX13                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 13"

  I10_DX14                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 14"

  I10_DX15                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 15"

  I10_DX16                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 16"

  I10_DX17                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 17"

  I10_DX18                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 18"

  I10_DX19                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 19"

  I10_DX20                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 20"

  I10_DX21                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 21"

  I10_DX22                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 22"

  I10_DX23                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 23"

  I10_DX24                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 24"

  I10_DX25                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 25"

  I10_DX26                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 26"

  I10_DX27                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 27"

  I10_DX28                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 28"

  I10_DX29                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 29"

  I10_DX30                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 30"

  I10_DX31                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 31"

  I10_DX32                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 32"

  I10_DX33                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 33"

  I10_DX34                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 34"

  I10_DX35                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 35"

  I10_DX36                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 36"

  I10_DX37                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 37"

  I10_DX38                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 38"

  I10_DX39                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 39"

  I10_DX40                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 40"

  I10_INJURY                 LENGTH=3
  LABEL="Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)"

  I10_INJURY_CUT             LENGTH=3
  LABEL="Mechanism of injury: cut or pierce"

  I10_INJURY_DROWN           LENGTH=3
  LABEL="Mechanism of injury: drowning or submersion"

  I10_INJURY_FALL            LENGTH=3
  LABEL="Mechanism of injury: fall"

  I10_INJURY_FIRE            LENGTH=3
  LABEL="Mechanism of injury: fire, flame, hot object, or hot substance"

  I10_INJURY_FIREARM         LENGTH=3
  LABEL="Mechanism of injury: firearm"

  I10_INJURY_MACHINERY       LENGTH=3
  LABEL="Mechanism of injury: machinery"

  I10_INJURY_MVT             LENGTH=3
  LABEL=

"Mechanism of injury: motor vehicle traffic, including the occupant of a car, motorcyclist, pedal cyclist, pedestrian, other, or uns
pecified"

  I10_INJURY_NATURE          LENGTH=3
  LABEL="Mechanism of injury: natural or environmental, included venomous and nonvenomous bites and stings"

  I10_INJURY_OVEREXERTION    LENGTH=3
  LABEL="Mechanism of injury: overexertion"

  I10_INJURY_POISON          LENGTH=3
  LABEL="Mechanism of injury: poisoning, including drugs and nondrugs"

  I10_INJURY_STRUCK          LENGTH=3
  LABEL="Mechanism of injury: struck by or against"

  I10_INJURY_SUFFOCATION     LENGTH=3
  LABEL="Mechanism of injury: suffocation"

  I10_INTENT_ASSAULT         LENGTH=3
  LABEL="Intent of injury: assault"

  I10_INTENT_SELF_HARM       LENGTH=3
  LABEL="Intent of injury: intentional self-harm"

  I10_INTENT_UNINTENTIONAL   LENGTH=3
  LABEL="Intent of injury: unintentional"

  I10_MULTINJURY             LENGTH=3
  LABEL="Multiple ICD-10-CM injuries reported on record"

  I10_NDX                    LENGTH=3
  LABEL="ICD-10-CM Number of diagnoses on this record"

  KEY_ED                     LENGTH=8            FORMAT=Z14.
  LABEL="HCUP NEDS record identifier"

  NEDS_STRATUM               LENGTH=4            FORMAT=5.
  LABEL="Stratum used to sample hospital"

  PAY1                       LENGTH=3
  LABEL="Primary expected payer (uniform)"

  PAY2                       LENGTH=3
  LABEL="Secondary expected payer (uniform)"

  PL_NCHS                    LENGTH=3
  LABEL="Patient Location: NCHS Urban-Rural Code"

  RACE                       LENGTH=3
  LABEL="Race (uniform)"

  TOTCHG_ED                  LENGTH=6
  LABEL="Total charge for ED services"

  YEAR                       LENGTH=3
  LABEL="Calendar year"

  ZIPINC_QRTL                LENGTH=3
  LABEL="Median household income national quartile for patient ZIP Code"
  ;

/* Read data elements from the CSV file */
INPUT 
      AGE                      :N3PF.
      AMONTH                   :N2PF.
      AWEEKEND                 :N2PF.
      DIED_VISIT               :N2PF.
      DISCWT                   :N11P7F.
      DISP_ED                  :N2PF.
      DQTR                     :N2PF.
      EDEVENT                  :N2PF.
      FEMALE                   :N2PF.
      HCUPFILE                 :$CHAR4.
      HOSP_ED                  :5.
      I10_DX1                  :$CHAR7.
      I10_DX2                  :$CHAR7.
      I10_DX3                  :$CHAR7.
      I10_DX4                  :$CHAR7.
      I10_DX5                  :$CHAR7.
      I10_DX6                  :$CHAR7.
      I10_DX7                  :$CHAR7.
      I10_DX8                  :$CHAR7.
      I10_DX9                  :$CHAR7.
      I10_DX10                 :$CHAR7.
      I10_DX11                 :$CHAR7.
      I10_DX12                 :$CHAR7.
      I10_DX13                 :$CHAR7.
      I10_DX14                 :$CHAR7.
      I10_DX15                 :$CHAR7.
      I10_DX16                 :$CHAR7.
      I10_DX17                 :$CHAR7.
      I10_DX18                 :$CHAR7.
      I10_DX19                 :$CHAR7.
      I10_DX20                 :$CHAR7.
      I10_DX21                 :$CHAR7.
      I10_DX22                 :$CHAR7.
      I10_DX23                 :$CHAR7.
      I10_DX24                 :$CHAR7.
      I10_DX25                 :$CHAR7.
      I10_DX26                 :$CHAR7.
      I10_DX27                 :$CHAR7.
      I10_DX28                 :$CHAR7.
      I10_DX29                 :$CHAR7.
      I10_DX30                 :$CHAR7.
      I10_DX31                 :$CHAR7.
      I10_DX32                 :$CHAR7.
      I10_DX33                 :$CHAR7.
      I10_DX34                 :$CHAR7.
      I10_DX35                 :$CHAR7.
      I10_DX36                 :$CHAR7.
      I10_DX37                 :$CHAR7.
      I10_DX38                 :$CHAR7.
      I10_DX39                 :$CHAR7.
      I10_DX40                 :$CHAR7.
      I10_INJURY               :N2PF.
      I10_INJURY_CUT           :N2PF.
      I10_INJURY_DROWN         :N2PF.
      I10_INJURY_FALL          :N2PF.
      I10_INJURY_FIRE          :N2PF.
      I10_INJURY_FIREARM       :N2PF.
      I10_INJURY_MACHINERY     :N2PF.
      I10_INJURY_MVT           :N2PF.
      I10_INJURY_NATURE        :N2PF.
      I10_INJURY_OVEREXERTION  :N2PF.
      I10_INJURY_POISON        :N2PF.
      I10_INJURY_STRUCK        :N2PF.
      I10_INJURY_SUFFOCATION   :N2PF.
      I10_INTENT_ASSAULT       :N2PF.
      I10_INTENT_SELF_HARM     :N2PF.
      I10_INTENT_UNINTENTIONAL :N2PF.
      I10_MULTINJURY           :N2PF.
      I10_NDX                  :N3PF.
      KEY_ED                   :16.
      NEDS_STRATUM             :N5PF.
      PAY1                     :N2PF.
      PAY2                     :N2PF.
      PL_NCHS                  :N3PF.
      RACE                     :N2PF.
      TOTCHG_ED                :N12P2F.
      YEAR                     :N4PF.
      ZIPINC_QRTL              :N2PF.
      ;
RUN;
