/*****************************************************************************
 * SASload_NEDS_2015Q4_ED.SAS
 * This program will load the NEDS 2015 Q4 ED csv File into SAS.
 *****************************************************************************/

/* Create SAS informats for missing values */
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

/* Data Step to load the file */
DATA NEDS_2015Q4_ED; 
INFILE 'NEDS_2015Q4_ED.csv' dsd dlm=',' LRECL = 481;

/* Define data element attributes */
ATTRIB 
  CPT1                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 1"

  CPT2                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 2"

  CPT3                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 3"

  CPT4                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 4"

  CPT5                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 5"

  CPT6                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 6"

  CPT7                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 7"

  CPT8                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 8"

  CPT9                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 9"

  CPT10                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 10"

  CPT11                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 11"

  CPT12                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 12"

  CPT13                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 13"

  CPT14                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 14"

  CPT15                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 15"

  CPTCCS1                    LENGTH=4
  LABEL="CCS: CPT 1"

  CPTCCS2                    LENGTH=4
  LABEL="CCS: CPT 2"

  CPTCCS3                    LENGTH=4
  LABEL="CCS: CPT 3"

  CPTCCS4                    LENGTH=4
  LABEL="CCS: CPT 4"

  CPTCCS5                    LENGTH=4
  LABEL="CCS: CPT 5"

  CPTCCS6                    LENGTH=4
  LABEL="CCS: CPT 6"

  CPTCCS7                    LENGTH=4
  LABEL="CCS: CPT 7"

  CPTCCS8                    LENGTH=4
  LABEL="CCS: CPT 8"

  CPTCCS9                    LENGTH=4
  LABEL="CCS: CPT 9"

  CPTCCS10                   LENGTH=4
  LABEL="CCS: CPT 10"

  CPTCCS11                   LENGTH=4
  LABEL="CCS: CPT 11"

  CPTCCS12                   LENGTH=4
  LABEL="CCS: CPT 12"

  CPTCCS13                   LENGTH=4
  LABEL="CCS: CPT 13"

  CPTCCS14                   LENGTH=4
  LABEL="CCS: CPT 14"

  CPTCCS15                   LENGTH=4
  LABEL="CCS: CPT 15"

  DXVER                      LENGTH=3
  LABEL="Diagnosis Version"

  HCUPFILE                   LENGTH=$4
  LABEL="Source of HCUP Record (SID or SEDD)"

  HOSP_ED                    LENGTH=4            FORMAT=Z5.
  LABEL="HCUP ED hospital identifier"

  I10_DX1                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 1"

  I10_DX2                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 2"

  I10_DX3                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 3"

  I10_DX4                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 4"

  I10_DX5                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 5"

  I10_DX6                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 6"

  I10_DX7                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 7"

  I10_DX8                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 8"

  I10_DX9                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 9"

  I10_DX10                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 10"

  I10_DX11                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 11"

  I10_DX12                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 12"

  I10_DX13                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 13"

  I10_DX14                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 14"

  I10_DX15                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 15"

  I10_DX16                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 16"

  I10_DX17                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 17"

  I10_DX18                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 18"

  I10_DX19                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 19"

  I10_DX20                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 20"

  I10_DX21                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 21"

  I10_DX22                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 22"

  I10_DX23                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 23"

  I10_DX24                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 24"

  I10_DX25                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 25"

  I10_DX26                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 26"

  I10_DX27                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 27"

  I10_DX28                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 28"

  I10_DX29                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 29"

  I10_DX30                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 30"

  I10_ECAUSE1                LENGTH=$7
  LABEL="ICD-10-CM External cause 1"

  I10_ECAUSE2                LENGTH=$7
  LABEL="ICD-10-CM External cause 2"

  I10_ECAUSE3                LENGTH=$7
  LABEL="ICD-10-CM External cause 3"

  I10_ECAUSE4                LENGTH=$7
  LABEL="ICD-10-CM External cause 4"

  I10_NDX                    LENGTH=3
  LABEL="ICD-10-CM Number of diagnoses on this record"

  I10_NECAUSE                LENGTH=3
  LABEL="ICD-10-CM Number of external cause codes on this record"

  KEY_ED                     LENGTH=8            FORMAT=Z14.
  LABEL="HCUP NEDS record identifier"

  NCPT                       LENGTH=3
  LABEL="Number of CPT/HCPCS procedures for this visit"
  ;

/* Read data elements from the CSV file */
INPUT 
      CPT1                     :$CHAR5.
      CPT2                     :$CHAR5.
      CPT3                     :$CHAR5.
      CPT4                     :$CHAR5.
      CPT5                     :$CHAR5.
      CPT6                     :$CHAR5.
      CPT7                     :$CHAR5.
      CPT8                     :$CHAR5.
      CPT9                     :$CHAR5.
      CPT10                    :$CHAR5.
      CPT11                    :$CHAR5.
      CPT12                    :$CHAR5.
      CPT13                    :$CHAR5.
      CPT14                    :$CHAR5.
      CPT15                    :$CHAR5.
      CPTCCS1                  :N4PF.
      CPTCCS2                  :N4PF.
      CPTCCS3                  :N4PF.
      CPTCCS4                  :N4PF.
      CPTCCS5                  :N4PF.
      CPTCCS6                  :N4PF.
      CPTCCS7                  :N4PF.
      CPTCCS8                  :N4PF.
      CPTCCS9                  :N4PF.
      CPTCCS10                 :N4PF.
      CPTCCS11                 :N4PF.
      CPTCCS12                 :N4PF.
      CPTCCS13                 :N4PF.
      CPTCCS14                 :N4PF.
      CPTCCS15                 :N4PF.
      DXVER                    :N2PF.
      HCUPFILE                 :$CHAR4.
      HOSP_ED                  :5.
      I10_DX1                  :$CHAR7.
      I10_DX2                  :$CHAR7.
      I10_DX3                  :$CHAR7.
      I10_DX4                  :$CHAR7.
      I10_DX5                  :$CHAR7.
      I10_DX6                  :$CHAR7.
      I10_DX7                  :$CHAR7.
      I10_DX8                  :$CHAR7.
      I10_DX9                  :$CHAR7.
      I10_DX10                 :$CHAR7.
      I10_DX11                 :$CHAR7.
      I10_DX12                 :$CHAR7.
      I10_DX13                 :$CHAR7.
      I10_DX14                 :$CHAR7.
      I10_DX15                 :$CHAR7.
      I10_DX16                 :$CHAR7.
      I10_DX17                 :$CHAR7.
      I10_DX18                 :$CHAR7.
      I10_DX19                 :$CHAR7.
      I10_DX20                 :$CHAR7.
      I10_DX21                 :$CHAR7.
      I10_DX22                 :$CHAR7.
      I10_DX23                 :$CHAR7.
      I10_DX24                 :$CHAR7.
      I10_DX25                 :$CHAR7.
      I10_DX26                 :$CHAR7.
      I10_DX27                 :$CHAR7.
      I10_DX28                 :$CHAR7.
      I10_DX29                 :$CHAR7.
      I10_DX30                 :$CHAR7.
      I10_ECAUSE1              :$CHAR7.
      I10_ECAUSE2              :$CHAR7.
      I10_ECAUSE3              :$CHAR7.
      I10_ECAUSE4              :$CHAR7.
      I10_NDX                  :N3PF.
      I10_NECAUSE              :N3PF.
      KEY_ED                   :16.
      NCPT                     :N4PF.
      ;
RUN;
