/*****************************************************************************
 * SASload_NEDS_2018_ED.SAS
 * This program will load the NEDS 2018 ED csv File into SAS.
 *****************************************************************************/

/* Create SAS informats for missing values */
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

/* Data Step to load the file */
DATA NEDS_2018_ED; 
INFILE 'NEDS_2018_ED.csv' dsd dlm=',' LRECL = 413;

/* Define data element attributes */
ATTRIB 
  HOSP_ED                    LENGTH=4            FORMAT=Z5.
  LABEL="HCUP ED hospital identifier"

  KEY_ED                     LENGTH=8            FORMAT=Z14.
  LABEL="HCUP NEDS record identifier"

  CPT1                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 1"

  CPT2                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 2"

  CPT3                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 3"

  CPT4                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 4"

  CPT5                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 5"

  CPT6                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 6"

  CPT7                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 7"

  CPT8                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 8"

  CPT9                       LENGTH=$5
  LABEL="CPT/HCPCS procedure code 9"

  CPT10                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 10"

  CPT11                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 11"

  CPT12                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 12"

  CPT13                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 13"

  CPT14                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 14"

  CPT15                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 15"

  CPT16                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 16"

  CPT17                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 17"

  CPT18                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 18"

  CPT19                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 19"

  CPT20                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 20"

  CPT21                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 21"

  CPT22                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 22"

  CPT23                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 23"

  CPT24                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 24"

  CPT25                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 25"

  CPT26                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 26"

  CPT27                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 27"

  CPT28                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 28"

  CPT29                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 29"

  CPT30                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 30"

  CPT31                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 31"

  CPT32                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 32"

  CPT33                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 33"

  CPT34                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 34"

  CPT35                      LENGTH=$5
  LABEL="CPT/HCPCS procedure code 35"

  CPTCCS1                    LENGTH=4
  LABEL="CCS: CPT 1"

  CPTCCS2                    LENGTH=4
  LABEL="CCS: CPT 2"

  CPTCCS3                    LENGTH=4
  LABEL="CCS: CPT 3"

  CPTCCS4                    LENGTH=4
  LABEL="CCS: CPT 4"

  CPTCCS5                    LENGTH=4
  LABEL="CCS: CPT 5"

  CPTCCS6                    LENGTH=4
  LABEL="CCS: CPT 6"

  CPTCCS7                    LENGTH=4
  LABEL="CCS: CPT 7"

  CPTCCS8                    LENGTH=4
  LABEL="CCS: CPT 8"

  CPTCCS9                    LENGTH=4
  LABEL="CCS: CPT 9"

  CPTCCS10                   LENGTH=4
  LABEL="CCS: CPT 10"

  CPTCCS11                   LENGTH=4
  LABEL="CCS: CPT 11"

  CPTCCS12                   LENGTH=4
  LABEL="CCS: CPT 12"

  CPTCCS13                   LENGTH=4
  LABEL="CCS: CPT 13"

  CPTCCS14                   LENGTH=4
  LABEL="CCS: CPT 14"

  CPTCCS15                   LENGTH=4
  LABEL="CCS: CPT 15"

  CPTCCS16                   LENGTH=4
  LABEL="CCS: CPT 16"

  CPTCCS17                   LENGTH=4
  LABEL="CCS: CPT 17"

  CPTCCS18                   LENGTH=4
  LABEL="CCS: CPT 18"

  CPTCCS19                   LENGTH=4
  LABEL="CCS: CPT 19"

  CPTCCS20                   LENGTH=4
  LABEL="CCS: CPT 20"

  CPTCCS21                   LENGTH=4
  LABEL="CCS: CPT 21"

  CPTCCS22                   LENGTH=4
  LABEL="CCS: CPT 22"

  CPTCCS23                   LENGTH=4
  LABEL="CCS: CPT 23"

  CPTCCS24                   LENGTH=4
  LABEL="CCS: CPT 24"

  CPTCCS25                   LENGTH=4
  LABEL="CCS: CPT 25"

  CPTCCS26                   LENGTH=4
  LABEL="CCS: CPT 26"

  CPTCCS27                   LENGTH=4
  LABEL="CCS: CPT 27"

  CPTCCS28                   LENGTH=4
  LABEL="CCS: CPT 28"

  CPTCCS29                   LENGTH=4
  LABEL="CCS: CPT 29"

  CPTCCS30                   LENGTH=4
  LABEL="CCS: CPT 30"

  CPTCCS31                   LENGTH=4
  LABEL="CCS: CPT 31"

  CPTCCS32                   LENGTH=4
  LABEL="CCS: CPT 32"

  CPTCCS33                   LENGTH=4
  LABEL="CCS: CPT 33"

  CPTCCS34                   LENGTH=4
  LABEL="CCS: CPT 34"

  CPTCCS35                   LENGTH=4
  LABEL="CCS: CPT 35"

  NCPT                       LENGTH=3
  LABEL="Number of CPT/HCPCS procedures for this visit"
  ;

/* Read data elements from the CSV file */
INPUT 
      HOSP_ED                  :5.
      KEY_ED                   :16.
      CPT1                     :$CHAR5.
      CPT2                     :$CHAR5.
      CPT3                     :$CHAR5.
      CPT4                     :$CHAR5.
      CPT5                     :$CHAR5.
      CPT6                     :$CHAR5.
      CPT7                     :$CHAR5.
      CPT8                     :$CHAR5.
      CPT9                     :$CHAR5.
      CPT10                    :$CHAR5.
      CPT11                    :$CHAR5.
      CPT12                    :$CHAR5.
      CPT13                    :$CHAR5.
      CPT14                    :$CHAR5.
      CPT15                    :$CHAR5.
      CPT16                    :$CHAR5.
      CPT17                    :$CHAR5.
      CPT18                    :$CHAR5.
      CPT19                    :$CHAR5.
      CPT20                    :$CHAR5.
      CPT21                    :$CHAR5.
      CPT22                    :$CHAR5.
      CPT23                    :$CHAR5.
      CPT24                    :$CHAR5.
      CPT25                    :$CHAR5.
      CPT26                    :$CHAR5.
      CPT27                    :$CHAR5.
      CPT28                    :$CHAR5.
      CPT29                    :$CHAR5.
      CPT30                    :$CHAR5.
      CPT31                    :$CHAR5.
      CPT32                    :$CHAR5.
      CPT33                    :$CHAR5.
      CPT34                    :$CHAR5.
      CPT35                    :$CHAR5.
      CPTCCS1                  :N4PF.
      CPTCCS2                  :N4PF.
      CPTCCS3                  :N4PF.
      CPTCCS4                  :N4PF.
      CPTCCS5                  :N4PF.
      CPTCCS6                  :N4PF.
      CPTCCS7                  :N4PF.
      CPTCCS8                  :N4PF.
      CPTCCS9                  :N4PF.
      CPTCCS10                 :N4PF.
      CPTCCS11                 :N4PF.
      CPTCCS12                 :N4PF.
      CPTCCS13                 :N4PF.
      CPTCCS14                 :N4PF.
      CPTCCS15                 :N4PF.
      CPTCCS16                 :N4PF.
      CPTCCS17                 :N4PF.
      CPTCCS18                 :N4PF.
      CPTCCS19                 :N4PF.
      CPTCCS20                 :N4PF.
      CPTCCS21                 :N4PF.
      CPTCCS22                 :N4PF.
      CPTCCS23                 :N4PF.
      CPTCCS24                 :N4PF.
      CPTCCS25                 :N4PF.
      CPTCCS26                 :N4PF.
      CPTCCS27                 :N4PF.
      CPTCCS28                 :N4PF.
      CPTCCS29                 :N4PF.
      CPTCCS30                 :N4PF.
      CPTCCS31                 :N4PF.
      CPTCCS32                 :N4PF.
      CPTCCS33                 :N4PF.
      CPTCCS34                 :N4PF.
      CPTCCS35                 :N4PF.
      NCPT                     :N4PF.
      ;
RUN;
