/*****************************************************************************
 * SASload_NEDS_2021_IP.SAS
 * This program will load the NEDS 2021 IP csv File into SAS.
 * created on 03/01/2024.
 *****************************************************************************/

/* Create SAS informats for missing values */
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

/* Data Step to load the file */
DATA NEDS_2021_IP; 
INFILE 'NEDS_2021_IP.csv' dsd dlm=',' LRECL = 1241;

/* Define data element attributes */
ATTRIB 
  HOSP_ED                    LENGTH=4            FORMAT=Z5.
  LABEL="HCUP ED hospital identifier"

  KEY_ED                     LENGTH=8            FORMAT=Z14.
  LABEL="HCUP NEDS record identifier"

  DISP_IP                    LENGTH=3
  LABEL="Disposition of patient (uniform) from IP"

  DRG                        LENGTH=3
  LABEL="DRG in effect on discharge date"

  DRGVER                     LENGTH=3
  LABEL="DRG grouper version used on discharge date"

  DRG_NoPOA                  LENGTH=3
  LABEL="DRG in use on discharge date, calculated without POA"

  I10_NPR_IP                 LENGTH=3
  LABEL="Number of ICD-10-PCS procedures from inpatient discharge record"

  I10_PR_IP1                 LENGTH=$7
  LABEL="ICD-10-PCS Procedure 1 from inpatient discharge record"

  I10_PR_IP2                 LENGTH=$7
  LABEL="ICD-10-PCS Procedure 2 from inpatient discharge record"

  I10_PR_IP3                 LENGTH=$7
  LABEL="ICD-10-PCS Procedure 3 from inpatient discharge record"

  I10_PR_IP4                 LENGTH=$7
  LABEL="ICD-10-PCS Procedure 4 from inpatient discharge record"

  I10_PR_IP5                 LENGTH=$7
  LABEL="ICD-10-PCS Procedure 5 from inpatient discharge record"

  I10_PR_IP6                 LENGTH=$7
  LABEL="ICD-10-PCS Procedure 6 from inpatient discharge record"

  I10_PR_IP7                 LENGTH=$7
  LABEL="ICD-10-PCS Procedure 7 from inpatient discharge record"

  I10_PR_IP8                 LENGTH=$7
  LABEL="ICD-10-PCS Procedure 8 from inpatient discharge record"

  I10_PR_IP9                 LENGTH=$7
  LABEL="ICD-10-PCS Procedure 9 from inpatient discharge record"

  I10_PR_IP10                LENGTH=$7
  LABEL="ICD-10-PCS Procedure 10 from inpatient discharge record"

  I10_PR_IP11                LENGTH=$7
  LABEL="ICD-10-PCS Procedure 11 from inpatient discharge record"

  I10_PR_IP12                LENGTH=$7
  LABEL="ICD-10-PCS Procedure 12 from inpatient discharge record"

  I10_PR_IP13                LENGTH=$7
  LABEL="ICD-10-PCS Procedure 13 from inpatient discharge record"

  I10_PR_IP14                LENGTH=$7
  LABEL="ICD-10-PCS Procedure 14 from inpatient discharge record"

  I10_PR_IP15                LENGTH=$7
  LABEL="ICD-10-PCS Procedure 15 from inpatient discharge record"

  LOS_IP                     LENGTH=4
  LABEL="Length of stay (cleaned) from IP"

  MDC                        LENGTH=3
  LABEL="MDC in effect on discharge date"

  MDC_NoPOA                  LENGTH=3
  LABEL="MDC in use on discharge date, calculated without POA"

  PCLASS1                    LENGTH=3
  LABEL="ICD-10-PCS Procedure class 1"

  PCLASS2                    LENGTH=3
  LABEL="ICD-10-PCS Procedure class 2"

  PCLASS3                    LENGTH=3
  LABEL="ICD-10-PCS Procedure class 3"

  PCLASS4                    LENGTH=3
  LABEL="ICD-10-PCS Procedure class 4"

  PCLASS5                    LENGTH=3
  LABEL="ICD-10-PCS Procedure class 5"

  PCLASS6                    LENGTH=3
  LABEL="ICD-10-PCS Procedure class 6"

  PCLASS7                    LENGTH=3
  LABEL="ICD-10-PCS Procedure class 7"

  PCLASS8                    LENGTH=3
  LABEL="ICD-10-PCS Procedure class 8"

  PCLASS9                    LENGTH=3
  LABEL="ICD-10-PCS Procedure class 9"

  PCLASS10                   LENGTH=3
  LABEL="ICD-10-PCS Procedure class 10"

  PCLASS11                   LENGTH=3
  LABEL="ICD-10-PCS Procedure class 11"

  PCLASS12                   LENGTH=3
  LABEL="ICD-10-PCS Procedure class 12"

  PCLASS13                   LENGTH=3
  LABEL="ICD-10-PCS Procedure class 13"

  PCLASS14                   LENGTH=3
  LABEL="ICD-10-PCS Procedure class 14"

  PCLASS15                   LENGTH=3
  LABEL="ICD-10-PCS Procedure class 15"

  PCLASS_VERSION             LENGTH=$6
  LABEL="Version of ICD-10-PCS Procedure class"

  PRCCSR_ADM001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM001"

  PRCCSR_ADM002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM002"

  PRCCSR_ADM003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM003"

  PRCCSR_ADM004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM004"

  PRCCSR_ADM005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM005"

  PRCCSR_ADM006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM006"

  PRCCSR_ADM007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM007"

  PRCCSR_ADM008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM008"

  PRCCSR_ADM009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM009"

  PRCCSR_ADM010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM010"

  PRCCSR_ADM011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM011"

  PRCCSR_ADM012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM012"

  PRCCSR_ADM013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM013"

  PRCCSR_ADM014              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM014"

  PRCCSR_ADM015              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM015"

  PRCCSR_ADM016              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM016"

  PRCCSR_ADM017              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM017"

  PRCCSR_ADM018              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM018"

  PRCCSR_ADM019              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM019"

  PRCCSR_ADM020              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM020"

  PRCCSR_ADM021              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM021"

  PRCCSR_ADM022              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM022"

  PRCCSR_CAR001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR001"

  PRCCSR_CAR002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR002"

  PRCCSR_CAR003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR003"

  PRCCSR_CAR004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR004"

  PRCCSR_CAR005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR005"

  PRCCSR_CAR006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR006"

  PRCCSR_CAR007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR007"

  PRCCSR_CAR008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR008"

  PRCCSR_CAR009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR009"

  PRCCSR_CAR010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR010"

  PRCCSR_CAR011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR011"

  PRCCSR_CAR012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR012"

  PRCCSR_CAR013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR013"

  PRCCSR_CAR014              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR014"

  PRCCSR_CAR015              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR015"

  PRCCSR_CAR016              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR016"

  PRCCSR_CAR017              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR017"

  PRCCSR_CAR018              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR018"

  PRCCSR_CAR019              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR019"

  PRCCSR_CAR020              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR020"

  PRCCSR_CAR021              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR021"

  PRCCSR_CAR022              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR022"

  PRCCSR_CAR023              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR023"

  PRCCSR_CAR024              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR024"

  PRCCSR_CAR025              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR025"

  PRCCSR_CAR026              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR026"

  PRCCSR_CAR027              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR027"

  PRCCSR_CAR028              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR028"

  PRCCSR_CAR029              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR029"

  PRCCSR_CHP001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CHP001"

  PRCCSR_CNS001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS001"

  PRCCSR_CNS002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS002"

  PRCCSR_CNS003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS003"

  PRCCSR_CNS004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS004"

  PRCCSR_CNS005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS005"

  PRCCSR_CNS006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS006"

  PRCCSR_CNS007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS007"

  PRCCSR_CNS008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS008"

  PRCCSR_CNS009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS009"

  PRCCSR_CNS010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS010"

  PRCCSR_CNS011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS011"

  PRCCSR_CNS012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS012"

  PRCCSR_CNS013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS013"

  PRCCSR_CNS014              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS014"

  PRCCSR_ENP001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP001"

  PRCCSR_ENP002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP002"

  PRCCSR_ENP003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP003"

  PRCCSR_ENP004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP004"

  PRCCSR_ENP005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP005"

  PRCCSR_ENP006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP006"

  PRCCSR_ENT001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT001"

  PRCCSR_ENT002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT002"

  PRCCSR_ENT003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT003"

  PRCCSR_ENT004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT004"

  PRCCSR_ENT005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT005"

  PRCCSR_ENT006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT006"

  PRCCSR_ENT007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT007"

  PRCCSR_ENT008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT008"

  PRCCSR_ENT009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT009"

  PRCCSR_ENT010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT010"

  PRCCSR_ENT011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT011"

  PRCCSR_ENT012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT012"

  PRCCSR_ENT013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT013"

  PRCCSR_ENT014              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT014"

  PRCCSR_ENT015              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT015"

  PRCCSR_ENT016              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT016"

  PRCCSR_ENT017              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT017"

  PRCCSR_ESA001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA001"

  PRCCSR_ESA002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA002"

  PRCCSR_ESA003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA003"

  PRCCSR_ESA004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA004"

  PRCCSR_ESA005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA005"

  PRCCSR_ESA006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA006"

  PRCCSR_ESA007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA007"

  PRCCSR_ESA008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA008"

  PRCCSR_ESA009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA009"

  PRCCSR_ESA010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA010"

  PRCCSR_ESA011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA011"

  PRCCSR_EST001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST001"

  PRCCSR_EST002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST002"

  PRCCSR_EST003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST003"

  PRCCSR_EST004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST004"

  PRCCSR_EST005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST005"

  PRCCSR_EYP001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP001"

  PRCCSR_EYP002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP002"

  PRCCSR_FRS001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS001"

  PRCCSR_FRS002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS002"

  PRCCSR_FRS003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS003"

  PRCCSR_FRS004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS004"

  PRCCSR_FRS005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS005"

  PRCCSR_FRS006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS006"

  PRCCSR_FRS007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS007"

  PRCCSR_FRS008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS008"

  PRCCSR_FRS009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS009"

  PRCCSR_FRS010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS010"

  PRCCSR_FRS011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS011"

  PRCCSR_FRS012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS012"

  PRCCSR_FRS013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS013"

  PRCCSR_FRS014              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS014"

  PRCCSR_FRS015              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS015"

  PRCCSR_GIS001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS001"

  PRCCSR_GIS002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS002"

  PRCCSR_GIS003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS003"

  PRCCSR_GIS004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS004"

  PRCCSR_GIS005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS005"

  PRCCSR_GIS006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS006"

  PRCCSR_GIS007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS007"

  PRCCSR_GIS008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS008"

  PRCCSR_GIS009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS009"

  PRCCSR_GIS010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS010"

  PRCCSR_GIS011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS011"

  PRCCSR_GIS012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS012"

  PRCCSR_GIS013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS013"

  PRCCSR_GIS014              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS014"

  PRCCSR_GIS015              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS015"

  PRCCSR_GIS016              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS016"

  PRCCSR_GIS017              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS017"

  PRCCSR_GIS018              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS018"

  PRCCSR_GIS019              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS019"

  PRCCSR_GIS020              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS020"

  PRCCSR_GIS021              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS021"

  PRCCSR_GIS022              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS022"

  PRCCSR_GIS023              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS023"

  PRCCSR_GIS024              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS024"

  PRCCSR_GIS025              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS025"

  PRCCSR_GIS026              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS026"

  PRCCSR_GIS027              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS027"

  PRCCSR_GIS028              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS028"

  PRCCSR_GIS029              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS029"

  PRCCSR_GNR001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR001"

  PRCCSR_GNR002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR002"

  PRCCSR_GNR003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR003"

  PRCCSR_GNR004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR004"

  PRCCSR_GNR005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR005"

  PRCCSR_GNR006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR006"

  PRCCSR_GNR007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR007"

  PRCCSR_GNR008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR008"

  PRCCSR_GNR009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR009"

  PRCCSR_GNR010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR010"

  PRCCSR_HEP001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP001"

  PRCCSR_HEP002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP002"

  PRCCSR_HEP003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP003"

  PRCCSR_HEP004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP004"

  PRCCSR_HEP005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP005"

  PRCCSR_HEP006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP006"

  PRCCSR_HEP007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP007"

  PRCCSR_HEP008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP008"

  PRCCSR_HEP009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP009"

  PRCCSR_HEP010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP010"

  PRCCSR_HEP011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP011"

  PRCCSR_HEP012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP012"

  PRCCSR_HEP013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP013"

  PRCCSR_IMG001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG001"

  PRCCSR_IMG002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG002"

  PRCCSR_IMG003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG003"

  PRCCSR_IMG004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG004"

  PRCCSR_IMG005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG005"

  PRCCSR_IMG006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG006"

  PRCCSR_IMG007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG007"

  PRCCSR_IMG008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG008"

  PRCCSR_IMG009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG009"

  PRCCSR_IMG010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG010"

  PRCCSR_LYM001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM001"

  PRCCSR_LYM002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM002"

  PRCCSR_LYM003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM003"

  PRCCSR_LYM004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM004"

  PRCCSR_LYM005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM005"

  PRCCSR_LYM006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM006"

  PRCCSR_LYM007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM007"

  PRCCSR_LYM008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM008"

  PRCCSR_LYM009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM009"

  PRCCSR_LYM010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM010"

  PRCCSR_LYM011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM011"

  PRCCSR_MAM001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM001"

  PRCCSR_MAM002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM002"

  PRCCSR_MAM003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM003"

  PRCCSR_MAM004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM004"

  PRCCSR_MAM005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM005"

  PRCCSR_MAM006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM006"

  PRCCSR_MAM007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM007"

  PRCCSR_MAM008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM008"

  PRCCSR_MAM009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM009"

  PRCCSR_MAM010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM010"

  PRCCSR_MAM011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM011"

  PRCCSR_MAM012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM012"

  PRCCSR_MAM013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM013"

  PRCCSR_MAM014              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM014"

  PRCCSR_MAM015              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM015"

  PRCCSR_MHT001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT001"

  PRCCSR_MHT002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT002"

  PRCCSR_MHT003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT003"

  PRCCSR_MHT004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT004"

  PRCCSR_MHT005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT005"

  PRCCSR_MRS001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS001"

  PRCCSR_MRS002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS002"

  PRCCSR_MRS003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS003"

  PRCCSR_MRS004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS004"

  PRCCSR_MRS005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS005"

  PRCCSR_MRS006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS006"

  PRCCSR_MRS007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS007"

  PRCCSR_MST001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST001"

  PRCCSR_MST002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST002"

  PRCCSR_MST003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST003"

  PRCCSR_MST004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST004"

  PRCCSR_MST005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST005"

  PRCCSR_MST006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST006"

  PRCCSR_MST007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST007"

  PRCCSR_MST008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST008"

  PRCCSR_MST009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST009"

  PRCCSR_MST010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST010"

  PRCCSR_MST011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST011"

  PRCCSR_MST012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST012"

  PRCCSR_MST013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST013"

  PRCCSR_MST014              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST014"

  PRCCSR_MST015              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST015"

  PRCCSR_MST016              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST016"

  PRCCSR_MST017              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST017"

  PRCCSR_MST018              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST018"

  PRCCSR_MST019              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST019"

  PRCCSR_MST020              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST020"

  PRCCSR_MST021              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST021"

  PRCCSR_MST022              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST022"

  PRCCSR_MST023              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST023"

  PRCCSR_MST024              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST024"

  PRCCSR_MST025              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST025"

  PRCCSR_MST026              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST026"

  PRCCSR_MST027              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST027"

  PRCCSR_MST028              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST028"

  PRCCSR_MST029              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST029"

  PRCCSR_MST030              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST030"

  PRCCSR_NCM001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM001"

  PRCCSR_NCM002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM002"

  PRCCSR_NCM003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM003"

  PRCCSR_NCM004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM004"

  PRCCSR_OST001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OST001"

  PRCCSR_OTR001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR001"

  PRCCSR_OTR002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR002"

  PRCCSR_OTR003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR003"

  PRCCSR_OTR004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR004"

  PRCCSR_OTR005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR005"

  PRCCSR_PGN001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN001"

  PRCCSR_PGN002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN002"

  PRCCSR_PGN003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN003"

  PRCCSR_PGN004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN004"

  PRCCSR_PGN005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN005"

  PRCCSR_PGN006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN006"

  PRCCSR_PGN007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN007"

  PRCCSR_PGN008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN008"

  PRCCSR_PGN009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN009"

  PRCCSR_PLC001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC001"

  PRCCSR_PLC002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC002"

  PRCCSR_PNS001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS001"

  PRCCSR_PNS002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS002"

  PRCCSR_PNS003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS003"

  PRCCSR_PNS004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS004"

  PRCCSR_PNS005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS005"

  PRCCSR_PNS006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS006"

  PRCCSR_RAD001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD001"

  PRCCSR_RAD002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD002"

  PRCCSR_RAD003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD003"

  PRCCSR_RAD004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD004"

  PRCCSR_RES001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES001"

  PRCCSR_RES002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES002"

  PRCCSR_RES003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES003"

  PRCCSR_RES004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES004"

  PRCCSR_RES005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES005"

  PRCCSR_RES006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES006"

  PRCCSR_RES007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES007"

  PRCCSR_RES008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES008"

  PRCCSR_RES009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES009"

  PRCCSR_RES010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES010"

  PRCCSR_RES011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES011"

  PRCCSR_RES012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES012"

  PRCCSR_RES013              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES013"

  PRCCSR_RES014              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES014"

  PRCCSR_RHB001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB001"

  PRCCSR_RHB002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB002"

  PRCCSR_RHB003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB003"

  PRCCSR_RHB004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB004"

  PRCCSR_SKB001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB001"

  PRCCSR_SKB002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB002"

  PRCCSR_SKB003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB003"

  PRCCSR_SKB004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB004"

  PRCCSR_SKB005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB005"

  PRCCSR_SKB006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB006"

  PRCCSR_SKB007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB007"

  PRCCSR_SKB008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB008"

  PRCCSR_SKB009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB009"

  PRCCSR_SKB010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB010"

  PRCCSR_SUD001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD001"

  PRCCSR_SUD002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD002"

  PRCCSR_SUD003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD003"

  PRCCSR_SUD004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD004"

  PRCCSR_URN001              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN001"

  PRCCSR_URN002              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN002"

  PRCCSR_URN003              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN003"

  PRCCSR_URN004              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN004"

  PRCCSR_URN005              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN005"

  PRCCSR_URN006              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN006"

  PRCCSR_URN007              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN007"

  PRCCSR_URN008              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN008"

  PRCCSR_URN009              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN009"

  PRCCSR_URN010              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN010"

  PRCCSR_URN011              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN011"

  PRCCSR_URN012              LENGTH=3
  LABEL="Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN012"

  PRCCSR_VERSION             LENGTH=$6
  LABEL="Version of CCSR for ICD-10-PCS procedures"

  TOTCHG_IP                  LENGTH=6
  LABEL="Total charge for ED and inpatient services"
  ;

/* Read data elements from the CSV file */
INPUT 
      HOSP_ED                  :5.
      KEY_ED                   :16.
      DISP_IP                  :N2PF.
      DRG                      :N3PF.
      DRGVER                   :N2PF.
      DRG_NoPOA                :N3PF.
      I10_NPR_IP               :N3PF.
      I10_PR_IP1               :$CHAR7.
      I10_PR_IP2               :$CHAR7.
      I10_PR_IP3               :$CHAR7.
      I10_PR_IP4               :$CHAR7.
      I10_PR_IP5               :$CHAR7.
      I10_PR_IP6               :$CHAR7.
      I10_PR_IP7               :$CHAR7.
      I10_PR_IP8               :$CHAR7.
      I10_PR_IP9               :$CHAR7.
      I10_PR_IP10              :$CHAR7.
      I10_PR_IP11              :$CHAR7.
      I10_PR_IP12              :$CHAR7.
      I10_PR_IP13              :$CHAR7.
      I10_PR_IP14              :$CHAR7.
      I10_PR_IP15              :$CHAR7.
      LOS_IP                   :N5PF.
      MDC                      :N2PF.
      MDC_NoPOA                :N2PF.
      PCLASS1                  :N3PF.
      PCLASS2                  :N3PF.
      PCLASS3                  :N3PF.
      PCLASS4                  :N3PF.
      PCLASS5                  :N3PF.
      PCLASS6                  :N3PF.
      PCLASS7                  :N3PF.
      PCLASS8                  :N3PF.
      PCLASS9                  :N3PF.
      PCLASS10                 :N3PF.
      PCLASS11                 :N3PF.
      PCLASS12                 :N3PF.
      PCLASS13                 :N3PF.
      PCLASS14                 :N3PF.
      PCLASS15                 :N3PF.
      PCLASS_VERSION           :$CHAR6.
      PRCCSR_ADM001            :N2PF.
      PRCCSR_ADM002            :N2PF.
      PRCCSR_ADM003            :N2PF.
      PRCCSR_ADM004            :N2PF.
      PRCCSR_ADM005            :N2PF.
      PRCCSR_ADM006            :N2PF.
      PRCCSR_ADM007            :N2PF.
      PRCCSR_ADM008            :N2PF.
      PRCCSR_ADM009            :N2PF.
      PRCCSR_ADM010            :N2PF.
      PRCCSR_ADM011            :N2PF.
      PRCCSR_ADM012            :N2PF.
      PRCCSR_ADM013            :N2PF.
      PRCCSR_ADM014            :N2PF.
      PRCCSR_ADM015            :N2PF.
      PRCCSR_ADM016            :N2PF.
      PRCCSR_ADM017            :N2PF.
      PRCCSR_ADM018            :N2PF.
      PRCCSR_ADM019            :N2PF.
      PRCCSR_ADM020            :N2PF.
      PRCCSR_ADM021            :N2PF.
      PRCCSR_ADM022            :N2PF.
      PRCCSR_CAR001            :N2PF.
      PRCCSR_CAR002            :N2PF.
      PRCCSR_CAR003            :N2PF.
      PRCCSR_CAR004            :N2PF.
      PRCCSR_CAR005            :N2PF.
      PRCCSR_CAR006            :N2PF.
      PRCCSR_CAR007            :N2PF.
      PRCCSR_CAR008            :N2PF.
      PRCCSR_CAR009            :N2PF.
      PRCCSR_CAR010            :N2PF.
      PRCCSR_CAR011            :N2PF.
      PRCCSR_CAR012            :N2PF.
      PRCCSR_CAR013            :N2PF.
      PRCCSR_CAR014            :N2PF.
      PRCCSR_CAR015            :N2PF.
      PRCCSR_CAR016            :N2PF.
      PRCCSR_CAR017            :N2PF.
      PRCCSR_CAR018            :N2PF.
      PRCCSR_CAR019            :N2PF.
      PRCCSR_CAR020            :N2PF.
      PRCCSR_CAR021            :N2PF.
      PRCCSR_CAR022            :N2PF.
      PRCCSR_CAR023            :N2PF.
      PRCCSR_CAR024            :N2PF.
      PRCCSR_CAR025            :N2PF.
      PRCCSR_CAR026            :N2PF.
      PRCCSR_CAR027            :N2PF.
      PRCCSR_CAR028            :N2PF.
      PRCCSR_CAR029            :N2PF.
      PRCCSR_CHP001            :N2PF.
      PRCCSR_CNS001            :N2PF.
      PRCCSR_CNS002            :N2PF.
      PRCCSR_CNS003            :N2PF.
      PRCCSR_CNS004            :N2PF.
      PRCCSR_CNS005            :N2PF.
      PRCCSR_CNS006            :N2PF.
      PRCCSR_CNS007            :N2PF.
      PRCCSR_CNS008            :N2PF.
      PRCCSR_CNS009            :N2PF.
      PRCCSR_CNS010            :N2PF.
      PRCCSR_CNS011            :N2PF.
      PRCCSR_CNS012            :N2PF.
      PRCCSR_CNS013            :N2PF.
      PRCCSR_CNS014            :N2PF.
      PRCCSR_ENP001            :N2PF.
      PRCCSR_ENP002            :N2PF.
      PRCCSR_ENP003            :N2PF.
      PRCCSR_ENP004            :N2PF.
      PRCCSR_ENP005            :N2PF.
      PRCCSR_ENP006            :N2PF.
      PRCCSR_ENT001            :N2PF.
      PRCCSR_ENT002            :N2PF.
      PRCCSR_ENT003            :N2PF.
      PRCCSR_ENT004            :N2PF.
      PRCCSR_ENT005            :N2PF.
      PRCCSR_ENT006            :N2PF.
      PRCCSR_ENT007            :N2PF.
      PRCCSR_ENT008            :N2PF.
      PRCCSR_ENT009            :N2PF.
      PRCCSR_ENT010            :N2PF.
      PRCCSR_ENT011            :N2PF.
      PRCCSR_ENT012            :N2PF.
      PRCCSR_ENT013            :N2PF.
      PRCCSR_ENT014            :N2PF.
      PRCCSR_ENT015            :N2PF.
      PRCCSR_ENT016            :N2PF.
      PRCCSR_ENT017            :N2PF.
      PRCCSR_ESA001            :N2PF.
      PRCCSR_ESA002            :N2PF.
      PRCCSR_ESA003            :N2PF.
      PRCCSR_ESA004            :N2PF.
      PRCCSR_ESA005            :N2PF.
      PRCCSR_ESA006            :N2PF.
      PRCCSR_ESA007            :N2PF.
      PRCCSR_ESA008            :N2PF.
      PRCCSR_ESA009            :N2PF.
      PRCCSR_ESA010            :N2PF.
      PRCCSR_ESA011            :N2PF.
      PRCCSR_EST001            :N2PF.
      PRCCSR_EST002            :N2PF.
      PRCCSR_EST003            :N2PF.
      PRCCSR_EST004            :N2PF.
      PRCCSR_EST005            :N2PF.
      PRCCSR_EYP001            :N2PF.
      PRCCSR_EYP002            :N2PF.
      PRCCSR_FRS001            :N2PF.
      PRCCSR_FRS002            :N2PF.
      PRCCSR_FRS003            :N2PF.
      PRCCSR_FRS004            :N2PF.
      PRCCSR_FRS005            :N2PF.
      PRCCSR_FRS006            :N2PF.
      PRCCSR_FRS007            :N2PF.
      PRCCSR_FRS008            :N2PF.
      PRCCSR_FRS009            :N2PF.
      PRCCSR_FRS010            :N2PF.
      PRCCSR_FRS011            :N2PF.
      PRCCSR_FRS012            :N2PF.
      PRCCSR_FRS013            :N2PF.
      PRCCSR_FRS014            :N2PF.
      PRCCSR_FRS015            :N2PF.
      PRCCSR_GIS001            :N2PF.
      PRCCSR_GIS002            :N2PF.
      PRCCSR_GIS003            :N2PF.
      PRCCSR_GIS004            :N2PF.
      PRCCSR_GIS005            :N2PF.
      PRCCSR_GIS006            :N2PF.
      PRCCSR_GIS007            :N2PF.
      PRCCSR_GIS008            :N2PF.
      PRCCSR_GIS009            :N2PF.
      PRCCSR_GIS010            :N2PF.
      PRCCSR_GIS011            :N2PF.
      PRCCSR_GIS012            :N2PF.
      PRCCSR_GIS013            :N2PF.
      PRCCSR_GIS014            :N2PF.
      PRCCSR_GIS015            :N2PF.
      PRCCSR_GIS016            :N2PF.
      PRCCSR_GIS017            :N2PF.
      PRCCSR_GIS018            :N2PF.
      PRCCSR_GIS019            :N2PF.
      PRCCSR_GIS020            :N2PF.
      PRCCSR_GIS021            :N2PF.
      PRCCSR_GIS022            :N2PF.
      PRCCSR_GIS023            :N2PF.
      PRCCSR_GIS024            :N2PF.
      PRCCSR_GIS025            :N2PF.
      PRCCSR_GIS026            :N2PF.
      PRCCSR_GIS027            :N2PF.
      PRCCSR_GIS028            :N2PF.
      PRCCSR_GIS029            :N2PF.
      PRCCSR_GNR001            :N2PF.
      PRCCSR_GNR002            :N2PF.
      PRCCSR_GNR003            :N2PF.
      PRCCSR_GNR004            :N2PF.
      PRCCSR_GNR005            :N2PF.
      PRCCSR_GNR006            :N2PF.
      PRCCSR_GNR007            :N2PF.
      PRCCSR_GNR008            :N2PF.
      PRCCSR_GNR009            :N2PF.
      PRCCSR_GNR010            :N2PF.
      PRCCSR_HEP001            :N2PF.
      PRCCSR_HEP002            :N2PF.
      PRCCSR_HEP003            :N2PF.
      PRCCSR_HEP004            :N2PF.
      PRCCSR_HEP005            :N2PF.
      PRCCSR_HEP006            :N2PF.
      PRCCSR_HEP007            :N2PF.
      PRCCSR_HEP008            :N2PF.
      PRCCSR_HEP009            :N2PF.
      PRCCSR_HEP010            :N2PF.
      PRCCSR_HEP011            :N2PF.
      PRCCSR_HEP012            :N2PF.
      PRCCSR_HEP013            :N2PF.
      PRCCSR_IMG001            :N2PF.
      PRCCSR_IMG002            :N2PF.
      PRCCSR_IMG003            :N2PF.
      PRCCSR_IMG004            :N2PF.
      PRCCSR_IMG005            :N2PF.
      PRCCSR_IMG006            :N2PF.
      PRCCSR_IMG007            :N2PF.
      PRCCSR_IMG008            :N2PF.
      PRCCSR_IMG009            :N2PF.
      PRCCSR_IMG010            :N2PF.
      PRCCSR_LYM001            :N2PF.
      PRCCSR_LYM002            :N2PF.
      PRCCSR_LYM003            :N2PF.
      PRCCSR_LYM004            :N2PF.
      PRCCSR_LYM005            :N2PF.
      PRCCSR_LYM006            :N2PF.
      PRCCSR_LYM007            :N2PF.
      PRCCSR_LYM008            :N2PF.
      PRCCSR_LYM009            :N2PF.
      PRCCSR_LYM010            :N2PF.
      PRCCSR_LYM011            :N2PF.
      PRCCSR_MAM001            :N2PF.
      PRCCSR_MAM002            :N2PF.
      PRCCSR_MAM003            :N2PF.
      PRCCSR_MAM004            :N2PF.
      PRCCSR_MAM005            :N2PF.
      PRCCSR_MAM006            :N2PF.
      PRCCSR_MAM007            :N2PF.
      PRCCSR_MAM008            :N2PF.
      PRCCSR_MAM009            :N2PF.
      PRCCSR_MAM010            :N2PF.
      PRCCSR_MAM011            :N2PF.
      PRCCSR_MAM012            :N2PF.
      PRCCSR_MAM013            :N2PF.
      PRCCSR_MAM014            :N2PF.
      PRCCSR_MAM015            :N2PF.
      PRCCSR_MHT001            :N2PF.
      PRCCSR_MHT002            :N2PF.
      PRCCSR_MHT003            :N2PF.
      PRCCSR_MHT004            :N2PF.
      PRCCSR_MHT005            :N2PF.
      PRCCSR_MRS001            :N2PF.
      PRCCSR_MRS002            :N2PF.
      PRCCSR_MRS003            :N2PF.
      PRCCSR_MRS004            :N2PF.
      PRCCSR_MRS005            :N2PF.
      PRCCSR_MRS006            :N2PF.
      PRCCSR_MRS007            :N2PF.
      PRCCSR_MST001            :N2PF.
      PRCCSR_MST002            :N2PF.
      PRCCSR_MST003            :N2PF.
      PRCCSR_MST004            :N2PF.
      PRCCSR_MST005            :N2PF.
      PRCCSR_MST006            :N2PF.
      PRCCSR_MST007            :N2PF.
      PRCCSR_MST008            :N2PF.
      PRCCSR_MST009            :N2PF.
      PRCCSR_MST010            :N2PF.
      PRCCSR_MST011            :N2PF.
      PRCCSR_MST012            :N2PF.
      PRCCSR_MST013            :N2PF.
      PRCCSR_MST014            :N2PF.
      PRCCSR_MST015            :N2PF.
      PRCCSR_MST016            :N2PF.
      PRCCSR_MST017            :N2PF.
      PRCCSR_MST018            :N2PF.
      PRCCSR_MST019            :N2PF.
      PRCCSR_MST020            :N2PF.
      PRCCSR_MST021            :N2PF.
      PRCCSR_MST022            :N2PF.
      PRCCSR_MST023            :N2PF.
      PRCCSR_MST024            :N2PF.
      PRCCSR_MST025            :N2PF.
      PRCCSR_MST026            :N2PF.
      PRCCSR_MST027            :N2PF.
      PRCCSR_MST028            :N2PF.
      PRCCSR_MST029            :N2PF.
      PRCCSR_MST030            :N2PF.
      PRCCSR_NCM001            :N2PF.
      PRCCSR_NCM002            :N2PF.
      PRCCSR_NCM003            :N2PF.
      PRCCSR_NCM004            :N2PF.
      PRCCSR_OST001            :N2PF.
      PRCCSR_OTR001            :N2PF.
      PRCCSR_OTR002            :N2PF.
      PRCCSR_OTR003            :N2PF.
      PRCCSR_OTR004            :N2PF.
      PRCCSR_OTR005            :N2PF.
      PRCCSR_PGN001            :N2PF.
      PRCCSR_PGN002            :N2PF.
      PRCCSR_PGN003            :N2PF.
      PRCCSR_PGN004            :N2PF.
      PRCCSR_PGN005            :N2PF.
      PRCCSR_PGN006            :N2PF.
      PRCCSR_PGN007            :N2PF.
      PRCCSR_PGN008            :N2PF.
      PRCCSR_PGN009            :N2PF.
      PRCCSR_PLC001            :N2PF.
      PRCCSR_PLC002            :N2PF.
      PRCCSR_PNS001            :N2PF.
      PRCCSR_PNS002            :N2PF.
      PRCCSR_PNS003            :N2PF.
      PRCCSR_PNS004            :N2PF.
      PRCCSR_PNS005            :N2PF.
      PRCCSR_PNS006            :N2PF.
      PRCCSR_RAD001            :N2PF.
      PRCCSR_RAD002            :N2PF.
      PRCCSR_RAD003            :N2PF.
      PRCCSR_RAD004            :N2PF.
      PRCCSR_RES001            :N2PF.
      PRCCSR_RES002            :N2PF.
      PRCCSR_RES003            :N2PF.
      PRCCSR_RES004            :N2PF.
      PRCCSR_RES005            :N2PF.
      PRCCSR_RES006            :N2PF.
      PRCCSR_RES007            :N2PF.
      PRCCSR_RES008            :N2PF.
      PRCCSR_RES009            :N2PF.
      PRCCSR_RES010            :N2PF.
      PRCCSR_RES011            :N2PF.
      PRCCSR_RES012            :N2PF.
      PRCCSR_RES013            :N2PF.
      PRCCSR_RES014            :N2PF.
      PRCCSR_RHB001            :N2PF.
      PRCCSR_RHB002            :N2PF.
      PRCCSR_RHB003            :N2PF.
      PRCCSR_RHB004            :N2PF.
      PRCCSR_SKB001            :N2PF.
      PRCCSR_SKB002            :N2PF.
      PRCCSR_SKB003            :N2PF.
      PRCCSR_SKB004            :N2PF.
      PRCCSR_SKB005            :N2PF.
      PRCCSR_SKB006            :N2PF.
      PRCCSR_SKB007            :N2PF.
      PRCCSR_SKB008            :N2PF.
      PRCCSR_SKB009            :N2PF.
      PRCCSR_SKB010            :N2PF.
      PRCCSR_SUD001            :N2PF.
      PRCCSR_SUD002            :N2PF.
      PRCCSR_SUD003            :N2PF.
      PRCCSR_SUD004            :N2PF.
      PRCCSR_URN001            :N2PF.
      PRCCSR_URN002            :N2PF.
      PRCCSR_URN003            :N2PF.
      PRCCSR_URN004            :N2PF.
      PRCCSR_URN005            :N2PF.
      PRCCSR_URN006            :N2PF.
      PRCCSR_URN007            :N2PF.
      PRCCSR_URN008            :N2PF.
      PRCCSR_URN009            :N2PF.
      PRCCSR_URN010            :N2PF.
      PRCCSR_URN011            :N2PF.
      PRCCSR_URN012            :N2PF.
      PRCCSR_VERSION           :$CHAR6.
      TOTCHG_IP                :N12P2F.
      ;
RUN;
