/*****************************************************************************/
/* SPSSload_NEDS_2017_ED.SPS                                          */
/* This program will load the NEDS 2017 ED csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2017_ED.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_ED                  F5.0
    KEY_ED                   F16.0
    CPT1                     A5
    CPT2                     A5
    CPT3                     A5
    CPT4                     A5
    CPT5                     A5
    CPT6                     A5
    CPT7                     A5
    CPT8                     A5
    CPT9                     A5
    CPT10                    A5
    CPT11                    A5
    CPT12                    A5
    CPT13                    A5
    CPT14                    A5
    CPT15                    A5
    CPT16                    A5
    CPT17                    A5
    CPT18                    A5
    CPT19                    A5
    CPT20                    A5
    CPT21                    A5
    CPT22                    A5
    CPT23                    A5
    CPT24                    A5
    CPT25                    A5
    CPT26                    A5
    CPT27                    A5
    CPT28                    A5
    CPT29                    A5
    CPT30                    A5
    CPT31                    A5
    CPT32                    A5
    CPT33                    A5
    CPT34                    A5
    CPT35                    A5
    CPTCCS1                  F4.0
    CPTCCS2                  F4.0
    CPTCCS3                  F4.0
    CPTCCS4                  F4.0
    CPTCCS5                  F4.0
    CPTCCS6                  F4.0
    CPTCCS7                  F4.0
    CPTCCS8                  F4.0
    CPTCCS9                  F4.0
    CPTCCS10                 F4.0
    CPTCCS11                 F4.0
    CPTCCS12                 F4.0
    CPTCCS13                 F4.0
    CPTCCS14                 F4.0
    CPTCCS15                 F4.0
    CPTCCS16                 F4.0
    CPTCCS17                 F4.0
    CPTCCS18                 F4.0
    CPTCCS19                 F4.0
    CPTCCS20                 F4.0
    CPTCCS21                 F4.0
    CPTCCS22                 F4.0
    CPTCCS23                 F4.0
    CPTCCS24                 F4.0
    CPTCCS25                 F4.0
    CPTCCS26                 F4.0
    CPTCCS27                 F4.0
    CPTCCS28                 F4.0
    CPTCCS29                 F4.0
    CPTCCS30                 F4.0
    CPTCCS31                 F4.0
    CPTCCS32                 F4.0
    CPTCCS33                 F4.0
    CPTCCS34                 F4.0
    CPTCCS35                 F4.0
    NCPT                     F4.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_ED                  "HCUP ED hospital identifier"
    KEY_ED                   "HCUP NEDS record identifier"
    CPT1                     "CPT/HCPCS procedure code 1"
    CPT2                     "CPT/HCPCS procedure code 2"
    CPT3                     "CPT/HCPCS procedure code 3"
    CPT4                     "CPT/HCPCS procedure code 4"
    CPT5                     "CPT/HCPCS procedure code 5"
    CPT6                     "CPT/HCPCS procedure code 6"
    CPT7                     "CPT/HCPCS procedure code 7"
    CPT8                     "CPT/HCPCS procedure code 8"
    CPT9                     "CPT/HCPCS procedure code 9"
    CPT10                    "CPT/HCPCS procedure code 10"
    CPT11                    "CPT/HCPCS procedure code 11"
    CPT12                    "CPT/HCPCS procedure code 12"
    CPT13                    "CPT/HCPCS procedure code 13"
    CPT14                    "CPT/HCPCS procedure code 14"
    CPT15                    "CPT/HCPCS procedure code 15"
    CPT16                    "CPT/HCPCS procedure code 16"
    CPT17                    "CPT/HCPCS procedure code 17"
    CPT18                    "CPT/HCPCS procedure code 18"
    CPT19                    "CPT/HCPCS procedure code 19"
    CPT20                    "CPT/HCPCS procedure code 20"
    CPT21                    "CPT/HCPCS procedure code 21"
    CPT22                    "CPT/HCPCS procedure code 22"
    CPT23                    "CPT/HCPCS procedure code 23"
    CPT24                    "CPT/HCPCS procedure code 24"
    CPT25                    "CPT/HCPCS procedure code 25"
    CPT26                    "CPT/HCPCS procedure code 26"
    CPT27                    "CPT/HCPCS procedure code 27"
    CPT28                    "CPT/HCPCS procedure code 28"
    CPT29                    "CPT/HCPCS procedure code 29"
    CPT30                    "CPT/HCPCS procedure code 30"
    CPT31                    "CPT/HCPCS procedure code 31"
    CPT32                    "CPT/HCPCS procedure code 32"
    CPT33                    "CPT/HCPCS procedure code 33"
    CPT34                    "CPT/HCPCS procedure code 34"
    CPT35                    "CPT/HCPCS procedure code 35"
    CPTCCS1                  "CCS: CPT 1"
    CPTCCS2                  "CCS: CPT 2"
    CPTCCS3                  "CCS: CPT 3"
    CPTCCS4                  "CCS: CPT 4"
    CPTCCS5                  "CCS: CPT 5"
    CPTCCS6                  "CCS: CPT 6"
    CPTCCS7                  "CCS: CPT 7"
    CPTCCS8                  "CCS: CPT 8"
    CPTCCS9                  "CCS: CPT 9"
    CPTCCS10                 "CCS: CPT 10"
    CPTCCS11                 "CCS: CPT 11"
    CPTCCS12                 "CCS: CPT 12"
    CPTCCS13                 "CCS: CPT 13"
    CPTCCS14                 "CCS: CPT 14"
    CPTCCS15                 "CCS: CPT 15"
    CPTCCS16                 "CCS: CPT 16"
    CPTCCS17                 "CCS: CPT 17"
    CPTCCS18                 "CCS: CPT 18"
    CPTCCS19                 "CCS: CPT 19"
    CPTCCS20                 "CCS: CPT 20"
    CPTCCS21                 "CCS: CPT 21"
    CPTCCS22                 "CCS: CPT 22"
    CPTCCS23                 "CCS: CPT 23"
    CPTCCS24                 "CCS: CPT 24"
    CPTCCS25                 "CCS: CPT 25"
    CPTCCS26                 "CCS: CPT 26"
    CPTCCS27                 "CCS: CPT 27"
    CPTCCS28                 "CCS: CPT 28"
    CPTCCS29                 "CCS: CPT 29"
    CPTCCS30                 "CCS: CPT 30"
    CPTCCS31                 "CCS: CPT 31"
    CPTCCS32                 "CCS: CPT 32"
    CPTCCS33                 "CCS: CPT 33"
    CPTCCS34                 "CCS: CPT 34"
    CPTCCS35                 "CCS: CPT 35"
    NCPT                     "Number of CPT/HCPCS procedures for this visit" .

/* Convert special values to system missing values */
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE CPTCCS1                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS2                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS3                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS4                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS5                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS6                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS7                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS8                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS9                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS10                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS11                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS12                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS13                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS14                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS15                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS16                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS17                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS18                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS19                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS20                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS21                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS22                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS23                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS24                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS25                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS26                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS27                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS28                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS29                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS30                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS31                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS32                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS33                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS34                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS35                 (-999 -888 -666=SYSMIS).
RECODE NCPT                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NEDS_2017_ED.SAV' / COMPRESSED.
