/*****************************************************************************
 * Stataload_NEDS_2015Q4_IP.Do
 * This program will load the NEDS 2015 Q4 IP csv File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2015Q4_IP.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      byte   disp_ip
      int    drg
      byte   drgver
      int    drg_nopoa
      byte   dxver
      str4   hcupfile
      long   hosp_ed
      str7   i10_dx1
      str7   i10_dx2
      str7   i10_dx3
      str7   i10_dx4
      str7   i10_dx5
      str7   i10_dx6
      str7   i10_dx7
      str7   i10_dx8
      str7   i10_dx9
      str7   i10_dx10
      str7   i10_dx11
      str7   i10_dx12
      str7   i10_dx13
      str7   i10_dx14
      str7   i10_dx15
      str7   i10_dx16
      str7   i10_dx17
      str7   i10_dx18
      str7   i10_dx19
      str7   i10_dx20
      str7   i10_dx21
      str7   i10_dx22
      str7   i10_dx23
      str7   i10_dx24
      str7   i10_dx25
      str7   i10_dx26
      str7   i10_dx27
      str7   i10_dx28
      str7   i10_dx29
      str7   i10_dx30
      str7   i10_ecause1
      str7   i10_ecause2
      str7   i10_ecause3
      str7   i10_ecause4
      int    i10_ndx
      int    i10_necause
      int    i10_npr_ip
      str7   i10_pr_ip1
      str7   i10_pr_ip2
      str7   i10_pr_ip3
      str7   i10_pr_ip4
      str7   i10_pr_ip5
      str7   i10_pr_ip6
      str7   i10_pr_ip7
      str7   i10_pr_ip8
      str7   i10_pr_ip9
      double key_ed
      long   los_ip
      byte   mdc
      byte   mdc_nopoa
      byte   prver
      double totchg_ip
using NEDS_2015Q4_IP.csv;

/*  Assign labels to the data elements */
label var disp_ip                  "Disposition of patient (uniform) from IP" ;
label var drg                      "DRG in effect on discharge date" ;
label var drgver                   "DRG grouper version used on discharge date" ;
label var drg_nopoa                "DRG in use on discharge date, calculated without POA" ;
label var dxver                    "Diagnosis Version" ;
label var hcupfile                 "Source of HCUP Record (SID or SEDD)" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var i10_dx1                  "ICD-10-CM Diagnosis 1" ;
label var i10_dx2                  "ICD-10-CM Diagnosis 2" ;
label var i10_dx3                  "ICD-10-CM Diagnosis 3" ;
label var i10_dx4                  "ICD-10-CM Diagnosis 4" ;
label var i10_dx5                  "ICD-10-CM Diagnosis 5" ;
label var i10_dx6                  "ICD-10-CM Diagnosis 6" ;
label var i10_dx7                  "ICD-10-CM Diagnosis 7" ;
label var i10_dx8                  "ICD-10-CM Diagnosis 8" ;
label var i10_dx9                  "ICD-10-CM Diagnosis 9" ;
label var i10_dx10                 "ICD-10-CM Diagnosis 10" ;
label var i10_dx11                 "ICD-10-CM Diagnosis 11" ;
label var i10_dx12                 "ICD-10-CM Diagnosis 12" ;
label var i10_dx13                 "ICD-10-CM Diagnosis 13" ;
label var i10_dx14                 "ICD-10-CM Diagnosis 14" ;
label var i10_dx15                 "ICD-10-CM Diagnosis 15" ;
label var i10_dx16                 "ICD-10-CM Diagnosis 16" ;
label var i10_dx17                 "ICD-10-CM Diagnosis 17" ;
label var i10_dx18                 "ICD-10-CM Diagnosis 18" ;
label var i10_dx19                 "ICD-10-CM Diagnosis 19" ;
label var i10_dx20                 "ICD-10-CM Diagnosis 20" ;
label var i10_dx21                 "ICD-10-CM Diagnosis 21" ;
label var i10_dx22                 "ICD-10-CM Diagnosis 22" ;
label var i10_dx23                 "ICD-10-CM Diagnosis 23" ;
label var i10_dx24                 "ICD-10-CM Diagnosis 24" ;
label var i10_dx25                 "ICD-10-CM Diagnosis 25" ;
label var i10_dx26                 "ICD-10-CM Diagnosis 26" ;
label var i10_dx27                 "ICD-10-CM Diagnosis 27" ;
label var i10_dx28                 "ICD-10-CM Diagnosis 28" ;
label var i10_dx29                 "ICD-10-CM Diagnosis 29" ;
label var i10_dx30                 "ICD-10-CM Diagnosis 30" ;
label var i10_ecause1              "ICD-10-CM External cause 1" ;
label var i10_ecause2              "ICD-10-CM External cause 2" ;
label var i10_ecause3              "ICD-10-CM External cause 3" ;
label var i10_ecause4              "ICD-10-CM External cause 4" ;
label var i10_ndx                  "ICD-10-CM Number of diagnoses on this record" ;
label var i10_necause              "ICD-10-CM Number of external cause codes on this record" ;
label var i10_npr_ip               "ICD-10-PCS Number of procedures on this record" ;
label var i10_pr_ip1               "ICD-10-PCS Principal procedure from inpatient discharge record" ;
label var i10_pr_ip2               "ICD-10-PCS Procedure 2 from inpatient discharge record" ;
label var i10_pr_ip3               "ICD-10-PCS Procedure 3 from inpatient discharge record" ;
label var i10_pr_ip4               "ICD-10-PCS Procedure 4 from inpatient discharge record" ;
label var i10_pr_ip5               "ICD-10-PCS Procedure 5 from inpatient discharge record" ;
label var i10_pr_ip6               "ICD-10-PCS Procedure 6 from inpatient discharge record" ;
label var i10_pr_ip7               "ICD-10-PCS Procedure 7 from inpatient discharge record" ;
label var i10_pr_ip8               "ICD-10-PCS Procedure 8 from inpatient discharge record" ;
label var i10_pr_ip9               "ICD-10-PCS Procedure 9 from inpatient discharge record" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var los_ip                   "Length of stay (cleaned) from IP" ;
label var mdc                      "MDC in effect on discharge date" ;
label var mdc_nopoa                "MDC in use on discharge date, calculated without POA" ;
label var prver                    "Procedure Version" ;
label var totchg_ip                "Total charge for ED and inpatient services" ;

/* Convert special values to missing values */
recode disp_ip                   (-9 -8 -6 -5=.) ;
recode drg                       (-99 -88 -66=.) ;
recode drgver                    (-9 -8 -6 -5=.) ;
recode drg_nopoa                 (-99 -88 -66=.) ;
recode dxver                     (-9 -8 -6 -5=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode i10_ndx                   (-99 -88 -66=.) ;
recode i10_necause               (-99 -88 -66=.) ;
recode i10_npr_ip                (-99 -88 -66=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode los_ip                    (-9999 -8888 -6666=.) ;
recode mdc                       (-9 -8 -6 -5=.) ;
recode mdc_nopoa                 (-9 -8 -6 -5=.) ;
recode prver                     (-9 -8 -6 -5=.) ;
recode totchg_ip                 (-99999999.99 -88888888.88 -66666666.66=.) ;

describe;

save "NEDS_2015Q4_IP.dta", replace;
#delimit cr
