/*****************************************************************************
 * Stataload_NEDS_2016_ED.Do
 * This program will load the NEDS 2016 ED csv File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2016_ED.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      long   hosp_ed
      double key_ed
      str5   cpt1
      str5   cpt2
      str5   cpt3
      str5   cpt4
      str5   cpt5
      str5   cpt6
      str5   cpt7
      str5   cpt8
      str5   cpt9
      str5   cpt10
      str5   cpt11
      str5   cpt12
      str5   cpt13
      str5   cpt14
      str5   cpt15
      int    cptccs1
      int    cptccs2
      int    cptccs3
      int    cptccs4
      int    cptccs5
      int    cptccs6
      int    cptccs7
      int    cptccs8
      int    cptccs9
      int    cptccs10
      int    cptccs11
      int    cptccs12
      int    cptccs13
      int    cptccs14
      int    cptccs15
      int    ncpt
using NEDS_2016_ED.csv;

/*  Assign labels to the data elements */
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var cpt1                     "CPT/HCPCS procedure code 1" ;
label var cpt2                     "CPT/HCPCS procedure code 2" ;
label var cpt3                     "CPT/HCPCS procedure code 3" ;
label var cpt4                     "CPT/HCPCS procedure code 4" ;
label var cpt5                     "CPT/HCPCS procedure code 5" ;
label var cpt6                     "CPT/HCPCS procedure code 6" ;
label var cpt7                     "CPT/HCPCS procedure code 7" ;
label var cpt8                     "CPT/HCPCS procedure code 8" ;
label var cpt9                     "CPT/HCPCS procedure code 9" ;
label var cpt10                    "CPT/HCPCS procedure code 10" ;
label var cpt11                    "CPT/HCPCS procedure code 11" ;
label var cpt12                    "CPT/HCPCS procedure code 12" ;
label var cpt13                    "CPT/HCPCS procedure code 13" ;
label var cpt14                    "CPT/HCPCS procedure code 14" ;
label var cpt15                    "CPT/HCPCS procedure code 15" ;
label var cptccs1                  "CCS: CPT 1" ;
label var cptccs2                  "CCS: CPT 2" ;
label var cptccs3                  "CCS: CPT 3" ;
label var cptccs4                  "CCS: CPT 4" ;
label var cptccs5                  "CCS: CPT 5" ;
label var cptccs6                  "CCS: CPT 6" ;
label var cptccs7                  "CCS: CPT 7" ;
label var cptccs8                  "CCS: CPT 8" ;
label var cptccs9                  "CCS: CPT 9" ;
label var cptccs10                 "CCS: CPT 10" ;
label var cptccs11                 "CCS: CPT 11" ;
label var cptccs12                 "CCS: CPT 12" ;
label var cptccs13                 "CCS: CPT 13" ;
label var cptccs14                 "CCS: CPT 14" ;
label var cptccs15                 "CCS: CPT 15" ;
label var ncpt                     "Number of CPT/HCPCS procedures for this visit" ;

/* Convert special values to missing values */
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode cptccs1                   (-999 -888 -666=.) ;
recode cptccs2                   (-999 -888 -666=.) ;
recode cptccs3                   (-999 -888 -666=.) ;
recode cptccs4                   (-999 -888 -666=.) ;
recode cptccs5                   (-999 -888 -666=.) ;
recode cptccs6                   (-999 -888 -666=.) ;
recode cptccs7                   (-999 -888 -666=.) ;
recode cptccs8                   (-999 -888 -666=.) ;
recode cptccs9                   (-999 -888 -666=.) ;
recode cptccs10                  (-999 -888 -666=.) ;
recode cptccs11                  (-999 -888 -666=.) ;
recode cptccs12                  (-999 -888 -666=.) ;
recode cptccs13                  (-999 -888 -666=.) ;
recode cptccs14                  (-999 -888 -666=.) ;
recode cptccs15                  (-999 -888 -666=.) ;
recode ncpt                      (-999 -888 -666=.) ;

describe;

save "NEDS_2016_ED.dta", replace;
#delimit cr
