/*****************************************************************************
 * Stataload_NEDS_2008_ED.Do
 * This program will load the 2008 NEDS CSV ED File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.      
 * or use "in" option after "using NEDS_2008_ED.csv" to read a subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      double discwt
      str4   hcupfile
      long   hosp_ed
      double key_ed
      str5   cpt1
      str5   cpt2
      str5   cpt3
      str5   cpt4
      str5   cpt5
      str5   cpt6
      str5   cpt7
      str5   cpt8
      str5   cpt9
      str5   cpt10
      str5   cpt11
      str5   cpt12
      str5   cpt13
      str5   cpt14
      str5   cpt15
      int    cptccs1
      int    cptccs2
      int    cptccs3
      int    cptccs4
      int    cptccs5
      int    cptccs6
      int    cptccs7
      int    cptccs8
      int    cptccs9
      int    cptccs10
      int    cptccs11
      int    cptccs12
      int    cptccs13
      int    cptccs14
      int    cptccs15
      int    ncpt
      int    npr_ed
      int    pcls_ed1
      int    pcls_ed2
      int    pcls_ed3
      int    pcls_ed4
      int    pcls_ed5
      int    pcls_ed6
      int    pcls_ed7
      int    pcls_ed8
      int    pcls_ed9
      str4   pr_ed1
      str4   pr_ed2
      str4   pr_ed3
      str4   pr_ed4
      str4   pr_ed5
      str4   pr_ed6
      str4   pr_ed7
      str4   pr_ed8
      str4   pr_ed9
      int    prccsed1
      int    prccsed2
      int    prccsed3
      int    prccsed4
      int    prccsed5
      int    prccsed6
      int    prccsed7
      int    prccsed8
      int    prccsed9
using  "NEDS_2008_ED.csv";

/*  Assign labels to the data elements */
label var discwt                   "Weight to ED Visits in AHA universe" ;
label var hcupfile                 "Source of HCUP Record (SID or SEDD)" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var cpt1                     "CPT/HCPCS procedure code 1" ;
label var cpt2                     "CPT/HCPCS procedure code 2" ;
label var cpt3                     "CPT/HCPCS procedure code 3" ;
label var cpt4                     "CPT/HCPCS procedure code 4" ;
label var cpt5                     "CPT/HCPCS procedure code 5" ;
label var cpt6                     "CPT/HCPCS procedure code 6" ;
label var cpt7                     "CPT/HCPCS procedure code 7" ;
label var cpt8                     "CPT/HCPCS procedure code 8" ;
label var cpt9                     "CPT/HCPCS procedure code 9" ;
label var cpt10                    "CPT/HCPCS procedure code 10" ;
label var cpt11                    "CPT/HCPCS procedure code 11" ;
label var cpt12                    "CPT/HCPCS procedure code 12" ;
label var cpt13                    "CPT/HCPCS procedure code 13" ;
label var cpt14                    "CPT/HCPCS procedure code 14" ;
label var cpt15                    "CPT/HCPCS procedure code 15" ;
label var cptccs1                  "CCS: CPT 1" ;
label var cptccs2                  "CCS: CPT 2" ;
label var cptccs3                  "CCS: CPT 3" ;
label var cptccs4                  "CCS: CPT 4" ;
label var cptccs5                  "CCS: CPT 5" ;
label var cptccs6                  "CCS: CPT 6" ;
label var cptccs7                  "CCS: CPT 7" ;
label var cptccs8                  "CCS: CPT 8" ;
label var cptccs9                  "CCS: CPT 9" ;
label var cptccs10                 "CCS: CPT 10" ;
label var cptccs11                 "CCS: CPT 11" ;
label var cptccs12                 "CCS: CPT 12" ;
label var cptccs13                 "CCS: CPT 13" ;
label var cptccs14                 "CCS: CPT 14" ;
label var cptccs15                 "CCS: CPT 15" ;
label var ncpt                     "Number of CPT/HCPCS procedures on this record" ;
label var npr_ed                   "Number of procedures from ED" ;
label var pcls_ed1                 "Principal procedure class for ED procedure" ;
label var pcls_ed2                 "Procedure class 2 for ED procedure" ;
label var pcls_ed3                 "Procedure class 3 for ED procedure" ;
label var pcls_ed4                 "Procedure class 4 for ED procedure" ;
label var pcls_ed5                 "Procedure class 5 for ED procedure" ;
label var pcls_ed6                 "Procedure class 6 for ED procedure" ;
label var pcls_ed7                 "Procedure class 7 for ED procedure" ;
label var pcls_ed8                 "Procedure class 8 for ED procedure" ;
label var pcls_ed9                 "Procedure class 9 for ED procedure" ;
label var pr_ed1                   "Principal procedure from ED" ;
label var pr_ed2                   "Procedure 2 from ED" ;
label var pr_ed3                   "Procedure 3 from ED" ;
label var pr_ed4                   "Procedure 4 from ED" ;
label var pr_ed5                   "Procedure 5 from ED" ;
label var pr_ed6                   "Procedure 6 from ED" ;
label var pr_ed7                   "Procedure 7 from ED" ;
label var pr_ed8                   "Procedure 8 from ED" ;
label var pr_ed9                   "Procedure 9 from ED" ;
label var prccsed1                 "CCS: principal procedure from ED" ;
label var prccsed2                 "CCS: procedure 2 from ED" ;
label var prccsed3                 "CCS: procedure 3 from ED" ;
label var prccsed4                 "CCS: procedure 4 from ED" ;
label var prccsed5                 "CCS: procedure 5 from ED" ;
label var prccsed6                 "CCS: procedure 6 from ED" ;
label var prccsed7                 "CCS: procedure 7 from ED" ;
label var prccsed8                 "CCS: procedure 8 from ED" ;
label var prccsed9                 "CCS: procedure 9 from ED" ;

/* Convert special values to missing values */
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode cptccs1                   (-999 -888 -666=.) ;
recode cptccs2                   (-999 -888 -666=.) ;
recode cptccs3                   (-999 -888 -666=.) ;
recode cptccs4                   (-999 -888 -666=.) ;
recode cptccs5                   (-999 -888 -666=.) ;
recode cptccs6                   (-999 -888 -666=.) ;
recode cptccs7                   (-999 -888 -666=.) ;
recode cptccs8                   (-999 -888 -666=.) ;
recode cptccs9                   (-999 -888 -666=.) ;
recode cptccs10                  (-999 -888 -666=.) ;
recode cptccs11                  (-999 -888 -666=.) ;
recode cptccs12                  (-999 -888 -666=.) ;
recode cptccs13                  (-999 -888 -666=.) ;
recode cptccs14                  (-999 -888 -666=.) ;
recode cptccs15                  (-999 -888 -666=.) ;
recode ncpt                      (-999 -888 -666=.) ;
recode npr_ed                    (-99 -88 -66=.) ;
recode pcls_ed1                  (-99 -88 -66=.) ;
recode pcls_ed2                  (-99 -88 -66=.) ;
recode pcls_ed3                  (-99 -88 -66=.) ;
recode pcls_ed4                  (-99 -88 -66=.) ;
recode pcls_ed5                  (-99 -88 -66=.) ;
recode pcls_ed6                  (-99 -88 -66=.) ;
recode pcls_ed7                  (-99 -88 -66=.) ;
recode pcls_ed8                  (-99 -88 -66=.) ;
recode pcls_ed9                  (-99 -88 -66=.) ;
recode prccsed1                  (-99 -88 -66=.) ;
recode prccsed2                  (-99 -88 -66=.) ;
recode prccsed3                  (-99 -88 -66=.) ;
recode prccsed4                  (-99 -88 -66=.) ;
recode prccsed5                  (-99 -88 -66=.) ;
recode prccsed6                  (-99 -88 -66=.) ;
recode prccsed7                  (-99 -88 -66=.) ;
recode prccsed8                  (-99 -88 -66=.) ;
recode prccsed9                  (-99 -88 -66=.) ;

describe;

save "NEDS_2008_ED.dta", replace;
#delimit cr
