/*****************************************************************************
* Stataload_NIS_2005_Core.Do
* This program will load the 2005 NIS ASCII Core File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    AGE                         1-  3   ///
      int    AGEDAY                      4-  6   ///
      byte   AMONTH                      7-  8   ///
      byte   ASOURCE                     9- 10   ///
      str    ASOURCEUB92                11       ///
      str    ASOURCE_X                  12- 19   ///
      byte   ATYPE                      20- 21   ///
      byte   AWEEKEND                   22- 23   ///
      byte   DIED                       24- 25   ///
      double DISCWT                     26- 36   ///
      byte   DISPUB92                   37- 38   ///
      byte   DISPUNIFORM                39- 40   ///
      byte   DQTR                       41- 42   ///
      int    DRG                        43- 45   ///
      int    DRG18                      46- 48   ///
      byte   DRGVER                     49- 50   ///
      str    DSHOSPID                   51- 63   ///
      str    DX1                        64- 68   ///
      str    DX2                        69- 73   ///
      str    DX3                        74- 78   ///
      str    DX4                        79- 83   ///
      str    DX5                        84- 88   ///
      str    DX6                        89- 93   ///
      str    DX7                        94- 98   ///
      str    DX8                        99-103   ///
      str    DX9                       104-108   ///
      str    DX10                      109-113   ///
      str    DX11                      114-118   ///
      str    DX12                      119-123   ///
      str    DX13                      124-128   ///
      str    DX14                      129-133   ///
      str    DX15                      134-138   ///
      int    DXCCS1                    139-142   ///
      int    DXCCS2                    143-146   ///
      int    DXCCS3                    147-150   ///
      int    DXCCS4                    151-154   ///
      int    DXCCS5                    155-158   ///
      int    DXCCS6                    159-162   ///
      int    DXCCS7                    163-166   ///
      int    DXCCS8                    167-170   ///
      int    DXCCS9                    171-174   ///
      int    DXCCS10                   175-178   ///
      int    DXCCS11                   179-182   ///
      int    DXCCS12                   183-186   ///
      int    DXCCS13                   187-190   ///
      int    DXCCS14                   191-194   ///
      int    DXCCS15                   195-198   ///
      str    ECODE1                    199-203   ///
      str    ECODE2                    204-208   ///
      str    ECODE3                    209-213   ///
      str    ECODE4                    214-218   ///
      byte   ELECTIVE                  219-220   ///
      int    E_CCS1                    221-224   ///
      int    E_CCS2                    225-228   ///
      int    E_CCS3                    229-232   ///
      int    E_CCS4                    233-236   ///
      byte   FEMALE                    237-238   ///
      long   HOSPID                    239-243   ///
      str    HOSPST                    244-245   ///
      double KEY                       246-259   ///
      long   LOS                       260-264   ///
      long   LOS_X                     265-270   ///
      byte   MDC                       271-272   ///
      byte   MDC18                     273-274   ///
      long   MDNUM1_R                  275-279   ///
      long   MDNUM2_R                  280-284   ///
      byte   NDX                       285-286   ///
      int    NECODE                    287-289   ///
      byte   NEOMAT                    290-291   ///
      int    NIS_STRATUM               292-295   ///
      byte   NPR                       296-297   ///
      byte   PAY1                      298-299   ///
      str    PAY1_X                    300-309   ///
      byte   PAY2                      310-311   ///
      str    PAY2_X                    312-321   ///
      byte   PL_UR_CAT4                322-323   ///
      str    PR1                       324-327   ///
      str    PR2                       328-331   ///
      str    PR3                       332-335   ///
      str    PR4                       336-339   ///
      str    PR5                       340-343   ///
      str    PR6                       344-347   ///
      str    PR7                       348-351   ///
      str    PR8                       352-355   ///
      str    PR9                       356-359   ///
      str    PR10                      360-363   ///
      str    PR11                      364-367   ///
      str    PR12                      368-371   ///
      str    PR13                      372-375   ///
      str    PR14                      376-379   ///
      str    PR15                      380-383   ///
      int    PRCCS1                    384-386   ///
      int    PRCCS2                    387-389   ///
      int    PRCCS3                    390-392   ///
      int    PRCCS4                    393-395   ///
      int    PRCCS5                    396-398   ///
      int    PRCCS6                    399-401   ///
      int    PRCCS7                    402-404   ///
      int    PRCCS8                    405-407   ///
      int    PRCCS9                    408-410   ///
      int    PRCCS10                   411-413   ///
      int    PRCCS11                   414-416   ///
      int    PRCCS12                   417-419   ///
      int    PRCCS13                   420-422   ///
      int    PRCCS14                   423-425   ///
      int    PRCCS15                   426-428   ///
      int    PRDAY1                    429-431   ///
      int    PRDAY2                    432-434   ///
      int    PRDAY3                    435-437   ///
      int    PRDAY4                    438-440   ///
      int    PRDAY5                    441-443   ///
      int    PRDAY6                    444-446   ///
      int    PRDAY7                    447-449   ///
      int    PRDAY8                    450-452   ///
      int    PRDAY9                    453-455   ///
      int    PRDAY10                   456-458   ///
      int    PRDAY11                   459-461   ///
      int    PRDAY12                   462-464   ///
      int    PRDAY13                   465-467   ///
      int    PRDAY14                   468-470   ///
      int    PRDAY15                   471-473   ///
      byte   RACE                      474-475   ///
      double TOTCHG                    476-485   ///
      double TOTCHG_X                  486-500   ///
      int    YEAR                      501-504   ///
      byte   ZIPInc_Qrtl               505-506   ///
      using  "NIS_2005_Core.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AMONTH                   "Admission month"
label var ASOURCE                  "Admission source (uniform)"
label var ASOURCEUB92              "Admission source (UB-92 standard coding)"
label var ASOURCE_X                "Admission source (as received from source)"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var DIED                     "Died during hospitalization"
label var DISCWT                   "Weight to discharges in AHA universe"
label var DISPUB92                 "Disposition of patient (UB-92 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DQTR                     "Discharge quarter"
label var DRG                      "DRG in effect on discharge date"
label var DRG18                    "DRG, version 18"
label var DRGVER                   "DRG grouper version used on discharge date"
label var DSHOSPID                 "Data source hospital identifier"
label var DX1                      "Principal diagnosis"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DXCCS1                   "CCS: principal diagnosis"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ELECTIVE                 "Elective versus non-elective admission"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var FEMALE                   "Indicator of sex"
label var HOSPID                   "HCUP hospital identification number"
label var HOSPST                   "Hospital state postal code"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDC                      "MDC in effect on discharge date"
label var MDC18                    "MDC, version 18"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NIS_STRATUM              "Stratum used to sample hospital"
label var NPR                      "Number of procedures on this record"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PAY2                     "Secondary expected payer (uniform)"
label var PAY2_X                   "Secondary expected payer (as received from source)"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var PR1                      "Principal procedure"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PRCCS1                   "CCS: principal procedure"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var RACE                     "Race (uniform)"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var YEAR                     "Calendar year"
label var ZIPInc_Qrtl              "Median household income quartile for patient's ZIP Code"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ASOURCE                   (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISCWT                    (-99.9999999 -88.8888888 -66.6666666=.)
recode DISPUB92                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DRG                       (-99 -88 -66=.)
recode DRG18                     (-99 -88 -66=.)
recode DRGVER                    (-9 -8 -6 -5=.)
recode DXCCS1                    (-999 -888 -666=.)
recode DXCCS2                    (-999 -888 -666=.)
recode DXCCS3                    (-999 -888 -666=.)
recode DXCCS4                    (-999 -888 -666=.)
recode DXCCS5                    (-999 -888 -666=.)
recode DXCCS6                    (-999 -888 -666=.)
recode DXCCS7                    (-999 -888 -666=.)
recode DXCCS8                    (-999 -888 -666=.)
recode DXCCS9                    (-999 -888 -666=.)
recode DXCCS10                   (-999 -888 -666=.)
recode DXCCS11                   (-999 -888 -666=.)
recode DXCCS12                   (-999 -888 -666=.)
recode DXCCS13                   (-999 -888 -666=.)
recode DXCCS14                   (-999 -888 -666=.)
recode DXCCS15                   (-999 -888 -666=.)
recode ELECTIVE                  (-9 -8 -6 -5=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDC                       (-9 -8 -6 -5=.)
recode MDC18                     (-9 -8 -6 -5=.)
recode MDNUM1_R                  (-9999 -8888 -6666=.)
recode MDNUM2_R                  (-9999 -8888 -6666=.)
recode NDX                       (-9 -8 -6 -5=.)
recode NECODE                    (-99 -88 -66=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NIS_STRATUM               (-999 -888 -666=.)
recode NPR                       (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PAY2                      (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRDAY1                    (-99 -88 -66=.)
recode PRDAY2                    (-99 -88 -66=.)
recode PRDAY3                    (-99 -88 -66=.)
recode PRDAY4                    (-99 -88 -66=.)
recode PRDAY5                    (-99 -88 -66=.)
recode PRDAY6                    (-99 -88 -66=.)
recode PRDAY7                    (-99 -88 -66=.)
recode PRDAY8                    (-99 -88 -66=.)
recode PRDAY9                    (-99 -88 -66=.)
recode PRDAY10                   (-99 -88 -66=.)
recode PRDAY11                   (-99 -88 -66=.)
recode PRDAY12                   (-99 -88 -66=.)
recode PRDAY13                   (-99 -88 -66=.)
recode PRDAY14                   (-99 -88 -66=.)
recode PRDAY15                   (-99 -88 -66=.)
recode RACE                      (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPInc_Qrtl               (-9 -8 -6 -5=.)

save "NIS_2005_Core.dta", replace
