/*****************************************************************************
* Stataload_NIS_2015Q1Q3_Severity.Do
* This program will load the NIS_2015Q1Q3_Severity ASCII File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    APRDRG                       1-   4   ///
      byte   APRDRG_Risk_Mortality        5-   6   ///
      byte   APRDRG_Severity              7-   8   ///
      byte   CM_AIDS                      9-  10   ///
      byte   CM_ALCOHOL                  11-  12   ///
      byte   CM_ANEMDEF                  13-  14   ///
      byte   CM_ARTH                     15-  16   ///
      byte   CM_BLDLOSS                  17-  18   ///
      byte   CM_CHF                      19-  20   ///
      byte   CM_CHRNLUNG                 21-  22   ///
      byte   CM_COAG                     23-  24   ///
      byte   CM_DEPRESS                  25-  26   ///
      byte   CM_DM                       27-  28   ///
      byte   CM_DMCX                     29-  30   ///
      byte   CM_DRUG                     31-  32   ///
      byte   CM_HTN_C                    33-  34   ///
      byte   CM_HYPOTHY                  35-  36   ///
      byte   CM_LIVER                    37-  38   ///
      byte   CM_LYMPH                    39-  40   ///
      byte   CM_LYTES                    41-  42   ///
      byte   CM_METS                     43-  44   ///
      byte   CM_NEURO                    45-  46   ///
      byte   CM_OBESE                    47-  48   ///
      byte   CM_PARA                     49-  50   ///
      byte   CM_PERIVASC                 51-  52   ///
      byte   CM_PSYCH                    53-  54   ///
      byte   CM_PULMCIRC                 55-  56   ///
      byte   CM_RENLFAIL                 57-  58   ///
      byte   CM_TUMOR                    59-  60   ///
      byte   CM_ULCER                    61-  62   ///
      byte   CM_VALVE                    63-  64   ///
      byte   CM_WGHTLOSS                 65-  66   ///
      long   HOSP_NIS                    67-  71   ///
      double KEY_NIS                     72-  81   ///
      using  "NIS_2015Q1Q3_Severity.ASC"

***  Assign labels to the data elements ***
label var APRDRG                   "All Patient Refined DRG"
label var APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
label var APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass"
label var CM_AIDS                  "AHRQ comorbidity measure: Acquired immune deficiency syndrome"
label var CM_ALCOHOL               "AHRQ comorbidity measure: Alcohol abuse"
label var CM_ANEMDEF               "AHRQ comorbidity measure: Deficiency anemias"
label var CM_ARTH                  "AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases"
label var CM_BLDLOSS               "AHRQ comorbidity measure: Chronic blood loss anemia"
label var CM_CHF                   "AHRQ comorbidity measure: Congestive heart failure"
label var CM_CHRNLUNG              "AHRQ comorbidity measure: Chronic pulmonary disease"
label var CM_COAG                  "AHRQ comorbidity measure: Coagulopathy"
label var CM_DEPRESS               "AHRQ comorbidity measure: Depression"
label var CM_DM                    "AHRQ comorbidity measure: Diabetes, uncomplicated"
label var CM_DMCX                  "AHRQ comorbidity measure: Diabetes with chronic complications"
label var CM_DRUG                  "AHRQ comorbidity measure: Drug abuse"
label var CM_HTN_C                 "AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)"
label var CM_HYPOTHY               "AHRQ comorbidity measure: Hypothyroidism"
label var CM_LIVER                 "AHRQ comorbidity measure: Liver disease"
label var CM_LYMPH                 "AHRQ comorbidity measure: Lymphoma"
label var CM_LYTES                 "AHRQ comorbidity measure: Fluid and electrolyte disorders"
label var CM_METS                  "AHRQ comorbidity measure: Metastatic cancer"
label var CM_NEURO                 "AHRQ comorbidity measure: Other neurological disorders"
label var CM_OBESE                 "AHRQ comorbidity measure: Obesity"
label var CM_PARA                  "AHRQ comorbidity measure: Paralysis"
label var CM_PERIVASC              "AHRQ comorbidity measure: Peripheral vascular disorders"
label var CM_PSYCH                 "AHRQ comorbidity measure: Psychoses"
label var CM_PULMCIRC              "AHRQ comorbidity measure: Pulmonary circulation disorders"
label var CM_RENLFAIL              "AHRQ comorbidity measure: Renal failure"
label var CM_TUMOR                 "AHRQ comorbidity measure: Solid tumor without metastasis"
label var CM_ULCER                 "AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding"
label var CM_VALVE                 "AHRQ comorbidity measure: Valvular disease"
label var CM_WGHTLOSS              "AHRQ comorbidity measure: Weight loss"
label var HOSP_NIS                 "NIS hospital number"
label var KEY_NIS                  "NIS record number"

*** Convert special values to missing values ***
recode APRDRG                    (-999 -888 -666=.)
recode APRDRG_Risk_Mortality     (-9 -8 -6 -5=.)
recode APRDRG_Severity           (-9 -8 -6 -5=.)
recode CM_AIDS                   (-9 -8 -6 -5=.)
recode CM_ALCOHOL                (-9 -8 -6 -5=.)
recode CM_ANEMDEF                (-9 -8 -6 -5=.)
recode CM_ARTH                   (-9 -8 -6 -5=.)
recode CM_BLDLOSS                (-9 -8 -6 -5=.)
recode CM_CHF                    (-9 -8 -6 -5=.)
recode CM_CHRNLUNG               (-9 -8 -6 -5=.)
recode CM_COAG                   (-9 -8 -6 -5=.)
recode CM_DEPRESS                (-9 -8 -6 -5=.)
recode CM_DM                     (-9 -8 -6 -5=.)
recode CM_DMCX                   (-9 -8 -6 -5=.)
recode CM_DRUG                   (-9 -8 -6 -5=.)
recode CM_HTN_C                  (-9 -8 -6 -5=.)
recode CM_HYPOTHY                (-9 -8 -6 -5=.)
recode CM_LIVER                  (-9 -8 -6 -5=.)
recode CM_LYMPH                  (-9 -8 -6 -5=.)
recode CM_LYTES                  (-9 -8 -6 -5=.)
recode CM_METS                   (-9 -8 -6 -5=.)
recode CM_NEURO                  (-9 -8 -6 -5=.)
recode CM_OBESE                  (-9 -8 -6 -5=.)
recode CM_PARA                   (-9 -8 -6 -5=.)
recode CM_PERIVASC               (-9 -8 -6 -5=.)
recode CM_PSYCH                  (-9 -8 -6 -5=.)
recode CM_PULMCIRC               (-9 -8 -6 -5=.)
recode CM_RENLFAIL               (-9 -8 -6 -5=.)
recode CM_TUMOR                  (-9 -8 -6 -5=.)
recode CM_ULCER                  (-9 -8 -6 -5=.)
recode CM_VALVE                  (-9 -8 -6 -5=.)
recode CM_WGHTLOSS               (-9 -8 -6 -5=.)
recode HOSP_NIS                  (-9999 -8888 -6666=.)
recode KEY_NIS                   (-999999999 -888888888 -666666666=.)

save "NIS_2015Q1Q3_Severity.dta", replace
