/*****************************************************************************
* Stataload_NIS_2002_Supplemental.Do
* This program will load the 2002 NIS ASCII Supplemental File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix double TRENDWT                     1- 11   ///
      byte   NDX                        12- 13   ///
      int    DXCCS1                     14- 16   ///
      int    DXCCS2                     17- 19   ///
      int    DXCCS3                     20- 22   ///
      int    DXCCS4                     23- 25   ///
      int    DXCCS5                     26- 28   ///
      int    DXCCS6                     29- 31   ///
      int    DXCCS7                     32- 34   ///
      int    DXCCS8                     35- 37   ///
      int    DXCCS9                     38- 40   ///
      int    DXCCS10                    41- 43   ///
      int    DXCCS11                    44- 46   ///
      int    DXCCS12                    47- 49   ///
      int    DXCCS13                    50- 52   ///
      int    DXCCS14                    53- 55   ///
      int    DXCCS15                    56- 58   ///
      int    E_CCS1                     59- 62   ///
      int    E_CCS2                     63- 66   ///
      int    E_CCS3                     67- 70   ///
      int    E_CCS4                     71- 74   ///
      int    NECODE                     75- 77   ///
      byte   ZipInc_Qrtl                78- 79   ///
      double KEY                        80- 94   ///
      str    DX1                        95- 99   ///
      str    DX2                       100-104   ///
      str    DX3                       105-109   ///
      str    DX4                       110-114   ///
      str    DX5                       115-119   ///
      str    DX6                       120-124   ///
      str    DX7                       125-129   ///
      str    DX8                       130-134   ///
      str    DX9                       135-139   ///
      str    DX10                      140-144   ///
      str    DX11                      145-149   ///
      str    DX12                      150-154   ///
      str    DX13                      155-159   ///
      str    DX14                      160-164   ///
      str    DX15                      165-169   ///
      str    ECODE1                    170-174   ///
      str    ECODE2                    175-179   ///
      str    ECODE3                    180-184   ///
      str    ECODE4                    185-189   ///
      using  "NIS_2002_Supplemental.ASC"

***  Assign labels to the data elements ***
label var TRENDWT                  "Trend weight to discharges in the universe"
label var NDX                      "I:Number of diagnoses on this discharge"
label var DXCCS1                   "CCS: principal diagnosis"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var NECODE                   "Number of E codes on this record"
label var ZipInc_Qrtl              "Median Household Income Quartiles for Patient's ZIP Code"
label var KEY                      "HCUP record identifier"
label var DX1                      "Principal diagnosis"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"

*** Convert special values to missing values ***
recode TRENDWT                   (-99.9999999 -88.8888888 -66.6666666=.)
recode NDX                       (-9 -8 -6 -5=.)
recode DXCCS1                    (-99 -88 -66=.)
recode DXCCS2                    (-99 -88 -66=.)
recode DXCCS3                    (-99 -88 -66=.)
recode DXCCS4                    (-99 -88 -66=.)
recode DXCCS5                    (-99 -88 -66=.)
recode DXCCS6                    (-99 -88 -66=.)
recode DXCCS7                    (-99 -88 -66=.)
recode DXCCS8                    (-99 -88 -66=.)
recode DXCCS9                    (-99 -88 -66=.)
recode DXCCS10                   (-99 -88 -66=.)
recode DXCCS11                   (-99 -88 -66=.)
recode DXCCS12                   (-99 -88 -66=.)
recode DXCCS13                   (-99 -88 -66=.)
recode DXCCS14                   (-99 -88 -66=.)
recode DXCCS15                   (-99 -88 -66=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode NECODE                    (-99 -88 -66=.)
recode ZipInc_Qrtl               (-9 -8 -6 -5=.)

save "NIS_2002_Supplemental.dta", replace
