/*****************************************************************************
* SPSSload_NIS_2000_HOSPITAL_TrendWt.SPS
* This program will load the 2000 NIS ASCII HOSPITAL_TrendWt File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2000_HOSPITAL_TrendWt.ASC' FIXED / 
    YEAR                       1-  4
    HOSPID                     5-  9
    TRENDWT                   10- 20
    TRENDWTcharge             21- 31.

***  Specify write formats  ***.
FORMATS
    YEAR                     (F4.0) /
    HOSPID                   (F5.0) /
    TRENDWT                  (F11.7) /
    TRENDWTcharge            (F11.7) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    YEAR                     "Calendar year"
    HOSPID                   "HCUP hospital identification number"
    TRENDWT                  "Weight to discharges in the universe"
    TRENDWTcharge            "Weight to discharges in the universe for total charge estimates" .

*** Convert special values to system missing values ***.
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE TRENDWT                  (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE TRENDWTcharge            (-99.9999999 -88.8888888 -66.6666666=SYSMIS).

SAVE OUTFILE = 'NIS_2000_HOSPITAL_TrendWt.SAV' / COMPRESSED.
