/*****************************************************************************
* Stataload_NIS_1996_HOSPITAL_TrendWt.Do
* This program will load the 1996 NIS ASCII HOSPITAL_TrendWt File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix int    YEAR                        1-  4   ///
      long   HOSPID                      5-  9   ///
      double TRENDWT                    10- 20   ///
      using  "NIS_1996_HOSPITAL_TrendWt.ASC"

***  Assign labels to the data elements ***
label var YEAR                     "Calendar year"
label var HOSPID                   "HCUP hospital identification number"
label var TRENDWT                  "Weight to discharges in the universe"

*** Convert special values to missing values ***
recode YEAR                      (-999 -888 -666=.)
recode TRENDWT                   (-99.9999999 -88.8888888 -66.6666666=.)

save "NIS_1996_HOSPITAL_TrendWt.dta", replace
