/*****************************************************************************
 * Stataload_NRD_2010_Hospital_V2.Do
 * Created on 09/28/2017.
 * This program will load the 2010 NRD CSV Hospital_V2 File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NRD_2010_Hospital_V2.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      byte   hosp_bedsize
      byte   h_contrl
      long   hosp_nrd
      byte   hosp_urcat4
      byte   hosp_ur_teach
      long   nrd_stratum
      long   n_disc_u
      int    n_hosp_u
      long   s_disc_u
      long   s_hosp_u
      long   total_disc
      int    year
using NRD_2010_Hospital_V2.csv;

/*  Assign labels to the data elements */
label var hosp_bedsize             "Bed size of hospital" ;
label var h_contrl                 "Control/ownership of hospital" ;
label var hosp_nrd                 "NRD hospital identifier" ;
label var hosp_urcat4              "Hospital urban-rural designation" ;
label var hosp_ur_teach            "Teaching status of urban hospitals" ;
label var nrd_stratum              "NRD stratum used for weighting" ;
label var n_disc_u                 "Number of universe discharges in NRD_STRATUM" ;
label var n_hosp_u                 "Number of universe hospitals in NRD_STRATUM" ;
label var s_disc_u                 "Number of sample discharges in NRD_STRATUM" ;
label var s_hosp_u                 "Number of universe hospitals in NRD_STRATUM" ;
label var total_disc               "Total hospital discharges" ;
label var year                     "Calendar year" ;

/* Convert special values to missing values */
recode hosp_bedsize              (-9 -8 -6 -5=.) ;
recode h_contrl                  (-9 -8 -6 -5=.) ;
recode hosp_nrd                  (-9999 -8888 -6666=.) ;
recode hosp_urcat4               (-9 -8 -6 -5=.) ;
recode hosp_ur_teach             (-9 -8 -6 -5=.) ;
recode nrd_stratum               (-9999 -8888 -6666=.) ;
recode n_disc_u                  (-9999999 -8888888 -6666666=.) ;
recode n_hosp_u                  (-999 -888 -666=.) ;
recode s_disc_u                  (-9999999 -8888888 -6666666=.) ;
recode s_hosp_u                  (-99999 -88888 -66666=.) ;
recode total_disc                (-99999 -88888 -66666=.) ;
recode year                      (-999 -888 -666=.) ;

describe;

save "NRD_2010_Hospital_V2.dta", replace;
#delimit cr
