/*****************************************************************************
 * Stataload_NRD_2015Q1Q3_DX_PR_GRPS.Do
 * Created on 10/31/2017.
 * This program will load the NRD_2015Q1Q3_DX_PR_GRPS CSV File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NRD_2015Q1Q3_DX_PR_GRPS.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    bodysystem1
      int    bodysystem2
      int    bodysystem3
      int    bodysystem4
      int    bodysystem5
      int    bodysystem6
      int    bodysystem7
      int    bodysystem8
      int    bodysystem9
      int    bodysystem10
      int    bodysystem11
      int    bodysystem12
      int    bodysystem13
      int    bodysystem14
      int    bodysystem15
      int    bodysystem16
      int    bodysystem17
      int    bodysystem18
      int    bodysystem19
      int    bodysystem20
      int    bodysystem21
      int    bodysystem22
      int    bodysystem23
      int    bodysystem24
      int    bodysystem25
      int    bodysystem26
      int    bodysystem27
      int    bodysystem28
      int    bodysystem29
      int    bodysystem30
      int    chron1
      int    chron2
      int    chron3
      int    chron4
      int    chron5
      int    chron6
      int    chron7
      int    chron8
      int    chron9
      int    chron10
      int    chron11
      int    chron12
      int    chron13
      int    chron14
      int    chron15
      int    chron16
      int    chron17
      int    chron18
      int    chron19
      int    chron20
      int    chron21
      int    chron22
      int    chron23
      int    chron24
      int    chron25
      int    chron26
      int    chron27
      int    chron28
      int    chron29
      int    chron30
      int    drg
      byte   drgver
      int    drg_nopoa
      str7   dx1
      str7   dx2
      str7   dx3
      str7   dx4
      str7   dx5
      str7   dx6
      str7   dx7
      str7   dx8
      str7   dx9
      str7   dx10
      str7   dx11
      str7   dx12
      str7   dx13
      str7   dx14
      str7   dx15
      str7   dx16
      str7   dx17
      str7   dx18
      str7   dx19
      str7   dx20
      str7   dx21
      str7   dx22
      str7   dx23
      str7   dx24
      str7   dx25
      str7   dx26
      str7   dx27
      str7   dx28
      str7   dx29
      str7   dx30
      int    dxccs1
      int    dxccs2
      int    dxccs3
      int    dxccs4
      int    dxccs5
      int    dxccs6
      int    dxccs7
      int    dxccs8
      int    dxccs9
      int    dxccs10
      int    dxccs11
      int    dxccs12
      int    dxccs13
      int    dxccs14
      int    dxccs15
      int    dxccs16
      int    dxccs17
      int    dxccs18
      int    dxccs19
      int    dxccs20
      int    dxccs21
      int    dxccs22
      int    dxccs23
      int    dxccs24
      int    dxccs25
      int    dxccs26
      int    dxccs27
      int    dxccs28
      int    dxccs29
      int    dxccs30
      str11  dxmccs1
      byte   dxver
      str7   ecode1
      str7   ecode2
      str7   ecode3
      str7   ecode4
      int    e_ccs1
      int    e_ccs2
      int    e_ccs3
      int    e_ccs4
      str11  e_mccs1
      long   hosp_nrd
      double key_nrd
      byte   mdc
      byte   mdc_nopoa
      byte   nchronic
      int    ndx
      int    necode
      int    npr
      byte   orproc
      int    pclass1
      int    pclass2
      int    pclass3
      int    pclass4
      int    pclass5
      int    pclass6
      int    pclass7
      int    pclass8
      int    pclass9
      int    pclass10
      int    pclass11
      int    pclass12
      int    pclass13
      int    pclass14
      int    pclass15
      str7   pr1
      str7   pr2
      str7   pr3
      str7   pr4
      str7   pr5
      str7   pr6
      str7   pr7
      str7   pr8
      str7   pr9
      str7   pr10
      str7   pr11
      str7   pr12
      str7   pr13
      str7   pr14
      str7   pr15
      int    prccs1
      int    prccs2
      int    prccs3
      int    prccs4
      int    prccs5
      int    prccs6
      int    prccs7
      int    prccs8
      int    prccs9
      int    prccs10
      int    prccs11
      int    prccs12
      int    prccs13
      int    prccs14
      int    prccs15
      int    prday1
      int    prday2
      int    prday3
      int    prday4
      int    prday5
      int    prday6
      int    prday7
      int    prday8
      int    prday9
      int    prday10
      int    prday11
      int    prday12
      int    prday13
      int    prday14
      int    prday15
      str8   prmccs1
      byte   prver
      byte   serviceline
using NRD_2015Q1Q3_DX_PR_GRPS.csv;

/*  Assign labels to the data elements */
label var bodysystem1              "Body system 1" ;
label var bodysystem2              "Body system 2" ;
label var bodysystem3              "Body system 3" ;
label var bodysystem4              "Body system 4" ;
label var bodysystem5              "Body system 5" ;
label var bodysystem6              "Body system 6" ;
label var bodysystem7              "Body system 7" ;
label var bodysystem8              "Body system 8" ;
label var bodysystem9              "Body system 9" ;
label var bodysystem10             "Body system 10" ;
label var bodysystem11             "Body system 11" ;
label var bodysystem12             "Body system 12" ;
label var bodysystem13             "Body system 13" ;
label var bodysystem14             "Body system 14" ;
label var bodysystem15             "Body system 15" ;
label var bodysystem16             "Body system 16" ;
label var bodysystem17             "Body system 17" ;
label var bodysystem18             "Body system 18" ;
label var bodysystem19             "Body system 19" ;
label var bodysystem20             "Body system 20" ;
label var bodysystem21             "Body system 21" ;
label var bodysystem22             "Body system 22" ;
label var bodysystem23             "Body system 23" ;
label var bodysystem24             "Body system 24" ;
label var bodysystem25             "Body system 25" ;
label var bodysystem26             "Body system 26" ;
label var bodysystem27             "Body system 27" ;
label var bodysystem28             "Body system 28" ;
label var bodysystem29             "Body system 29" ;
label var bodysystem30             "Body system 30" ;
label var chron1                   "Chronic condition indicator 1" ;
label var chron2                   "Chronic condition indicator 2" ;
label var chron3                   "Chronic condition indicator 3" ;
label var chron4                   "Chronic condition indicator 4" ;
label var chron5                   "Chronic condition indicator 5" ;
label var chron6                   "Chronic condition indicator 6" ;
label var chron7                   "Chronic condition indicator 7" ;
label var chron8                   "Chronic condition indicator 8" ;
label var chron9                   "Chronic condition indicator 9" ;
label var chron10                  "Chronic condition indicator 10" ;
label var chron11                  "Chronic condition indicator 11" ;
label var chron12                  "Chronic condition indicator 12" ;
label var chron13                  "Chronic condition indicator 13" ;
label var chron14                  "Chronic condition indicator 14" ;
label var chron15                  "Chronic condition indicator 15" ;
label var chron16                  "Chronic condition indicator 16" ;
label var chron17                  "Chronic condition indicator 17" ;
label var chron18                  "Chronic condition indicator 18" ;
label var chron19                  "Chronic condition indicator 19" ;
label var chron20                  "Chronic condition indicator 20" ;
label var chron21                  "Chronic condition indicator 21" ;
label var chron22                  "Chronic condition indicator 22" ;
label var chron23                  "Chronic condition indicator 23" ;
label var chron24                  "Chronic condition indicator 24" ;
label var chron25                  "Chronic condition indicator 25" ;
label var chron26                  "Chronic condition indicator 26" ;
label var chron27                  "Chronic condition indicator 27" ;
label var chron28                  "Chronic condition indicator 28" ;
label var chron29                  "Chronic condition indicator 29" ;
label var chron30                  "Chronic condition indicator 30" ;
label var drg                      "DRG in effect on discharge date" ;
label var drgver                   "DRG grouper version used on discharge date" ;
label var drg_nopoa                "DRG in use on discharge date, calculated without POA" ;
label var dx1                      "Diagnosis 1" ;
label var dx2                      "Diagnosis 2" ;
label var dx3                      "Diagnosis 3" ;
label var dx4                      "Diagnosis 4" ;
label var dx5                      "Diagnosis 5" ;
label var dx6                      "Diagnosis 6" ;
label var dx7                      "Diagnosis 7" ;
label var dx8                      "Diagnosis 8" ;
label var dx9                      "Diagnosis 9" ;
label var dx10                     "Diagnosis 10" ;
label var dx11                     "Diagnosis 11" ;
label var dx12                     "Diagnosis 12" ;
label var dx13                     "Diagnosis 13" ;
label var dx14                     "Diagnosis 14" ;
label var dx15                     "Diagnosis 15" ;
label var dx16                     "Diagnosis 16" ;
label var dx17                     "Diagnosis 17" ;
label var dx18                     "Diagnosis 18" ;
label var dx19                     "Diagnosis 19" ;
label var dx20                     "Diagnosis 20" ;
label var dx21                     "Diagnosis 21" ;
label var dx22                     "Diagnosis 22" ;
label var dx23                     "Diagnosis 23" ;
label var dx24                     "Diagnosis 24" ;
label var dx25                     "Diagnosis 25" ;
label var dx26                     "Diagnosis 26" ;
label var dx27                     "Diagnosis 27" ;
label var dx28                     "Diagnosis 28" ;
label var dx29                     "Diagnosis 29" ;
label var dx30                     "Diagnosis 30" ;
label var dxccs1                   "CCS: diagnosis 1" ;
label var dxccs2                   "CCS: diagnosis 2" ;
label var dxccs3                   "CCS: diagnosis 3" ;
label var dxccs4                   "CCS: diagnosis 4" ;
label var dxccs5                   "CCS: diagnosis 5" ;
label var dxccs6                   "CCS: diagnosis 6" ;
label var dxccs7                   "CCS: diagnosis 7" ;
label var dxccs8                   "CCS: diagnosis 8" ;
label var dxccs9                   "CCS: diagnosis 9" ;
label var dxccs10                  "CCS: diagnosis 10" ;
label var dxccs11                  "CCS: diagnosis 11" ;
label var dxccs12                  "CCS: diagnosis 12" ;
label var dxccs13                  "CCS: diagnosis 13" ;
label var dxccs14                  "CCS: diagnosis 14" ;
label var dxccs15                  "CCS: diagnosis 15" ;
label var dxccs16                  "CCS: diagnosis 16" ;
label var dxccs17                  "CCS: diagnosis 17" ;
label var dxccs18                  "CCS: diagnosis 18" ;
label var dxccs19                  "CCS: diagnosis 19" ;
label var dxccs20                  "CCS: diagnosis 20" ;
label var dxccs21                  "CCS: diagnosis 21" ;
label var dxccs22                  "CCS: diagnosis 22" ;
label var dxccs23                  "CCS: diagnosis 23" ;
label var dxccs24                  "CCS: diagnosis 24" ;
label var dxccs25                  "CCS: diagnosis 25" ;
label var dxccs26                  "CCS: diagnosis 26" ;
label var dxccs27                  "CCS: diagnosis 27" ;
label var dxccs28                  "CCS: diagnosis 28" ;
label var dxccs29                  "CCS: diagnosis 29" ;
label var dxccs30                  "CCS: diagnosis 30" ;
label var dxmccs1                  "Multi-Level CCS:  Diagnosis 1" ;
label var dxver                    "Diagnosis Version" ;
label var ecode1                   "E code 1" ;
label var ecode2                   "E code 2" ;
label var ecode3                   "E code 3" ;
label var ecode4                   "E code 4" ;
label var e_ccs1                   "CCS: E Code 1" ;
label var e_ccs2                   "CCS: E Code 2" ;
label var e_ccs3                   "CCS: E Code 3" ;
label var e_ccs4                   "CCS: E Code 4" ;
label var e_mccs1                  "Multi-Level CCS:  E Code 1" ;
label var hosp_nrd                 "NRD hospital identifier" ;
label var key_nrd                  "NRD record identifier" ;
label var mdc                      "MDC in effect on discharge date" ;
label var mdc_nopoa                "MDC in use on discharge date, calculated without POA" ;
label var nchronic                 "Number of chronic conditions" ;
label var ndx                      "Number of diagnoses on this record" ;
label var necode                   "Number of E codes on this record" ;
label var npr                      "Number of procedures on this record" ;
label var orproc                   "Major operating room procedure indicator" ;
label var pclass1                  "Procedure class 1" ;
label var pclass2                  "Procedure class 2" ;
label var pclass3                  "Procedure class 3" ;
label var pclass4                  "Procedure class 4" ;
label var pclass5                  "Procedure class 5" ;
label var pclass6                  "Procedure class 6" ;
label var pclass7                  "Procedure class 7" ;
label var pclass8                  "Procedure class 8" ;
label var pclass9                  "Procedure class 9" ;
label var pclass10                 "Procedure class 10" ;
label var pclass11                 "Procedure class 11" ;
label var pclass12                 "Procedure class 12" ;
label var pclass13                 "Procedure class 13" ;
label var pclass14                 "Procedure class 14" ;
label var pclass15                 "Procedure class 15" ;
label var pr1                      "Procedure 1" ;
label var pr2                      "Procedure 2" ;
label var pr3                      "Procedure 3" ;
label var pr4                      "Procedure 4" ;
label var pr5                      "Procedure 5" ;
label var pr6                      "Procedure 6" ;
label var pr7                      "Procedure 7" ;
label var pr8                      "Procedure 8" ;
label var pr9                      "Procedure 9" ;
label var pr10                     "Procedure 10" ;
label var pr11                     "Procedure 11" ;
label var pr12                     "Procedure 12" ;
label var pr13                     "Procedure 13" ;
label var pr14                     "Procedure 14" ;
label var pr15                     "Procedure 15" ;
label var prccs1                   "CCS: procedure 1" ;
label var prccs2                   "CCS: procedure 2" ;
label var prccs3                   "CCS: procedure 3" ;
label var prccs4                   "CCS: procedure 4" ;
label var prccs5                   "CCS: procedure 5" ;
label var prccs6                   "CCS: procedure 6" ;
label var prccs7                   "CCS: procedure 7" ;
label var prccs8                   "CCS: procedure 8" ;
label var prccs9                   "CCS: procedure 9" ;
label var prccs10                  "CCS: procedure 10" ;
label var prccs11                  "CCS: procedure 11" ;
label var prccs12                  "CCS: procedure 12" ;
label var prccs13                  "CCS: procedure 13" ;
label var prccs14                  "CCS: procedure 14" ;
label var prccs15                  "CCS: procedure 15" ;
label var prday1                   "Number of days from admission to PR1" ;
label var prday2                   "Number of days from admission to PR2" ;
label var prday3                   "Number of days from admission to PR3" ;
label var prday4                   "Number of days from admission to PR4" ;
label var prday5                   "Number of days from admission to PR5" ;
label var prday6                   "Number of days from admission to PR6" ;
label var prday7                   "Number of days from admission to PR7" ;
label var prday8                   "Number of days from admission to PR8" ;
label var prday9                   "Number of days from admission to PR9" ;
label var prday10                  "Number of days from admission to PR10" ;
label var prday11                  "Number of days from admission to PR11" ;
label var prday12                  "Number of days from admission to PR12" ;
label var prday13                  "Number of days from admission to PR13" ;
label var prday14                  "Number of days from admission to PR14" ;
label var prday15                  "Number of days from admission to PR15" ;
label var prmccs1                  "Multi-Level CCS:  Procedure 1" ;
label var prver                    "Procedure Version" ;
label var serviceline              "Hospital Service Line" ;

/* Convert special values to missing values */
recode bodysystem1               (-99 -88 -66=.) ;
recode bodysystem2               (-99 -88 -66=.) ;
recode bodysystem3               (-99 -88 -66=.) ;
recode bodysystem4               (-99 -88 -66=.) ;
recode bodysystem5               (-99 -88 -66=.) ;
recode bodysystem6               (-99 -88 -66=.) ;
recode bodysystem7               (-99 -88 -66=.) ;
recode bodysystem8               (-99 -88 -66=.) ;
recode bodysystem9               (-99 -88 -66=.) ;
recode bodysystem10              (-99 -88 -66=.) ;
recode bodysystem11              (-99 -88 -66=.) ;
recode bodysystem12              (-99 -88 -66=.) ;
recode bodysystem13              (-99 -88 -66=.) ;
recode bodysystem14              (-99 -88 -66=.) ;
recode bodysystem15              (-99 -88 -66=.) ;
recode bodysystem16              (-99 -88 -66=.) ;
recode bodysystem17              (-99 -88 -66=.) ;
recode bodysystem18              (-99 -88 -66=.) ;
recode bodysystem19              (-99 -88 -66=.) ;
recode bodysystem20              (-99 -88 -66=.) ;
recode bodysystem21              (-99 -88 -66=.) ;
recode bodysystem22              (-99 -88 -66=.) ;
recode bodysystem23              (-99 -88 -66=.) ;
recode bodysystem24              (-99 -88 -66=.) ;
recode bodysystem25              (-99 -88 -66=.) ;
recode bodysystem26              (-99 -88 -66=.) ;
recode bodysystem27              (-99 -88 -66=.) ;
recode bodysystem28              (-99 -88 -66=.) ;
recode bodysystem29              (-99 -88 -66=.) ;
recode bodysystem30              (-99 -88 -66=.) ;
recode chron1                    (-99 -88 -66=.) ;
recode chron2                    (-99 -88 -66=.) ;
recode chron3                    (-99 -88 -66=.) ;
recode chron4                    (-99 -88 -66=.) ;
recode chron5                    (-99 -88 -66=.) ;
recode chron6                    (-99 -88 -66=.) ;
recode chron7                    (-99 -88 -66=.) ;
recode chron8                    (-99 -88 -66=.) ;
recode chron9                    (-99 -88 -66=.) ;
recode chron10                   (-99 -88 -66=.) ;
recode chron11                   (-99 -88 -66=.) ;
recode chron12                   (-99 -88 -66=.) ;
recode chron13                   (-99 -88 -66=.) ;
recode chron14                   (-99 -88 -66=.) ;
recode chron15                   (-99 -88 -66=.) ;
recode chron16                   (-99 -88 -66=.) ;
recode chron17                   (-99 -88 -66=.) ;
recode chron18                   (-99 -88 -66=.) ;
recode chron19                   (-99 -88 -66=.) ;
recode chron20                   (-99 -88 -66=.) ;
recode chron21                   (-99 -88 -66=.) ;
recode chron22                   (-99 -88 -66=.) ;
recode chron23                   (-99 -88 -66=.) ;
recode chron24                   (-99 -88 -66=.) ;
recode chron25                   (-99 -88 -66=.) ;
recode chron26                   (-99 -88 -66=.) ;
recode chron27                   (-99 -88 -66=.) ;
recode chron28                   (-99 -88 -66=.) ;
recode chron29                   (-99 -88 -66=.) ;
recode chron30                   (-99 -88 -66=.) ;
recode drg                       (-99 -88 -66=.) ;
recode drgver                    (-9 -8 -6 -5=.) ;
recode drg_nopoa                 (-99 -88 -66=.) ;
recode dxccs1                    (-999 -888 -666=.) ;
recode dxccs2                    (-999 -888 -666=.) ;
recode dxccs3                    (-999 -888 -666=.) ;
recode dxccs4                    (-999 -888 -666=.) ;
recode dxccs5                    (-999 -888 -666=.) ;
recode dxccs6                    (-999 -888 -666=.) ;
recode dxccs7                    (-999 -888 -666=.) ;
recode dxccs8                    (-999 -888 -666=.) ;
recode dxccs9                    (-999 -888 -666=.) ;
recode dxccs10                   (-999 -888 -666=.) ;
recode dxccs11                   (-999 -888 -666=.) ;
recode dxccs12                   (-999 -888 -666=.) ;
recode dxccs13                   (-999 -888 -666=.) ;
recode dxccs14                   (-999 -888 -666=.) ;
recode dxccs15                   (-999 -888 -666=.) ;
recode dxccs16                   (-999 -888 -666=.) ;
recode dxccs17                   (-999 -888 -666=.) ;
recode dxccs18                   (-999 -888 -666=.) ;
recode dxccs19                   (-999 -888 -666=.) ;
recode dxccs20                   (-999 -888 -666=.) ;
recode dxccs21                   (-999 -888 -666=.) ;
recode dxccs22                   (-999 -888 -666=.) ;
recode dxccs23                   (-999 -888 -666=.) ;
recode dxccs24                   (-999 -888 -666=.) ;
recode dxccs25                   (-999 -888 -666=.) ;
recode dxccs26                   (-999 -888 -666=.) ;
recode dxccs27                   (-999 -888 -666=.) ;
recode dxccs28                   (-999 -888 -666=.) ;
recode dxccs29                   (-999 -888 -666=.) ;
recode dxccs30                   (-999 -888 -666=.) ;
recode dxver                     (-9 -8 -6 -5=.) ;
recode e_ccs1                    (-999 -888 -666=.) ;
recode e_ccs2                    (-999 -888 -666=.) ;
recode e_ccs3                    (-999 -888 -666=.) ;
recode e_ccs4                    (-999 -888 -666=.) ;
recode hosp_nrd                  (-9999 -8888 -6666=.) ;
recode key_nrd                   (-99999999999999 -88888888888888 -66666666666666=.) ;
recode mdc                       (-9 -8 -6 -5=.) ;
recode mdc_nopoa                 (-9 -8 -6 -5=.) ;
recode nchronic                  (-9 -8 -6 -5=.) ;
recode ndx                       (-99 -88 -66=.) ;
recode necode                    (-99 -88 -66=.) ;
recode npr                       (-99 -88 -66=.) ;
recode orproc                    (-9 -8 -6 -5=.) ;
recode pclass1                   (-99 -88 -66=.) ;
recode pclass2                   (-99 -88 -66=.) ;
recode pclass3                   (-99 -88 -66=.) ;
recode pclass4                   (-99 -88 -66=.) ;
recode pclass5                   (-99 -88 -66=.) ;
recode pclass6                   (-99 -88 -66=.) ;
recode pclass7                   (-99 -88 -66=.) ;
recode pclass8                   (-99 -88 -66=.) ;
recode pclass9                   (-99 -88 -66=.) ;
recode pclass10                  (-99 -88 -66=.) ;
recode pclass11                  (-99 -88 -66=.) ;
recode pclass12                  (-99 -88 -66=.) ;
recode pclass13                  (-99 -88 -66=.) ;
recode pclass14                  (-99 -88 -66=.) ;
recode pclass15                  (-99 -88 -66=.) ;
recode prccs1                    (-99 -88 -66=.) ;
recode prccs2                    (-99 -88 -66=.) ;
recode prccs3                    (-99 -88 -66=.) ;
recode prccs4                    (-99 -88 -66=.) ;
recode prccs5                    (-99 -88 -66=.) ;
recode prccs6                    (-99 -88 -66=.) ;
recode prccs7                    (-99 -88 -66=.) ;
recode prccs8                    (-99 -88 -66=.) ;
recode prccs9                    (-99 -88 -66=.) ;
recode prccs10                   (-99 -88 -66=.) ;
recode prccs11                   (-99 -88 -66=.) ;
recode prccs12                   (-99 -88 -66=.) ;
recode prccs13                   (-99 -88 -66=.) ;
recode prccs14                   (-99 -88 -66=.) ;
recode prccs15                   (-99 -88 -66=.) ;
recode prday1                    (-99 -88 -66=.) ;
recode prday2                    (-99 -88 -66=.) ;
recode prday3                    (-99 -88 -66=.) ;
recode prday4                    (-99 -88 -66=.) ;
recode prday5                    (-99 -88 -66=.) ;
recode prday6                    (-99 -88 -66=.) ;
recode prday7                    (-99 -88 -66=.) ;
recode prday8                    (-99 -88 -66=.) ;
recode prday9                    (-99 -88 -66=.) ;
recode prday10                   (-99 -88 -66=.) ;
recode prday11                   (-99 -88 -66=.) ;
recode prday12                   (-99 -88 -66=.) ;
recode prday13                   (-99 -88 -66=.) ;
recode prday14                   (-99 -88 -66=.) ;
recode prday15                   (-99 -88 -66=.) ;
recode prver                     (-9 -8 -6 -5=.) ;
recode serviceline               (-9 -8 -6 -5=.) ;

describe;

save "NRD_2015Q1Q3_DX_PR_GRPS.dta", replace;
#delimit cr
