/*******************************************************************
*   NY_SASD_2011_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NY_SASD_2011_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ANESTH                    16-  18
 AWEEKEND                  19-  20
 BILLTYPE                  21-  24 (A)
 CPT1                      25-  29 (A)
 CPT2                      30-  34 (A)
 CPT3                      35-  39 (A)
 CPT4                      40-  44 (A)
 CPT5                      45-  49 (A)
 CPT6                      50-  54 (A)
 CPT7                      55-  59 (A)
 CPT8                      60-  64 (A)
 CPT9                      65-  69 (A)
 CPT10                     70-  74 (A)
 CPT11                     75-  79 (A)
 CPT12                     80-  84 (A)
 CPT13                     85-  89 (A)
 CPT14                     90-  94 (A)
 CPT15                     95-  99 (A)
 CPT16                    100- 104 (A)
 CPT17                    105- 109 (A)
 CPT18                    110- 114 (A)
 CPT19                    115- 119 (A)
 CPT20                    120- 124 (A)
 CPTCCS1                  125- 127
 CPTCCS2                  128- 130
 CPTCCS3                  131- 133
 CPTCCS4                  134- 136
 CPTCCS5                  137- 139
 CPTCCS6                  140- 142
 CPTCCS7                  143- 145
 CPTCCS8                  146- 148
 CPTCCS9                  149- 151
 CPTCCS10                 152- 154
 CPTCCS11                 155- 157
 CPTCCS12                 158- 160
 CPTCCS13                 161- 163
 CPTCCS14                 164- 166
 CPTCCS15                 167- 169
 CPTCCS16                 170- 172
 CPTCCS17                 173- 175
 CPTCCS18                 176- 178
 CPTCCS19                 179- 181
 CPTCCS20                 182- 184
 CPTM1_1                  185- 186 (A)
 CPTM1_2                  187- 188 (A)
 CPTM1_3                  189- 190 (A)
 CPTM1_4                  191- 192 (A)
 CPTM1_5                  193- 194 (A)
 CPTM1_6                  195- 196 (A)
 CPTM1_7                  197- 198 (A)
 CPTM1_8                  199- 200 (A)
 CPTM1_9                  201- 202 (A)
 CPTM1_10                 203- 204 (A)
 CPTM1_11                 205- 206 (A)
 CPTM1_12                 207- 208 (A)
 CPTM1_13                 209- 210 (A)
 CPTM1_14                 211- 212 (A)
 CPTM1_15                 213- 214 (A)
 CPTM1_16                 215- 216 (A)
 CPTM1_17                 217- 218 (A)
 CPTM1_18                 219- 220 (A)
 CPTM1_19                 221- 222 (A)
 CPTM1_20                 223- 224 (A)
 CPTM2_1                  225- 226 (A)
 CPTM2_2                  227- 228 (A)
 CPTM2_3                  229- 230 (A)
 CPTM2_4                  231- 232 (A)
 CPTM2_5                  233- 234 (A)
 CPTM2_6                  235- 236 (A)
 CPTM2_7                  237- 238 (A)
 CPTM2_8                  239- 240 (A)
 CPTM2_9                  241- 242 (A)
 CPTM2_10                 243- 244 (A)
 CPTM2_11                 245- 246 (A)
 CPTM2_12                 247- 248 (A)
 CPTM2_13                 249- 250 (A)
 CPTM2_14                 251- 252 (A)
 CPTM2_15                 253- 254 (A)
 CPTM2_16                 255- 256 (A)
 CPTM2_17                 257- 258 (A)
 CPTM2_18                 259- 260 (A)
 CPTM2_19                 261- 262 (A)
 CPTM2_20                 263- 264 (A)
 DHOUR                    265- 268
 DIED                     269- 270
 DISPUB04                 271- 272
 DISPUNIFORM              273- 274
 DISP_X                   275- 276 (A)
 DQTR                     277- 278
 DSHOSPID                 279- 295 (A)
 DURATION                 296- 301
 DX1                      302- 306 (A)
 DX2                      307- 311 (A)
 DX3                      312- 316 (A)
 DX4                      317- 321 (A)
 DX5                      322- 326 (A)
 DX6                      327- 331 (A)
 DX7                      332- 336 (A)
 DX8                      337- 341 (A)
 DX9                      342- 346 (A)
 DX10                     347- 351 (A)
 DX11                     352- 356 (A)
 DX12                     357- 361 (A)
 DX13                     362- 366 (A)
 DX14                     367- 371 (A)
 DX15                     372- 376 (A)
 DX16                     377- 381 (A)
 DX17                     382- 386 (A)
 DX18                     387- 391 (A)
 DX19                     392- 396 (A)
 DX20                     397- 401 (A)
 DX21                     402- 406 (A)
 DX22                     407- 411 (A)
 DX23                     412- 416 (A)
 DX24                     417- 421 (A)
 DX25                     422- 426 (A)
 DXCCS1                   427- 430
 DXCCS2                   431- 434
 DXCCS3                   435- 438
 DXCCS4                   439- 442
 DXCCS5                   443- 446
 DXCCS6                   447- 450
 DXCCS7                   451- 454
 DXCCS8                   455- 458
 DXCCS9                   459- 462
 DXCCS10                  463- 466
 DXCCS11                  467- 470
 DXCCS12                  471- 474
 DXCCS13                  475- 478
 DXCCS14                  479- 482
 DXCCS15                  483- 486
 DXCCS16                  487- 490
 DXCCS17                  491- 494
 DXCCS18                  495- 498
 DXCCS19                  499- 502
 DXCCS20                  503- 506
 DXCCS21                  507- 510
 DXCCS22                  511- 514
 DXCCS23                  515- 518
 DXCCS24                  519- 522
 DXCCS25                  523- 526
 DX_Visit_Reason1         527- 531 (A)
 DaysToEvent              532- 537
 ECODE1                   538- 542 (A)
 ECODE2                   543- 547 (A)
 ECODE3                   548- 552 (A)
 ECODE4                   553- 557 (A)
 ECODE5                   558- 562 (A)
 ECODE6                   563- 567 (A)
 ECODE7                   568- 572 (A)
 ECODE8                   573- 577 (A)
 E_CCS1                   578- 581
 E_CCS2                   582- 585
 E_CCS3                   586- 589
 E_CCS4                   590- 593
 E_CCS5                   594- 597
 E_CCS6                   598- 601
 E_CCS7                   602- 605
 E_CCS8                   606- 609
 FEMALE                   610- 611
 HCUP_ED                  612- 613
 HCUP_OS                  614- 615
 HCUP_SURGERY_BROAD       616- 617
 HCUP_SURGERY_NARROW      618- 619
 HISPANIC_X               620     (A)
 HOSPBRTH                 621- 623
 HOSPST                   624- 625 (A)
 Homeless                 626- 627
 KEY                      628- 645
 LOS                      646- 650
 LOS_X                    651- 656
 MEDINCSTQ                657- 658
 NCHRONIC                 659- 661
 NCPT                     662- 664
 NDX                      665- 666
 NECODE                   667- 668
 NEOMAT                   669- 670
 ORTIME                   671- 674
 PAY1                     675- 676
 PAY1_X                   677- 678 (A)
 PL_CBSA                  679- 681
 PL_MSA1993               682- 684
 PL_NCHS2006              685- 686
 PL_RUCA10_2005           687- 688
 PL_RUCA2005              689- 692
 PL_RUCA4_2005            693- 694
 PL_RUCC2003              695- 696
 PL_UIC2003               697- 698
 PL_UR_CAT4               699- 700
 PROCTYPE                 701- 703
 PSTATE                   704- 705 (A)
 PSTCO                    706- 710
 PSTCO2                   711- 715
 RACE                     716- 717
 RACE_X                   718- 719 (A)
 STATE_AS                 720- 721
 STATE_ED                 722- 723
 STATE_OS                 724- 725
 TOTCHG                   726- 735
 TOTCHG_X                 736- 750
 VisitLink                751- 759
 YEAR                     760- 763
 ZIP3                     764- 766 (A)
 ZIPINC_QRTL              767- 769
 ZIP                      770- 774 (A)
 AYEAR                    775- 778
 DMONTH                   779- 780
 BMONTH                   781- 782
 BYEAR                    783- 786.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ANESTH                  (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DURATION                (F4.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HCUP_SURGERY_BROAD      (F3.0) /
 HCUP_SURGERY_NARROW     (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 ORTIME                  (F4.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ANESTH                  "Method of anesthesia"
 AWEEKEND                "Admission day is a weekend"
 BILLTYPE                "UB-92 bill type"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM1_7                 "First CPT-4/HCPCS modifier 7"
 CPTM1_8                 "First CPT-4/HCPCS modifier 8"
 CPTM1_9                 "First CPT-4/HCPCS modifier 9"
 CPTM1_10                "First CPT-4/HCPCS modifier 10"
 CPTM1_11                "First CPT-4/HCPCS modifier 11"
 CPTM1_12                "First CPT-4/HCPCS modifier 12"
 CPTM1_13                "First CPT-4/HCPCS modifier 13"
 CPTM1_14                "First CPT-4/HCPCS modifier 14"
 CPTM1_15                "First CPT-4/HCPCS modifier 15"
 CPTM1_16                "First CPT-4/HCPCS modifier 16"
 CPTM1_17                "First CPT-4/HCPCS modifier 17"
 CPTM1_18                "First CPT-4/HCPCS modifier 18"
 CPTM1_19                "First CPT-4/HCPCS modifier 19"
 CPTM1_20                "First CPT-4/HCPCS modifier 20"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                 "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                 "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                 "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                "Second CPT-4/HCPCS modifier 20"
 DHOUR                   "Discharge Hour"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DURATION                "Hours in Emergency Department"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DX_Visit_Reason1        "Reason for visit diagnosis 1"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD      "Revised HCUP_AS (PCLASSn=3 or 4, or broad definition)"
 HCUP_SURGERY_NARROW     "Revised HCUP_AS (PCLASSn=4, or narrow definition)"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 Homeless                "Indicator that patient is homeless"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 ORTIME                  "Operating room time in minutes"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ANESTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_NARROW
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE ORTIME
 (-999,-888,-666,-555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NY_SASD_2011_CORE.SAV' /COMPRESSED.
