/*******************************************************************
* Creation Date: 11/28/2018   
*   OR_SASD_2015q4_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'OR_SASD_2015q4_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 I10_BODYSYSTEM1                 1-   2
 I10_BODYSYSTEM2                 3-   4
 I10_BODYSYSTEM3                 5-   6
 I10_BODYSYSTEM4                 7-   8
 I10_BODYSYSTEM5                 9-  10
 I10_BODYSYSTEM6                11-  12
 I10_BODYSYSTEM7                13-  14
 I10_BODYSYSTEM8                15-  16
 I10_BODYSYSTEM9                17-  18
 I10_BODYSYSTEM10               19-  20
 I10_CHRON1                     21-  22
 I10_CHRON2                     23-  24
 I10_CHRON3                     25-  26
 I10_CHRON4                     27-  28
 I10_CHRON5                     29-  30
 I10_CHRON6                     31-  32
 I10_CHRON7                     33-  34
 I10_CHRON8                     35-  36
 I10_CHRON9                     37-  38
 I10_CHRON10                    39-  40
 I10_DXMCCS1                    41-  51 (A)
 I10_DXMCCS2                    52-  62 (A)
 I10_DXMCCS3                    63-  73 (A)
 I10_DXMCCS4                    74-  84 (A)
 I10_DXMCCS5                    85-  95 (A)
 I10_DXMCCS6                    96- 106 (A)
 I10_DXMCCS7                   107- 117 (A)
 I10_DXMCCS8                   118- 128 (A)
 I10_DXMCCS9                   129- 139 (A)
 I10_DXMCCS10                  140- 150 (A)
 I10_ECauseMCCS1               151- 161 (A)
 I10_ECauseMCCS2               162- 172 (A)
 I10_ECauseMCCS3               173- 183 (A)
 I10_ECauseMCCS4               184- 194 (A)
 I10_ECauseMCCS5               195- 205 (A)
 I10_INJURY                    206- 207
 I10_MULTINJURY                208- 209
 I10_U_BLOOD                   210- 211
 I10_U_CATH                    212- 213
 I10_U_CTSCAN                  214- 215
 I10_U_EKG                     216- 217
 I10_U_MHSA                    218- 219
 I10_U_MRT                     220- 221
 I10_U_PACEMAKER               222- 223
 I10_U_PHYTHERAPY              224- 225
 I10_U_RADTHERAPY              226- 227
 I10_U_STRESS                  228- 229
 KEY                           230- 244
 U_CCU                         245- 246
 U_CHESTXRAY                   247- 248
 U_DIALYSIS                    249- 250
 U_ECHO                        251- 252
 U_ED                          253- 254
 U_EEG                         255- 256
 U_EPO                         257- 258
 U_ICU                         259- 260
 U_LITHOTRIPSY                 261- 262
 U_NEWBN2L                     263- 264
 U_NEWBN3L                     265- 266
 U_NEWBN4L                     267- 268
 U_NUCMED                      269- 270
 U_OBSERVATION                 271- 272
 U_OCCTHERAPY                  273- 274
 U_ORGANACQ                    275- 276
 U_OTHIMPLANTS                 277- 278
 U_RESPTHERAPY                 279- 280
 U_SPEECHTHERAPY               281- 282
 U_ULTRASOUND                  283- 284.


***  Specify write formats  ***.
FORMATS
 I10_BODYSYSTEM1              (F3.0) /
 I10_BODYSYSTEM2              (F3.0) /
 I10_BODYSYSTEM3              (F3.0) /
 I10_BODYSYSTEM4              (F3.0) /
 I10_BODYSYSTEM5              (F3.0) /
 I10_BODYSYSTEM6              (F3.0) /
 I10_BODYSYSTEM7              (F3.0) /
 I10_BODYSYSTEM8              (F3.0) /
 I10_BODYSYSTEM9              (F3.0) /
 I10_BODYSYSTEM10             (F3.0) /
 I10_CHRON1                   (F3.0) /
 I10_CHRON2                   (F3.0) /
 I10_CHRON3                   (F3.0) /
 I10_CHRON4                   (F3.0) /
 I10_CHRON5                   (F3.0) /
 I10_CHRON6                   (F3.0) /
 I10_CHRON7                   (F3.0) /
 I10_CHRON8                   (F3.0) /
 I10_CHRON9                   (F3.0) /
 I10_CHRON10                  (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_MULTINJURY               (F3.0) /
 I10_U_BLOOD                  (F3.0) /
 I10_U_CATH                   (F3.0) /
 I10_U_CTSCAN                 (F3.0) /
 I10_U_EKG                    (F3.0) /
 I10_U_MHSA                   (F3.0) /
 I10_U_MRT                    (F3.0) /
 I10_U_PACEMAKER              (F3.0) /
 I10_U_PHYTHERAPY             (F3.0) /
 I10_U_RADTHERAPY             (F3.0) /
 I10_U_STRESS                 (F3.0) /
 KEY                          (F8.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 I10_BODYSYSTEM1              "ICD-10-CM Body system 1"
 I10_BODYSYSTEM2              "ICD-10-CM Body system 2"
 I10_BODYSYSTEM3              "ICD-10-CM Body system 3"
 I10_BODYSYSTEM4              "ICD-10-CM Body system 4"
 I10_BODYSYSTEM5              "ICD-10-CM Body system 5"
 I10_BODYSYSTEM6              "ICD-10-CM Body system 6"
 I10_BODYSYSTEM7              "ICD-10-CM Body system 7"
 I10_BODYSYSTEM8              "ICD-10-CM Body system 8"
 I10_BODYSYSTEM9              "ICD-10-CM Body system 9"
 I10_BODYSYSTEM10             "ICD-10-CM Body system 10"
 I10_CHRON1                   "ICD-10-CM Chronic condition indicator 1"
 I10_CHRON2                   "ICD-10-CM Chronic condition indicator 2"
 I10_CHRON3                   "ICD-10-CM Chronic condition indicator 3"
 I10_CHRON4                   "ICD-10-CM Chronic condition indicator 4"
 I10_CHRON5                   "ICD-10-CM Chronic condition indicator 5"
 I10_CHRON6                   "ICD-10-CM Chronic condition indicator 6"
 I10_CHRON7                   "ICD-10-CM Chronic condition indicator 7"
 I10_CHRON8                   "ICD-10-CM Chronic condition indicator 8"
 I10_CHRON9                   "ICD-10-CM Chronic condition indicator 9"
 I10_CHRON10                  "ICD-10-CM Chronic condition indicator 10"
 I10_DXMCCS1                  "ICD-10-CM Multi-Level CCS:  Diagnosis 1"
 I10_DXMCCS2                  "ICD-10-CM Multi-Level CCS:  Diagnosis 2"
 I10_DXMCCS3                  "ICD-10-CM Multi-Level CCS:  Diagnosis 3"
 I10_DXMCCS4                  "ICD-10-CM Multi-Level CCS:  Diagnosis 4"
 I10_DXMCCS5                  "ICD-10-CM Multi-Level CCS:  Diagnosis 5"
 I10_DXMCCS6                  "ICD-10-CM Multi-Level CCS:  Diagnosis 6"
 I10_DXMCCS7                  "ICD-10-CM Multi-Level CCS:  Diagnosis 7"
 I10_DXMCCS8                  "ICD-10-CM Multi-Level CCS:  Diagnosis 8"
 I10_DXMCCS9                  "ICD-10-CM Multi-Level CCS:  Diagnosis 9"
 I10_DXMCCS10                 "ICD-10-CM Multi-Level CCS:  Diagnosis 10"
 I10_ECauseMCCS1              "ICD-10-CM Multi-Level CCS:  E Cause 1"
 I10_ECauseMCCS2              "ICD-10-CM Multi-Level CCS:  E Cause 2"
 I10_ECauseMCCS3              "ICD-10-CM Multi-Level CCS:  E Cause 3"
 I10_ECauseMCCS4              "ICD-10-CM Multi-Level CCS:  E Cause 4"
 I10_ECauseMCCS5              "ICD-10-CM Multi-Level CCS:  E Cause 5"
 I10_INJURY
 "ICD-10-CM Injury diagnosis reported on record (1:I10_DX1 is an injury; 2:I10_DX2+ is an injury; 0:No injury)"
 I10_MULTINJURY               "ICD-10-CM More than one injury diagnosis reported on record"
 I10_U_BLOOD                  "ICD-10-PCS Utilization Flag: Blood"
 I10_U_CATH                   "ICD-10-PCS Utilization Flag: Cardiac Catheterization Lab"
 I10_U_CTSCAN                 "ICD-10-PCS Utilization Flag: Computed Tomography Scan"
 I10_U_EKG                    "ICD-10-PCS Utilization Flag: Electrocardiogram"
 I10_U_MHSA                   "ICD-10-PCS Utilization Flag: Mental Health and Substance Abuse"
 I10_U_MRT                    "ICD-10-PCS Utilization Flag: Magnetic Resonance Technology"
 I10_U_PACEMAKER              "ICD-10-PCS Utilization Flag: Pacemaker"
 I10_U_PHYTHERAPY             "ICD-10-PCS Utilization Flag: Physical Therapy"
 I10_U_RADTHERAPY             "ICD-10-PCS Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 I10_U_STRESS                 "ICD-10-PCS Utilization Flag: Cardiac Stress Test"
 KEY                          "HCUP record identifier"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE I10_BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'OR_SASD_2015q4_DX_PR_GRPS.SAV' /COMPRESSED.
