/*******************************************************************
*   MD_SASD_2006_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CHGS FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SASD_2006_CHGS.ASC' FIXED / 
 KEY                        1-  14
 CHARGE                    15-  26
 CPTHCPCS                  27-  31 (A)
 CPTMod1                   32-  33 (A)
 CPTMod2                   34-  35 (A)
 REVCODE                   36-  39 (A)
 SERVDAY                   40-  44
 UNITS                     45-  52.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 CHARGE                  (F6.2) /
 SERVDAY                 (F3.0) /
 UNITS                   (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CHARGE    "Line item charges (as received from source)"
 CPTHCPCS  "Line item CPT-4/HCPCS procedure code (as received from source)"
 CPTMod1   "Line item CPT-4/HCPCS first modifier (as received from source)"
 CPTMod2   "Line item CPT-4/HCPCS second modifier (as received from source)"
 REVCODE   "Line item revenue code (as received from source)"
 SERVDAY   "Line item days from admission date"
 UNITS     "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE SERVDAY
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE UNITS
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).



SAVE OUTFILE = 'MD_SASD_2006_CHGS.SAV' /COMPRESSED.
