/*******************************************************************
*   MD_SASD_2008_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'MD_SASD_2008_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRON11                   21-  22
 CHRON12                   23-  24
 CHRON13                   25-  26
 CHRON14                   27-  28
 CHRON15                   29-  30
 CHRON16                   31-  32
 CHRONB1                   33-  34
 CHRONB2                   35-  36
 CHRONB3                   37-  38
 CHRONB4                   39-  40
 CHRONB5                   41-  42
 CHRONB6                   43-  44
 CHRONB7                   45-  46
 CHRONB8                   47-  48
 CHRONB9                   49-  50
 CHRONB10                  51-  52
 CHRONB11                  53-  54
 CHRONB12                  55-  56
 CHRONB13                  57-  58
 CHRONB14                  59-  60
 CHRONB15                  61-  62
 CHRONB16                  63-  64
 DXMCCS1                   65-  75 (A)
 DXMCCS2                   76-  86 (A)
 DXMCCS3                   87-  97 (A)
 DXMCCS4                   98- 108 (A)
 DXMCCS5                  109- 119 (A)
 DXMCCS6                  120- 130 (A)
 DXMCCS7                  131- 141 (A)
 DXMCCS8                  142- 152 (A)
 DXMCCS9                  153- 163 (A)
 DXMCCS10                 164- 174 (A)
 DXMCCS11                 175- 185 (A)
 DXMCCS12                 186- 196 (A)
 DXMCCS13                 197- 207 (A)
 DXMCCS14                 208- 218 (A)
 DXMCCS15                 219- 229 (A)
 DXMCCS16                 230- 240 (A)
 E_MCCS1                  241- 251 (A)
 E_MCCS2                  252- 262 (A)
 E_MCCS3                  263- 273 (A)
 E_MCCS4                  274- 284 (A)
 E_MCCS5                  285- 295 (A)
 E_MCCS6                  296- 306 (A)
 E_MCCS7                  307- 317 (A)
 KEY                      318- 331
 U_BLOOD                  332- 333
 U_CATH                   334- 335
 U_CCU                    336- 337
 U_CHESTX                 338- 339
 U_CTSCAN                 340- 341
 U_DIALYS                 342- 343
 U_ECHO                   344- 345
 U_ED                     346- 347
 U_EEG                    348- 349
 U_EKG                    350- 351
 U_EPO                    352- 353
 U_ICU                    354- 355
 U_LITHOT                 356- 357
 U_MHSA                   358- 359
 U_MRT                    360- 361
 U_NEWBN2                 362- 363
 U_NEWBN3                 364- 365
 U_NEWBN4                 366- 367
 U_NUCMED                 368- 369
 U_OBSERV                 370- 371
 U_OCCTHE                 372- 373
 U_ORGANA                 374- 375
 U_OTHIMP                 376- 377
 U_PACEMA                 378- 379
 U_PHYTHE                 380- 381
 U_RADTHE                 382- 383
 U_RESPTH                 384- 385
 U_SPEECH                 386- 387
 U_STRESS                 388- 389
 U_ULTRAS                 390- 391.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRON11                 (F3.0) /
 CHRON12                 (F3.0) /
 CHRON13                 (F3.0) /
 CHRON14                 (F3.0) /
 CHRON15                 (F3.0) /
 CHRON16                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 CHRONB11                (F3.0) /
 CHRONB12                (F3.0) /
 CHRONB13                (F3.0) /
 CHRONB14                (F3.0) /
 CHRONB15                (F3.0) /
 CHRONB16                (F3.0) /
 KEY                     (F8.0) /
 U_BLOOD                 (F3.0) /
 U_CATH                  (F3.0) /
 U_CCU                   (F3.0) /
 U_CHESTX                (F3.0) /
 U_CTSCAN                (F3.0) /
 U_DIALYS                (F3.0) /
 U_ECHO                  (F3.0) /
 U_ED                    (F3.0) /
 U_EEG                   (F3.0) /
 U_EKG                   (F3.0) /
 U_EPO                   (F3.0) /
 U_ICU                   (F3.0) /
 U_LITHOT                (F3.0) /
 U_MHSA                  (F3.0) /
 U_MRT                   (F3.0) /
 U_NEWBN2                (F3.0) /
 U_NEWBN3                (F3.0) /
 U_NEWBN4                (F3.0) /
 U_NUCMED                (F3.0) /
 U_OBSERV                (F3.0) /
 U_OCCTHE                (F3.0) /
 U_ORGANA                (F3.0) /
 U_OTHIMP                (F3.0) /
 U_PACEMA                (F3.0) /
 U_PHYTHE                (F3.0) /
 U_RADTHE                (F3.0) /
 U_RESPTH                (F3.0) /
 U_SPEECH                (F3.0) /
 U_STRESS                (F3.0) /
 U_ULTRAS                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1    "Chronic condition indicator 1"
 CHRON2    "Chronic condition indicator 2"
 CHRON3    "Chronic condition indicator 3"
 CHRON4    "Chronic condition indicator 4"
 CHRON5    "Chronic condition indicator 5"
 CHRON6    "Chronic condition indicator 6"
 CHRON7    "Chronic condition indicator 7"
 CHRON8    "Chronic condition indicator 8"
 CHRON9    "Chronic condition indicator 9"
 CHRON10   "Chronic condition indicator 10"
 CHRON11   "Chronic condition indicator 11"
 CHRON12   "Chronic condition indicator 12"
 CHRON13   "Chronic condition indicator 13"
 CHRON14   "Chronic condition indicator 14"
 CHRON15   "Chronic condition indicator 15"
 CHRON16   "Chronic condition indicator 16"
 CHRONB1   "Chronic condition body system 1"
 CHRONB2   "Chronic condition body system 2"
 CHRONB3   "Chronic condition body system 3"
 CHRONB4   "Chronic condition body system 4"
 CHRONB5   "Chronic condition body system 5"
 CHRONB6   "Chronic condition body system 6"
 CHRONB7   "Chronic condition body system 7"
 CHRONB8   "Chronic condition body system 8"
 CHRONB9   "Chronic condition body system 9"
 CHRONB10  "Chronic condition body system 10"
 CHRONB11  "Chronic condition body system 11"
 CHRONB12  "Chronic condition body system 12"
 CHRONB13  "Chronic condition body system 13"
 CHRONB14  "Chronic condition body system 14"
 CHRONB15  "Chronic condition body system 15"
 CHRONB16  "Chronic condition body system 16"
 DXMCCS1   "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2   "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3   "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4   "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5   "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6   "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7   "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8   "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9   "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10  "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11  "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12  "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13  "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14  "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15  "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16  "Multi-Level CCS:  Diagnosis 16"
 E_MCCS1   "Multi-Level CCS:  E Code 1"
 E_MCCS2   "Multi-Level CCS:  E Code 2"
 E_MCCS3   "Multi-Level CCS:  E Code 3"
 E_MCCS4   "Multi-Level CCS:  E Code 4"
 E_MCCS5   "Multi-Level CCS:  E Code 5"
 E_MCCS6   "Multi-Level CCS:  E Code 6"
 E_MCCS7   "Multi-Level CCS:  E Code 7"
 KEY       "HCUP record identifier"
 U_BLOOD   "Utilization Flag: Blood"
 U_CATH    "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU     "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTX  "Utilization Flag: Chest X-Ray"
 U_CTSCAN  "Utilization Flag: Computed Tomography Scan"
 U_DIALYS  "Utilization Flag: Renal Dialysis"
 U_ECHO    "Utilization Flag: Echocardiology"
 U_ED      "Utilization Flag: Emergency Room"
 U_EEG     "Utilization Flag: Electroencephalogram"
 U_EKG     "Utilization Flag: Electrocardiogram"
 U_EPO     "Utilization Flag: EPO"
 U_ICU     "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOT  "Utilization Flag: Lithotripsy"
 U_MHSA    "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT     "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2  "Utilization Flag: Nursery Level II"
 U_NEWBN3  "Utilization Flag: Nursery Level III"
 U_NEWBN4  "Utilization Flag: Nursery Level IV"
 U_NUCMED  "Utilization Flag: Nuclear Medicine"
 U_OBSERV  "Utilization Flag: Observation Room"
 U_OCCTHE  "Utilization Flag: Occupational Therapy"
 U_ORGANA  "Utilization Flag: Organ Acquisition"
 U_OTHIMP  "Utilization Flag: Other Implants"
 U_PACEMA  "Utilization Flag: Pacemaker"
 U_PHYTHE  "Utilization Flag: Physical Therapy"
 U_RADTHE  "Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTH  "Utilization Flag: Respiratory Services"
 U_SPEECH  "Utilization Flag: Speech - Language Pathology"
 U_STRESS  "Utilization Flag: Cardiac Stress Test"
 U_ULTRAS  "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTX
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERV
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMP
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRAS
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MD_SASD_2008_DX_PR_GRPS.SAV' /COMPRESSED.
