/*****************************************************************************
* Creation Date: 03/16/2017   
* CO_SASD_2015q1q3_CORE.Do
* This program will load the 2015 CO ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***
infix 3 firstlineoffile                            ///
      int    AGE                          1-   3   ///
      int    AGEMONTH                     4-   6   ///
      byte   AMONTH                       7-   8   ///
      byte   ATYPE                        9-  10   ///
      byte   AWEEKEND                    11-  12   ///
      str    CPT1                        13-  17   ///
      str    CPT2                        18-  22   ///
      str    CPT3                        23-  27   ///
      str    CPT4                        28-  32   ///
      str    CPT5                        33-  37   ///
      str    CPT6                        38-  42   ///
      str    CPT7                        43-  47   ///
      str    CPT8                        48-  52   ///
      str    CPT9                        53-  57   ///
      str    CPT10                       58-  62   ///
      str    CPT11                       63-  67   ///
      str    CPT12                       68-  72   ///
      str    CPT13                       73-  77   ///
      str    CPT14                       78-  82   ///
      str    CPT15                       83-  87   ///
      int    CPTCCS1                     88-  90   ///
      int    CPTCCS2                     91-  93   ///
      int    CPTCCS3                     94-  96   ///
      int    CPTCCS4                     97-  99   ///
      int    CPTCCS5                    100- 102   ///
      int    CPTCCS6                    103- 105   ///
      int    CPTCCS7                    106- 108   ///
      int    CPTCCS8                    109- 111   ///
      int    CPTCCS9                    112- 114   ///
      int    CPTCCS10                   115- 117   ///
      int    CPTCCS11                   118- 120   ///
      int    CPTCCS12                   121- 123   ///
      int    CPTCCS13                   124- 126   ///
      int    CPTCCS14                   127- 129   ///
      int    CPTCCS15                   130- 132   ///
      byte   DIED                       133- 134   ///
      str    DISP_X                     135- 136   ///
      byte   DISPUB04                   137- 138   ///
      byte   DISPUNIFORM                139- 140   ///
      byte   DMONTH                     141- 142   ///
      byte   DQTR                       143- 144   ///
      str    DSHOSPID                   145- 161   ///
      str    DX1                        162- 168   ///
      str    DX2                        169- 175   ///
      str    DX3                        176- 182   ///
      str    DX4                        183- 189   ///
      str    DX5                        190- 196   ///
      str    DX6                        197- 203   ///
      str    DX7                        204- 210   ///
      str    DX8                        211- 217   ///
      str    DX9                        218- 224   ///
      str    DX10                       225- 231   ///
      str    DX11                       232- 238   ///
      str    DX12                       239- 245   ///
      str    DX13                       246- 252   ///
      str    DX14                       253- 259   ///
      str    DX15                       260- 266   ///
      str    DX16                       267- 273   ///
      str    DX17                       274- 280   ///
      str    DX18                       281- 287   ///
      str    DX19                       288- 294   ///
      str    DX20                       295- 301   ///
      str    DX21                       302- 308   ///
      str    DX22                       309- 315   ///
      str    DX23                       316- 322   ///
      str    DX24                       323- 329   ///
      str    DX25                       330- 336   ///
      str    DX26                       337- 343   ///
      str    DX27                       344- 350   ///
      str    DX28                       351- 357   ///
      str    DX29                       358- 364   ///
      str    DX30                       365- 371   ///
      int    DXCCS1                     372- 375   ///
      int    DXCCS2                     376- 379   ///
      int    DXCCS3                     380- 383   ///
      int    DXCCS4                     384- 387   ///
      int    DXCCS5                     388- 391   ///
      int    DXCCS6                     392- 395   ///
      int    DXCCS7                     396- 399   ///
      int    DXCCS8                     400- 403   ///
      int    DXCCS9                     404- 407   ///
      int    DXCCS10                    408- 411   ///
      int    DXCCS11                    412- 415   ///
      int    DXCCS12                    416- 419   ///
      int    DXCCS13                    420- 423   ///
      int    DXCCS14                    424- 427   ///
      int    DXCCS15                    428- 431   ///
      int    DXCCS16                    432- 435   ///
      int    DXCCS17                    436- 439   ///
      int    DXCCS18                    440- 443   ///
      int    DXCCS19                    444- 447   ///
      int    DXCCS20                    448- 451   ///
      int    DXCCS21                    452- 455   ///
      int    DXCCS22                    456- 459   ///
      int    DXCCS23                    460- 463   ///
      int    DXCCS24                    464- 467   ///
      int    DXCCS25                    468- 471   ///
      int    DXCCS26                    472- 475   ///
      int    DXCCS27                    476- 479   ///
      int    DXCCS28                    480- 483   ///
      int    DXCCS29                    484- 487   ///
      int    DXCCS30                    488- 491   ///
      int    DXVER                      492- 494   ///
      int    E_CCS1                     495- 498   ///
      int    E_CCS2                     499- 502   ///
      int    E_CCS3                     503- 506   ///
      int    E_CCS4                     507- 510   ///
      int    E_CCS5                     511- 514   ///
      int    E_CCS6                     515- 518   ///
      int    E_CCS7                     519- 522   ///
      int    E_CCS8                     523- 526   ///
      int    E_CCS9                     527- 530   ///
      int    E_CCS10                    531- 534   ///
      int    E_CCS11                    535- 538   ///
      int    E_CCS12                    539- 542   ///
      int    E_CCS13                    543- 546   ///
      int    E_CCS14                    547- 550   ///
      int    E_CCS15                    551- 554   ///
      int    E_CCS16                    555- 558   ///
      int    E_CCS17                    559- 562   ///
      int    E_CCS18                    563- 566   ///
      int    E_CCS19                    567- 570   ///
      int    E_CCS20                    571- 574   ///
      int    E_CCS21                    575- 578   ///
      int    E_CCS22                    579- 582   ///
      int    E_CCS23                    583- 586   ///
      int    E_CCS24                    587- 590   ///
      int    E_CCS25                    591- 594   ///
      int    E_CCS26                    595- 598   ///
      int    E_CCS27                    599- 602   ///
      int    E_CCS28                    603- 606   ///
      int    E_CCS29                    607- 610   ///
      int    E_CCS30                    611- 614   ///
      str    ECODE1                     615- 621   ///
      str    ECODE2                     622- 628   ///
      str    ECODE3                     629- 635   ///
      str    ECODE4                     636- 642   ///
      str    ECODE5                     643- 649   ///
      str    ECODE6                     650- 656   ///
      str    ECODE7                     657- 663   ///
      str    ECODE8                     664- 670   ///
      str    ECODE9                     671- 677   ///
      str    ECODE10                    678- 684   ///
      str    ECODE11                    685- 691   ///
      str    ECODE12                    692- 698   ///
      str    ECODE13                    699- 705   ///
      str    ECODE14                    706- 712   ///
      str    ECODE15                    713- 719   ///
      str    ECODE16                    720- 726   ///
      str    ECODE17                    727- 733   ///
      str    ECODE18                    734- 740   ///
      str    ECODE19                    741- 747   ///
      str    ECODE20                    748- 754   ///
      str    ECODE21                    755- 761   ///
      str    ECODE22                    762- 768   ///
      str    ECODE23                    769- 775   ///
      str    ECODE24                    776- 782   ///
      str    ECODE25                    783- 789   ///
      str    ECODE26                    790- 796   ///
      str    ECODE27                    797- 803   ///
      str    ECODE28                    804- 810   ///
      str    ECODE29                    811- 817   ///
      str    ECODE30                    818- 824   ///
      byte   FEMALE                     825- 826   ///
      byte   HCUP_ED                    827- 828   ///
      byte   HCUP_OS                    829- 830   ///
      long   HCUP_SURGERY_BROAD_CPT     831- 835   ///
      long   HCUP_SURGERY_BROAD_I9      836- 840   ///
      long   HCUP_SURGERY_NARROW_CPT    841- 845   ///
      long   HCUP_SURGERY_NARROW_I9     846- 850   ///
      byte   Homeless                   851- 852   ///
      int    HOSPBRTH                   853- 855   ///
      str    HOSPST                     856- 857   ///
      double KEY                        858- 872   ///
      long   LOS                        873- 877   ///
      long   LOS_X                      878- 883   ///
      long   MDNUM1_R                   884- 892   ///
      long   MDNUM2_R                   893- 901   ///
      byte   MEDINCSTQ                  902- 903   ///
      long   MRN_R                      904- 912   ///
      int    NCHRONIC                   913- 915   ///
      int    NCPT                       916- 919   ///
      int    NDX                        920- 922   ///
      byte   NECODE                     923- 924   ///
      byte   NEOMAT                     925- 926   ///
      int    NPR                        927- 929   ///
      byte   ORPROC                     930- 931   ///
      byte   PAY1                       932- 933   ///
      str    PAY1_X                     934- 935   ///
      int    PL_CBSA                    936- 938   ///
      byte   PL_NCHS                    939- 940   ///
      byte   PL_RUCC                    941- 942   ///
      byte   PL_UIC                     943- 944   ///
      byte   PL_UR_CAT4                 945- 946   ///
      str    PointOfOrigin_X            947        ///
      str    PointOfOriginUB04          948        ///
      str    PR1                        949- 955   ///
      str    PR2                        956- 962   ///
      str    PR3                        963- 969   ///
      str    PR4                        970- 976   ///
      str    PR5                        977- 983   ///
      str    PR6                        984- 990   ///
      str    PR7                        991- 997   ///
      str    PR8                        998-1004   ///
      str    PR9                       1005-1011   ///
      str    PR10                      1012-1018   ///
      str    PR11                      1019-1025   ///
      str    PR12                      1026-1032   ///
      str    PR13                      1033-1039   ///
      str    PR14                      1040-1046   ///
      str    PR15                      1047-1053   ///
      str    PR16                      1054-1060   ///
      str    PR17                      1061-1067   ///
      str    PR18                      1068-1074   ///
      str    PR19                      1075-1081   ///
      str    PR20                      1082-1088   ///
      str    PR21                      1089-1095   ///
      str    PR22                      1096-1102   ///
      str    PR23                      1103-1109   ///
      str    PR24                      1110-1116   ///
      str    PR25                      1117-1123   ///
      str    PR26                      1124-1130   ///
      str    PR27                      1131-1137   ///
      str    PR28                      1138-1144   ///
      str    PR29                      1145-1151   ///
      str    PR30                      1152-1158   ///
      int    PRCCS1                    1159-1161   ///
      int    PRCCS2                    1162-1164   ///
      int    PRCCS3                    1165-1167   ///
      int    PRCCS4                    1168-1170   ///
      int    PRCCS5                    1171-1173   ///
      int    PRCCS6                    1174-1176   ///
      int    PRCCS7                    1177-1179   ///
      int    PRCCS8                    1180-1182   ///
      int    PRCCS9                    1183-1185   ///
      int    PRCCS10                   1186-1188   ///
      int    PRCCS11                   1189-1191   ///
      int    PRCCS12                   1192-1194   ///
      int    PRCCS13                   1195-1197   ///
      int    PRCCS14                   1198-1200   ///
      int    PRCCS15                   1201-1203   ///
      int    PRCCS16                   1204-1206   ///
      int    PRCCS17                   1207-1209   ///
      int    PRCCS18                   1210-1212   ///
      int    PRCCS19                   1213-1215   ///
      int    PRCCS20                   1216-1218   ///
      int    PRCCS21                   1219-1221   ///
      int    PRCCS22                   1222-1224   ///
      int    PRCCS23                   1225-1227   ///
      int    PRCCS24                   1228-1230   ///
      int    PRCCS25                   1231-1233   ///
      int    PRCCS26                   1234-1236   ///
      int    PRCCS27                   1237-1239   ///
      int    PRCCS28                   1240-1242   ///
      int    PRCCS29                   1243-1245   ///
      int    PRCCS30                   1246-1248   ///
      long   PRDAY1                    1249-1253   ///
      long   PRDAY2                    1254-1258   ///
      long   PRDAY3                    1259-1263   ///
      long   PRDAY4                    1264-1268   ///
      long   PRDAY5                    1269-1273   ///
      long   PRDAY6                    1274-1278   ///
      long   PRDAY7                    1279-1283   ///
      long   PRDAY8                    1284-1288   ///
      long   PRDAY9                    1289-1293   ///
      long   PRDAY10                   1294-1298   ///
      long   PRDAY11                   1299-1303   ///
      long   PRDAY12                   1304-1308   ///
      long   PRDAY13                   1309-1313   ///
      long   PRDAY14                   1314-1318   ///
      long   PRDAY15                   1319-1323   ///
      long   PRDAY16                   1324-1328   ///
      long   PRDAY17                   1329-1333   ///
      long   PRDAY18                   1334-1338   ///
      long   PRDAY19                   1339-1343   ///
      long   PRDAY20                   1344-1348   ///
      long   PRDAY21                   1349-1353   ///
      long   PRDAY22                   1354-1358   ///
      long   PRDAY23                   1359-1363   ///
      long   PRDAY24                   1364-1368   ///
      long   PRDAY25                   1369-1373   ///
      long   PRDAY26                   1374-1378   ///
      long   PRDAY27                   1379-1383   ///
      long   PRDAY28                   1384-1388   ///
      long   PRDAY29                   1389-1393   ///
      long   PRDAY30                   1394-1398   ///
      int    PROCTYPE                  1399-1401   ///
      int    PRVER                     1402-1404   ///
      str    PSTATE                    1405-1406   ///
      long   PSTCO                     1407-1411   ///
      long   PSTCO2                    1412-1416   ///
      byte   RACE                      1417-1418   ///
      str    RACE_X                    1419        ///
      byte   STATE_AS                  1420-1421   ///
      byte   STATE_ED                  1422-1423   ///
      byte   STATE_OS                  1424-1425   ///
      double TOTCHG                    1426-1435   ///
      double TOTCHG_X                  1436-1450   ///
      int    YEAR                      1451-1454   ///
      str    ZIP                       1455-1459   ///
      str    ZIP3                      1460-1462   ///
      int    ZIPINC_QRTL               1463-1465   ///
      int    AYEAR                     1466-1469   ///
      byte   BMONTH                    1470-1471   ///
      int    BYEAR                     1472-1475   ///
      byte   PRMONTH1                  1476-1477   ///
      byte   PRMONTH2                  1478-1479   ///
      byte   PRMONTH3                  1480-1481   ///
      byte   PRMONTH4                  1482-1483   ///
      byte   PRMONTH5                  1484-1485   ///
      byte   PRMONTH6                  1486-1487   ///
      byte   PRMONTH7                  1488-1489   ///
      byte   PRMONTH8                  1490-1491   ///
      byte   PRMONTH9                  1492-1493   ///
      byte   PRMONTH10                 1494-1495   ///
      byte   PRMONTH11                 1496-1497   ///
      byte   PRMONTH12                 1498-1499   ///
      byte   PRMONTH13                 1500-1501   ///
      byte   PRMONTH14                 1502-1503   ///
      byte   PRMONTH15                 1504-1505   ///
      byte   PRMONTH16                 1506-1507   ///
      byte   PRMONTH17                 1508-1509   ///
      byte   PRMONTH18                 1510-1511   ///
      byte   PRMONTH19                 1512-1513   ///
      byte   PRMONTH20                 1514-1515   ///
      byte   PRMONTH21                 1516-1517   ///
      byte   PRMONTH22                 1518-1519   ///
      byte   PRMONTH23                 1520-1521   ///
      byte   PRMONTH24                 1522-1523   ///
      byte   PRMONTH25                 1524-1525   ///
      byte   PRMONTH26                 1526-1527   ///
      byte   PRMONTH27                 1528-1529   ///
      byte   PRMONTH28                 1530-1531   ///
      byte   PRMONTH29                 1532-1533   ///
      byte   PRMONTH30                 1534-1535   ///
      int    PRYEAR1                   1536-1539   ///
      int    PRYEAR2                   1540-1543   ///
      int    PRYEAR3                   1544-1547   ///
      int    PRYEAR4                   1548-1551   ///
      int    PRYEAR5                   1552-1555   ///
      int    PRYEAR6                   1556-1559   ///
      int    PRYEAR7                   1560-1563   ///
      int    PRYEAR8                   1564-1567   ///
      int    PRYEAR9                   1568-1571   ///
      int    PRYEAR10                  1572-1575   ///
      int    PRYEAR11                  1576-1579   ///
      int    PRYEAR12                  1580-1583   ///
      int    PRYEAR13                  1584-1587   ///
      int    PRYEAR14                  1588-1591   ///
      int    PRYEAR15                  1592-1595   ///
      int    PRYEAR16                  1596-1599   ///
      int    PRYEAR17                  1600-1603   ///
      int    PRYEAR18                  1604-1607   ///
      int    PRYEAR19                  1608-1611   ///
      int    PRYEAR20                  1612-1615   ///
      int    PRYEAR21                  1616-1619   ///
      int    PRYEAR22                  1620-1623   ///
      int    PRYEAR23                  1624-1627   ///
      int    PRYEAR24                  1628-1631   ///
      int    PRYEAR25                  1632-1635   ///
      int    PRYEAR26                  1636-1639   ///
      int    PRYEAR27                  1640-1643   ///
      int    PRYEAR28                  1644-1647   ///
      int    PRYEAR29                  1648-1651   ///
      int    PRYEAR30                  1652-1655   ///
      using  "CO_SASD_2015q1q3_CORE.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var CPT1                     "CPT/HCPCS procedure code 1"
label var CPT2                     "CPT/HCPCS procedure code 2"
label var CPT3                     "CPT/HCPCS procedure code 3"
label var CPT4                     "CPT/HCPCS procedure code 4"
label var CPT5                     "CPT/HCPCS procedure code 5"
label var CPT6                     "CPT/HCPCS procedure code 6"
label var CPT7                     "CPT/HCPCS procedure code 7"
label var CPT8                     "CPT/HCPCS procedure code 8"
label var CPT9                     "CPT/HCPCS procedure code 9"
label var CPT10                    "CPT/HCPCS procedure code 10"
label var CPT11                    "CPT/HCPCS procedure code 11"
label var CPT12                    "CPT/HCPCS procedure code 12"
label var CPT13                    "CPT/HCPCS procedure code 13"
label var CPT14                    "CPT/HCPCS procedure code 14"
label var CPT15                    "CPT/HCPCS procedure code 15"
label var CPTCCS1                  "CCS: CPT 1"
label var CPTCCS2                  "CCS: CPT 2"
label var CPTCCS3                  "CCS: CPT 3"
label var CPTCCS4                  "CCS: CPT 4"
label var CPTCCS5                  "CCS: CPT 5"
label var CPTCCS6                  "CCS: CPT 6"
label var CPTCCS7                  "CCS: CPT 7"
label var CPTCCS8                  "CCS: CPT 8"
label var CPTCCS9                  "CCS: CPT 9"
label var CPTCCS10                 "CCS: CPT 10"
label var CPTCCS11                 "CCS: CPT 11"
label var CPTCCS12                 "CCS: CPT 12"
label var CPTCCS13                 "CCS: CPT 13"
label var CPTCCS14                 "CCS: CPT 14"
label var CPTCCS15                 "CCS: CPT 15"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DSHOSPID                 "Data source hospital identifier"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DX10                     "Diagnosis 10"
label var DX11                     "Diagnosis 11"
label var DX12                     "Diagnosis 12"
label var DX13                     "Diagnosis 13"
label var DX14                     "Diagnosis 14"
label var DX15                     "Diagnosis 15"
label var DX16                     "Diagnosis 16"
label var DX17                     "Diagnosis 17"
label var DX18                     "Diagnosis 18"
label var DX19                     "Diagnosis 19"
label var DX20                     "Diagnosis 20"
label var DX21                     "Diagnosis 21"
label var DX22                     "Diagnosis 22"
label var DX23                     "Diagnosis 23"
label var DX24                     "Diagnosis 24"
label var DX25                     "Diagnosis 25"
label var DX26                     "Diagnosis 26"
label var DX27                     "Diagnosis 27"
label var DX28                     "Diagnosis 28"
label var DX29                     "Diagnosis 29"
label var DX30                     "Diagnosis 30"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXCCS10                  "CCS: diagnosis 10"
label var DXCCS11                  "CCS: diagnosis 11"
label var DXCCS12                  "CCS: diagnosis 12"
label var DXCCS13                  "CCS: diagnosis 13"
label var DXCCS14                  "CCS: diagnosis 14"
label var DXCCS15                  "CCS: diagnosis 15"
label var DXCCS16                  "CCS: diagnosis 16"
label var DXCCS17                  "CCS: diagnosis 17"
label var DXCCS18                  "CCS: diagnosis 18"
label var DXCCS19                  "CCS: diagnosis 19"
label var DXCCS20                  "CCS: diagnosis 20"
label var DXCCS21                  "CCS: diagnosis 21"
label var DXCCS22                  "CCS: diagnosis 22"
label var DXCCS23                  "CCS: diagnosis 23"
label var DXCCS24                  "CCS: diagnosis 24"
label var DXCCS25                  "CCS: diagnosis 25"
label var DXCCS26                  "CCS: diagnosis 26"
label var DXCCS27                  "CCS: diagnosis 27"
label var DXCCS28                  "CCS: diagnosis 28"
label var DXCCS29                  "CCS: diagnosis 29"
label var DXCCS30                  "CCS: diagnosis 30"
label var DXVER                    "Diagnosis Version"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var E_CCS5                   "CCS: E Code 5"
label var E_CCS6                   "CCS: E Code 6"
label var E_CCS7                   "CCS: E Code 7"
label var E_CCS8                   "CCS: E Code 8"
label var E_CCS9                   "CCS: E Code 9"
label var E_CCS10                  "CCS: E Code 10"
label var E_CCS11                  "CCS: E Code 11"
label var E_CCS12                  "CCS: E Code 12"
label var E_CCS13                  "CCS: E Code 13"
label var E_CCS14                  "CCS: E Code 14"
label var E_CCS15                  "CCS: E Code 15"
label var E_CCS16                  "CCS: E Code 16"
label var E_CCS17                  "CCS: E Code 17"
label var E_CCS18                  "CCS: E Code 18"
label var E_CCS19                  "CCS: E Code 19"
label var E_CCS20                  "CCS: E Code 20"
label var E_CCS21                  "CCS: E Code 21"
label var E_CCS22                  "CCS: E Code 22"
label var E_CCS23                  "CCS: E Code 23"
label var E_CCS24                  "CCS: E Code 24"
label var E_CCS25                  "CCS: E Code 25"
label var E_CCS26                  "CCS: E Code 26"
label var E_CCS27                  "CCS: E Code 27"
label var E_CCS28                  "CCS: E Code 28"
label var E_CCS29                  "CCS: E Code 29"
label var E_CCS30                  "CCS: E Code 30"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ECODE5                   "E code 5"
label var ECODE6                   "E code 6"
label var ECODE7                   "E code 7"
label var ECODE8                   "E code 8"
label var ECODE9                   "E code 9"
label var ECODE10                  "E code 10"
label var ECODE11                  "E code 11"
label var ECODE12                  "E code 12"
label var ECODE13                  "E code 13"
label var ECODE14                  "E code 14"
label var ECODE15                  "E code 15"
label var ECODE16                  "E code 16"
label var ECODE17                  "E code 17"
label var ECODE18                  "E code 18"
label var ECODE19                  "E code 19"
label var ECODE20                  "E code 20"
label var ECODE21                  "E code 21"
label var ECODE22                  "E code 22"
label var ECODE23                  "E code 23"
label var ECODE24                  "E code 24"
label var ECODE25                  "E code 25"
label var ECODE26                  "E code 26"
label var ECODE27                  "E code 27"
label var ECODE28                  "E code 28"
label var ECODE29                  "E code 29"
label var ECODE30                  "E code 30"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HCUP_SURGERY_BROAD_CPT   "Number of reported CPT procedures that qualify as a surgery using a broad definition"
label var HCUP_SURGERY_BROAD_I9    "Number of reported ICD-9-CM procedures that qualify as a surgery using a broad definition"
label var HCUP_SURGERY_NARROW_CPT  "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
label var HCUP_SURGERY_NARROW_I9   "Number of reported ICD-9-CM procedures that qualify as a surgery using a narrow definition"
label var Homeless                 "Indicator that patient is homeless"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSPST                   "Hospital state postal code"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var MRN_R                    "Medical record number (re-identified)"
label var NCHRONIC                 "Number of chronic conditions"
label var NCPT                     "Number of CPT/HCPCS procedures for this visit"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes(RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PR7                      "Procedure 7"
label var PR8                      "Procedure 8"
label var PR9                      "Procedure 9"
label var PR10                     "Procedure 10"
label var PR11                     "Procedure 11"
label var PR12                     "Procedure 12"
label var PR13                     "Procedure 13"
label var PR14                     "Procedure 14"
label var PR15                     "Procedure 15"
label var PR16                     "Procedure 16"
label var PR17                     "Procedure 17"
label var PR18                     "Procedure 18"
label var PR19                     "Procedure 19"
label var PR20                     "Procedure 20"
label var PR21                     "Procedure 21"
label var PR22                     "Procedure 22"
label var PR23                     "Procedure 23"
label var PR24                     "Procedure 24"
label var PR25                     "Procedure 25"
label var PR26                     "Procedure 26"
label var PR27                     "Procedure 27"
label var PR28                     "Procedure 28"
label var PR29                     "Procedure 29"
label var PR30                     "Procedure 30"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRCCS7                   "CCS: procedure 7"
label var PRCCS8                   "CCS: procedure 8"
label var PRCCS9                   "CCS: procedure 9"
label var PRCCS10                  "CCS: procedure 10"
label var PRCCS11                  "CCS: procedure 11"
label var PRCCS12                  "CCS: procedure 12"
label var PRCCS13                  "CCS: procedure 13"
label var PRCCS14                  "CCS: procedure 14"
label var PRCCS15                  "CCS: procedure 15"
label var PRCCS16                  "CCS: procedure 16"
label var PRCCS17                  "CCS: procedure 17"
label var PRCCS18                  "CCS: procedure 18"
label var PRCCS19                  "CCS: procedure 19"
label var PRCCS20                  "CCS: procedure 20"
label var PRCCS21                  "CCS: procedure 21"
label var PRCCS22                  "CCS: procedure 22"
label var PRCCS23                  "CCS: procedure 23"
label var PRCCS24                  "CCS: procedure 24"
label var PRCCS25                  "CCS: procedure 25"
label var PRCCS26                  "CCS: procedure 26"
label var PRCCS27                  "CCS: procedure 27"
label var PRCCS28                  "CCS: procedure 28"
label var PRCCS29                  "CCS: procedure 29"
label var PRCCS30                  "CCS: procedure 30"
label var PRDAY1                   "Number of days from admission to PR1"
label var PRDAY2                   "Number of days from admission to PR2"
label var PRDAY3                   "Number of days from admission to PR3"
label var PRDAY4                   "Number of days from admission to PR4"
label var PRDAY5                   "Number of days from admission to PR5"
label var PRDAY6                   "Number of days from admission to PR6"
label var PRDAY7                   "Number of days from admission to PR7"
label var PRDAY8                   "Number of days from admission to PR8"
label var PRDAY9                   "Number of days from admission to PR9"
label var PRDAY10                  "Number of days from admission to PR10"
label var PRDAY11                  "Number of days from admission to PR11"
label var PRDAY12                  "Number of days from admission to PR12"
label var PRDAY13                  "Number of days from admission to PR13"
label var PRDAY14                  "Number of days from admission to PR14"
label var PRDAY15                  "Number of days from admission to PR15"
label var PRDAY16                  "Number of days from admission to PR16"
label var PRDAY17                  "Number of days from admission to PR17"
label var PRDAY18                  "Number of days from admission to PR18"
label var PRDAY19                  "Number of days from admission to PR19"
label var PRDAY20                  "Number of days from admission to PR20"
label var PRDAY21                  "Number of days from admission to PR21"
label var PRDAY22                  "Number of days from admission to PR22"
label var PRDAY23                  "Number of days from admission to PR23"
label var PRDAY24                  "Number of days from admission to PR24"
label var PRDAY25                  "Number of days from admission to PR25"
label var PRDAY26                  "Number of days from admission to PR26"
label var PRDAY27                  "Number of days from admission to PR27"
label var PRDAY28                  "Number of days from admission to PR28"
label var PRDAY29                  "Number of days from admission to PR29"
label var PRDAY30                  "Number of days from admission to PR30"
label var PROCTYPE                 "Procedure type indicator"
label var PRVER                    "Procedure Version"
label var PSTATE                   "Patient State postal code"
label var PSTCO                    "Patient state/county FIPS code"
label var PSTCO2                   "Patient state/county FIPS code, possibly derived from ZIP Code"
label var RACE                     "Race (uniform)"
label var RACE_X                   "Race (as received from source)"
label var STATE_AS                 "State Ambulatory Surgery service indicator"
label var STATE_ED                 "State Emergency Department service indicator"
label var STATE_OS                 "State Observation Stay service indicator"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var AYEAR                    "Admission year"
label var BMONTH                   "Birth month"
label var BYEAR                    "Birth year"
label var PRMONTH1                 "Month of procedure 1"
label var PRMONTH2                 "Month of procedure 2"
label var PRMONTH3                 "Month of procedure 3"
label var PRMONTH4                 "Month of procedure 4"
label var PRMONTH5                 "Month of procedure 5"
label var PRMONTH6                 "Month of procedure 6"
label var PRMONTH7                 "Month of procedure 7"
label var PRMONTH8                 "Month of procedure 8"
label var PRMONTH9                 "Month of procedure 9"
label var PRMONTH10                "Month of procedure 10"
label var PRMONTH11                "Month of procedure 11"
label var PRMONTH12                "Month of procedure 12"
label var PRMONTH13                "Month of procedure 13"
label var PRMONTH14                "Month of procedure 14"
label var PRMONTH15                "Month of procedure 15"
label var PRMONTH16                "Month of procedure 16"
label var PRMONTH17                "Month of procedure 17"
label var PRMONTH18                "Month of procedure 18"
label var PRMONTH19                "Month of procedure 19"
label var PRMONTH20                "Month of procedure 20"
label var PRMONTH21                "Month of procedure 21"
label var PRMONTH22                "Month of procedure 22"
label var PRMONTH23                "Month of procedure 23"
label var PRMONTH24                "Month of procedure 24"
label var PRMONTH25                "Month of procedure 25"
label var PRMONTH26                "Month of procedure 26"
label var PRMONTH27                "Month of procedure 27"
label var PRMONTH28                "Month of procedure 28"
label var PRMONTH29                "Month of procedure 29"
label var PRMONTH30                "Month of procedure 30"
label var PRYEAR1                  "Year of procedure 1"
label var PRYEAR2                  "Year of procedure 2"
label var PRYEAR3                  "Year of procedure 3"
label var PRYEAR4                  "Year of procedure 4"
label var PRYEAR5                  "Year of procedure 5"
label var PRYEAR6                  "Year of procedure 6"
label var PRYEAR7                  "Year of procedure 7"
label var PRYEAR8                  "Year of procedure 8"
label var PRYEAR9                  "Year of procedure 9"
label var PRYEAR10                 "Year of procedure 10"
label var PRYEAR11                 "Year of procedure 11"
label var PRYEAR12                 "Year of procedure 12"
label var PRYEAR13                 "Year of procedure 13"
label var PRYEAR14                 "Year of procedure 14"
label var PRYEAR15                 "Year of procedure 15"
label var PRYEAR16                 "Year of procedure 16"
label var PRYEAR17                 "Year of procedure 17"
label var PRYEAR18                 "Year of procedure 18"
label var PRYEAR19                 "Year of procedure 19"
label var PRYEAR20                 "Year of procedure 20"
label var PRYEAR21                 "Year of procedure 21"
label var PRYEAR22                 "Year of procedure 22"
label var PRYEAR23                 "Year of procedure 23"
label var PRYEAR24                 "Year of procedure 24"
label var PRYEAR25                 "Year of procedure 25"
label var PRYEAR26                 "Year of procedure 26"
label var PRYEAR27                 "Year of procedure 27"
label var PRYEAR28                 "Year of procedure 28"
label var PRYEAR29                 "Year of procedure 29"
label var PRYEAR30                 "Year of procedure 30"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode CPTCCS1                   (-99 -88 -66=.)
recode CPTCCS2                   (-99 -88 -66=.)
recode CPTCCS3                   (-99 -88 -66=.)
recode CPTCCS4                   (-99 -88 -66=.)
recode CPTCCS5                   (-99 -88 -66=.)
recode CPTCCS6                   (-99 -88 -66=.)
recode CPTCCS7                   (-99 -88 -66=.)
recode CPTCCS8                   (-99 -88 -66=.)
recode CPTCCS9                   (-99 -88 -66=.)
recode CPTCCS10                  (-99 -88 -66=.)
recode CPTCCS11                  (-99 -88 -66=.)
recode CPTCCS12                  (-99 -88 -66=.)
recode CPTCCS13                  (-99 -88 -66=.)
recode CPTCCS14                  (-99 -88 -66=.)
recode CPTCCS15                  (-99 -88 -66=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DXCCS1                    (-999 -888 -666=.)
recode DXCCS2                    (-999 -888 -666=.)
recode DXCCS3                    (-999 -888 -666=.)
recode DXCCS4                    (-999 -888 -666=.)
recode DXCCS5                    (-999 -888 -666=.)
recode DXCCS6                    (-999 -888 -666=.)
recode DXCCS7                    (-999 -888 -666=.)
recode DXCCS8                    (-999 -888 -666=.)
recode DXCCS9                    (-999 -888 -666=.)
recode DXCCS10                   (-999 -888 -666=.)
recode DXCCS11                   (-999 -888 -666=.)
recode DXCCS12                   (-999 -888 -666=.)
recode DXCCS13                   (-999 -888 -666=.)
recode DXCCS14                   (-999 -888 -666=.)
recode DXCCS15                   (-999 -888 -666=.)
recode DXCCS16                   (-999 -888 -666=.)
recode DXCCS17                   (-999 -888 -666=.)
recode DXCCS18                   (-999 -888 -666=.)
recode DXCCS19                   (-999 -888 -666=.)
recode DXCCS20                   (-999 -888 -666=.)
recode DXCCS21                   (-999 -888 -666=.)
recode DXCCS22                   (-999 -888 -666=.)
recode DXCCS23                   (-999 -888 -666=.)
recode DXCCS24                   (-999 -888 -666=.)
recode DXCCS25                   (-999 -888 -666=.)
recode DXCCS26                   (-999 -888 -666=.)
recode DXCCS27                   (-999 -888 -666=.)
recode DXCCS28                   (-999 -888 -666=.)
recode DXCCS29                   (-999 -888 -666=.)
recode DXCCS30                   (-999 -888 -666=.)
recode DXVER                     (-99 -88 -66=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode E_CCS5                    (-999 -888 -666=.)
recode E_CCS6                    (-999 -888 -666=.)
recode E_CCS7                    (-999 -888 -666=.)
recode E_CCS8                    (-999 -888 -666=.)
recode E_CCS9                    (-999 -888 -666=.)
recode E_CCS10                   (-999 -888 -666=.)
recode E_CCS11                   (-999 -888 -666=.)
recode E_CCS12                   (-999 -888 -666=.)
recode E_CCS13                   (-999 -888 -666=.)
recode E_CCS14                   (-999 -888 -666=.)
recode E_CCS15                   (-999 -888 -666=.)
recode E_CCS16                   (-999 -888 -666=.)
recode E_CCS17                   (-999 -888 -666=.)
recode E_CCS18                   (-999 -888 -666=.)
recode E_CCS19                   (-999 -888 -666=.)
recode E_CCS20                   (-999 -888 -666=.)
recode E_CCS21                   (-999 -888 -666=.)
recode E_CCS22                   (-999 -888 -666=.)
recode E_CCS23                   (-999 -888 -666=.)
recode E_CCS24                   (-999 -888 -666=.)
recode E_CCS25                   (-999 -888 -666=.)
recode E_CCS26                   (-999 -888 -666=.)
recode E_CCS27                   (-999 -888 -666=.)
recode E_CCS28                   (-999 -888 -666=.)
recode E_CCS29                   (-999 -888 -666=.)
recode E_CCS30                   (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HCUP_SURGERY_BROAD_CPT    (-9999 -8888 -6666=.)
recode HCUP_SURGERY_BROAD_I9     (-9999 -8888 -6666=.)
recode HCUP_SURGERY_NARROW_CPT   (-9999 -8888 -6666=.)
recode HCUP_SURGERY_NARROW_I9    (-9999 -8888 -6666=.)
recode Homeless                  (-9 -8 -6 -5=.)
recode HOSPBRTH                  (-99 -88 -66=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM2_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode MRN_R                     (-99999999 -88888888 -66666666=.)
recode NCHRONIC                  (-99 -88 -66=.)
recode NCPT                      (-999 -888 -666=.)
recode NDX                       (-99 -88 -66=.)
recode NECODE                    (-9 -8 -6 -5=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NPR                       (-99 -88 -66=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRCCS7                    (-99 -88 -66=.)
recode PRCCS8                    (-99 -88 -66=.)
recode PRCCS9                    (-99 -88 -66=.)
recode PRCCS10                   (-99 -88 -66=.)
recode PRCCS11                   (-99 -88 -66=.)
recode PRCCS12                   (-99 -88 -66=.)
recode PRCCS13                   (-99 -88 -66=.)
recode PRCCS14                   (-99 -88 -66=.)
recode PRCCS15                   (-99 -88 -66=.)
recode PRCCS16                   (-99 -88 -66=.)
recode PRCCS17                   (-99 -88 -66=.)
recode PRCCS18                   (-99 -88 -66=.)
recode PRCCS19                   (-99 -88 -66=.)
recode PRCCS20                   (-99 -88 -66=.)
recode PRCCS21                   (-99 -88 -66=.)
recode PRCCS22                   (-99 -88 -66=.)
recode PRCCS23                   (-99 -88 -66=.)
recode PRCCS24                   (-99 -88 -66=.)
recode PRCCS25                   (-99 -88 -66=.)
recode PRCCS26                   (-99 -88 -66=.)
recode PRCCS27                   (-99 -88 -66=.)
recode PRCCS28                   (-99 -88 -66=.)
recode PRCCS29                   (-99 -88 -66=.)
recode PRCCS30                   (-99 -88 -66=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PRDAY2                    (-9999 -8888 -6666=.)
recode PRDAY3                    (-9999 -8888 -6666=.)
recode PRDAY4                    (-9999 -8888 -6666=.)
recode PRDAY5                    (-9999 -8888 -6666=.)
recode PRDAY6                    (-9999 -8888 -6666=.)
recode PRDAY7                    (-9999 -8888 -6666=.)
recode PRDAY8                    (-9999 -8888 -6666=.)
recode PRDAY9                    (-9999 -8888 -6666=.)
recode PRDAY10                   (-9999 -8888 -6666=.)
recode PRDAY11                   (-9999 -8888 -6666=.)
recode PRDAY12                   (-9999 -8888 -6666=.)
recode PRDAY13                   (-9999 -8888 -6666=.)
recode PRDAY14                   (-9999 -8888 -6666=.)
recode PRDAY15                   (-9999 -8888 -6666=.)
recode PRDAY16                   (-9999 -8888 -6666=.)
recode PRDAY17                   (-9999 -8888 -6666=.)
recode PRDAY18                   (-9999 -8888 -6666=.)
recode PRDAY19                   (-9999 -8888 -6666=.)
recode PRDAY20                   (-9999 -8888 -6666=.)
recode PRDAY21                   (-9999 -8888 -6666=.)
recode PRDAY22                   (-9999 -8888 -6666=.)
recode PRDAY23                   (-9999 -8888 -6666=.)
recode PRDAY24                   (-9999 -8888 -6666=.)
recode PRDAY25                   (-9999 -8888 -6666=.)
recode PRDAY26                   (-9999 -8888 -6666=.)
recode PRDAY27                   (-9999 -8888 -6666=.)
recode PRDAY28                   (-9999 -8888 -6666=.)
recode PRDAY29                   (-9999 -8888 -6666=.)
recode PRDAY30                   (-9999 -8888 -6666=.)
recode PROCTYPE                  (-99 -88 -66=.)
recode PRVER                     (-99 -88 -66=.)
recode PSTCO                     (-9999 -8888 -6666=.)
recode PSTCO2                    (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode STATE_AS                  (-9 -8 -6 -5=.)
recode STATE_ED                  (-9 -8 -6 -5=.)
recode STATE_OS                  (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode BMONTH                    (-9 -8 -6 -5=.)
recode BYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRMONTH2                  (-9 -8 -6 -5=.)
recode PRMONTH3                  (-9 -8 -6 -5=.)
recode PRMONTH4                  (-9 -8 -6 -5=.)
recode PRMONTH5                  (-9 -8 -6 -5=.)
recode PRMONTH6                  (-9 -8 -6 -5=.)
recode PRMONTH7                  (-9 -8 -6 -5=.)
recode PRMONTH8                  (-9 -8 -6 -5=.)
recode PRMONTH9                  (-9 -8 -6 -5=.)
recode PRMONTH10                 (-9 -8 -6 -5=.)
recode PRMONTH11                 (-9 -8 -6 -5=.)
recode PRMONTH12                 (-9 -8 -6 -5=.)
recode PRMONTH13                 (-9 -8 -6 -5=.)
recode PRMONTH14                 (-9 -8 -6 -5=.)
recode PRMONTH15                 (-9 -8 -6 -5=.)
recode PRMONTH16                 (-9 -8 -6 -5=.)
recode PRMONTH17                 (-9 -8 -6 -5=.)
recode PRMONTH18                 (-9 -8 -6 -5=.)
recode PRMONTH19                 (-9 -8 -6 -5=.)
recode PRMONTH20                 (-9 -8 -6 -5=.)
recode PRMONTH21                 (-9 -8 -6 -5=.)
recode PRMONTH22                 (-9 -8 -6 -5=.)
recode PRMONTH23                 (-9 -8 -6 -5=.)
recode PRMONTH24                 (-9 -8 -6 -5=.)
recode PRMONTH25                 (-9 -8 -6 -5=.)
recode PRMONTH26                 (-9 -8 -6 -5=.)
recode PRMONTH27                 (-9 -8 -6 -5=.)
recode PRMONTH28                 (-9 -8 -6 -5=.)
recode PRMONTH29                 (-9 -8 -6 -5=.)
recode PRMONTH30                 (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)
recode PRYEAR2                   (-999 -888 -666=.)
recode PRYEAR3                   (-999 -888 -666=.)
recode PRYEAR4                   (-999 -888 -666=.)
recode PRYEAR5                   (-999 -888 -666=.)
recode PRYEAR6                   (-999 -888 -666=.)
recode PRYEAR7                   (-999 -888 -666=.)
recode PRYEAR8                   (-999 -888 -666=.)
recode PRYEAR9                   (-999 -888 -666=.)
recode PRYEAR10                  (-999 -888 -666=.)
recode PRYEAR11                  (-999 -888 -666=.)
recode PRYEAR12                  (-999 -888 -666=.)
recode PRYEAR13                  (-999 -888 -666=.)
recode PRYEAR14                  (-999 -888 -666=.)
recode PRYEAR15                  (-999 -888 -666=.)
recode PRYEAR16                  (-999 -888 -666=.)
recode PRYEAR17                  (-999 -888 -666=.)
recode PRYEAR18                  (-999 -888 -666=.)
recode PRYEAR19                  (-999 -888 -666=.)
recode PRYEAR20                  (-999 -888 -666=.)
recode PRYEAR21                  (-999 -888 -666=.)
recode PRYEAR22                  (-999 -888 -666=.)
recode PRYEAR23                  (-999 -888 -666=.)
recode PRYEAR24                  (-999 -888 -666=.)
recode PRYEAR25                  (-999 -888 -666=.)
recode PRYEAR26                  (-999 -888 -666=.)
recode PRYEAR27                  (-999 -888 -666=.)
recode PRYEAR28                  (-999 -888 -666=.)
recode PRYEAR29                  (-999 -888 -666=.)
recode PRYEAR30                  (-999 -888 -666=.)

save "CO_SASD_2015q1q3_CORE.dta", replace
