/*****************************************************************************
* Creation Date: 02/26/2018   
* CO_SASD_2016_CORE.Do
* This program will load the 2016 CO ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***
infix 3 firstlineoffile                            ///
      int    AGE                          1-   3   ///
      int    AGEMONTH                     4-   6   ///
      byte   AMONTH                       7-   8   ///
      byte   ATYPE                        9-  10   ///
      byte   AWEEKEND                    11-  12   ///
      str    CPT1                        13-  17   ///
      str    CPT2                        18-  22   ///
      str    CPT3                        23-  27   ///
      str    CPT4                        28-  32   ///
      str    CPT5                        33-  37   ///
      str    CPT6                        38-  42   ///
      str    CPT7                        43-  47   ///
      str    CPT8                        48-  52   ///
      str    CPT9                        53-  57   ///
      str    CPT10                       58-  62   ///
      str    CPT11                       63-  67   ///
      str    CPT12                       68-  72   ///
      str    CPT13                       73-  77   ///
      str    CPT14                       78-  82   ///
      str    CPT15                       83-  87   ///
      int    CPTCCS1                     88-  90   ///
      int    CPTCCS2                     91-  93   ///
      int    CPTCCS3                     94-  96   ///
      int    CPTCCS4                     97-  99   ///
      int    CPTCCS5                    100- 102   ///
      int    CPTCCS6                    103- 105   ///
      int    CPTCCS7                    106- 108   ///
      int    CPTCCS8                    109- 111   ///
      int    CPTCCS9                    112- 114   ///
      int    CPTCCS10                   115- 117   ///
      int    CPTCCS11                   118- 120   ///
      int    CPTCCS12                   121- 123   ///
      int    CPTCCS13                   124- 126   ///
      int    CPTCCS14                   127- 129   ///
      int    CPTCCS15                   130- 132   ///
      byte   DIED                       133- 134   ///
      str    DISP_X                     135- 136   ///
      byte   DISPUB04                   137- 138   ///
      byte   DISPUNIFORM                139- 140   ///
      byte   DMONTH                     141- 142   ///
      byte   DQTR                       143- 144   ///
      str    DSHOSPID                   145- 161   ///
      int    DXVER                      162- 164   ///
      byte   FEMALE                     165- 166   ///
      byte   HCUP_ED                    167- 168   ///
      byte   HCUP_OS                    169- 170   ///
      long   HCUP_SURGERY_BROAD_CPT     171- 175   ///
      long   HCUP_SURGERY_NARROW_CPT    176- 180   ///
      byte   Homeless                   181- 182   ///
      str    HOSPST                     183- 184   ///
      str    I10_DX1                    185- 191   ///
      str    I10_DX2                    192- 198   ///
      str    I10_DX3                    199- 205   ///
      str    I10_DX4                    206- 212   ///
      str    I10_DX5                    213- 219   ///
      str    I10_DX6                    220- 226   ///
      str    I10_DX7                    227- 233   ///
      str    I10_DX8                    234- 240   ///
      str    I10_DX9                    241- 247   ///
      str    I10_DX10                   248- 254   ///
      str    I10_DX11                   255- 261   ///
      str    I10_DX12                   262- 268   ///
      str    I10_DX13                   269- 275   ///
      str    I10_DX14                   276- 282   ///
      str    I10_DX15                   283- 289   ///
      str    I10_DX16                   290- 296   ///
      str    I10_DX17                   297- 303   ///
      str    I10_DX18                   304- 310   ///
      str    I10_DX19                   311- 317   ///
      str    I10_DX20                   318- 324   ///
      str    I10_DX21                   325- 331   ///
      str    I10_DX22                   332- 338   ///
      str    I10_DX23                   339- 345   ///
      str    I10_DX24                   346- 352   ///
      str    I10_DX25                   353- 359   ///
      str    I10_DX26                   360- 366   ///
      str    I10_DX27                   367- 373   ///
      str    I10_DX28                   374- 380   ///
      str    I10_DX29                   381- 387   ///
      str    I10_DX30                   388- 394   ///
      str    I10_DX31                   395- 401   ///
      str    I10_DX32                   402- 408   ///
      str    I10_DX33                   409- 415   ///
      str    I10_ECAUSE1                416- 422   ///
      str    I10_ECAUSE2                423- 429   ///
      str    I10_ECAUSE3                430- 436   ///
      str    I10_ECAUSE4                437- 443   ///
      str    I10_ECAUSE5                444- 450   ///
      str    I10_ECAUSE6                451- 457   ///
      str    I10_ECAUSE7                458- 464   ///
      str    I10_ECAUSE8                465- 471   ///
      str    I10_ECAUSE9                472- 478   ///
      str    I10_ECAUSE10               479- 485   ///
      str    I10_ECAUSE11               486- 492   ///
      str    I10_ECAUSE12               493- 499   ///
      str    I10_ECAUSE13               500- 506   ///
      str    I10_ECAUSE14               507- 513   ///
      str    I10_ECAUSE15               514- 520   ///
      str    I10_ECAUSE16               521- 527   ///
      str    I10_ECAUSE17               528- 534   ///
      str    I10_ECAUSE18               535- 541   ///
      str    I10_ECAUSE19               542- 548   ///
      str    I10_ECAUSE20               549- 555   ///
      str    I10_ECAUSE21               556- 562   ///
      str    I10_ECAUSE22               563- 569   ///
      str    I10_ECAUSE23               570- 576   ///
      str    I10_ECAUSE24               577- 583   ///
      str    I10_ECAUSE25               584- 590   ///
      str    I10_ECAUSE26               591- 597   ///
      str    I10_ECAUSE27               598- 604   ///
      str    I10_ECAUSE28               605- 611   ///
      str    I10_ECAUSE29               612- 618   ///
      str    I10_ECAUSE30               619- 625   ///
      str    I10_ECAUSE31               626- 632   ///
      str    I10_ECAUSE32               633- 639   ///
      int    I10_NDX                    640- 642   ///
      byte   I10_NECAUSE                643- 644   ///
      int    I10_NPR                    645- 647   ///
      str    I10_PR1                    648- 654   ///
      str    I10_PR2                    655- 661   ///
      str    I10_PR3                    662- 668   ///
      str    I10_PR4                    669- 675   ///
      str    I10_PR5                    676- 682   ///
      str    I10_PR6                    683- 689   ///
      str    I10_PR7                    690- 696   ///
      str    I10_PR8                    697- 703   ///
      str    I10_PR9                    704- 710   ///
      str    I10_PR10                   711- 717   ///
      str    I10_PR11                   718- 724   ///
      str    I10_PR12                   725- 731   ///
      str    I10_PR13                   732- 738   ///
      str    I10_PR14                   739- 745   ///
      str    I10_PR15                   746- 752   ///
      str    I10_PR16                   753- 759   ///
      str    I10_PR17                   760- 766   ///
      str    I10_PR18                   767- 773   ///
      str    I10_PR19                   774- 780   ///
      str    I10_PR20                   781- 787   ///
      int    I10_PROCTYPE               788- 790   ///
      double KEY                        791- 805   ///
      long   LOS                        806- 810   ///
      long   LOS_X                      811- 816   ///
      long   MDNUM1_R                   817- 825   ///
      long   MDNUM2_R                   826- 834   ///
      byte   MEDINCSTQ                  835- 836   ///
      int    NCPT                       837- 840   ///
      byte   PAY1                       841- 842   ///
      str    PAY1_X                     843- 844   ///
      int    PL_CBSA                    845- 847   ///
      byte   PL_NCHS                    848- 849   ///
      byte   PL_RUCC                    850- 851   ///
      byte   PL_UIC                     852- 853   ///
      byte   PL_UR_CAT4                 854- 855   ///
      str    PointOfOrigin_X            856        ///
      str    PointOfOriginUB04          857        ///
      long   PRDAY1                     858- 862   ///
      long   PRDAY2                     863- 867   ///
      long   PRDAY3                     868- 872   ///
      long   PRDAY4                     873- 877   ///
      long   PRDAY5                     878- 882   ///
      long   PRDAY6                     883- 887   ///
      long   PRDAY7                     888- 892   ///
      long   PRDAY8                     893- 897   ///
      long   PRDAY9                     898- 902   ///
      long   PRDAY10                    903- 907   ///
      long   PRDAY11                    908- 912   ///
      long   PRDAY12                    913- 917   ///
      long   PRDAY13                    918- 922   ///
      long   PRDAY14                    923- 927   ///
      long   PRDAY15                    928- 932   ///
      long   PRDAY16                    933- 937   ///
      long   PRDAY17                    938- 942   ///
      long   PRDAY18                    943- 947   ///
      long   PRDAY19                    948- 952   ///
      long   PRDAY20                    953- 957   ///
      int    PRVER                      958- 960   ///
      str    PSTATE                     961- 962   ///
      long   PSTCO                      963- 967   ///
      long   PSTCO2                     968- 972   ///
      byte   RACE                       973- 974   ///
      str    RACE_X                     975        ///
      byte   STATE_AS                   976- 977   ///
      byte   STATE_ED                   978- 979   ///
      byte   STATE_OS                   980- 981   ///
      double TOTCHG                     982- 991   ///
      double TOTCHG_X                   992-1006   ///
      int    YEAR                      1007-1010   ///
      str    ZIP                       1011-1015   ///
      str    ZIP3                      1016-1018   ///
      int    ZIPINC_QRTL               1019-1021   ///
      int    AYEAR                     1022-1025   ///
      byte   BMONTH                    1026-1027   ///
      int    BYEAR                     1028-1031   ///
      byte   PRMONTH1                  1032-1033   ///
      byte   PRMONTH2                  1034-1035   ///
      byte   PRMONTH3                  1036-1037   ///
      byte   PRMONTH4                  1038-1039   ///
      byte   PRMONTH5                  1040-1041   ///
      byte   PRMONTH6                  1042-1043   ///
      byte   PRMONTH7                  1044-1045   ///
      byte   PRMONTH8                  1046-1047   ///
      byte   PRMONTH9                  1048-1049   ///
      byte   PRMONTH10                 1050-1051   ///
      byte   PRMONTH11                 1052-1053   ///
      byte   PRMONTH12                 1054-1055   ///
      byte   PRMONTH13                 1056-1057   ///
      byte   PRMONTH14                 1058-1059   ///
      byte   PRMONTH15                 1060-1061   ///
      byte   PRMONTH16                 1062-1063   ///
      byte   PRMONTH17                 1064-1065   ///
      byte   PRMONTH18                 1066-1067   ///
      byte   PRMONTH19                 1068-1069   ///
      byte   PRMONTH20                 1070-1071   ///
      int    PRYEAR1                   1072-1075   ///
      int    PRYEAR2                   1076-1079   ///
      int    PRYEAR3                   1080-1083   ///
      int    PRYEAR4                   1084-1087   ///
      int    PRYEAR5                   1088-1091   ///
      int    PRYEAR6                   1092-1095   ///
      int    PRYEAR7                   1096-1099   ///
      int    PRYEAR8                   1100-1103   ///
      int    PRYEAR9                   1104-1107   ///
      int    PRYEAR10                  1108-1111   ///
      int    PRYEAR11                  1112-1115   ///
      int    PRYEAR12                  1116-1119   ///
      int    PRYEAR13                  1120-1123   ///
      int    PRYEAR14                  1124-1127   ///
      int    PRYEAR15                  1128-1131   ///
      int    PRYEAR16                  1132-1135   ///
      int    PRYEAR17                  1136-1139   ///
      int    PRYEAR18                  1140-1143   ///
      int    PRYEAR19                  1144-1147   ///
      int    PRYEAR20                  1148-1151   ///
      using  "CO_SASD_2016_CORE.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var ATYPE                    "Admission type"
label var AWEEKEND                 "Admission day is a weekend"
label var CPT1                     "CPT/HCPCS procedure code 1"
label var CPT2                     "CPT/HCPCS procedure code 2"
label var CPT3                     "CPT/HCPCS procedure code 3"
label var CPT4                     "CPT/HCPCS procedure code 4"
label var CPT5                     "CPT/HCPCS procedure code 5"
label var CPT6                     "CPT/HCPCS procedure code 6"
label var CPT7                     "CPT/HCPCS procedure code 7"
label var CPT8                     "CPT/HCPCS procedure code 8"
label var CPT9                     "CPT/HCPCS procedure code 9"
label var CPT10                    "CPT/HCPCS procedure code 10"
label var CPT11                    "CPT/HCPCS procedure code 11"
label var CPT12                    "CPT/HCPCS procedure code 12"
label var CPT13                    "CPT/HCPCS procedure code 13"
label var CPT14                    "CPT/HCPCS procedure code 14"
label var CPT15                    "CPT/HCPCS procedure code 15"
label var CPTCCS1                  "CCS: CPT 1"
label var CPTCCS2                  "CCS: CPT 2"
label var CPTCCS3                  "CCS: CPT 3"
label var CPTCCS4                  "CCS: CPT 4"
label var CPTCCS5                  "CCS: CPT 5"
label var CPTCCS6                  "CCS: CPT 6"
label var CPTCCS7                  "CCS: CPT 7"
label var CPTCCS8                  "CCS: CPT 8"
label var CPTCCS9                  "CCS: CPT 9"
label var CPTCCS10                 "CCS: CPT 10"
label var CPTCCS11                 "CCS: CPT 11"
label var CPTCCS12                 "CCS: CPT 12"
label var CPTCCS13                 "CCS: CPT 13"
label var CPTCCS14                 "CCS: CPT 14"
label var CPTCCS15                 "CCS: CPT 15"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DSHOSPID                 "Data source hospital identifier"
label var DXVER                    "Diagnosis Version"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HCUP_SURGERY_BROAD_CPT   "Number of reported CPT procedures that qualify as a surgery using a broad definition"
label var HCUP_SURGERY_NARROW_CPT  "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
label var Homeless                 "Indicator that patient is homeless"
label var HOSPST                   "Hospital state postal code"
label var I10_DX1                  "ICD-10-CM Diagnosis 1"
label var I10_DX2                  "ICD-10-CM Diagnosis 2"
label var I10_DX3                  "ICD-10-CM Diagnosis 3"
label var I10_DX4                  "ICD-10-CM Diagnosis 4"
label var I10_DX5                  "ICD-10-CM Diagnosis 5"
label var I10_DX6                  "ICD-10-CM Diagnosis 6"
label var I10_DX7                  "ICD-10-CM Diagnosis 7"
label var I10_DX8                  "ICD-10-CM Diagnosis 8"
label var I10_DX9                  "ICD-10-CM Diagnosis 9"
label var I10_DX10                 "ICD-10-CM Diagnosis 10"
label var I10_DX11                 "ICD-10-CM Diagnosis 11"
label var I10_DX12                 "ICD-10-CM Diagnosis 12"
label var I10_DX13                 "ICD-10-CM Diagnosis 13"
label var I10_DX14                 "ICD-10-CM Diagnosis 14"
label var I10_DX15                 "ICD-10-CM Diagnosis 15"
label var I10_DX16                 "ICD-10-CM Diagnosis 16"
label var I10_DX17                 "ICD-10-CM Diagnosis 17"
label var I10_DX18                 "ICD-10-CM Diagnosis 18"
label var I10_DX19                 "ICD-10-CM Diagnosis 19"
label var I10_DX20                 "ICD-10-CM Diagnosis 20"
label var I10_DX21                 "ICD-10-CM Diagnosis 21"
label var I10_DX22                 "ICD-10-CM Diagnosis 22"
label var I10_DX23                 "ICD-10-CM Diagnosis 23"
label var I10_DX24                 "ICD-10-CM Diagnosis 24"
label var I10_DX25                 "ICD-10-CM Diagnosis 25"
label var I10_DX26                 "ICD-10-CM Diagnosis 26"
label var I10_DX27                 "ICD-10-CM Diagnosis 27"
label var I10_DX28                 "ICD-10-CM Diagnosis 28"
label var I10_DX29                 "ICD-10-CM Diagnosis 29"
label var I10_DX30                 "ICD-10-CM Diagnosis 30"
label var I10_DX31                 "ICD-10-CM Diagnosis 31"
label var I10_DX32                 "ICD-10-CM Diagnosis 32"
label var I10_DX33                 "ICD-10-CM Diagnosis 33"
label var I10_ECAUSE1              "ICD-10-CM External cause 1"
label var I10_ECAUSE2              "ICD-10-CM External cause 2"
label var I10_ECAUSE3              "ICD-10-CM External cause 3"
label var I10_ECAUSE4              "ICD-10-CM External cause 4"
label var I10_ECAUSE5              "ICD-10-CM External cause 5"
label var I10_ECAUSE6              "ICD-10-CM External cause 6"
label var I10_ECAUSE7              "ICD-10-CM External cause 7"
label var I10_ECAUSE8              "ICD-10-CM External cause 8"
label var I10_ECAUSE9              "ICD-10-CM External cause 9"
label var I10_ECAUSE10             "ICD-10-CM External cause 10"
label var I10_ECAUSE11             "ICD-10-CM External cause 11"
label var I10_ECAUSE12             "ICD-10-CM External cause 12"
label var I10_ECAUSE13             "ICD-10-CM External cause 13"
label var I10_ECAUSE14             "ICD-10-CM External cause 14"
label var I10_ECAUSE15             "ICD-10-CM External cause 15"
label var I10_ECAUSE16             "ICD-10-CM External cause 16"
label var I10_ECAUSE17             "ICD-10-CM External cause 17"
label var I10_ECAUSE18             "ICD-10-CM External cause 18"
label var I10_ECAUSE19             "ICD-10-CM External cause 19"
label var I10_ECAUSE20             "ICD-10-CM External cause 20"
label var I10_ECAUSE21             "ICD-10-CM External cause 21"
label var I10_ECAUSE22             "ICD-10-CM External cause 22"
label var I10_ECAUSE23             "ICD-10-CM External cause 23"
label var I10_ECAUSE24             "ICD-10-CM External cause 24"
label var I10_ECAUSE25             "ICD-10-CM External cause 25"
label var I10_ECAUSE26             "ICD-10-CM External cause 26"
label var I10_ECAUSE27             "ICD-10-CM External cause 27"
label var I10_ECAUSE28             "ICD-10-CM External cause 28"
label var I10_ECAUSE29             "ICD-10-CM External cause 29"
label var I10_ECAUSE30             "ICD-10-CM External cause 30"
label var I10_ECAUSE31             "ICD-10-CM External cause 31"
label var I10_ECAUSE32             "ICD-10-CM External cause 32"
label var I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
label var I10_NECAUSE              "ICD-10-CM Number of External cause codes on this record"
label var I10_NPR                  "ICD-10-PCS Number of procedures on this record"
label var I10_PR1                  "ICD-10-PCS Procedure 1"
label var I10_PR2                  "ICD-10-PCS Procedure 2"
label var I10_PR3                  "ICD-10-PCS Procedure 3"
label var I10_PR4                  "ICD-10-PCS Procedure 4"
label var I10_PR5                  "ICD-10-PCS Procedure 5"
label var I10_PR6                  "ICD-10-PCS Procedure 6"
label var I10_PR7                  "ICD-10-PCS Procedure 7"
label var I10_PR8                  "ICD-10-PCS Procedure 8"
label var I10_PR9                  "ICD-10-PCS Procedure 9"
label var I10_PR10                 "ICD-10-PCS Procedure 10"
label var I10_PR11                 "ICD-10-PCS Procedure 11"
label var I10_PR12                 "ICD-10-PCS Procedure 12"
label var I10_PR13                 "ICD-10-PCS Procedure 13"
label var I10_PR14                 "ICD-10-PCS Procedure 14"
label var I10_PR15                 "ICD-10-PCS Procedure 15"
label var I10_PR16                 "ICD-10-PCS Procedure 16"
label var I10_PR17                 "ICD-10-PCS Procedure 17"
label var I10_PR18                 "ICD-10-PCS Procedure 18"
label var I10_PR19                 "ICD-10-PCS Procedure 19"
label var I10_PR20                 "ICD-10-PCS Procedure 20"
label var I10_PROCTYPE             "ICD-10-PCS Procedure type indicator"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MDNUM2_R                 "Physician 2 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var NCPT                     "Number of CPT/HCPCS procedures for this visit"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes(RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PRDAY1                   "Number of days from admission to I10_PR1"
label var PRDAY2                   "Number of days from admission to I10_PR2"
label var PRDAY3                   "Number of days from admission to I10_PR3"
label var PRDAY4                   "Number of days from admission to I10_PR4"
label var PRDAY5                   "Number of days from admission to I10_PR5"
label var PRDAY6                   "Number of days from admission to I10_PR6"
label var PRDAY7                   "Number of days from admission to I10_PR7"
label var PRDAY8                   "Number of days from admission to I10_PR8"
label var PRDAY9                   "Number of days from admission to I10_PR9"
label var PRDAY10                  "Number of days from admission to I10_PR10"
label var PRDAY11                  "Number of days from admission to I10_PR11"
label var PRDAY12                  "Number of days from admission to I10_PR12"
label var PRDAY13                  "Number of days from admission to I10_PR13"
label var PRDAY14                  "Number of days from admission to I10_PR14"
label var PRDAY15                  "Number of days from admission to I10_PR15"
label var PRDAY16                  "Number of days from admission to I10_PR16"
label var PRDAY17                  "Number of days from admission to I10_PR17"
label var PRDAY18                  "Number of days from admission to I10_PR18"
label var PRDAY19                  "Number of days from admission to I10_PR19"
label var PRDAY20                  "Number of days from admission to I10_PR20"
label var PRVER                    "Procedure Version"
label var PSTATE                   "Patient State postal code"
label var PSTCO                    "Patient state/county FIPS code"
label var PSTCO2                   "Patient state/county FIPS code, possibly derived from ZIP Code"
label var RACE                     "Race (uniform)"
label var RACE_X                   "Race (as received from source)"
label var STATE_AS                 "State Ambulatory Surgery service indicator"
label var STATE_ED                 "State Emergency Department service indicator"
label var STATE_OS                 "State Observation Stay service indicator"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var AYEAR                    "Admission year"
label var BMONTH                   "Birth month"
label var BYEAR                    "Birth year"
label var PRMONTH1                 "Month of procedure 1"
label var PRMONTH2                 "Month of procedure 2"
label var PRMONTH3                 "Month of procedure 3"
label var PRMONTH4                 "Month of procedure 4"
label var PRMONTH5                 "Month of procedure 5"
label var PRMONTH6                 "Month of procedure 6"
label var PRMONTH7                 "Month of procedure 7"
label var PRMONTH8                 "Month of procedure 8"
label var PRMONTH9                 "Month of procedure 9"
label var PRMONTH10                "Month of procedure 10"
label var PRMONTH11                "Month of procedure 11"
label var PRMONTH12                "Month of procedure 12"
label var PRMONTH13                "Month of procedure 13"
label var PRMONTH14                "Month of procedure 14"
label var PRMONTH15                "Month of procedure 15"
label var PRMONTH16                "Month of procedure 16"
label var PRMONTH17                "Month of procedure 17"
label var PRMONTH18                "Month of procedure 18"
label var PRMONTH19                "Month of procedure 19"
label var PRMONTH20                "Month of procedure 20"
label var PRYEAR1                  "Year of procedure 1"
label var PRYEAR2                  "Year of procedure 2"
label var PRYEAR3                  "Year of procedure 3"
label var PRYEAR4                  "Year of procedure 4"
label var PRYEAR5                  "Year of procedure 5"
label var PRYEAR6                  "Year of procedure 6"
label var PRYEAR7                  "Year of procedure 7"
label var PRYEAR8                  "Year of procedure 8"
label var PRYEAR9                  "Year of procedure 9"
label var PRYEAR10                 "Year of procedure 10"
label var PRYEAR11                 "Year of procedure 11"
label var PRYEAR12                 "Year of procedure 12"
label var PRYEAR13                 "Year of procedure 13"
label var PRYEAR14                 "Year of procedure 14"
label var PRYEAR15                 "Year of procedure 15"
label var PRYEAR16                 "Year of procedure 16"
label var PRYEAR17                 "Year of procedure 17"
label var PRYEAR18                 "Year of procedure 18"
label var PRYEAR19                 "Year of procedure 19"
label var PRYEAR20                 "Year of procedure 20"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode ATYPE                     (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode CPTCCS1                   (-99 -88 -66=.)
recode CPTCCS2                   (-99 -88 -66=.)
recode CPTCCS3                   (-99 -88 -66=.)
recode CPTCCS4                   (-99 -88 -66=.)
recode CPTCCS5                   (-99 -88 -66=.)
recode CPTCCS6                   (-99 -88 -66=.)
recode CPTCCS7                   (-99 -88 -66=.)
recode CPTCCS8                   (-99 -88 -66=.)
recode CPTCCS9                   (-99 -88 -66=.)
recode CPTCCS10                  (-99 -88 -66=.)
recode CPTCCS11                  (-99 -88 -66=.)
recode CPTCCS12                  (-99 -88 -66=.)
recode CPTCCS13                  (-99 -88 -66=.)
recode CPTCCS14                  (-99 -88 -66=.)
recode CPTCCS15                  (-99 -88 -66=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DXVER                     (-99 -88 -66=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HCUP_SURGERY_BROAD_CPT    (-9999 -8888 -6666=.)
recode HCUP_SURGERY_NARROW_CPT   (-9999 -8888 -6666=.)
recode Homeless                  (-9 -8 -6 -5=.)
recode I10_NDX                   (-99 -88 -66=.)
recode I10_NECAUSE               (-9 -8 -6 -5=.)
recode I10_NPR                   (-99 -88 -66=.)
recode I10_PROCTYPE              (-99 -88 -66=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MDNUM2_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode NCPT                      (-999 -888 -666=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PRDAY2                    (-9999 -8888 -6666=.)
recode PRDAY3                    (-9999 -8888 -6666=.)
recode PRDAY4                    (-9999 -8888 -6666=.)
recode PRDAY5                    (-9999 -8888 -6666=.)
recode PRDAY6                    (-9999 -8888 -6666=.)
recode PRDAY7                    (-9999 -8888 -6666=.)
recode PRDAY8                    (-9999 -8888 -6666=.)
recode PRDAY9                    (-9999 -8888 -6666=.)
recode PRDAY10                   (-9999 -8888 -6666=.)
recode PRDAY11                   (-9999 -8888 -6666=.)
recode PRDAY12                   (-9999 -8888 -6666=.)
recode PRDAY13                   (-9999 -8888 -6666=.)
recode PRDAY14                   (-9999 -8888 -6666=.)
recode PRDAY15                   (-9999 -8888 -6666=.)
recode PRDAY16                   (-9999 -8888 -6666=.)
recode PRDAY17                   (-9999 -8888 -6666=.)
recode PRDAY18                   (-9999 -8888 -6666=.)
recode PRDAY19                   (-9999 -8888 -6666=.)
recode PRDAY20                   (-9999 -8888 -6666=.)
recode PRVER                     (-99 -88 -66=.)
recode PSTCO                     (-9999 -8888 -6666=.)
recode PSTCO2                    (-9999 -8888 -6666=.)
recode RACE                      (-9 -8 -6 -5=.)
recode STATE_AS                  (-9 -8 -6 -5=.)
recode STATE_ED                  (-9 -8 -6 -5=.)
recode STATE_OS                  (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode BMONTH                    (-9 -8 -6 -5=.)
recode BYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRMONTH2                  (-9 -8 -6 -5=.)
recode PRMONTH3                  (-9 -8 -6 -5=.)
recode PRMONTH4                  (-9 -8 -6 -5=.)
recode PRMONTH5                  (-9 -8 -6 -5=.)
recode PRMONTH6                  (-9 -8 -6 -5=.)
recode PRMONTH7                  (-9 -8 -6 -5=.)
recode PRMONTH8                  (-9 -8 -6 -5=.)
recode PRMONTH9                  (-9 -8 -6 -5=.)
recode PRMONTH10                 (-9 -8 -6 -5=.)
recode PRMONTH11                 (-9 -8 -6 -5=.)
recode PRMONTH12                 (-9 -8 -6 -5=.)
recode PRMONTH13                 (-9 -8 -6 -5=.)
recode PRMONTH14                 (-9 -8 -6 -5=.)
recode PRMONTH15                 (-9 -8 -6 -5=.)
recode PRMONTH16                 (-9 -8 -6 -5=.)
recode PRMONTH17                 (-9 -8 -6 -5=.)
recode PRMONTH18                 (-9 -8 -6 -5=.)
recode PRMONTH19                 (-9 -8 -6 -5=.)
recode PRMONTH20                 (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)
recode PRYEAR2                   (-999 -888 -666=.)
recode PRYEAR3                   (-999 -888 -666=.)
recode PRYEAR4                   (-999 -888 -666=.)
recode PRYEAR5                   (-999 -888 -666=.)
recode PRYEAR6                   (-999 -888 -666=.)
recode PRYEAR7                   (-999 -888 -666=.)
recode PRYEAR8                   (-999 -888 -666=.)
recode PRYEAR9                   (-999 -888 -666=.)
recode PRYEAR10                  (-999 -888 -666=.)
recode PRYEAR11                  (-999 -888 -666=.)
recode PRYEAR12                  (-999 -888 -666=.)
recode PRYEAR13                  (-999 -888 -666=.)
recode PRYEAR14                  (-999 -888 -666=.)
recode PRYEAR15                  (-999 -888 -666=.)
recode PRYEAR16                  (-999 -888 -666=.)
recode PRYEAR17                  (-999 -888 -666=.)
recode PRYEAR18                  (-999 -888 -666=.)
recode PRYEAR19                  (-999 -888 -666=.)
recode PRYEAR20                  (-999 -888 -666=.)

save "CO_SASD_2016_CORE.dta", replace
