/*******************************************************************
* Creation Date: 05/13/2016   
*   GA_SEDD_2010_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'GA_SEDD_2010_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BILLTYPE                       16-  19 (A)
 CPT1                           20-  24 (A)
 CPT2                           25-  29 (A)
 CPT3                           30-  34 (A)
 CPT4                           35-  39 (A)
 CPT5                           40-  44 (A)
 CPT6                           45-  49 (A)
 CPT7                           50-  54 (A)
 CPT8                           55-  59 (A)
 CPT9                           60-  64 (A)
 CPT10                          65-  69 (A)
 CPT11                          70-  74 (A)
 CPT12                          75-  79 (A)
 CPT13                          80-  84 (A)
 CPT14                          85-  89 (A)
 CPT15                          90-  94 (A)
 CPT16                          95-  99 (A)
 CPT17                         100- 104 (A)
 CPT18                         105- 109 (A)
 CPT19                         110- 114 (A)
 CPT20                         115- 119 (A)
 CPT21                         120- 124 (A)
 CPT22                         125- 129 (A)
 CPT23                         130- 134 (A)
 CPT24                         135- 139 (A)
 CPT25                         140- 144 (A)
 CPT26                         145- 149 (A)
 CPT27                         150- 154 (A)
 CPT28                         155- 159 (A)
 CPT29                         160- 164 (A)
 CPT30                         165- 169 (A)
 CPTCCS1                       170- 172
 CPTCCS2                       173- 175
 CPTCCS3                       176- 178
 CPTCCS4                       179- 181
 CPTCCS5                       182- 184
 CPTCCS6                       185- 187
 CPTCCS7                       188- 190
 CPTCCS8                       191- 193
 CPTCCS9                       194- 196
 CPTCCS10                      197- 199
 CPTCCS11                      200- 202
 CPTCCS12                      203- 205
 CPTCCS13                      206- 208
 CPTCCS14                      209- 211
 CPTCCS15                      212- 214
 CPTCCS16                      215- 217
 CPTCCS17                      218- 220
 CPTCCS18                      221- 223
 CPTCCS19                      224- 226
 CPTCCS20                      227- 229
 CPTCCS21                      230- 232
 CPTCCS22                      233- 235
 CPTCCS23                      236- 238
 CPTCCS24                      239- 241
 CPTCCS25                      242- 244
 CPTCCS26                      245- 247
 CPTCCS27                      248- 250
 CPTCCS28                      251- 253
 CPTCCS29                      254- 256
 CPTCCS30                      257- 259
 CPTDAY1                       260- 262
 CPTDAY2                       263- 265
 CPTDAY3                       266- 268
 CPTDAY4                       269- 271
 CPTDAY5                       272- 274
 CPTDAY6                       275- 277
 CPTDAY7                       278- 280
 CPTDAY8                       281- 283
 CPTDAY9                       284- 286
 CPTDAY10                      287- 289
 CPTDAY11                      290- 292
 CPTDAY12                      293- 295
 CPTDAY13                      296- 298
 CPTDAY14                      299- 301
 CPTDAY15                      302- 304
 CPTDAY16                      305- 307
 CPTDAY17                      308- 310
 CPTDAY18                      311- 313
 CPTDAY19                      314- 316
 CPTDAY20                      317- 319
 CPTDAY21                      320- 322
 CPTDAY22                      323- 325
 CPTDAY23                      326- 328
 CPTDAY24                      329- 331
 CPTDAY25                      332- 334
 CPTDAY26                      335- 337
 CPTDAY27                      338- 340
 CPTDAY28                      341- 343
 CPTDAY29                      344- 346
 CPTDAY30                      347- 349
 DIED                          350- 351
 DISPUB04                      352- 353
 DISPUNIFORM                   354- 355
 DISP_X                        356- 357 (A)
 DQTR                          358- 359
 DX1                           360- 366 (A)
 DX2                           367- 373 (A)
 DX3                           374- 380 (A)
 DX4                           381- 387 (A)
 DX5                           388- 394 (A)
 DX6                           395- 401 (A)
 DX7                           402- 408 (A)
 DX8                           409- 415 (A)
 DX9                           416- 422 (A)
 DX10                          423- 429 (A)
 DX11                          430- 436 (A)
 DX12                          437- 443 (A)
 DX13                          444- 450 (A)
 DX14                          451- 457 (A)
 DX15                          458- 464 (A)
 DX16                          465- 471 (A)
 DX17                          472- 478 (A)
 DX18                          479- 485 (A)
 DX19                          486- 492 (A)
 DX20                          493- 499 (A)
 DX21                          500- 506 (A)
 DX22                          507- 513 (A)
 DX23                          514- 520 (A)
 DX24                          521- 527 (A)
 DX25                          528- 534 (A)
 DX26                          535- 541 (A)
 DX27                          542- 548 (A)
 DX28                          549- 555 (A)
 DX29                          556- 562 (A)
 DX30                          563- 569 (A)
 DX31                          570- 576 (A)
 DX32                          577- 583 (A)
 DX33                          584- 590 (A)
 DX34                          591- 597 (A)
 DX35                          598- 604 (A)
 DX36                          605- 611 (A)
 DX37                          612- 618 (A)
 DX38                          619- 625 (A)
 DX39                          626- 632 (A)
 DX40                          633- 639 (A)
 DX41                          640- 646 (A)
 DX42                          647- 653 (A)
 DXCCS1                        654- 657
 DXCCS2                        658- 661
 DXCCS3                        662- 665
 DXCCS4                        666- 669
 DXCCS5                        670- 673
 DXCCS6                        674- 677
 DXCCS7                        678- 681
 DXCCS8                        682- 685
 DXCCS9                        686- 689
 DXCCS10                       690- 693
 DXCCS11                       694- 697
 DXCCS12                       698- 701
 DXCCS13                       702- 705
 DXCCS14                       706- 709
 DXCCS15                       710- 713
 DXCCS16                       714- 717
 DXCCS17                       718- 721
 DXCCS18                       722- 725
 DXCCS19                       726- 729
 DXCCS20                       730- 733
 DXCCS21                       734- 737
 DXCCS22                       738- 741
 DXCCS23                       742- 745
 DXCCS24                       746- 749
 DXCCS25                       750- 753
 DXCCS26                       754- 757
 DXCCS27                       758- 761
 DXCCS28                       762- 765
 DXCCS29                       766- 769
 DXCCS30                       770- 773
 DXCCS31                       774- 777
 DXCCS32                       778- 781
 DXCCS33                       782- 785
 DXCCS34                       786- 789
 DXCCS35                       790- 793
 DXCCS36                       794- 797
 DXCCS37                       798- 801
 DXCCS38                       802- 805
 DXCCS39                       806- 809
 DXCCS40                       810- 813
 DXCCS41                       814- 817
 DXCCS42                       818- 821
 DXPOA1                        822     (A)
 DXPOA2                        823     (A)
 DXPOA3                        824     (A)
 DXPOA4                        825     (A)
 DXPOA5                        826     (A)
 DXPOA6                        827     (A)
 DXPOA7                        828     (A)
 DXPOA8                        829     (A)
 DXPOA9                        830     (A)
 DXPOA10                       831     (A)
 DXPOA11                       832     (A)
 DXPOA12                       833     (A)
 DXPOA13                       834     (A)
 DXPOA14                       835     (A)
 DXPOA15                       836     (A)
 DXPOA16                       837     (A)
 DXPOA17                       838     (A)
 DXPOA18                       839     (A)
 DXPOA19                       840     (A)
 DXPOA20                       841     (A)
 DXPOA21                       842     (A)
 DXPOA22                       843     (A)
 DXPOA23                       844     (A)
 DXPOA24                       845     (A)
 DXPOA25                       846     (A)
 DXPOA26                       847     (A)
 DXPOA27                       848     (A)
 DXPOA28                       849     (A)
 DXPOA29                       850     (A)
 DXPOA30                       851     (A)
 DXPOA31                       852     (A)
 DXPOA32                       853     (A)
 DXPOA33                       854     (A)
 DXPOA34                       855     (A)
 DXPOA35                       856     (A)
 DXPOA36                       857     (A)
 DXPOA37                       858     (A)
 DXPOA38                       859     (A)
 DXPOA39                       860     (A)
 DXPOA40                       861     (A)
 DXPOA41                       862     (A)
 DXPOA42                       863     (A)
 DaysToEvent                   864- 869
 ECODE1                        870- 876 (A)
 ECODE2                        877- 883 (A)
 ECODE3                        884- 890 (A)
 ECODE4                        891- 897 (A)
 ECODE5                        898- 904 (A)
 ECODE6                        905- 911 (A)
 ECODE7                        912- 918 (A)
 ECODE8                        919- 925 (A)
 ECODE9                        926- 932 (A)
 ECODE10                       933- 939 (A)
 ECODE11                       940- 946 (A)
 ECODE12                       947- 953 (A)
 ECODE13                       954- 960 (A)
 ECODE14                       961- 967 (A)
 E_CCS1                        968- 971
 E_CCS2                        972- 975
 E_CCS3                        976- 979
 E_CCS4                        980- 983
 E_CCS5                        984- 987
 E_CCS6                        988- 991
 E_CCS7                        992- 995
 E_CCS8                        996- 999
 E_CCS9                       1000-1003
 E_CCS10                      1004-1007
 E_CCS11                      1008-1011
 E_CCS12                      1012-1015
 E_CCS13                      1016-1019
 E_CCS14                      1020-1023
 E_POA1                       1024     (A)
 E_POA2                       1025     (A)
 E_POA3                       1026     (A)
 E_POA4                       1027     (A)
 E_POA5                       1028     (A)
 E_POA6                       1029     (A)
 E_POA7                       1030     (A)
 E_POA8                       1031     (A)
 E_POA9                       1032     (A)
 E_POA10                      1033     (A)
 E_POA11                      1034     (A)
 E_POA12                      1035     (A)
 E_POA13                      1036     (A)
 E_POA14                      1037     (A)
 FEMALE                       1038-1039
 HCUP_AS                      1040-1041
 HCUP_ED                      1042-1043
 HCUP_OS                      1044-1045
 HISPANIC_X                   1046     (A)
 HOSPBRTH                     1047-1049
 HOSPST                       1050-1051 (A)
 Homeless                     1052-1053
 KEY                          1054-1068
 LOS                          1069-1073
 LOS_X                        1074-1079
 MARITALSTATUSUB04            1080     (A)
 MARITALSTATUS_X              1081     (A)
 MDNUM1_R                     1082-1090
 MDNUM2_R                     1091-1099
 MDNUM3_R                     1100-1108
 MDNUM4_R                     1109-1117
 MEDINCSTQ                    1118-1119
 NCHRONIC                     1120-1122
 NCPT                         1123-1126
 NDX                          1127-1129
 NECODE                       1130-1131
 NEOMAT                       1132-1133
 NPR                          1134-1136
 OPservice                    1137-1138 (A)
 ORPROC                       1139-1140
 PAY1                         1141-1142
 PAY1_X                       1143-1146 (A)
 PAY2                         1147-1148
 PAY2_X                       1149-1152 (A)
 PAY3                         1153-1154
 PAY3_X                       1155-1158 (A)
 PL_CBSA                      1159-1161
 PL_MSA1993                   1162-1164
 PL_NCHS2006                  1165-1166
 PL_RUCA10_2005               1167-1168
 PL_RUCA2005                  1169-1172
 PL_RUCA4_2005                1173-1174
 PL_RUCC2003                  1175-1176
 PL_UIC2003                   1177-1178
 PL_UR_CAT4                   1179-1180
 PR1                          1181-1187 (A)
 PR2                          1188-1194 (A)
 PR3                          1195-1201 (A)
 PR4                          1202-1208 (A)
 PR5                          1209-1215 (A)
 PR6                          1216-1222 (A)
 PR7                          1223-1229 (A)
 PR8                          1230-1236 (A)
 PR9                          1237-1243 (A)
 PR10                         1244-1250 (A)
 PR11                         1251-1257 (A)
 PR12                         1258-1264 (A)
 PR13                         1265-1271 (A)
 PR14                         1272-1278 (A)
 PR15                         1279-1285 (A)
 PR16                         1286-1292 (A)
 PR17                         1293-1299 (A)
 PR18                         1300-1306 (A)
 PR19                         1307-1313 (A)
 PR20                         1314-1320 (A)
 PR21                         1321-1327 (A)
 PR22                         1328-1334 (A)
 PR23                         1335-1341 (A)
 PR24                         1342-1348 (A)
 PR25                         1349-1355 (A)
 PRCCS1                       1356-1358
 PRCCS2                       1359-1361
 PRCCS3                       1362-1364
 PRCCS4                       1365-1367
 PRCCS5                       1368-1370
 PRCCS6                       1371-1373
 PRCCS7                       1374-1376
 PRCCS8                       1377-1379
 PRCCS9                       1380-1382
 PRCCS10                      1383-1385
 PRCCS11                      1386-1388
 PRCCS12                      1389-1391
 PRCCS13                      1392-1394
 PRCCS14                      1395-1397
 PRCCS15                      1398-1400
 PRCCS16                      1401-1403
 PRCCS17                      1404-1406
 PRCCS18                      1407-1409
 PRCCS19                      1410-1412
 PRCCS20                      1413-1415
 PRCCS21                      1416-1418
 PRCCS22                      1419-1421
 PRCCS23                      1422-1424
 PRCCS24                      1425-1427
 PRCCS25                      1428-1430
 PRDAY1                       1431-1435
 PRDAY2                       1436-1440
 PRDAY3                       1441-1445
 PRDAY4                       1446-1450
 PRDAY5                       1451-1455
 PRDAY6                       1456-1460
 PRDAY7                       1461-1465
 PRDAY8                       1466-1470
 PRDAY9                       1471-1475
 PRDAY10                      1476-1480
 PRDAY11                      1481-1485
 PRDAY12                      1486-1490
 PRDAY13                      1491-1495
 PRDAY14                      1496-1500
 PRDAY15                      1501-1505
 PRDAY16                      1506-1510
 PRDAY17                      1511-1515
 PRDAY18                      1516-1520
 PRDAY19                      1521-1525
 PRDAY20                      1526-1530
 PRDAY21                      1531-1535
 PRDAY22                      1536-1540
 PRDAY23                      1541-1545
 PRDAY24                      1546-1550
 PRDAY25                      1551-1555
 PROCTYPE                     1556-1558
 PSTATE                       1559-1560 (A)
 PSTCO                        1561-1565
 PSTCO2                       1566-1570
 PointOfOriginUB04            1571     (A)
 PointOfOrigin_X              1572     (A)
 RACE                         1573-1574
 RACE_X                       1575     (A)
 STATE_AS                     1576-1577
 STATE_ED                     1578-1579
 STATE_OS                     1580-1581
 TOTCHG                       1582-1591
 TOTCHG_X                     1592-1606
 VisitLink                    1607-1615
 YEAR                         1616-1619
 ZIP3                         1620-1622 (A)
 ZIPINC_QRTL                  1623-1625
 HOSPID                       1626-1630
 ZIP                          1631-1635 (A)
 AYEAR                        1636-1639
 DMONTH                       1640-1641
 BMONTH                       1642-1643
 BYEAR                        1644-1647
 PRMONTH1                     1648-1649
 PRMONTH2                     1650-1651
 PRMONTH3                     1652-1653
 PRMONTH4                     1654-1655
 PRMONTH5                     1656-1657
 PRMONTH6                     1658-1659
 PRMONTH7                     1660-1661
 PRMONTH8                     1662-1663
 PRMONTH9                     1664-1665
 PRMONTH10                    1666-1667
 PRMONTH11                    1668-1669
 PRMONTH12                    1670-1671
 PRMONTH13                    1672-1673
 PRMONTH14                    1674-1675
 PRMONTH15                    1676-1677
 PRMONTH16                    1678-1679
 PRMONTH17                    1680-1681
 PRMONTH18                    1682-1683
 PRMONTH19                    1684-1685
 PRMONTH20                    1686-1687
 PRMONTH21                    1688-1689
 PRMONTH22                    1690-1691
 PRMONTH23                    1692-1693
 PRMONTH24                    1694-1695
 PRMONTH25                    1696-1697
 PRYEAR1                      1698-1701
 PRYEAR2                      1702-1705
 PRYEAR3                      1706-1709
 PRYEAR4                      1710-1713
 PRYEAR5                      1714-1717
 PRYEAR6                      1718-1721
 PRYEAR7                      1722-1725
 PRYEAR8                      1726-1729
 PRYEAR9                      1730-1733
 PRYEAR10                     1734-1737
 PRYEAR11                     1738-1741
 PRYEAR12                     1742-1745
 PRYEAR13                     1746-1749
 PRYEAR14                     1750-1753
 PRYEAR15                     1754-1757
 PRYEAR16                     1758-1761
 PRYEAR17                     1762-1765
 PRYEAR18                     1766-1769
 PRYEAR19                     1770-1773
 PRYEAR20                     1774-1777
 PRYEAR21                     1778-1781
 PRYEAR22                     1782-1785
 PRYEAR23                     1786-1789
 PRYEAR24                     1790-1793
 PRYEAR25                     1794-1797.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 CPTDAY22                     (F4.0) /
 CPTDAY23                     (F4.0) /
 CPTDAY24                     (F4.0) /
 CPTDAY25                     (F4.0) /
 CPTDAY26                     (F4.0) /
 CPTDAY27                     (F4.0) /
 CPTDAY28                     (F4.0) /
 CPTDAY29                     (F4.0) /
 CPTDAY30                     (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DQTR                         (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 DXCCS19                      (F4.0) /
 DXCCS20                      (F4.0) /
 DXCCS21                      (F4.0) /
 DXCCS22                      (F4.0) /
 DXCCS23                      (F4.0) /
 DXCCS24                      (F4.0) /
 DXCCS25                      (F4.0) /
 DXCCS26                      (F4.0) /
 DXCCS27                      (F4.0) /
 DXCCS28                      (F4.0) /
 DXCCS29                      (F4.0) /
 DXCCS30                      (F4.0) /
 DXCCS31                      (F4.0) /
 DXCCS32                      (F4.0) /
 DXCCS33                      (F4.0) /
 DXCCS34                      (F4.0) /
 DXCCS35                      (F4.0) /
 DXCCS36                      (F4.0) /
 DXCCS37                      (F4.0) /
 DXCCS38                      (F4.0) /
 DXCCS39                      (F4.0) /
 DXCCS40                      (F4.0) /
 DXCCS41                      (F4.0) /
 DXCCS42                      (F4.0) /
 DaysToEvent                  (F8.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 E_CCS9                       (F3.0) /
 E_CCS10                      (F3.0) /
 E_CCS11                      (F3.0) /
 E_CCS12                      (F3.0) /
 E_CCS13                      (F3.0) /
 E_CCS14                      (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_AS                      (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 Homeless                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 NCHRONIC                     (F3.0) /
 NCPT                         (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_MSA1993                   (F3.0) /
 PL_NCHS2006                  (F3.0) /
 PL_RUCA10_2005               (F3.0) /
 PL_RUCA2005                  (F4.1) /
 PL_RUCA4_2005                (F3.0) /
 PL_RUCC2003                  (F3.0) /
 PL_UIC2003                   (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRCCS14                      (F3.0) /
 PRCCS15                      (F3.0) /
 PRCCS16                      (F3.0) /
 PRCCS17                      (F3.0) /
 PRCCS18                      (F3.0) /
 PRCCS19                      (F3.0) /
 PRCCS20                      (F3.0) /
 PRCCS21                      (F3.0) /
 PRCCS22                      (F3.0) /
 PRCCS23                      (F3.0) /
 PRCCS24                      (F3.0) /
 PRCCS25                      (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PROCTYPE                     (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 DMONTH                       (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "UB-92 bill type"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 CPTDAY22                     "Number of days from admission to CPT22"
 CPTDAY23                     "Number of days from admission to CPT23"
 CPTDAY24                     "Number of days from admission to CPT24"
 CPTDAY25                     "Number of days from admission to CPT25"
 CPTDAY26                     "Number of days from admission to CPT26"
 CPTDAY27                     "Number of days from admission to CPT27"
 CPTDAY28                     "Number of days from admission to CPT28"
 CPTDAY29                     "Number of days from admission to CPT29"
 CPTDAY30                     "Number of days from admission to CPT30"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DQTR                         "Discharge quarter"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DX19                         "Diagnosis 19"
 DX20                         "Diagnosis 20"
 DX21                         "Diagnosis 21"
 DX22                         "Diagnosis 22"
 DX23                         "Diagnosis 23"
 DX24                         "Diagnosis 24"
 DX25                         "Diagnosis 25"
 DX26                         "Diagnosis 26"
 DX27                         "Diagnosis 27"
 DX28                         "Diagnosis 28"
 DX29                         "Diagnosis 29"
 DX30                         "Diagnosis 30"
 DX31                         "Diagnosis 31"
 DX32                         "Diagnosis 32"
 DX33                         "Diagnosis 33"
 DX34                         "Diagnosis 34"
 DX35                         "Diagnosis 35"
 DX36                         "Diagnosis 36"
 DX37                         "Diagnosis 37"
 DX38                         "Diagnosis 38"
 DX39                         "Diagnosis 39"
 DX40                         "Diagnosis 40"
 DX41                         "Diagnosis 41"
 DX42                         "Diagnosis 42"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXCCS19                      "CCS: diagnosis 19"
 DXCCS20                      "CCS: diagnosis 20"
 DXCCS21                      "CCS: diagnosis 21"
 DXCCS22                      "CCS: diagnosis 22"
 DXCCS23                      "CCS: diagnosis 23"
 DXCCS24                      "CCS: diagnosis 24"
 DXCCS25                      "CCS: diagnosis 25"
 DXCCS26                      "CCS: diagnosis 26"
 DXCCS27                      "CCS: diagnosis 27"
 DXCCS28                      "CCS: diagnosis 28"
 DXCCS29                      "CCS: diagnosis 29"
 DXCCS30                      "CCS: diagnosis 30"
 DXCCS31                      "CCS: diagnosis 31"
 DXCCS32                      "CCS: diagnosis 32"
 DXCCS33                      "CCS: diagnosis 33"
 DXCCS34                      "CCS: diagnosis 34"
 DXCCS35                      "CCS: diagnosis 35"
 DXCCS36                      "CCS: diagnosis 36"
 DXCCS37                      "CCS: diagnosis 37"
 DXCCS38                      "CCS: diagnosis 38"
 DXCCS39                      "CCS: diagnosis 39"
 DXCCS40                      "CCS: diagnosis 40"
 DXCCS41                      "CCS: diagnosis 41"
 DXCCS42                      "CCS: diagnosis 42"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DaysToEvent                  "Days from 'start date' to admission"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 ECODE9                       "E code 9"
 ECODE10                      "E code 10"
 ECODE11                      "E code 11"
 ECODE12                      "E code 12"
 ECODE13                      "E code 13"
 ECODE14                      "E code 14"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 E_CCS9                       "CCS: E Code 9"
 E_CCS10                      "CCS: E Code 10"
 E_CCS11                      "CCS: E Code 11"
 E_CCS12                      "CCS: E Code 12"
 E_CCS13                      "CCS: E Code 13"
 E_CCS14                      "CCS: E Code 14"
 E_POA1                       "E Code 1, present on admission indicator"
 E_POA2                       "E Code 2, present on admission indicator"
 E_POA3                       "E Code 3, present on admission indicator"
 E_POA4                       "E Code 4, present on admission indicator"
 E_POA5                       "E Code 5, present on admission indicator"
 E_POA6                       "E Code 6, present on admission indicator"
 E_POA7                       "E Code 7, present on admission indicator"
 E_POA8                       "E Code 8, present on admission indicator"
 E_POA9                       "E Code 9, present on admission indicator"
 E_POA10                      "E Code 10, present on admission indicator"
 E_POA11                      "E Code 11, present on admission indicator"
 E_POA12                      "E Code 12, present on admission indicator"
 E_POA13                      "E Code 13, present on admission indicator"
 E_POA14                      "E Code 14, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_AS                      "HCUP Ambulatory Surgery service indicator"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 Homeless                     "Indicator that patient is homeless"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCHRONIC                     "Number of chronic conditions"
 NCPT                         "Number of CPT/HCPCS procedures on this record"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 OPservice                    "Indicator of outpatient service (as received from source)"
 ORPROC                       "Major operating room procedure indicator"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993                   "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006                  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005                  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003                  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003                   "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PR14                         "Procedure 14"
 PR15                         "Procedure 15"
 PR16                         "Procedure 16"
 PR17                         "Procedure 17"
 PR18                         "Procedure 18"
 PR19                         "Procedure 19"
 PR20                         "Procedure 20"
 PR21                         "Procedure 21"
 PR22                         "Procedure 22"
 PR23                         "Procedure 23"
 PR24                         "Procedure 24"
 PR25                         "Procedure 25"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRCCS14                      "CCS: procedure 14"
 PRCCS15                      "CCS: procedure 15"
 PRCCS16                      "CCS: procedure 16"
 PRCCS17                      "CCS: procedure 17"
 PRCCS18                      "CCS: procedure 18"
 PRCCS19                      "CCS: procedure 19"
 PRCCS20                      "CCS: procedure 20"
 PRCCS21                      "CCS: procedure 21"
 PRCCS22                      "CCS: procedure 22"
 PRCCS23                      "CCS: procedure 23"
 PRCCS24                      "CCS: procedure 24"
 PRCCS25                      "CCS: procedure 25"
 PRDAY1                       "Number of days from admission to PR1"
 PRDAY2                       "Number of days from admission to PR2"
 PRDAY3                       "Number of days from admission to PR3"
 PRDAY4                       "Number of days from admission to PR4"
 PRDAY5                       "Number of days from admission to PR5"
 PRDAY6                       "Number of days from admission to PR6"
 PRDAY7                       "Number of days from admission to PR7"
 PRDAY8                       "Number of days from admission to PR8"
 PRDAY9                       "Number of days from admission to PR9"
 PRDAY10                      "Number of days from admission to PR10"
 PRDAY11                      "Number of days from admission to PR11"
 PRDAY12                      "Number of days from admission to PR12"
 PRDAY13                      "Number of days from admission to PR13"
 PRDAY14                      "Number of days from admission to PR14"
 PRDAY15                      "Number of days from admission to PR15"
 PRDAY16                      "Number of days from admission to PR16"
 PRDAY17                      "Number of days from admission to PR17"
 PRDAY18                      "Number of days from admission to PR18"
 PRDAY19                      "Number of days from admission to PR19"
 PRDAY20                      "Number of days from admission to PR20"
 PRDAY21                      "Number of days from admission to PR21"
 PRDAY22                      "Number of days from admission to PR22"
 PRDAY23                      "Number of days from admission to PR23"
 PRDAY24                      "Number of days from admission to PR24"
 PRDAY25                      "Number of days from admission to PR25"
 PROCTYPE                     "Procedure type indicator"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 ZIP                          "Patient ZIP Code"
 AYEAR                        "Admission year"
 DMONTH                       "Discharge month"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'GA_SEDD_2010_CORE.SAV' /COMPRESSED.
