/*******************************************************************
*   NE_SEDD_2009_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NE_SEDD_2009_CHGS.ASC' FIXED / 
 CHARGE                     1-  12
 KEY                       13-  26
 REVCODE                   27-  30 (A)
 SERVDAY                   31-  35
 UNITS                     36-  43.


***  Specify write formats  ***.
FORMATS
 CHARGE                  (F6.2) /
 KEY                     (F8.0) /
 SERVDAY                 (F3.0) /
 UNITS                   (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHARGE                  "Line item charges (as received from source)"
 KEY                     "HCUP record identifier"
 REVCODE                 "Line item revenue code (as received from source)"
 SERVDAY                 "Line item days from admission date"
 UNITS                   "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHARGE
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE SERVDAY
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE UNITS
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).



SAVE OUTFILE = 'NE_SEDD_2009_CHGS.SAV' /COMPRESSED.
