/*******************************************************************
* Creation Date: 07/29/2024   
*   MA_SEDD_2022_CORE.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'MA_SEDD_2022_CORE.asc' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEMONTH                        4-   6
 AHOUR                           7-  10
 AMONTH                         11-  12
 ASOURCE                        13-  14
 ASOURCE_X                      15-  16 (A)
 ATYPE                          17-  18
 AWEEKEND                       19-  20
 CPT1                           21-  25 (A)
 CPT2                           26-  30 (A)
 CPT3                           31-  35 (A)
 CPT4                           36-  40 (A)
 CPT5                           41-  45 (A)
 CPT6                           46-  50 (A)
 CPT7                           51-  55 (A)
 CPT8                           56-  60 (A)
 CPT9                           61-  65 (A)
 CPT10                          66-  70 (A)
 CPT11                          71-  75 (A)
 CPT12                          76-  80 (A)
 CPT13                          81-  85 (A)
 CPT14                          86-  90 (A)
 CPT15                          91-  95 (A)
 CPT16                          96- 100 (A)
 CPT17                         101- 105 (A)
 CPT18                         106- 110 (A)
 CPT19                         111- 115 (A)
 CPT20                         116- 120 (A)
 CPT21                         121- 125 (A)
 CPT22                         126- 130 (A)
 CPT23                         131- 135 (A)
 CPT24                         136- 140 (A)
 CPT25                         141- 145 (A)
 CPT26                         146- 150 (A)
 CPT27                         151- 155 (A)
 CPT28                         156- 160 (A)
 CPT29                         161- 165 (A)
 CPT30                         166- 170 (A)
 CPT31                         171- 175 (A)
 CPT32                         176- 180 (A)
 CPT33                         181- 185 (A)
 CPT34                         186- 190 (A)
 CPT35                         191- 195 (A)
 CPT36                         196- 200 (A)
 CPT37                         201- 205 (A)
 CPT38                         206- 210 (A)
 CPT39                         211- 215 (A)
 CPT40                         216- 220 (A)
 CPT41                         221- 225 (A)
 CPT42                         226- 230 (A)
 CPT43                         231- 235 (A)
 CPT44                         236- 240 (A)
 CPT45                         241- 245 (A)
 CPT46                         246- 250 (A)
 CPT47                         251- 255 (A)
 CPT48                         256- 260 (A)
 CPT49                         261- 265 (A)
 CPT50                         266- 270 (A)
 CPT51                         271- 275 (A)
 CPT52                         276- 280 (A)
 CPT53                         281- 285 (A)
 CPT54                         286- 290 (A)
 CPT55                         291- 295 (A)
 CPT56                         296- 300 (A)
 CPT57                         301- 305 (A)
 CPT58                         306- 310 (A)
 CPT59                         311- 315 (A)
 CPT60                         316- 320 (A)
 CPT61                         321- 325 (A)
 CPT62                         326- 330 (A)
 CPT63                         331- 335 (A)
 CPT64                         336- 340 (A)
 CPT65                         341- 345 (A)
 CPT66                         346- 350 (A)
 CPT67                         351- 355 (A)
 CPT68                         356- 360 (A)
 CPT69                         361- 365 (A)
 CPT70                         366- 370 (A)
 CPT71                         371- 375 (A)
 CPT72                         376- 380 (A)
 CPT73                         381- 385 (A)
 CPT74                         386- 390 (A)
 CPT75                         391- 395 (A)
 CPT76                         396- 400 (A)
 CPT77                         401- 405 (A)
 CPT78                         406- 410 (A)
 CPT79                         411- 415 (A)
 CPT80                         416- 420 (A)
 CPT81                         421- 425 (A)
 CPT82                         426- 430 (A)
 CPT83                         431- 435 (A)
 CPT84                         436- 440 (A)
 CPT85                         441- 445 (A)
 CPT86                         446- 450 (A)
 CPT87                         451- 455 (A)
 CPT88                         456- 460 (A)
 CPT89                         461- 465 (A)
 CPT90                         466- 470 (A)
 CPT91                         471- 475 (A)
 CPT92                         476- 480 (A)
 CPT93                         481- 485 (A)
 CPT94                         486- 490 (A)
 CPT95                         491- 495 (A)
 CPT96                         496- 500 (A)
 CPT97                         501- 505 (A)
 CPT98                         506- 510 (A)
 CPT99                         511- 515 (A)
 CPT100                        516- 520 (A)
 CPT101                        521- 525 (A)
 CPT102                        526- 530 (A)
 CPT103                        531- 535 (A)
 CPT104                        536- 540 (A)
 CPT105                        541- 545 (A)
 CPT106                        546- 550 (A)
 CPT107                        551- 555 (A)
 CPT108                        556- 560 (A)
 CPT109                        561- 565 (A)
 CPT110                        566- 570 (A)
 CPT111                        571- 575 (A)
 CPT112                        576- 580 (A)
 CPT113                        581- 585 (A)
 CPT114                        586- 590 (A)
 CPT115                        591- 595 (A)
 CPT116                        596- 600 (A)
 CPT117                        601- 605 (A)
 CPT118                        606- 610 (A)
 CPT119                        611- 615 (A)
 CPT120                        616- 620 (A)
 CPT121                        621- 625 (A)
 CPT122                        626- 630 (A)
 CPT123                        631- 635 (A)
 CPT124                        636- 640 (A)
 CPT125                        641- 645 (A)
 CPT126                        646- 650 (A)
 CPT127                        651- 655 (A)
 CPT128                        656- 660 (A)
 CPT129                        661- 665 (A)
 CPT130                        666- 670 (A)
 CPT131                        671- 675 (A)
 CPT132                        676- 680 (A)
 CPT133                        681- 685 (A)
 CPT134                        686- 690 (A)
 CPT135                        691- 695 (A)
 CPT136                        696- 700 (A)
 CPT137                        701- 705 (A)
 CPT138                        706- 710 (A)
 CPT139                        711- 715 (A)
 CPT140                        716- 720 (A)
 CPT141                        721- 725 (A)
 CPT142                        726- 730 (A)
 CPT143                        731- 735 (A)
 CPT144                        736- 740 (A)
 CPT145                        741- 745 (A)
 CPT146                        746- 750 (A)
 CPT147                        751- 755 (A)
 CPT148                        756- 760 (A)
 CPT149                        761- 765 (A)
 CPT150                        766- 770 (A)
 CPT151                        771- 775 (A)
 CPT152                        776- 780 (A)
 CPT153                        781- 785 (A)
 CPT154                        786- 790 (A)
 CPT155                        791- 795 (A)
 CPT156                        796- 800 (A)
 CPT157                        801- 805 (A)
 CPT158                        806- 810 (A)
 CPT159                        811- 815 (A)
 CPT160                        816- 820 (A)
 CPT161                        821- 825 (A)
 CPT162                        826- 830 (A)
 CPT163                        831- 835 (A)
 CPT164                        836- 840 (A)
 CPT165                        841- 845 (A)
 CPT166                        846- 850 (A)
 CPT167                        851- 855 (A)
 CPT168                        856- 860 (A)
 CPT169                        861- 865 (A)
 CPT170                        866- 870 (A)
 CPT171                        871- 875 (A)
 CPT172                        876- 880 (A)
 CPT173                        881- 885 (A)
 CPT174                        886- 890 (A)
 CPT175                        891- 895 (A)
 CPT176                        896- 900 (A)
 CPT177                        901- 905 (A)
 CPT178                        906- 910 (A)
 CPT179                        911- 915 (A)
 CPT180                        916- 920 (A)
 CPT181                        921- 925 (A)
 CPT182                        926- 930 (A)
 CPT183                        931- 935 (A)
 CPT184                        936- 940 (A)
 CPT185                        941- 945 (A)
 CPT186                        946- 950 (A)
 CPT187                        951- 955 (A)
 CPT188                        956- 960 (A)
 CPT189                        961- 965 (A)
 CPT190                        966- 970 (A)
 CPT191                        971- 975 (A)
 CPT192                        976- 980 (A)
 CPT193                        981- 985 (A)
 CPT194                        986- 990 (A)
 CPT195                        991- 995 (A)
 CPT196                        996-1000 (A)
 CPT197                       1001-1005 (A)
 CPT198                       1006-1010 (A)
 CPT199                       1011-1015 (A)
 CPT200                       1016-1020 (A)
 CPTCCS1                      1021-1023
 CPTCCS2                      1024-1026
 CPTCCS3                      1027-1029
 CPTCCS4                      1030-1032
 CPTCCS5                      1033-1035
 CPTCCS6                      1036-1038
 CPTCCS7                      1039-1041
 CPTCCS8                      1042-1044
 CPTCCS9                      1045-1047
 CPTCCS10                     1048-1050
 CPTCCS11                     1051-1053
 CPTCCS12                     1054-1056
 CPTCCS13                     1057-1059
 CPTCCS14                     1060-1062
 CPTCCS15                     1063-1065
 CPTCCS16                     1066-1068
 CPTCCS17                     1069-1071
 CPTCCS18                     1072-1074
 CPTCCS19                     1075-1077
 CPTCCS20                     1078-1080
 CPTCCS21                     1081-1083
 CPTCCS22                     1084-1086
 CPTCCS23                     1087-1089
 CPTCCS24                     1090-1092
 CPTCCS25                     1093-1095
 CPTCCS26                     1096-1098
 CPTCCS27                     1099-1101
 CPTCCS28                     1102-1104
 CPTCCS29                     1105-1107
 CPTCCS30                     1108-1110
 CPTCCS31                     1111-1113
 CPTCCS32                     1114-1116
 CPTCCS33                     1117-1119
 CPTCCS34                     1120-1122
 CPTCCS35                     1123-1125
 CPTCCS36                     1126-1128
 CPTCCS37                     1129-1131
 CPTCCS38                     1132-1134
 CPTCCS39                     1135-1137
 CPTCCS40                     1138-1140
 CPTCCS41                     1141-1143
 CPTCCS42                     1144-1146
 CPTCCS43                     1147-1149
 CPTCCS44                     1150-1152
 CPTCCS45                     1153-1155
 CPTCCS46                     1156-1158
 CPTCCS47                     1159-1161
 CPTCCS48                     1162-1164
 CPTCCS49                     1165-1167
 CPTCCS50                     1168-1170
 CPTCCS51                     1171-1173
 CPTCCS52                     1174-1176
 CPTCCS53                     1177-1179
 CPTCCS54                     1180-1182
 CPTCCS55                     1183-1185
 CPTCCS56                     1186-1188
 CPTCCS57                     1189-1191
 CPTCCS58                     1192-1194
 CPTCCS59                     1195-1197
 CPTCCS60                     1198-1200
 CPTCCS61                     1201-1203
 CPTCCS62                     1204-1206
 CPTCCS63                     1207-1209
 CPTCCS64                     1210-1212
 CPTCCS65                     1213-1215
 CPTCCS66                     1216-1218
 CPTCCS67                     1219-1221
 CPTCCS68                     1222-1224
 CPTCCS69                     1225-1227
 CPTCCS70                     1228-1230
 CPTCCS71                     1231-1233
 CPTCCS72                     1234-1236
 CPTCCS73                     1237-1239
 CPTCCS74                     1240-1242
 CPTCCS75                     1243-1245
 CPTCCS76                     1246-1248
 CPTCCS77                     1249-1251
 CPTCCS78                     1252-1254
 CPTCCS79                     1255-1257
 CPTCCS80                     1258-1260
 CPTCCS81                     1261-1263
 CPTCCS82                     1264-1266
 CPTCCS83                     1267-1269
 CPTCCS84                     1270-1272
 CPTCCS85                     1273-1275
 CPTCCS86                     1276-1278
 CPTCCS87                     1279-1281
 CPTCCS88                     1282-1284
 CPTCCS89                     1285-1287
 CPTCCS90                     1288-1290
 CPTCCS91                     1291-1293
 CPTCCS92                     1294-1296
 CPTCCS93                     1297-1299
 CPTCCS94                     1300-1302
 CPTCCS95                     1303-1305
 CPTCCS96                     1306-1308
 CPTCCS97                     1309-1311
 CPTCCS98                     1312-1314
 CPTCCS99                     1315-1317
 CPTCCS100                    1318-1320
 CPTCCS101                    1321-1323
 CPTCCS102                    1324-1326
 CPTCCS103                    1327-1329
 CPTCCS104                    1330-1332
 CPTCCS105                    1333-1335
 CPTCCS106                    1336-1338
 CPTCCS107                    1339-1341
 CPTCCS108                    1342-1344
 CPTCCS109                    1345-1347
 CPTCCS110                    1348-1350
 CPTCCS111                    1351-1353
 CPTCCS112                    1354-1356
 CPTCCS113                    1357-1359
 CPTCCS114                    1360-1362
 CPTCCS115                    1363-1365
 CPTCCS116                    1366-1368
 CPTCCS117                    1369-1371
 CPTCCS118                    1372-1374
 CPTCCS119                    1375-1377
 CPTCCS120                    1378-1380
 CPTCCS121                    1381-1383
 CPTCCS122                    1384-1386
 CPTCCS123                    1387-1389
 CPTCCS124                    1390-1392
 CPTCCS125                    1393-1395
 CPTCCS126                    1396-1398
 CPTCCS127                    1399-1401
 CPTCCS128                    1402-1404
 CPTCCS129                    1405-1407
 CPTCCS130                    1408-1410
 CPTCCS131                    1411-1413
 CPTCCS132                    1414-1416
 CPTCCS133                    1417-1419
 CPTCCS134                    1420-1422
 CPTCCS135                    1423-1425
 CPTCCS136                    1426-1428
 CPTCCS137                    1429-1431
 CPTCCS138                    1432-1434
 CPTCCS139                    1435-1437
 CPTCCS140                    1438-1440
 CPTCCS141                    1441-1443
 CPTCCS142                    1444-1446
 CPTCCS143                    1447-1449
 CPTCCS144                    1450-1452
 CPTCCS145                    1453-1455
 CPTCCS146                    1456-1458
 CPTCCS147                    1459-1461
 CPTCCS148                    1462-1464
 CPTCCS149                    1465-1467
 CPTCCS150                    1468-1470
 CPTCCS151                    1471-1473
 CPTCCS152                    1474-1476
 CPTCCS153                    1477-1479
 CPTCCS154                    1480-1482
 CPTCCS155                    1483-1485
 CPTCCS156                    1486-1488
 CPTCCS157                    1489-1491
 CPTCCS158                    1492-1494
 CPTCCS159                    1495-1497
 CPTCCS160                    1498-1500
 CPTCCS161                    1501-1503
 CPTCCS162                    1504-1506
 CPTCCS163                    1507-1509
 CPTCCS164                    1510-1512
 CPTCCS165                    1513-1515
 CPTCCS166                    1516-1518
 CPTCCS167                    1519-1521
 CPTCCS168                    1522-1524
 CPTCCS169                    1525-1527
 CPTCCS170                    1528-1530
 CPTCCS171                    1531-1533
 CPTCCS172                    1534-1536
 CPTCCS173                    1537-1539
 CPTCCS174                    1540-1542
 CPTCCS175                    1543-1545
 CPTCCS176                    1546-1548
 CPTCCS177                    1549-1551
 CPTCCS178                    1552-1554
 CPTCCS179                    1555-1557
 CPTCCS180                    1558-1560
 CPTCCS181                    1561-1563
 CPTCCS182                    1564-1566
 CPTCCS183                    1567-1569
 CPTCCS184                    1570-1572
 CPTCCS185                    1573-1575
 CPTCCS186                    1576-1578
 CPTCCS187                    1579-1581
 CPTCCS188                    1582-1584
 CPTCCS189                    1585-1587
 CPTCCS190                    1588-1590
 CPTCCS191                    1591-1593
 CPTCCS192                    1594-1596
 CPTCCS193                    1597-1599
 CPTCCS194                    1600-1602
 CPTCCS195                    1603-1605
 CPTCCS196                    1606-1608
 CPTCCS197                    1609-1611
 CPTCCS198                    1612-1614
 CPTCCS199                    1615-1617
 CPTCCS200                    1618-1620
 DaysBetweenVisits            1621-1624
 DaysToEvent                  1625-1630
 DHOUR                        1631-1634
 DIED                         1635-1636
 DISP_X                       1637-1642 (A)
 DISPUNIFORM                  1643-1644
 DMONTH                       1645-1646
 DNR                          1647-1648
 DQTR                         1649-1650
 DSHOSPID                     1651-1667 (A)
 DURATION                     1668-1673
 DXPOA1                       1674     (A)
 DXPOA2                       1675     (A)
 DXPOA3                       1676     (A)
 DXPOA4                       1677     (A)
 DXPOA5                       1678     (A)
 DXPOA6                       1679     (A)
 DXPOA7                       1680     (A)
 DXPOA8                       1681     (A)
 DXPOA9                       1682     (A)
 DXPOA10                      1683     (A)
 DXPOA11                      1684     (A)
 DXPOA12                      1685     (A)
 DXPOA13                      1686     (A)
 DXPOA14                      1687     (A)
 DXPOA15                      1688     (A)
 DXPOA16                      1689     (A)
 DXPOA17                      1690     (A)
 DXPOA18                      1691     (A)
 DXPOA19                      1692     (A)
 DXPOA20                      1693     (A)
 DXPOA21                      1694     (A)
 DXPOA22                      1695     (A)
 DXPOA23                      1696     (A)
 DXPOA24                      1697     (A)
 DXPOA25                      1698     (A)
 DXPOA26                      1699     (A)
 DXPOA27                      1700     (A)
 DXPOA28                      1701     (A)
 DXPOA29                      1702     (A)
 DXPOA30                      1703     (A)
 DXPOA31                      1704     (A)
 DXPOA32                      1705     (A)
 DXPOA33                      1706     (A)
 DXPOA34                      1707     (A)
 DXPOA35                      1708     (A)
 DXPOA36                      1709     (A)
 DXPOA37                      1710     (A)
 DXPOA38                      1711     (A)
 DXPOA39                      1712     (A)
 DXPOA40                      1713     (A)
 DXPOA41                      1714     (A)
 DXPOA42                      1715     (A)
 FEMALE                       1716-1717
 HCUP_ED                      1718-1719
 HCUP_OS                      1720-1721
 HCUP_SURGERY_BROAD_CPT       1722-1726
 HCUP_SURGERY_NARROW_CPT      1727-1731
 HISPANIC                     1732-1733
 HISPANIC_X                   1734-1748 (A)
 Homeless                     1749-1750
 HOSPST                       1751-1752 (A)
 I10_DX1                      1753-1759 (A)
 I10_DX2                      1760-1766 (A)
 I10_DX3                      1767-1773 (A)
 I10_DX4                      1774-1780 (A)
 I10_DX5                      1781-1787 (A)
 I10_DX6                      1788-1794 (A)
 I10_DX7                      1795-1801 (A)
 I10_DX8                      1802-1808 (A)
 I10_DX9                      1809-1815 (A)
 I10_DX10                     1816-1822 (A)
 I10_DX11                     1823-1829 (A)
 I10_DX12                     1830-1836 (A)
 I10_DX13                     1837-1843 (A)
 I10_DX14                     1844-1850 (A)
 I10_DX15                     1851-1857 (A)
 I10_DX16                     1858-1864 (A)
 I10_DX17                     1865-1871 (A)
 I10_DX18                     1872-1878 (A)
 I10_DX19                     1879-1885 (A)
 I10_DX20                     1886-1892 (A)
 I10_DX21                     1893-1899 (A)
 I10_DX22                     1900-1906 (A)
 I10_DX23                     1907-1913 (A)
 I10_DX24                     1914-1920 (A)
 I10_DX25                     1921-1927 (A)
 I10_DX26                     1928-1934 (A)
 I10_DX27                     1935-1941 (A)
 I10_DX28                     1942-1948 (A)
 I10_DX29                     1949-1955 (A)
 I10_DX30                     1956-1962 (A)
 I10_DX31                     1963-1969 (A)
 I10_DX32                     1970-1976 (A)
 I10_DX33                     1977-1983 (A)
 I10_DX34                     1984-1990 (A)
 I10_DX35                     1991-1997 (A)
 I10_DX36                     1998-2004 (A)
 I10_DX37                     2005-2011 (A)
 I10_DX38                     2012-2018 (A)
 I10_DX39                     2019-2025 (A)
 I10_DX40                     2026-2032 (A)
 I10_DX41                     2033-2039 (A)
 I10_DX42                     2040-2046 (A)
 I10_NDX                      2047-2049
 I10_PROCTYPE                 2050-2052
 KEY                          2053-2067
 LOS                          2068-2072
 LOS_X                        2073-2078
 MEDINCSTQ                    2079-2080
 NCPT                         2081-2084
 PAY1                         2085-2086
 PAY1_X                       2087-2088 (A)
 PAY2                         2089-2090
 PAY2_X                       2091-2092 (A)
 PL_CBSA                      2093-2095
 PL_UR_CAT4                   2096-2097
 POA_Disch_Edit1              2098-2099
 POA_Disch_Edit2              2100-2101
 POA_Hosp_Edit1               2102-2103
 POA_Hosp_Edit2               2104-2105
 POA_Hosp_Edit3               2106-2107
 POA_Hosp_Edit3_Value         2108-2115
 PSTATE                       2116-2117 (A)
 PSTATE_GEO                   2118-2119 (A)
 PSTCO_GEO                    2120-2124
 RACE                         2125-2126
 RACE_PCT_MISS_HOSP           2127-2133
 RACE_X                       2134-2138 (A)
 SASD_SEDD                    2139-2140
 STATE_AS                     2141-2142
 STATE_ED                     2143-2144
 STATE_OS                     2145-2146
 TOTCHG                       2147-2156
 TOTCHG_X                     2157-2171
 TransportToHosp              2172-2173
 VisitLink                    2174-2182
 YEAR                         2183-2186
 ZIP3                         2187-2189 (A)
 ZIPINC_QRTL                  2190-2192
 AYEAR                        2193-2196.


/***  Specify write formats  ***/
FORMATS
 AGE                          (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ASOURCE                      (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTCCS77                     (F4.0) /
 CPTCCS78                     (F4.0) /
 CPTCCS79                     (F4.0) /
 CPTCCS80                     (F4.0) /
 CPTCCS81                     (F4.0) /
 CPTCCS82                     (F4.0) /
 CPTCCS83                     (F4.0) /
 CPTCCS84                     (F4.0) /
 CPTCCS85                     (F4.0) /
 CPTCCS86                     (F4.0) /
 CPTCCS87                     (F4.0) /
 CPTCCS88                     (F4.0) /
 CPTCCS89                     (F4.0) /
 CPTCCS90                     (F4.0) /
 CPTCCS91                     (F4.0) /
 CPTCCS92                     (F4.0) /
 CPTCCS93                     (F4.0) /
 CPTCCS94                     (F4.0) /
 CPTCCS95                     (F4.0) /
 CPTCCS96                     (F4.0) /
 CPTCCS97                     (F4.0) /
 CPTCCS98                     (F4.0) /
 CPTCCS99                     (F4.0) /
 CPTCCS100                    (F4.0) /
 CPTCCS101                    (F4.0) /
 CPTCCS102                    (F4.0) /
 CPTCCS103                    (F4.0) /
 CPTCCS104                    (F4.0) /
 CPTCCS105                    (F4.0) /
 CPTCCS106                    (F4.0) /
 CPTCCS107                    (F4.0) /
 CPTCCS108                    (F4.0) /
 CPTCCS109                    (F4.0) /
 CPTCCS110                    (F4.0) /
 CPTCCS111                    (F4.0) /
 CPTCCS112                    (F4.0) /
 CPTCCS113                    (F4.0) /
 CPTCCS114                    (F4.0) /
 CPTCCS115                    (F4.0) /
 CPTCCS116                    (F4.0) /
 CPTCCS117                    (F4.0) /
 CPTCCS118                    (F4.0) /
 CPTCCS119                    (F4.0) /
 CPTCCS120                    (F4.0) /
 CPTCCS121                    (F4.0) /
 CPTCCS122                    (F4.0) /
 CPTCCS123                    (F4.0) /
 CPTCCS124                    (F4.0) /
 CPTCCS125                    (F4.0) /
 CPTCCS126                    (F4.0) /
 CPTCCS127                    (F4.0) /
 CPTCCS128                    (F4.0) /
 CPTCCS129                    (F4.0) /
 CPTCCS130                    (F4.0) /
 CPTCCS131                    (F4.0) /
 CPTCCS132                    (F4.0) /
 CPTCCS133                    (F4.0) /
 CPTCCS134                    (F4.0) /
 CPTCCS135                    (F4.0) /
 CPTCCS136                    (F4.0) /
 CPTCCS137                    (F4.0) /
 CPTCCS138                    (F4.0) /
 CPTCCS139                    (F4.0) /
 CPTCCS140                    (F4.0) /
 CPTCCS141                    (F4.0) /
 CPTCCS142                    (F4.0) /
 CPTCCS143                    (F4.0) /
 CPTCCS144                    (F4.0) /
 CPTCCS145                    (F4.0) /
 CPTCCS146                    (F4.0) /
 CPTCCS147                    (F4.0) /
 CPTCCS148                    (F4.0) /
 CPTCCS149                    (F4.0) /
 CPTCCS150                    (F4.0) /
 CPTCCS151                    (F4.0) /
 CPTCCS152                    (F4.0) /
 CPTCCS153                    (F4.0) /
 CPTCCS154                    (F4.0) /
 CPTCCS155                    (F4.0) /
 CPTCCS156                    (F4.0) /
 CPTCCS157                    (F4.0) /
 CPTCCS158                    (F4.0) /
 CPTCCS159                    (F4.0) /
 CPTCCS160                    (F4.0) /
 CPTCCS161                    (F4.0) /
 CPTCCS162                    (F4.0) /
 CPTCCS163                    (F4.0) /
 CPTCCS164                    (F4.0) /
 CPTCCS165                    (F4.0) /
 CPTCCS166                    (F4.0) /
 CPTCCS167                    (F4.0) /
 CPTCCS168                    (F4.0) /
 CPTCCS169                    (F4.0) /
 CPTCCS170                    (F4.0) /
 CPTCCS171                    (F4.0) /
 CPTCCS172                    (F4.0) /
 CPTCCS173                    (F4.0) /
 CPTCCS174                    (F4.0) /
 CPTCCS175                    (F4.0) /
 CPTCCS176                    (F4.0) /
 CPTCCS177                    (F4.0) /
 CPTCCS178                    (F4.0) /
 CPTCCS179                    (F4.0) /
 CPTCCS180                    (F4.0) /
 CPTCCS181                    (F4.0) /
 CPTCCS182                    (F4.0) /
 CPTCCS183                    (F4.0) /
 CPTCCS184                    (F4.0) /
 CPTCCS185                    (F4.0) /
 CPTCCS186                    (F4.0) /
 CPTCCS187                    (F4.0) /
 CPTCCS188                    (F4.0) /
 CPTCCS189                    (F4.0) /
 CPTCCS190                    (F4.0) /
 CPTCCS191                    (F4.0) /
 CPTCCS192                    (F4.0) /
 CPTCCS193                    (F4.0) /
 CPTCCS194                    (F4.0) /
 CPTCCS195                    (F4.0) /
 CPTCCS196                    (F4.0) /
 CPTCCS197                    (F4.0) /
 CPTCCS198                    (F4.0) /
 CPTCCS199                    (F4.0) /
 CPTCCS200                    (F4.0) /
 DaysBetweenVisits            (F3.0) /
 DaysToEvent                  (F8.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DNR                          (F3.0) /
 DQTR                         (F3.0) /
 DURATION                     (F4.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HCUP_SURGERY_BROAD_CPT       (F3.0) /
 HCUP_SURGERY_NARROW_CPT      (F3.0) /
 HISPANIC                     (F3.0) /
 Homeless                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_PCT_MISS_HOSP           (F4.2) /
 SASD_SEDD                    (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TransportToHosp              (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ASOURCE                      "Admission source (uniform)"
 ASOURCE_X                    "Admission source (as received from source)"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPT77                        "CPT/HCPCS procedure code 77"
 CPT78                        "CPT/HCPCS procedure code 78"
 CPT79                        "CPT/HCPCS procedure code 79"
 CPT80                        "CPT/HCPCS procedure code 80"
 CPT81                        "CPT/HCPCS procedure code 81"
 CPT82                        "CPT/HCPCS procedure code 82"
 CPT83                        "CPT/HCPCS procedure code 83"
 CPT84                        "CPT/HCPCS procedure code 84"
 CPT85                        "CPT/HCPCS procedure code 85"
 CPT86                        "CPT/HCPCS procedure code 86"
 CPT87                        "CPT/HCPCS procedure code 87"
 CPT88                        "CPT/HCPCS procedure code 88"
 CPT89                        "CPT/HCPCS procedure code 89"
 CPT90                        "CPT/HCPCS procedure code 90"
 CPT91                        "CPT/HCPCS procedure code 91"
 CPT92                        "CPT/HCPCS procedure code 92"
 CPT93                        "CPT/HCPCS procedure code 93"
 CPT94                        "CPT/HCPCS procedure code 94"
 CPT95                        "CPT/HCPCS procedure code 95"
 CPT96                        "CPT/HCPCS procedure code 96"
 CPT97                        "CPT/HCPCS procedure code 97"
 CPT98                        "CPT/HCPCS procedure code 98"
 CPT99                        "CPT/HCPCS procedure code 99"
 CPT100                       "CPT/HCPCS procedure code 100"
 CPT101                       "CPT/HCPCS procedure code 101"
 CPT102                       "CPT/HCPCS procedure code 102"
 CPT103                       "CPT/HCPCS procedure code 103"
 CPT104                       "CPT/HCPCS procedure code 104"
 CPT105                       "CPT/HCPCS procedure code 105"
 CPT106                       "CPT/HCPCS procedure code 106"
 CPT107                       "CPT/HCPCS procedure code 107"
 CPT108                       "CPT/HCPCS procedure code 108"
 CPT109                       "CPT/HCPCS procedure code 109"
 CPT110                       "CPT/HCPCS procedure code 110"
 CPT111                       "CPT/HCPCS procedure code 111"
 CPT112                       "CPT/HCPCS procedure code 112"
 CPT113                       "CPT/HCPCS procedure code 113"
 CPT114                       "CPT/HCPCS procedure code 114"
 CPT115                       "CPT/HCPCS procedure code 115"
 CPT116                       "CPT/HCPCS procedure code 116"
 CPT117                       "CPT/HCPCS procedure code 117"
 CPT118                       "CPT/HCPCS procedure code 118"
 CPT119                       "CPT/HCPCS procedure code 119"
 CPT120                       "CPT/HCPCS procedure code 120"
 CPT121                       "CPT/HCPCS procedure code 121"
 CPT122                       "CPT/HCPCS procedure code 122"
 CPT123                       "CPT/HCPCS procedure code 123"
 CPT124                       "CPT/HCPCS procedure code 124"
 CPT125                       "CPT/HCPCS procedure code 125"
 CPT126                       "CPT/HCPCS procedure code 126"
 CPT127                       "CPT/HCPCS procedure code 127"
 CPT128                       "CPT/HCPCS procedure code 128"
 CPT129                       "CPT/HCPCS procedure code 129"
 CPT130                       "CPT/HCPCS procedure code 130"
 CPT131                       "CPT/HCPCS procedure code 131"
 CPT132                       "CPT/HCPCS procedure code 132"
 CPT133                       "CPT/HCPCS procedure code 133"
 CPT134                       "CPT/HCPCS procedure code 134"
 CPT135                       "CPT/HCPCS procedure code 135"
 CPT136                       "CPT/HCPCS procedure code 136"
 CPT137                       "CPT/HCPCS procedure code 137"
 CPT138                       "CPT/HCPCS procedure code 138"
 CPT139                       "CPT/HCPCS procedure code 139"
 CPT140                       "CPT/HCPCS procedure code 140"
 CPT141                       "CPT/HCPCS procedure code 141"
 CPT142                       "CPT/HCPCS procedure code 142"
 CPT143                       "CPT/HCPCS procedure code 143"
 CPT144                       "CPT/HCPCS procedure code 144"
 CPT145                       "CPT/HCPCS procedure code 145"
 CPT146                       "CPT/HCPCS procedure code 146"
 CPT147                       "CPT/HCPCS procedure code 147"
 CPT148                       "CPT/HCPCS procedure code 148"
 CPT149                       "CPT/HCPCS procedure code 149"
 CPT150                       "CPT/HCPCS procedure code 150"
 CPT151                       "CPT/HCPCS procedure code 151"
 CPT152                       "CPT/HCPCS procedure code 152"
 CPT153                       "CPT/HCPCS procedure code 153"
 CPT154                       "CPT/HCPCS procedure code 154"
 CPT155                       "CPT/HCPCS procedure code 155"
 CPT156                       "CPT/HCPCS procedure code 156"
 CPT157                       "CPT/HCPCS procedure code 157"
 CPT158                       "CPT/HCPCS procedure code 158"
 CPT159                       "CPT/HCPCS procedure code 159"
 CPT160                       "CPT/HCPCS procedure code 160"
 CPT161                       "CPT/HCPCS procedure code 161"
 CPT162                       "CPT/HCPCS procedure code 162"
 CPT163                       "CPT/HCPCS procedure code 163"
 CPT164                       "CPT/HCPCS procedure code 164"
 CPT165                       "CPT/HCPCS procedure code 165"
 CPT166                       "CPT/HCPCS procedure code 166"
 CPT167                       "CPT/HCPCS procedure code 167"
 CPT168                       "CPT/HCPCS procedure code 168"
 CPT169                       "CPT/HCPCS procedure code 169"
 CPT170                       "CPT/HCPCS procedure code 170"
 CPT171                       "CPT/HCPCS procedure code 171"
 CPT172                       "CPT/HCPCS procedure code 172"
 CPT173                       "CPT/HCPCS procedure code 173"
 CPT174                       "CPT/HCPCS procedure code 174"
 CPT175                       "CPT/HCPCS procedure code 175"
 CPT176                       "CPT/HCPCS procedure code 176"
 CPT177                       "CPT/HCPCS procedure code 177"
 CPT178                       "CPT/HCPCS procedure code 178"
 CPT179                       "CPT/HCPCS procedure code 179"
 CPT180                       "CPT/HCPCS procedure code 180"
 CPT181                       "CPT/HCPCS procedure code 181"
 CPT182                       "CPT/HCPCS procedure code 182"
 CPT183                       "CPT/HCPCS procedure code 183"
 CPT184                       "CPT/HCPCS procedure code 184"
 CPT185                       "CPT/HCPCS procedure code 185"
 CPT186                       "CPT/HCPCS procedure code 186"
 CPT187                       "CPT/HCPCS procedure code 187"
 CPT188                       "CPT/HCPCS procedure code 188"
 CPT189                       "CPT/HCPCS procedure code 189"
 CPT190                       "CPT/HCPCS procedure code 190"
 CPT191                       "CPT/HCPCS procedure code 191"
 CPT192                       "CPT/HCPCS procedure code 192"
 CPT193                       "CPT/HCPCS procedure code 193"
 CPT194                       "CPT/HCPCS procedure code 194"
 CPT195                       "CPT/HCPCS procedure code 195"
 CPT196                       "CPT/HCPCS procedure code 196"
 CPT197                       "CPT/HCPCS procedure code 197"
 CPT198                       "CPT/HCPCS procedure code 198"
 CPT199                       "CPT/HCPCS procedure code 199"
 CPT200                       "CPT/HCPCS procedure code 200"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTCCS77                     "CCS: CPT 77"
 CPTCCS78                     "CCS: CPT 78"
 CPTCCS79                     "CCS: CPT 79"
 CPTCCS80                     "CCS: CPT 80"
 CPTCCS81                     "CCS: CPT 81"
 CPTCCS82                     "CCS: CPT 82"
 CPTCCS83                     "CCS: CPT 83"
 CPTCCS84                     "CCS: CPT 84"
 CPTCCS85                     "CCS: CPT 85"
 CPTCCS86                     "CCS: CPT 86"
 CPTCCS87                     "CCS: CPT 87"
 CPTCCS88                     "CCS: CPT 88"
 CPTCCS89                     "CCS: CPT 89"
 CPTCCS90                     "CCS: CPT 90"
 CPTCCS91                     "CCS: CPT 91"
 CPTCCS92                     "CCS: CPT 92"
 CPTCCS93                     "CCS: CPT 93"
 CPTCCS94                     "CCS: CPT 94"
 CPTCCS95                     "CCS: CPT 95"
 CPTCCS96                     "CCS: CPT 96"
 CPTCCS97                     "CCS: CPT 97"
 CPTCCS98                     "CCS: CPT 98"
 CPTCCS99                     "CCS: CPT 99"
 CPTCCS100                    "CCS: CPT 100"
 CPTCCS101                    "CCS: CPT 101"
 CPTCCS102                    "CCS: CPT 102"
 CPTCCS103                    "CCS: CPT 103"
 CPTCCS104                    "CCS: CPT 104"
 CPTCCS105                    "CCS: CPT 105"
 CPTCCS106                    "CCS: CPT 106"
 CPTCCS107                    "CCS: CPT 107"
 CPTCCS108                    "CCS: CPT 108"
 CPTCCS109                    "CCS: CPT 109"
 CPTCCS110                    "CCS: CPT 110"
 CPTCCS111                    "CCS: CPT 111"
 CPTCCS112                    "CCS: CPT 112"
 CPTCCS113                    "CCS: CPT 113"
 CPTCCS114                    "CCS: CPT 114"
 CPTCCS115                    "CCS: CPT 115"
 CPTCCS116                    "CCS: CPT 116"
 CPTCCS117                    "CCS: CPT 117"
 CPTCCS118                    "CCS: CPT 118"
 CPTCCS119                    "CCS: CPT 119"
 CPTCCS120                    "CCS: CPT 120"
 CPTCCS121                    "CCS: CPT 121"
 CPTCCS122                    "CCS: CPT 122"
 CPTCCS123                    "CCS: CPT 123"
 CPTCCS124                    "CCS: CPT 124"
 CPTCCS125                    "CCS: CPT 125"
 CPTCCS126                    "CCS: CPT 126"
 CPTCCS127                    "CCS: CPT 127"
 CPTCCS128                    "CCS: CPT 128"
 CPTCCS129                    "CCS: CPT 129"
 CPTCCS130                    "CCS: CPT 130"
 CPTCCS131                    "CCS: CPT 131"
 CPTCCS132                    "CCS: CPT 132"
 CPTCCS133                    "CCS: CPT 133"
 CPTCCS134                    "CCS: CPT 134"
 CPTCCS135                    "CCS: CPT 135"
 CPTCCS136                    "CCS: CPT 136"
 CPTCCS137                    "CCS: CPT 137"
 CPTCCS138                    "CCS: CPT 138"
 CPTCCS139                    "CCS: CPT 139"
 CPTCCS140                    "CCS: CPT 140"
 CPTCCS141                    "CCS: CPT 141"
 CPTCCS142                    "CCS: CPT 142"
 CPTCCS143                    "CCS: CPT 143"
 CPTCCS144                    "CCS: CPT 144"
 CPTCCS145                    "CCS: CPT 145"
 CPTCCS146                    "CCS: CPT 146"
 CPTCCS147                    "CCS: CPT 147"
 CPTCCS148                    "CCS: CPT 148"
 CPTCCS149                    "CCS: CPT 149"
 CPTCCS150                    "CCS: CPT 150"
 CPTCCS151                    "CCS: CPT 151"
 CPTCCS152                    "CCS: CPT 152"
 CPTCCS153                    "CCS: CPT 153"
 CPTCCS154                    "CCS: CPT 154"
 CPTCCS155                    "CCS: CPT 155"
 CPTCCS156                    "CCS: CPT 156"
 CPTCCS157                    "CCS: CPT 157"
 CPTCCS158                    "CCS: CPT 158"
 CPTCCS159                    "CCS: CPT 159"
 CPTCCS160                    "CCS: CPT 160"
 CPTCCS161                    "CCS: CPT 161"
 CPTCCS162                    "CCS: CPT 162"
 CPTCCS163                    "CCS: CPT 163"
 CPTCCS164                    "CCS: CPT 164"
 CPTCCS165                    "CCS: CPT 165"
 CPTCCS166                    "CCS: CPT 166"
 CPTCCS167                    "CCS: CPT 167"
 CPTCCS168                    "CCS: CPT 168"
 CPTCCS169                    "CCS: CPT 169"
 CPTCCS170                    "CCS: CPT 170"
 CPTCCS171                    "CCS: CPT 171"
 CPTCCS172                    "CCS: CPT 172"
 CPTCCS173                    "CCS: CPT 173"
 CPTCCS174                    "CCS: CPT 174"
 CPTCCS175                    "CCS: CPT 175"
 CPTCCS176                    "CCS: CPT 176"
 CPTCCS177                    "CCS: CPT 177"
 CPTCCS178                    "CCS: CPT 178"
 CPTCCS179                    "CCS: CPT 179"
 CPTCCS180                    "CCS: CPT 180"
 CPTCCS181                    "CCS: CPT 181"
 CPTCCS182                    "CCS: CPT 182"
 CPTCCS183                    "CCS: CPT 183"
 CPTCCS184                    "CCS: CPT 184"
 CPTCCS185                    "CCS: CPT 185"
 CPTCCS186                    "CCS: CPT 186"
 CPTCCS187                    "CCS: CPT 187"
 CPTCCS188                    "CCS: CPT 188"
 CPTCCS189                    "CCS: CPT 189"
 CPTCCS190                    "CCS: CPT 190"
 CPTCCS191                    "CCS: CPT 191"
 CPTCCS192                    "CCS: CPT 192"
 CPTCCS193                    "CCS: CPT 193"
 CPTCCS194                    "CCS: CPT 194"
 CPTCCS195                    "CCS: CPT 195"
 CPTCCS196                    "CCS: CPT 196"
 CPTCCS197                    "CCS: CPT 197"
 CPTCCS198                    "CCS: CPT 198"
 CPTCCS199                    "CCS: CPT 199"
 CPTCCS200                    "CCS: CPT 200"
 DaysBetweenVisits            "Number of days between visits"
 DaysToEvent                  "Days from 'start date' to admission"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DNR                          "Do not resuscitate indicator"
 DQTR                         "Discharge quarter"
 DSHOSPID                     "Data source hospital identifier"
 DURATION                     "Elapsed time for hospital care in hours and minutes"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD_CPT       "Number of reported CPT procedures that qualify as a surgery using a broad definition"
 HCUP_SURGERY_NARROW_CPT      "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 Homeless                     "Indicator that patient is homeless"
 HOSPST                       "Hospital state postal code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 RACE                         "Race (uniform)"
 RACE_PCT_MISS_HOSP           "Hospital percentage of missing or invalid race values"
 RACE_X                       "Race (as received from source)"
 SASD_SEDD                    "SASD and SEDD indicator"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TransportToHosp              "Method of transportation to hospital"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS101
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS102
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS103
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS104
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS105
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS106
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS107
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS108
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS109
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS110
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS111
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS112
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS113
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS114
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS115
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS116
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS117
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS118
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS119
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS120
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS121
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS122
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS123
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS124
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS125
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS126
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS127
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS128
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS129
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS130
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS131
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS132
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS133
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS134
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS135
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS136
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS137
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS138
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS139
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS140
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS141
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS142
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS143
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS144
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS145
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS146
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS147
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS148
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS149
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS150
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS151
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS152
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS153
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS154
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS155
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS156
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS157
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS158
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS159
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS160
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS161
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS162
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS163
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS164
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS165
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS166
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS167
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS168
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS169
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS170
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS171
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS172
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS173
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS174
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS175
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS176
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS177
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS178
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS179
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS180
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS181
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS182
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS183
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS184
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS185
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS186
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS187
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS188
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS189
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS190
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS191
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS192
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS193
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS194
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS195
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS196
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS197
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS198
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS199
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS200
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysBetweenVisits
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HCUP_SURGERY_NARROW_CPT
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_PCT_MISS_HOSP
 (-999.99,-888.88,-666.66,-555.55=SYSMIS).
RECODE SASD_SEDD
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TransportToHosp
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MA_SEDD_2022_CORE.sav' /COMPRESSED.
