/*******************************************************************
*   SC_SEDD_2002_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'SC_SEDD_2002_CORE.ASC' FIXED / 
 KEY                   1-  14
 AMONTH               15-  16
 ASOURCE              17-  18
 ASOURCE_             19     (A)
 ASOURCEU             20     (A)
 ATYPE                21-  22
 AWEEKEND             23-  24
 DIED                 25-  26
 DISP_X               27-  28 (A)
 DISPUB92             29-  30
 DISPUNIF             31-  32
 DQTR                 33-  34
 DX1                  35-  39 (A)
 DX2                  40-  44 (A)
 DX3                  45-  49 (A)
 DX4                  50-  54 (A)
 DX5                  55-  59 (A)
 DX6                  60-  64 (A)
 DX7                  65-  69 (A)
 DX8                  70-  74 (A)
 DX9                  75-  79 (A)
 DX10                 80-  84 (A)
 DX11                 85-  89 (A)
 DX12                 90-  94 (A)
 DXCCS1               95-  98
 DXCCS2               99- 102
 DXCCS3              103- 106
 DXCCS4              107- 110
 DXCCS5              111- 114
 DXCCS6              115- 118
 DXCCS7              119- 122
 DXCCS8              123- 126
 DXCCS9              127- 130
 DXCCS10             131- 134
 DXCCS11             135- 138
 DXCCS12             139- 142
 FEMALE              143- 144
 HOSPST              145- 146 (A)
 LOS                 147- 151
 LOS_X               152- 157
 MDSPEC1             158- 160 (A)
 MDSPEC2             161- 163 (A)
 NDX                 164- 165
 NEOMAT              166- 167
 NPR                 168- 169
 PAY1                170- 171
 PAY1_X              172- 173 (A)
 PL_RUCA1            174- 175
 PL_RUCA4            176- 177
 PR1                 178- 181 (A)
 PR2                 182- 185 (A)
 PR3                 186- 189 (A)
 PR4                 190- 193 (A)
 PR5                 194- 197 (A)
 PR6                 198- 201 (A)
 PR7                 202- 205 (A)
 PR8                 206- 209 (A)
 PR9                 210- 213 (A)
 PR10                214- 217 (A)
 PRCCS1              218- 220
 PRCCS2              221- 223
 PRCCS3              224- 226
 PRCCS4              227- 229
 PRCCS5              230- 232
 PRCCS6              233- 235
 PRCCS7              236- 238
 PRCCS8              239- 241
 PRCCS9              242- 244
 PRCCS10             245- 247
 PRDAY1              248- 252
 PRDAY2              253- 257
 PRDAY3              258- 262
 PRDAY4              263- 267
 PRDAY5              268- 272
 PRDAY6              273- 277
 PRDAY7              278- 282
 PRDAY8              283- 287
 PRDAY9              288- 292
 PRDAY10             293- 297
 PSTCO               298- 302
 RACE                303- 304
 RACE_X              305     (A)
 TOTCHG              306- 315
 TOTCHG_X            316- 330
 YEAR                331- 334
 AGEGROUP            335- 337.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PL_RUCA1            (F3.0) /
 PL_RUCA4            (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PSTCO               (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 AGEGROUP            (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 FEMALE    "Indicator of sex"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDSPEC1   "Physician 1 specialty (as received from source)"
 MDSPEC2   "Physician 2 specialty (as received from source)"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PSTCO     "Patient state/county FIPS code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 AGEGROUP  "Age Group" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).



SAVE OUTFILE = 'SC_SEDD_2002_CORE.SAV' /COMPRESSED.
