/*******************************************************************            
* Creation Date: 02/17/2025                                                     
*   GA_SID_2023_DX_PR_GRPS.sas:                                                 
*      THE SAS CODE SHOWN BELOW WILL LOAD THE ASCII                             
*      SID DX_PR_GRPS FILE INTO SAS                                             
*******************************************************************/            
                                                                                
                                                                                
***************************************************************;                
* ----------------------------------------------------------- *;                
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;                
* |  terms and conditions of the HCUP Data Use Agreement.   | *;                
* ----------------------------------------------------------- *;                
***************************************************************;                
                                                                                
                                                                                
***********************************************;                                
*  Create SAS informats for missing values     ;                                
***********************************************;                                
PROC FORMAT;                                                                    
  INVALUE N2PF                                                                  
    '-9' = .                                                                    
    '-8' = .A                                                                   
    '-6' = .C                                                                   
    '-5' = .N                                                                   
    OTHER = (|2.|)                                                              
  ;                                                                             
  INVALUE N3PF                                                                  
    '-99' = .                                                                   
    '-88' = .A                                                                  
    '-66' = .C                                                                  
    OTHER = (|3.|)                                                              
  ;                                                                             
  INVALUE N4PF                                                                  
    '-999' = .                                                                  
    '-888' = .A                                                                 
    '-666' = .C                                                                 
    OTHER = (|4.|)                                                              
  ;                                                                             
  INVALUE N4P1F                                                                 
    '-9.9' = .                                                                  
    '-8.8' = .A                                                                 
    '-6.6' = .C                                                                 
    OTHER = (|4.1|)                                                             
  ;                                                                             
  INVALUE N5PF                                                                  
    '-9999' = .                                                                 
    '-8888' = .A                                                                
    '-6666' = .C                                                                
    OTHER = (|5.|)                                                              
  ;                                                                             
  INVALUE N5P2F                                                                 
    '-9.99' = .                                                                 
    '-8.88' = .A                                                                
    '-6.66' = .C                                                                
    OTHER = (|5.2|)                                                             
  ;                                                                             
  INVALUE N6PF                                                                  
    '-99999' = .                                                                
    '-88888' = .A                                                               
    '-66666' = .C                                                               
    OTHER = (|6.|)                                                              
  ;                                                                             
  INVALUE N6P2F                                                                 
    '-99.99' = .                                                                
    '-88.88' = .A                                                               
    '-66.66' = .C                                                               
    OTHER = (|6.2|)                                                             
  ;                                                                             
  INVALUE N7P2F                                                                 
    '-999.99' = .                                                               
    '-888.88' = .A                                                              
    '-666.66' = .C                                                              
    OTHER = (|7.2|)                                                             
  ;                                                                             
  INVALUE N7P4F                                                                 
    '-9.9999' = .                                                               
    '-8.8888' = .A                                                              
    '-6.6666' = .C                                                              
    OTHER = (|7.4|)                                                             
  ;                                                                             
  INVALUE N8PF                                                                  
    '-9999999' = .                                                              
    '-8888888' = .A                                                             
    '-6666666' = .C                                                             
    OTHER = (|8.|)                                                              
  ;                                                                             
  INVALUE N8P2F                                                                 
    '-9999.99' = .                                                              
    '-8888.88' = .A                                                             
    '-6666.66' = .C                                                             
    OTHER = (|8.2|)                                                             
  ;                                                                             
  INVALUE N9PF                                                                  
    '-99999999' = .                                                             
    '-88888888' = .A                                                            
    '-66666666' = .C                                                            
    OTHER = (|9.|)                                                              
  ;                                                                             
  INVALUE N9P2F                                                                 
    '-99999.99' = .                                                             
    '-88888.88' = .A                                                            
    '-66666.66' = .C                                                            
    OTHER = (|9.2|)                                                             
  ;                                                                             
  INVALUE N10PF                                                                 
    '-999999999' = .                                                            
    '-888888888' = .A                                                           
    '-666666666' = .C                                                           
    OTHER = (|10.|)                                                             
  ;                                                                             
  INVALUE N10P4F                                                                
    '-9999.9999' = .                                                            
    '-8888.8888' = .A                                                           
    '-6666.6666' = .C                                                           
    OTHER = (|10.4|)                                                            
  ;                                                                             
  INVALUE N10P5F                                                                
    '-999.99999' = .                                                            
    '-888.88888' = .A                                                           
    '-666.66666' = .C                                                           
    OTHER = (|10.5|)                                                            
  ;                                                                             
  INVALUE DATE10F                                                               
    '-999999999' = .                                                            
    '-888888888' = .A                                                           
    '-666666666' = .C                                                           
    OTHER = (|MMDDYY10.|)                                                       
  ;                                                                             
  INVALUE N11PF                                                                 
    '-9999999999' = .                                                           
    '-8888888888' = .A                                                          
    '-6666666666' = .C                                                          
    OTHER = (|11.|)                                                             
  ;                                                                             
  INVALUE N11P2F                                                                
    '-9999999.99' = .                                                           
    '-8888888.88' = .A                                                          
    '-6666666.66' = .C                                                          
    OTHER = (|11.2|)                                                            
  ;                                                                             
  INVALUE N12P2F                                                                
    '-99999999.99' = .                                                          
    '-88888888.88' = .A                                                         
    '-66666666.66' = .C                                                         
    OTHER = (|12.2|)                                                            
  ;                                                                             
  INVALUE N12P5F                                                                
    '-99999.99999' = .                                                          
    '-88888.88888' = .A                                                         
    '-66666.66666' = .C                                                         
    OTHER = (|12.5|)                                                            
  ;                                                                             
  INVALUE N13PF                                                                 
    '-999999999999' = .                                                         
    '-888888888888' = .A                                                        
    '-666666666666' = .C                                                        
    OTHER = (|13.|)                                                             
  ;                                                                             
  INVALUE N15P2F                                                                
    '-99999999999.99' = .                                                       
    '-88888888888.88' = .A                                                      
    '-66666666666.66' = .C                                                      
    OTHER = (|15.2|)                                                            
  ;                                                                             
  RUN;                                                                          
                                                                                
                                                                                
*******************************;                                                
*  Data Step                  *;                                                
*******************************;                                                
DATA GA_SIDC_2023_DX_PR_GRPS;                                                   
INFILE 'GA_SID_2023_DX_PR_GRPS.asc' FIRSTOBS=3 LRECL = 3579;                    
                                                                                
*** Variable attribute ***;                                                     
ATTRIB                                                                          
  CCIR_VERSION               LENGTH=$6                                          
  LABEL="Version of Chronic Condition Indicator Refined for ICD-10-CM"          
                                                                                
  CCIR1                      LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 1"                       
                                                                                
  CCIR2                      LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 2"                       
                                                                                
  CCIR3                      LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 3"                       
                                                                                
  CCIR4                      LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 4"                       
                                                                                
  CCIR5                      LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 5"                       
                                                                                
  CCIR6                      LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 6"                       
                                                                                
  CCIR7                      LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 7"                       
                                                                                
  CCIR8                      LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 8"                       
                                                                                
  CCIR9                      LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 9"                       
                                                                                
  CCIR10                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 10"                      
                                                                                
  CCIR11                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 11"                      
                                                                                
  CCIR12                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 12"                      
                                                                                
  CCIR13                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 13"                      
                                                                                
  CCIR14                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 14"                      
                                                                                
  CCIR15                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 15"                      
                                                                                
  CCIR16                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 16"                      
                                                                                
  CCIR17                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 17"                      
                                                                                
  CCIR18                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 18"                      
                                                                                
  CCIR19                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 19"                      
                                                                                
  CCIR20                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 20"                      
                                                                                
  CCIR21                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 21"                      
                                                                                
  CCIR22                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 22"                      
                                                                                
  CCIR23                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 23"                      
                                                                                
  CCIR24                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 24"                      
                                                                                
  CCIR25                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 25"                      
                                                                                
  CCIR26                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 26"                      
                                                                                
  CCIR27                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 27"                      
                                                                                
  CCIR28                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 28"                      
                                                                                
  CCIR29                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 29"                      
                                                                                
  CCIR30                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 30"                      
                                                                                
  CCIR31                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 31"                      
                                                                                
  CCIR32                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 32"                      
                                                                                
  CCIR33                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 33"                      
                                                                                
  CCIR34                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 34"                      
                                                                                
  CCIR35                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 35"                      
                                                                                
  CCIR36                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 36"                      
                                                                                
  CCIR37                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 37"                      
                                                                                
  CCIR38                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 38"                      
                                                                                
  CCIR39                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 39"                      
                                                                                
  CCIR40                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 40"                      
                                                                                
  CCIR41                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 41"                      
                                                                                
  CCIR42                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 42"                      
                                                                                
  CCIR43                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 43"                      
                                                                                
  CCIR44                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 44"                      
                                                                                
  CCIR45                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 45"                      
                                                                                
  CCIR46                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 46"                      
                                                                                
  CCIR47                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 47"                      
                                                                                
  CCIR48                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 48"                      
                                                                                
  CCIR49                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 49"                      
                                                                                
  CCIR50                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 50"                      
                                                                                
  CCIR51                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 51"                      
                                                                                
  CCIR52                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 52"                      
                                                                                
  CCIR53                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 53"                      
                                                                                
  CCIR54                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 54"                      
                                                                                
  CCIR55                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 55"                      
                                                                                
  CCIR56                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 56"                      
                                                                                
  CCIR57                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 57"                      
                                                                                
  CCIR58                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 58"                      
                                                                                
  CCIR59                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 59"                      
                                                                                
  CCIR60                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 60"                      
                                                                                
  CCIR61                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 61"                      
                                                                                
  CCIR62                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 62"                      
                                                                                
  CCIR63                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 63"                      
                                                                                
  CCIR64                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 64"                      
                                                                                
  CCIR65                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 65"                      
                                                                                
  CCIR66                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 66"                      
                                                                                
  CCIR67                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 67"                      
                                                                                
  CCIR68                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 68"                      
                                                                                
  CCIR69                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 69"                      
                                                                                
  CCIR70                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 70"                      
                                                                                
  CCIR71                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 71"                      
                                                                                
  CCIR72                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 72"                      
                                                                                
  CCIR73                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 73"                      
                                                                                
  CCIR74                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 74"                      
                                                                                
  CCIR75                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 75"                      
                                                                                
  CCIR76                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 76"                      
                                                                                
  CCIR77                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 77"                      
                                                                                
  CCIR78                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 78"                      
                                                                                
  CCIR79                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 79"                      
                                                                                
  CCIR80                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 80"                      
                                                                                
  CCIR81                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 81"                      
                                                                                
  CCIR82                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 82"                      
                                                                                
  CCIR83                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 83"                      
                                                                                
  CCIR84                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 84"                      
                                                                                
  CCIR85                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 85"                      
                                                                                
  CCIR86                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 86"                      
                                                                                
  CCIR87                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 87"                      
                                                                                
  CCIR88                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 88"                      
                                                                                
  CCIR89                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 89"                      
                                                                                
  CCIR90                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 90"                      
                                                                                
  CCIR91                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 91"                      
                                                                                
  CCIR92                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 92"                      
                                                                                
  CCIR93                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 93"                      
                                                                                
  CCIR94                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 94"                      
                                                                                
  CCIR95                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 95"                      
                                                                                
  CCIR96                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 96"                      
                                                                                
  CCIR97                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 97"                      
                                                                                
  CCIR98                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 98"                      
                                                                                
  CCIR99                     LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 99"                      
                                                                                
  CCIR100                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 100"                     
                                                                                
  CCIR101                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 101"                     
                                                                                
  CCIR102                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 102"                     
                                                                                
  CCIR103                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 103"                     
                                                                                
  CCIR104                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 104"                     
                                                                                
  CCIR105                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 105"                     
                                                                                
  CCIR106                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 106"                     
                                                                                
  CCIR107                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 107"                     
                                                                                
  CCIR108                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 108"                     
                                                                                
  CCIR109                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 109"                     
                                                                                
  CCIR110                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 110"                     
                                                                                
  CCIR111                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 111"                     
                                                                                
  CCIR112                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 112"                     
                                                                                
  CCIR113                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 113"                     
                                                                                
  CCIR114                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 114"                     
                                                                                
  CCIR115                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 115"                     
                                                                                
  CCIR116                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 116"                     
                                                                                
  CCIR117                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 117"                     
                                                                                
  CCIR118                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 118"                     
                                                                                
  CCIR119                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 119"                     
                                                                                
  CCIR120                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 120"                     
                                                                                
  CCIR121                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 121"                     
                                                                                
  CCIR122                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 122"                     
                                                                                
  CCIR123                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 123"                     
                                                                                
  CCIR124                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 124"                     
                                                                                
  CCIR125                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 125"                     
                                                                                
  CCIR126                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 126"                     
                                                                                
  CCIR127                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 127"                     
                                                                                
  CCIR128                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 128"                     
                                                                                
  CCIR129                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 129"                     
                                                                                
  CCIR130                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 130"                     
                                                                                
  CCIR131                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 131"                     
                                                                                
  CCIR132                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 132"                     
                                                                                
  CCIR133                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 133"                     
                                                                                
  CCIR134                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 134"                     
                                                                                
  CCIR135                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 135"                     
                                                                                
  CCIR136                    LENGTH=3                                           
  LABEL="ICD-10-CM Chronic Condition Indicator Refined 136"                     
                                                                                
  CMR_AIDS                   LENGTH=3                                           
  LABEL="Acquired immune deficiency syndrome"                                   
                                                                                
  CMR_ALCOHOL                LENGTH=3                                           
  LABEL="Alcohol abuse"                                                         
                                                                                
  CMR_ANEMDEF                LENGTH=3                                           
  LABEL="Anemias due to other nutritional deficiencies"                         
                                                                                
  CMR_AUTOIMMUNE             LENGTH=3                                           
  LABEL="Autoimmune conditions"                                                 
                                                                                
  CMR_BLDLOSS                LENGTH=3                                           
  LABEL="Chronic blood loss anemia (iron deficiency)"                           
                                                                                
  CMR_CANCER_LEUK            LENGTH=3                                           
  LABEL="Leukemia"                                                              
                                                                                
  CMR_CANCER_LYMPH           LENGTH=3                                           
  LABEL="Lymphoma"                                                              
                                                                                
  CMR_CANCER_METS            LENGTH=3                                           
  LABEL="Metastatic cancer"                                                     
                                                                                
  CMR_CANCER_NSITU           LENGTH=3                                           
  LABEL="Solid tumor without metastasis, in situ"                               
                                                                                
  CMR_CANCER_SOLID           LENGTH=3                                           
  LABEL="Solid tumor without metastasis, malignant"                             
                                                                                
  CMR_CBVD                   LENGTH=3                                           
  LABEL="Cerebrovascular disease"                                               
                                                                                
  CMR_COAG                   LENGTH=3                                           
  LABEL="Coagulopathy"                                                          
                                                                                
  CMR_DEMENTIA               LENGTH=3                                           
  LABEL="Dementia"                                                              
                                                                                
  CMR_DEPRESS                LENGTH=3                                           
  LABEL="Depression"                                                            
                                                                                
  CMR_DIAB_CX                LENGTH=3                                           
  LABEL="Diabetes with chronic complications"                                   
                                                                                
  CMR_DIAB_UNCX              LENGTH=3                                           
  LABEL="Diabetes without chronic complications"                                
                                                                                
  CMR_DRUG_ABUSE             LENGTH=3                                           
  LABEL="Drug abuse"                                                            
                                                                                
  CMR_HF                     LENGTH=3                                           
  LABEL="Heart failure"                                                         
                                                                                
  CMR_HTN_CX                 LENGTH=3                                           
  LABEL="Hypertension, complicated"                                             
                                                                                
  CMR_HTN_UNCX               LENGTH=3                                           
  LABEL="Hypertension, uncomplicated"                                           
                                                                                
  CMR_LIVER_MLD              LENGTH=3                                           
  LABEL="Liver disease, mild"                                                   
                                                                                
  CMR_LIVER_SEV              LENGTH=3                                           
  LABEL="Liver disease, moderate to severe"                                     
                                                                                
  CMR_LUNG_CHRONIC           LENGTH=3                                           
  LABEL="Chronic pulmonary disease"                                             
                                                                                
  CMR_NEURO_MOVT             LENGTH=3                                           
  LABEL="Neurological disorders affecting movement"                             
                                                                                
  CMR_NEURO_OTH              LENGTH=3                                           
  LABEL="Other neurological disorders"                                          
                                                                                
  CMR_NEURO_SEIZ             LENGTH=3                                           
  LABEL="Seizures and epilepsy"                                                 
                                                                                
  CMR_OBESE                  LENGTH=3                                           
  LABEL="Obesity"                                                               
                                                                                
  CMR_PARALYSIS              LENGTH=3                                           
  LABEL="Paralysis"                                                             
                                                                                
  CMR_PERIVASC               LENGTH=3                                           
  LABEL="Peripheral vascular disease"                                           
                                                                                
  CMR_PSYCHOSES              LENGTH=3                                           
  LABEL="Psychoses"                                                             
                                                                                
  CMR_PULMCIRC               LENGTH=3                                           
  LABEL="Pulmonary circulation disease"                                         
                                                                                
  CMR_RENLFL_MOD             LENGTH=3                                           
  LABEL="Renal failure, moderate"                                               
                                                                                
  CMR_RENLFL_SEV             LENGTH=3                                           
  LABEL="Renal failure, severe"                                                 
                                                                                
  CMR_THYROID_HYPO           LENGTH=3                                           
  LABEL="Hypothyroidism"                                                        
                                                                                
  CMR_THYROID_OTH            LENGTH=3                                           
  LABEL="Other thyroid disorders"                                               
                                                                                
  CMR_ULCER_PEPTIC           LENGTH=3                                           
  LABEL="Peptic ulcer disease x bleeding"                                       
                                                                                
  CMR_VALVE                  LENGTH=3                                           
  LABEL="Valvular disease"                                                      
                                                                                
  CMR_VERSION                LENGTH=$6                                          
  LABEL="Version of Elixhauser Comorbidity Software Refined"                    
                                                                                
  CMR_WGHTLOSS               LENGTH=3                                           
  LABEL="Weight loss"                                                           
                                                                                
  I10_INJURY                 LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other
 than first-listed injury; 0: No injury)"                                       
                                                                                
  I10_INJURY_CUT             LENGTH=3                                           
  LABEL="Mechanism of injury: cut or pierce"                                    
                                                                                
  I10_INJURY_DROWN           LENGTH=3                                           
  LABEL="Mechanism of injury: drowning or submersion"                           
                                                                                
  I10_INJURY_FALL            LENGTH=3                                           
  LABEL="Mechanism of injury: fall"                                             
                                                                                
  I10_INJURY_FIRE            LENGTH=3                                           
  LABEL="Mechanism of injury: fire, flame, hot object, or hot substance"        
                                                                                
  I10_INJURY_FIREARM         LENGTH=3                                           
  LABEL="Mechanism of injury: firearm"                                          
                                                                                
  I10_INJURY_MACHINERY       LENGTH=3                                           
  LABEL="Mechanism of injury: machinery"                                        
                                                                                
  I10_INJURY_MVT             LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Mechanism of injury: motor vehicle traffic, including the occupant of a car, mo
torcyclist, pedal cyclist, pedestrian, other, or unspecified"                   
                                                                                
  I10_INJURY_NATURE          LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Mechanism of injury: natural or environmental, included venomous and nonvenomou
s bites and stings"                                                             
                                                                                
  I10_INJURY_OVEREXERTION    LENGTH=3                                           
  LABEL="Mechanism of injury: overexertion"                                     
                                                                                
  I10_INJURY_POISON          LENGTH=3                                           
  LABEL="Mechanism of injury: poisoning, including drugs and nondrugs"          
                                                                                
  I10_INJURY_STRUCK          LENGTH=3                                           
  LABEL="Mechanism of injury: struck by or against"                             
                                                                                
  I10_INJURY_SUFFOCATION     LENGTH=3                                           
  LABEL="Mechanism of injury: suffocation"                                      
                                                                                
  I10_INTENT_ASSAULT         LENGTH=3                                           
  LABEL="Intent of injury: assault"                                             
                                                                                
  I10_INTENT_SELF_HARM       LENGTH=3                                           
  LABEL="Intent of injury: intentional self-harm"                               
                                                                                
  I10_INTENT_UNINTENTIONAL   LENGTH=3                                           
  LABEL="Intent of injury: unintentional"                                       
                                                                                
  I10_MULTINJURY             LENGTH=3                                           
  LABEL="Multiple ICD-10-CM injuries reported on record"                        
                                                                                
  KEY                        LENGTH=8                      FORMAT=Z15.          
  LABEL="HCUP record identifier"                                                
                                                                                
  PCLASS_VERSION             LENGTH=$6                                          
  LABEL="Version of ICD-10-PCS Procedure class"                                 
                                                                                
  PCLASS1                    LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 1"                                          
                                                                                
  PCLASS2                    LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 2"                                          
                                                                                
  PCLASS3                    LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 3"                                          
                                                                                
  PCLASS4                    LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 4"                                          
                                                                                
  PCLASS5                    LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 5"                                          
                                                                                
  PCLASS6                    LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 6"                                          
                                                                                
  PCLASS7                    LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 7"                                          
                                                                                
  PCLASS8                    LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 8"                                          
                                                                                
  PCLASS9                    LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 9"                                          
                                                                                
  PCLASS10                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 10"                                         
                                                                                
  PCLASS11                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 11"                                         
                                                                                
  PCLASS12                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 12"                                         
                                                                                
  PCLASS13                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 13"                                         
                                                                                
  PCLASS14                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 14"                                         
                                                                                
  PCLASS15                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 15"                                         
                                                                                
  PCLASS16                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 16"                                         
                                                                                
  PCLASS17                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 17"                                         
                                                                                
  PCLASS18                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 18"                                         
                                                                                
  PCLASS19                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 19"                                         
                                                                                
  PCLASS20                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 20"                                         
                                                                                
  PCLASS21                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 21"                                         
                                                                                
  PCLASS22                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 22"                                         
                                                                                
  PCLASS23                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 23"                                         
                                                                                
  PCLASS24                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 24"                                         
                                                                                
  PCLASS25                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 25"                                         
                                                                                
  PCLASS26                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 26"                                         
                                                                                
  PCLASS27                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 27"                                         
                                                                                
  PCLASS28                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 28"                                         
                                                                                
  PCLASS29                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 29"                                         
                                                                                
  PCLASS30                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 30"                                         
                                                                                
  PCLASS31                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 31"                                         
                                                                                
  PCLASS32                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 32"                                         
                                                                                
  PCLASS33                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 33"                                         
                                                                                
  PCLASS34                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 34"                                         
                                                                                
  PCLASS35                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 35"                                         
                                                                                
  PCLASS36                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 36"                                         
                                                                                
  PCLASS37                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 37"                                         
                                                                                
  PCLASS38                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 38"                                         
                                                                                
  PCLASS39                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 39"                                         
                                                                                
  PCLASS40                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 40"                                         
                                                                                
  PCLASS41                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 41"                                         
                                                                                
  PCLASS42                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 42"                                         
                                                                                
  PCLASS43                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 43"                                         
                                                                                
  PCLASS44                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 44"                                         
                                                                                
  PCLASS45                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 45"                                         
                                                                                
  PCLASS46                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 46"                                         
                                                                                
  PCLASS47                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 47"                                         
                                                                                
  PCLASS48                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 48"                                         
                                                                                
  PCLASS49                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 49"                                         
                                                                                
  PCLASS50                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 50"                                         
                                                                                
  PCLASS51                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 51"                                         
                                                                                
  PCLASS52                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 52"                                         
                                                                                
  PCLASS53                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 53"                                         
                                                                                
  PCLASS54                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 54"                                         
                                                                                
  PCLASS55                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 55"                                         
                                                                                
  PCLASS56                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 56"                                         
                                                                                
  PCLASS57                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 57"                                         
                                                                                
  PCLASS58                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 58"                                         
                                                                                
  PCLASS59                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 59"                                         
                                                                                
  PCLASS60                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 60"                                         
                                                                                
  PCLASS61                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 61"                                         
                                                                                
  PCLASS62                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 62"                                         
                                                                                
  PCLASS63                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 63"                                         
                                                                                
  PCLASS64                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 64"                                         
                                                                                
  PCLASS65                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 65"                                         
                                                                                
  PCLASS66                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 66"                                         
                                                                                
  PCLASS67                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 67"                                         
                                                                                
  PCLASS68                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 68"                                         
                                                                                
  PCLASS69                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 69"                                         
                                                                                
  PCLASS70                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 70"                                         
                                                                                
  PCLASS71                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 71"                                         
                                                                                
  PCLASS72                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 72"                                         
                                                                                
  PCLASS73                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 73"                                         
                                                                                
  PCLASS74                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 74"                                         
                                                                                
  PCLASS75                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 75"                                         
                                                                                
  PCLASS76                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 76"                                         
                                                                                
  PCLASS77                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 77"                                         
                                                                                
  PCLASS78                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 78"                                         
                                                                                
  PCLASS79                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 79"                                         
                                                                                
  PCLASS80                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 80"                                         
                                                                                
  PCLASS81                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 81"                                         
                                                                                
  PCLASS82                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 82"                                         
                                                                                
  PCLASS83                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 83"                                         
                                                                                
  PCLASS84                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 84"                                         
                                                                                
  PCLASS85                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 85"                                         
                                                                                
  PCLASS86                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 86"                                         
                                                                                
  PCLASS87                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 87"                                         
                                                                                
  PCLASS88                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 88"                                         
                                                                                
  PCLASS89                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 89"                                         
                                                                                
  PCLASS90                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 90"                                         
                                                                                
  PCLASS91                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 91"                                         
                                                                                
  PCLASS92                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 92"                                         
                                                                                
  PCLASS93                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 93"                                         
                                                                                
  PCLASS94                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 94"                                         
                                                                                
  PCLASS95                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 95"                                         
                                                                                
  PCLASS96                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 96"                                         
                                                                                
  PCLASS97                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 97"                                         
                                                                                
  PCLASS98                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 98"                                         
                                                                                
  PCLASS99                   LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 99"                                         
                                                                                
  PCLASS100                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 100"                                        
                                                                                
  PCLASS101                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 101"                                        
                                                                                
  PCLASS102                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 102"                                        
                                                                                
  PCLASS103                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 103"                                        
                                                                                
  PCLASS104                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 104"                                        
                                                                                
  PCLASS105                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 105"                                        
                                                                                
  PCLASS106                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 106"                                        
                                                                                
  PCLASS107                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 107"                                        
                                                                                
  PCLASS108                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 108"                                        
                                                                                
  PCLASS109                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 109"                                        
                                                                                
  PCLASS110                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 110"                                        
                                                                                
  PCLASS111                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 111"                                        
                                                                                
  PCLASS112                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 112"                                        
                                                                                
  PCLASS113                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 113"                                        
                                                                                
  PCLASS114                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 114"                                        
                                                                                
  PCLASS115                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 115"                                        
                                                                                
  PCLASS116                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 116"                                        
                                                                                
  PCLASS117                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 117"                                        
                                                                                
  PCLASS118                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 118"                                        
                                                                                
  PCLASS119                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 119"                                        
                                                                                
  PCLASS120                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 120"                                        
                                                                                
  PCLASS121                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 121"                                        
                                                                                
  PCLASS122                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 122"                                        
                                                                                
  PCLASS123                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 123"                                        
                                                                                
  PCLASS124                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 124"                                        
                                                                                
  PCLASS125                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 125"                                        
                                                                                
  PCLASS126                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 126"                                        
                                                                                
  PCLASS127                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 127"                                        
                                                                                
  PCLASS128                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 128"                                        
                                                                                
  PCLASS129                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 129"                                        
                                                                                
  PCLASS130                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 130"                                        
                                                                                
  PCLASS131                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 131"                                        
                                                                                
  PCLASS132                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 132"                                        
                                                                                
  PCLASS133                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 133"                                        
                                                                                
  PCLASS134                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 134"                                        
                                                                                
  PCLASS135                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 135"                                        
                                                                                
  PCLASS136                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 136"                                        
                                                                                
  PCLASS137                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 137"                                        
                                                                                
  PCLASS138                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 138"                                        
                                                                                
  PCLASS139                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 139"                                        
                                                                                
  PCLASS140                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 140"                                        
                                                                                
  PCLASS141                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 141"                                        
                                                                                
  PCLASS142                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 142"                                        
                                                                                
  PCLASS143                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 143"                                        
                                                                                
  PCLASS144                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 144"                                        
                                                                                
  PCLASS145                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 145"                                        
                                                                                
  PCLASS146                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 146"                                        
                                                                                
  PCLASS147                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 147"                                        
                                                                                
  PCLASS148                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 148"                                        
                                                                                
  PCLASS149                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 149"                                        
                                                                                
  PCLASS150                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 150"                                        
                                                                                
  PCLASS151                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 151"                                        
                                                                                
  PCLASS152                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 152"                                        
                                                                                
  PCLASS153                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 153"                                        
                                                                                
  PCLASS154                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 154"                                        
                                                                                
  PCLASS155                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 155"                                        
                                                                                
  PCLASS156                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 156"                                        
                                                                                
  PCLASS157                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 157"                                        
                                                                                
  PCLASS158                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 158"                                        
                                                                                
  PCLASS159                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 159"                                        
                                                                                
  PCLASS160                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 160"                                        
                                                                                
  PCLASS161                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 161"                                        
                                                                                
  PCLASS162                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 162"                                        
                                                                                
  PCLASS163                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 163"                                        
                                                                                
  PCLASS164                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 164"                                        
                                                                                
  PCLASS165                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 165"                                        
                                                                                
  PCLASS166                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 166"                                        
                                                                                
  PCLASS167                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 167"                                        
                                                                                
  PCLASS168                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 168"                                        
                                                                                
  PCLASS169                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 169"                                        
                                                                                
  PCLASS170                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 170"                                        
                                                                                
  PCLASS171                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 171"                                        
                                                                                
  PCLASS172                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 172"                                        
                                                                                
  PCLASS173                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 173"                                        
                                                                                
  PCLASS174                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 174"                                        
                                                                                
  PCLASS175                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 175"                                        
                                                                                
  PCLASS176                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 176"                                        
                                                                                
  PCLASS177                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 177"                                        
                                                                                
  PCLASS178                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 178"                                        
                                                                                
  PCLASS179                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 179"                                        
                                                                                
  PCLASS180                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 180"                                        
                                                                                
  PCLASS181                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 181"                                        
                                                                                
  PCLASS182                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 182"                                        
                                                                                
  PCLASS183                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 183"                                        
                                                                                
  PCLASS184                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 184"                                        
                                                                                
  PCLASS185                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 185"                                        
                                                                                
  PCLASS186                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 186"                                        
                                                                                
  PCLASS187                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 187"                                        
                                                                                
  PCLASS188                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 188"                                        
                                                                                
  PCLASS189                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 189"                                        
                                                                                
  PCLASS190                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 190"                                        
                                                                                
  PCLASS191                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 191"                                        
                                                                                
  PCLASS192                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 192"                                        
                                                                                
  PCLASS193                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 193"                                        
                                                                                
  PCLASS194                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 194"                                        
                                                                                
  PCLASS195                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 195"                                        
                                                                                
  PCLASS196                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 196"                                        
                                                                                
  PCLASS197                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 197"                                        
                                                                                
  PCLASS198                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 198"                                        
                                                                                
  PCLASS199                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 199"                                        
                                                                                
  PCLASS200                  LENGTH=3                                           
  LABEL="ICD-10-PCS Procedure class 200"                                        
                                                                                
  DXCCSR_Default_DX1         LENGTH=$6                                          
  LABEL="Default CCSR for principal/first-listed ICD-10-CM diagnosis"           
                                                                                
  DXCCSR_BLD001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD001"                                                                     
                                                                                
  DXCCSR_BLD002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD002"                                                                     
                                                                                
  DXCCSR_BLD003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD003"                                                                     
                                                                                
  DXCCSR_BLD004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD004"                                                                     
                                                                                
  DXCCSR_BLD005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD005"                                                                     
                                                                                
  DXCCSR_BLD006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD006"                                                                     
                                                                                
  DXCCSR_BLD007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD007"                                                                     
                                                                                
  DXCCSR_BLD008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD008"                                                                     
                                                                                
  DXCCSR_BLD009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD009"                                                                     
                                                                                
  DXCCSR_BLD010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR BLD010"                                                                     
                                                                                
  DXCCSR_CIR001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR001"                                                                     
                                                                                
  DXCCSR_CIR002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR002"                                                                     
                                                                                
  DXCCSR_CIR003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR003"                                                                     
                                                                                
  DXCCSR_CIR004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR004"                                                                     
                                                                                
  DXCCSR_CIR005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR005"                                                                     
                                                                                
  DXCCSR_CIR006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR006"                                                                     
                                                                                
  DXCCSR_CIR007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR007"                                                                     
                                                                                
  DXCCSR_CIR008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR008"                                                                     
                                                                                
  DXCCSR_CIR009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR009"                                                                     
                                                                                
  DXCCSR_CIR010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR010"                                                                     
                                                                                
  DXCCSR_CIR011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR011"                                                                     
                                                                                
  DXCCSR_CIR012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR012"                                                                     
                                                                                
  DXCCSR_CIR013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR013"                                                                     
                                                                                
  DXCCSR_CIR014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR014"                                                                     
                                                                                
  DXCCSR_CIR015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR015"                                                                     
                                                                                
  DXCCSR_CIR016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR016"                                                                     
                                                                                
  DXCCSR_CIR017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR017"                                                                     
                                                                                
  DXCCSR_CIR018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR018"                                                                     
                                                                                
  DXCCSR_CIR019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR019"                                                                     
                                                                                
  DXCCSR_CIR020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR020"                                                                     
                                                                                
  DXCCSR_CIR021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR021"                                                                     
                                                                                
  DXCCSR_CIR022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR022"                                                                     
                                                                                
  DXCCSR_CIR023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR023"                                                                     
                                                                                
  DXCCSR_CIR024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR024"                                                                     
                                                                                
  DXCCSR_CIR025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR025"                                                                     
                                                                                
  DXCCSR_CIR026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR026"                                                                     
                                                                                
  DXCCSR_CIR027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR027"                                                                     
                                                                                
  DXCCSR_CIR028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR028"                                                                     
                                                                                
  DXCCSR_CIR029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR029"                                                                     
                                                                                
  DXCCSR_CIR030              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR030"                                                                     
                                                                                
  DXCCSR_CIR031              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR031"                                                                     
                                                                                
  DXCCSR_CIR032              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR032"                                                                     
                                                                                
  DXCCSR_CIR033              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR033"                                                                     
                                                                                
  DXCCSR_CIR034              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR034"                                                                     
                                                                                
  DXCCSR_CIR035              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR035"                                                                     
                                                                                
  DXCCSR_CIR036              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR036"                                                                     
                                                                                
  DXCCSR_CIR037              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR037"                                                                     
                                                                                
  DXCCSR_CIR038              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR038"                                                                     
                                                                                
  DXCCSR_CIR039              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR CIR039"                                                                     
                                                                                
  DXCCSR_DEN001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DEN001"                                                                     
                                                                                
  DXCCSR_DEN002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DEN002"                                                                     
                                                                                
  DXCCSR_DEN003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DEN003"                                                                     
                                                                                
  DXCCSR_DIG001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG001"                                                                     
                                                                                
  DXCCSR_DIG002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG002"                                                                     
                                                                                
  DXCCSR_DIG003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG003"                                                                     
                                                                                
  DXCCSR_DIG004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG004"                                                                     
                                                                                
  DXCCSR_DIG005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG005"                                                                     
                                                                                
  DXCCSR_DIG006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG006"                                                                     
                                                                                
  DXCCSR_DIG007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG007"                                                                     
                                                                                
  DXCCSR_DIG008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG008"                                                                     
                                                                                
  DXCCSR_DIG009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG009"                                                                     
                                                                                
  DXCCSR_DIG010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG010"                                                                     
                                                                                
  DXCCSR_DIG011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG011"                                                                     
                                                                                
  DXCCSR_DIG012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG012"                                                                     
                                                                                
  DXCCSR_DIG013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG013"                                                                     
                                                                                
  DXCCSR_DIG014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG014"                                                                     
                                                                                
  DXCCSR_DIG015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG015"                                                                     
                                                                                
  DXCCSR_DIG016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG016"                                                                     
                                                                                
  DXCCSR_DIG017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG017"                                                                     
                                                                                
  DXCCSR_DIG018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG018"                                                                     
                                                                                
  DXCCSR_DIG019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG019"                                                                     
                                                                                
  DXCCSR_DIG020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG020"                                                                     
                                                                                
  DXCCSR_DIG021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG021"                                                                     
                                                                                
  DXCCSR_DIG022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG022"                                                                     
                                                                                
  DXCCSR_DIG023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG023"                                                                     
                                                                                
  DXCCSR_DIG024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG024"                                                                     
                                                                                
  DXCCSR_DIG025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR DIG025"                                                                     
                                                                                
  DXCCSR_EAR001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EAR001"                                                                     
                                                                                
  DXCCSR_EAR002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EAR002"                                                                     
                                                                                
  DXCCSR_EAR003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EAR003"                                                                     
                                                                                
  DXCCSR_EAR004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EAR004"                                                                     
                                                                                
  DXCCSR_EAR005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EAR005"                                                                     
                                                                                
  DXCCSR_EAR006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EAR006"                                                                     
                                                                                
  DXCCSR_END001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END001"                                                                     
                                                                                
  DXCCSR_END002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END002"                                                                     
                                                                                
  DXCCSR_END003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END003"                                                                     
                                                                                
  DXCCSR_END004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END004"                                                                     
                                                                                
  DXCCSR_END005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END005"                                                                     
                                                                                
  DXCCSR_END006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END006"                                                                     
                                                                                
  DXCCSR_END007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END007"                                                                     
                                                                                
  DXCCSR_END008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END008"                                                                     
                                                                                
  DXCCSR_END009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END009"                                                                     
                                                                                
  DXCCSR_END010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END010"                                                                     
                                                                                
  DXCCSR_END011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END011"                                                                     
                                                                                
  DXCCSR_END012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END012"                                                                     
                                                                                
  DXCCSR_END013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END013"                                                                     
                                                                                
  DXCCSR_END014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END014"                                                                     
                                                                                
  DXCCSR_END015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END015"                                                                     
                                                                                
  DXCCSR_END016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END016"                                                                     
                                                                                
  DXCCSR_END017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR END017"                                                                     
                                                                                
  DXCCSR_EXT001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT001"                                                                     
                                                                                
  DXCCSR_EXT002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT002"                                                                     
                                                                                
  DXCCSR_EXT003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT003"                                                                     
                                                                                
  DXCCSR_EXT004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT004"                                                                     
                                                                                
  DXCCSR_EXT005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT005"                                                                     
                                                                                
  DXCCSR_EXT006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT006"                                                                     
                                                                                
  DXCCSR_EXT007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT007"                                                                     
                                                                                
  DXCCSR_EXT008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT008"                                                                     
                                                                                
  DXCCSR_EXT009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT009"                                                                     
                                                                                
  DXCCSR_EXT010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT010"                                                                     
                                                                                
  DXCCSR_EXT011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT011"                                                                     
                                                                                
  DXCCSR_EXT012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT012"                                                                     
                                                                                
  DXCCSR_EXT013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT013"                                                                     
                                                                                
  DXCCSR_EXT014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT014"                                                                     
                                                                                
  DXCCSR_EXT015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT015"                                                                     
                                                                                
  DXCCSR_EXT016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT016"                                                                     
                                                                                
  DXCCSR_EXT017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT017"                                                                     
                                                                                
  DXCCSR_EXT018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT018"                                                                     
                                                                                
  DXCCSR_EXT019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT019"                                                                     
                                                                                
  DXCCSR_EXT020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT020"                                                                     
                                                                                
  DXCCSR_EXT021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT021"                                                                     
                                                                                
  DXCCSR_EXT022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT022"                                                                     
                                                                                
  DXCCSR_EXT023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT023"                                                                     
                                                                                
  DXCCSR_EXT024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT024"                                                                     
                                                                                
  DXCCSR_EXT025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT025"                                                                     
                                                                                
  DXCCSR_EXT026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT026"                                                                     
                                                                                
  DXCCSR_EXT027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT027"                                                                     
                                                                                
  DXCCSR_EXT028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT028"                                                                     
                                                                                
  DXCCSR_EXT029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT029"                                                                     
                                                                                
  DXCCSR_EXT030              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EXT030"                                                                     
                                                                                
  DXCCSR_EYE001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE001"                                                                     
                                                                                
  DXCCSR_EYE002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE002"                                                                     
                                                                                
  DXCCSR_EYE003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE003"                                                                     
                                                                                
  DXCCSR_EYE004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE004"                                                                     
                                                                                
  DXCCSR_EYE005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE005"                                                                     
                                                                                
  DXCCSR_EYE006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE006"                                                                     
                                                                                
  DXCCSR_EYE007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE007"                                                                     
                                                                                
  DXCCSR_EYE008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE008"                                                                     
                                                                                
  DXCCSR_EYE009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE009"                                                                     
                                                                                
  DXCCSR_EYE010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE010"                                                                     
                                                                                
  DXCCSR_EYE011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE011"                                                                     
                                                                                
  DXCCSR_EYE012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR EYE012"                                                                     
                                                                                
  DXCCSR_FAC001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC001"                                                                     
                                                                                
  DXCCSR_FAC002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC002"                                                                     
                                                                                
  DXCCSR_FAC003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC003"                                                                     
                                                                                
  DXCCSR_FAC004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC004"                                                                     
                                                                                
  DXCCSR_FAC005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC005"                                                                     
                                                                                
  DXCCSR_FAC006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC006"                                                                     
                                                                                
  DXCCSR_FAC007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC007"                                                                     
                                                                                
  DXCCSR_FAC008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC008"                                                                     
                                                                                
  DXCCSR_FAC009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC009"                                                                     
                                                                                
  DXCCSR_FAC010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC010"                                                                     
                                                                                
  DXCCSR_FAC011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC011"                                                                     
                                                                                
  DXCCSR_FAC012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC012"                                                                     
                                                                                
  DXCCSR_FAC013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC013"                                                                     
                                                                                
  DXCCSR_FAC014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC014"                                                                     
                                                                                
  DXCCSR_FAC015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC015"                                                                     
                                                                                
  DXCCSR_FAC016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC016"                                                                     
                                                                                
  DXCCSR_FAC017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC017"                                                                     
                                                                                
  DXCCSR_FAC018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC018"                                                                     
                                                                                
  DXCCSR_FAC019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC019"                                                                     
                                                                                
  DXCCSR_FAC020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC020"                                                                     
                                                                                
  DXCCSR_FAC021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC021"                                                                     
                                                                                
  DXCCSR_FAC022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC022"                                                                     
                                                                                
  DXCCSR_FAC023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC023"                                                                     
                                                                                
  DXCCSR_FAC024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC024"                                                                     
                                                                                
  DXCCSR_FAC025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR FAC025"                                                                     
                                                                                
  DXCCSR_GEN001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN001"                                                                     
                                                                                
  DXCCSR_GEN002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN002"                                                                     
                                                                                
  DXCCSR_GEN003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN003"                                                                     
                                                                                
  DXCCSR_GEN004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN004"                                                                     
                                                                                
  DXCCSR_GEN005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN005"                                                                     
                                                                                
  DXCCSR_GEN006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN006"                                                                     
                                                                                
  DXCCSR_GEN007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN007"                                                                     
                                                                                
  DXCCSR_GEN008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN008"                                                                     
                                                                                
  DXCCSR_GEN009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN009"                                                                     
                                                                                
  DXCCSR_GEN010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN010"                                                                     
                                                                                
  DXCCSR_GEN011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN011"                                                                     
                                                                                
  DXCCSR_GEN012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN012"                                                                     
                                                                                
  DXCCSR_GEN013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN013"                                                                     
                                                                                
  DXCCSR_GEN014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN014"                                                                     
                                                                                
  DXCCSR_GEN015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN015"                                                                     
                                                                                
  DXCCSR_GEN016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN016"                                                                     
                                                                                
  DXCCSR_GEN017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN017"                                                                     
                                                                                
  DXCCSR_GEN018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN018"                                                                     
                                                                                
  DXCCSR_GEN019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN019"                                                                     
                                                                                
  DXCCSR_GEN020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN020"                                                                     
                                                                                
  DXCCSR_GEN021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN021"                                                                     
                                                                                
  DXCCSR_GEN022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN022"                                                                     
                                                                                
  DXCCSR_GEN023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN023"                                                                     
                                                                                
  DXCCSR_GEN024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN024"                                                                     
                                                                                
  DXCCSR_GEN025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN025"                                                                     
                                                                                
  DXCCSR_GEN026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR GEN026"                                                                     
                                                                                
  DXCCSR_INF001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF001"                                                                     
                                                                                
  DXCCSR_INF002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF002"                                                                     
                                                                                
  DXCCSR_INF003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF003"                                                                     
                                                                                
  DXCCSR_INF004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF004"                                                                     
                                                                                
  DXCCSR_INF005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF005"                                                                     
                                                                                
  DXCCSR_INF006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF006"                                                                     
                                                                                
  DXCCSR_INF007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF007"                                                                     
                                                                                
  DXCCSR_INF008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF008"                                                                     
                                                                                
  DXCCSR_INF009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF009"                                                                     
                                                                                
  DXCCSR_INF010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF010"                                                                     
                                                                                
  DXCCSR_INF011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF011"                                                                     
                                                                                
  DXCCSR_INF012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INF012"                                                                     
                                                                                
  DXCCSR_INJ001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ001"                                                                     
                                                                                
  DXCCSR_INJ002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ002"                                                                     
                                                                                
  DXCCSR_INJ003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ003"                                                                     
                                                                                
  DXCCSR_INJ004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ004"                                                                     
                                                                                
  DXCCSR_INJ005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ005"                                                                     
                                                                                
  DXCCSR_INJ006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ006"                                                                     
                                                                                
  DXCCSR_INJ007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ007"                                                                     
                                                                                
  DXCCSR_INJ008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ008"                                                                     
                                                                                
  DXCCSR_INJ009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ009"                                                                     
                                                                                
  DXCCSR_INJ010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ010"                                                                     
                                                                                
  DXCCSR_INJ011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ011"                                                                     
                                                                                
  DXCCSR_INJ012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ012"                                                                     
                                                                                
  DXCCSR_INJ013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ013"                                                                     
                                                                                
  DXCCSR_INJ014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ014"                                                                     
                                                                                
  DXCCSR_INJ015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ015"                                                                     
                                                                                
  DXCCSR_INJ016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ016"                                                                     
                                                                                
  DXCCSR_INJ017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ017"                                                                     
                                                                                
  DXCCSR_INJ018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ018"                                                                     
                                                                                
  DXCCSR_INJ019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ019"                                                                     
                                                                                
  DXCCSR_INJ020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ020"                                                                     
                                                                                
  DXCCSR_INJ021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ021"                                                                     
                                                                                
  DXCCSR_INJ022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ022"                                                                     
                                                                                
  DXCCSR_INJ023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ023"                                                                     
                                                                                
  DXCCSR_INJ024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ024"                                                                     
                                                                                
  DXCCSR_INJ025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ025"                                                                     
                                                                                
  DXCCSR_INJ026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ026"                                                                     
                                                                                
  DXCCSR_INJ027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ027"                                                                     
                                                                                
  DXCCSR_INJ028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ028"                                                                     
                                                                                
  DXCCSR_INJ029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ029"                                                                     
                                                                                
  DXCCSR_INJ030              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ030"                                                                     
                                                                                
  DXCCSR_INJ031              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ031"                                                                     
                                                                                
  DXCCSR_INJ032              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ032"                                                                     
                                                                                
  DXCCSR_INJ033              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ033"                                                                     
                                                                                
  DXCCSR_INJ034              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ034"                                                                     
                                                                                
  DXCCSR_INJ035              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ035"                                                                     
                                                                                
  DXCCSR_INJ036              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ036"                                                                     
                                                                                
  DXCCSR_INJ037              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ037"                                                                     
                                                                                
  DXCCSR_INJ038              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ038"                                                                     
                                                                                
  DXCCSR_INJ039              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ039"                                                                     
                                                                                
  DXCCSR_INJ040              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ040"                                                                     
                                                                                
  DXCCSR_INJ041              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ041"                                                                     
                                                                                
  DXCCSR_INJ042              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ042"                                                                     
                                                                                
  DXCCSR_INJ043              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ043"                                                                     
                                                                                
  DXCCSR_INJ044              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ044"                                                                     
                                                                                
  DXCCSR_INJ045              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ045"                                                                     
                                                                                
  DXCCSR_INJ046              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ046"                                                                     
                                                                                
  DXCCSR_INJ047              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ047"                                                                     
                                                                                
  DXCCSR_INJ048              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ048"                                                                     
                                                                                
  DXCCSR_INJ049              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ049"                                                                     
                                                                                
  DXCCSR_INJ050              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ050"                                                                     
                                                                                
  DXCCSR_INJ051              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ051"                                                                     
                                                                                
  DXCCSR_INJ052              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ052"                                                                     
                                                                                
  DXCCSR_INJ053              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ053"                                                                     
                                                                                
  DXCCSR_INJ054              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ054"                                                                     
                                                                                
  DXCCSR_INJ055              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ055"                                                                     
                                                                                
  DXCCSR_INJ056              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ056"                                                                     
                                                                                
  DXCCSR_INJ057              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ057"                                                                     
                                                                                
  DXCCSR_INJ058              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ058"                                                                     
                                                                                
  DXCCSR_INJ059              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ059"                                                                     
                                                                                
  DXCCSR_INJ060              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ060"                                                                     
                                                                                
  DXCCSR_INJ061              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ061"                                                                     
                                                                                
  DXCCSR_INJ062              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ062"                                                                     
                                                                                
  DXCCSR_INJ063              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ063"                                                                     
                                                                                
  DXCCSR_INJ064              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ064"                                                                     
                                                                                
  DXCCSR_INJ065              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ065"                                                                     
                                                                                
  DXCCSR_INJ066              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ066"                                                                     
                                                                                
  DXCCSR_INJ067              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ067"                                                                     
                                                                                
  DXCCSR_INJ068              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ068"                                                                     
                                                                                
  DXCCSR_INJ069              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ069"                                                                     
                                                                                
  DXCCSR_INJ070              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ070"                                                                     
                                                                                
  DXCCSR_INJ071              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ071"                                                                     
                                                                                
  DXCCSR_INJ072              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ072"                                                                     
                                                                                
  DXCCSR_INJ073              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ073"                                                                     
                                                                                
  DXCCSR_INJ074              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ074"                                                                     
                                                                                
  DXCCSR_INJ075              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ075"                                                                     
                                                                                
  DXCCSR_INJ076              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR INJ076"                                                                     
                                                                                
  DXCCSR_MAL001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL001"                                                                     
                                                                                
  DXCCSR_MAL002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL002"                                                                     
                                                                                
  DXCCSR_MAL003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL003"                                                                     
                                                                                
  DXCCSR_MAL004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL004"                                                                     
                                                                                
  DXCCSR_MAL005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL005"                                                                     
                                                                                
  DXCCSR_MAL006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL006"                                                                     
                                                                                
  DXCCSR_MAL007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL007"                                                                     
                                                                                
  DXCCSR_MAL008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL008"                                                                     
                                                                                
  DXCCSR_MAL009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL009"                                                                     
                                                                                
  DXCCSR_MAL010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MAL010"                                                                     
                                                                                
  DXCCSR_MBD001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD001"                                                                     
                                                                                
  DXCCSR_MBD002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD002"                                                                     
                                                                                
  DXCCSR_MBD003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD003"                                                                     
                                                                                
  DXCCSR_MBD004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD004"                                                                     
                                                                                
  DXCCSR_MBD005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD005"                                                                     
                                                                                
  DXCCSR_MBD006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD006"                                                                     
                                                                                
  DXCCSR_MBD007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD007"                                                                     
                                                                                
  DXCCSR_MBD008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD008"                                                                     
                                                                                
  DXCCSR_MBD009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD009"                                                                     
                                                                                
  DXCCSR_MBD010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD010"                                                                     
                                                                                
  DXCCSR_MBD011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD011"                                                                     
                                                                                
  DXCCSR_MBD012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD012"                                                                     
                                                                                
  DXCCSR_MBD013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD013"                                                                     
                                                                                
  DXCCSR_MBD014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD014"                                                                     
                                                                                
  DXCCSR_MBD017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD017"                                                                     
                                                                                
  DXCCSR_MBD018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD018"                                                                     
                                                                                
  DXCCSR_MBD019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD019"                                                                     
                                                                                
  DXCCSR_MBD020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD020"                                                                     
                                                                                
  DXCCSR_MBD021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD021"                                                                     
                                                                                
  DXCCSR_MBD022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD022"                                                                     
                                                                                
  DXCCSR_MBD023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD023"                                                                     
                                                                                
  DXCCSR_MBD024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD024"                                                                     
                                                                                
  DXCCSR_MBD025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD025"                                                                     
                                                                                
  DXCCSR_MBD026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD026"                                                                     
                                                                                
  DXCCSR_MBD027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD027"                                                                     
                                                                                
  DXCCSR_MBD028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD028"                                                                     
                                                                                
  DXCCSR_MBD029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD029"                                                                     
                                                                                
  DXCCSR_MBD030              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD030"                                                                     
                                                                                
  DXCCSR_MBD031              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD031"                                                                     
                                                                                
  DXCCSR_MBD032              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD032"                                                                     
                                                                                
  DXCCSR_MBD033              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD033"                                                                     
                                                                                
  DXCCSR_MBD034              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MBD034"                                                                     
                                                                                
  DXCCSR_MUS001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS001"                                                                     
                                                                                
  DXCCSR_MUS002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS002"                                                                     
                                                                                
  DXCCSR_MUS003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS003"                                                                     
                                                                                
  DXCCSR_MUS004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS004"                                                                     
                                                                                
  DXCCSR_MUS005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS005"                                                                     
                                                                                
  DXCCSR_MUS006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS006"                                                                     
                                                                                
  DXCCSR_MUS007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS007"                                                                     
                                                                                
  DXCCSR_MUS008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS008"                                                                     
                                                                                
  DXCCSR_MUS009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS009"                                                                     
                                                                                
  DXCCSR_MUS010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS010"                                                                     
                                                                                
  DXCCSR_MUS011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS011"                                                                     
                                                                                
  DXCCSR_MUS012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS012"                                                                     
                                                                                
  DXCCSR_MUS013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS013"                                                                     
                                                                                
  DXCCSR_MUS014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS014"                                                                     
                                                                                
  DXCCSR_MUS015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS015"                                                                     
                                                                                
  DXCCSR_MUS016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS016"                                                                     
                                                                                
  DXCCSR_MUS017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS017"                                                                     
                                                                                
  DXCCSR_MUS018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS018"                                                                     
                                                                                
  DXCCSR_MUS019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS019"                                                                     
                                                                                
  DXCCSR_MUS020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS020"                                                                     
                                                                                
  DXCCSR_MUS021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS021"                                                                     
                                                                                
  DXCCSR_MUS022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS022"                                                                     
                                                                                
  DXCCSR_MUS023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS023"                                                                     
                                                                                
  DXCCSR_MUS024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS024"                                                                     
                                                                                
  DXCCSR_MUS025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS025"                                                                     
                                                                                
  DXCCSR_MUS026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS026"                                                                     
                                                                                
  DXCCSR_MUS027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS027"                                                                     
                                                                                
  DXCCSR_MUS028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS028"                                                                     
                                                                                
  DXCCSR_MUS029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS029"                                                                     
                                                                                
  DXCCSR_MUS030              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS030"                                                                     
                                                                                
  DXCCSR_MUS031              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS031"                                                                     
                                                                                
  DXCCSR_MUS032              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS032"                                                                     
                                                                                
  DXCCSR_MUS033              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS033"                                                                     
                                                                                
  DXCCSR_MUS034              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS034"                                                                     
                                                                                
  DXCCSR_MUS035              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS035"                                                                     
                                                                                
  DXCCSR_MUS036              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS036"                                                                     
                                                                                
  DXCCSR_MUS037              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS037"                                                                     
                                                                                
  DXCCSR_MUS038              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR MUS038"                                                                     
                                                                                
  DXCCSR_NEO001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO001"                                                                     
                                                                                
  DXCCSR_NEO002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO002"                                                                     
                                                                                
  DXCCSR_NEO003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO003"                                                                     
                                                                                
  DXCCSR_NEO004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO004"                                                                     
                                                                                
  DXCCSR_NEO005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO005"                                                                     
                                                                                
  DXCCSR_NEO006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO006"                                                                     
                                                                                
  DXCCSR_NEO007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO007"                                                                     
                                                                                
  DXCCSR_NEO008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO008"                                                                     
                                                                                
  DXCCSR_NEO009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO009"                                                                     
                                                                                
  DXCCSR_NEO010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO010"                                                                     
                                                                                
  DXCCSR_NEO011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO011"                                                                     
                                                                                
  DXCCSR_NEO012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO012"                                                                     
                                                                                
  DXCCSR_NEO013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO013"                                                                     
                                                                                
  DXCCSR_NEO014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO014"                                                                     
                                                                                
  DXCCSR_NEO015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO015"                                                                     
                                                                                
  DXCCSR_NEO016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO016"                                                                     
                                                                                
  DXCCSR_NEO017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO017"                                                                     
                                                                                
  DXCCSR_NEO018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO018"                                                                     
                                                                                
  DXCCSR_NEO019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO019"                                                                     
                                                                                
  DXCCSR_NEO020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO020"                                                                     
                                                                                
  DXCCSR_NEO021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO021"                                                                     
                                                                                
  DXCCSR_NEO022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO022"                                                                     
                                                                                
  DXCCSR_NEO023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO023"                                                                     
                                                                                
  DXCCSR_NEO024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO024"                                                                     
                                                                                
  DXCCSR_NEO025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO025"                                                                     
                                                                                
  DXCCSR_NEO026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO026"                                                                     
                                                                                
  DXCCSR_NEO027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO027"                                                                     
                                                                                
  DXCCSR_NEO028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO028"                                                                     
                                                                                
  DXCCSR_NEO029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO029"                                                                     
                                                                                
  DXCCSR_NEO030              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO030"                                                                     
                                                                                
  DXCCSR_NEO031              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO031"                                                                     
                                                                                
  DXCCSR_NEO032              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO032"                                                                     
                                                                                
  DXCCSR_NEO033              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO033"                                                                     
                                                                                
  DXCCSR_NEO034              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO034"                                                                     
                                                                                
  DXCCSR_NEO035              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO035"                                                                     
                                                                                
  DXCCSR_NEO036              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO036"                                                                     
                                                                                
  DXCCSR_NEO037              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO037"                                                                     
                                                                                
  DXCCSR_NEO038              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO038"                                                                     
                                                                                
  DXCCSR_NEO039              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO039"                                                                     
                                                                                
  DXCCSR_NEO040              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO040"                                                                     
                                                                                
  DXCCSR_NEO041              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO041"                                                                     
                                                                                
  DXCCSR_NEO042              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO042"                                                                     
                                                                                
  DXCCSR_NEO043              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO043"                                                                     
                                                                                
  DXCCSR_NEO044              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO044"                                                                     
                                                                                
  DXCCSR_NEO045              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO045"                                                                     
                                                                                
  DXCCSR_NEO046              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO046"                                                                     
                                                                                
  DXCCSR_NEO047              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO047"                                                                     
                                                                                
  DXCCSR_NEO048              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO048"                                                                     
                                                                                
  DXCCSR_NEO049              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO049"                                                                     
                                                                                
  DXCCSR_NEO050              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO050"                                                                     
                                                                                
  DXCCSR_NEO051              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO051"                                                                     
                                                                                
  DXCCSR_NEO052              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO052"                                                                     
                                                                                
  DXCCSR_NEO053              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO053"                                                                     
                                                                                
  DXCCSR_NEO054              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO054"                                                                     
                                                                                
  DXCCSR_NEO055              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO055"                                                                     
                                                                                
  DXCCSR_NEO056              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO056"                                                                     
                                                                                
  DXCCSR_NEO057              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO057"                                                                     
                                                                                
  DXCCSR_NEO058              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO058"                                                                     
                                                                                
  DXCCSR_NEO059              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO059"                                                                     
                                                                                
  DXCCSR_NEO060              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO060"                                                                     
                                                                                
  DXCCSR_NEO061              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO061"                                                                     
                                                                                
  DXCCSR_NEO062              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO062"                                                                     
                                                                                
  DXCCSR_NEO063              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO063"                                                                     
                                                                                
  DXCCSR_NEO064              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO064"                                                                     
                                                                                
  DXCCSR_NEO065              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO065"                                                                     
                                                                                
  DXCCSR_NEO066              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO066"                                                                     
                                                                                
  DXCCSR_NEO067              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO067"                                                                     
                                                                                
  DXCCSR_NEO068              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO068"                                                                     
                                                                                
  DXCCSR_NEO069              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO069"                                                                     
                                                                                
  DXCCSR_NEO070              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO070"                                                                     
                                                                                
  DXCCSR_NEO071              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO071"                                                                     
                                                                                
  DXCCSR_NEO072              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO072"                                                                     
                                                                                
  DXCCSR_NEO073              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO073"                                                                     
                                                                                
  DXCCSR_NEO074              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NEO074"                                                                     
                                                                                
  DXCCSR_NVS001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS001"                                                                     
                                                                                
  DXCCSR_NVS002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS002"                                                                     
                                                                                
  DXCCSR_NVS003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS003"                                                                     
                                                                                
  DXCCSR_NVS004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS004"                                                                     
                                                                                
  DXCCSR_NVS005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS005"                                                                     
                                                                                
  DXCCSR_NVS006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS006"                                                                     
                                                                                
  DXCCSR_NVS007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS007"                                                                     
                                                                                
  DXCCSR_NVS008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS008"                                                                     
                                                                                
  DXCCSR_NVS009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS009"                                                                     
                                                                                
  DXCCSR_NVS010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS010"                                                                     
                                                                                
  DXCCSR_NVS011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS011"                                                                     
                                                                                
  DXCCSR_NVS012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS012"                                                                     
                                                                                
  DXCCSR_NVS013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS013"                                                                     
                                                                                
  DXCCSR_NVS014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS014"                                                                     
                                                                                
  DXCCSR_NVS015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS015"                                                                     
                                                                                
  DXCCSR_NVS016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS016"                                                                     
                                                                                
  DXCCSR_NVS017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS017"                                                                     
                                                                                
  DXCCSR_NVS018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS018"                                                                     
                                                                                
  DXCCSR_NVS019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS019"                                                                     
                                                                                
  DXCCSR_NVS020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS020"                                                                     
                                                                                
  DXCCSR_NVS021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS021"                                                                     
                                                                                
  DXCCSR_NVS022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR NVS022"                                                                     
                                                                                
  DXCCSR_PNL001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL001"                                                                     
                                                                                
  DXCCSR_PNL002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL002"                                                                     
                                                                                
  DXCCSR_PNL003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL003"                                                                     
                                                                                
  DXCCSR_PNL004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL004"                                                                     
                                                                                
  DXCCSR_PNL005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL005"                                                                     
                                                                                
  DXCCSR_PNL006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL006"                                                                     
                                                                                
  DXCCSR_PNL007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL007"                                                                     
                                                                                
  DXCCSR_PNL008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL008"                                                                     
                                                                                
  DXCCSR_PNL009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL009"                                                                     
                                                                                
  DXCCSR_PNL010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL010"                                                                     
                                                                                
  DXCCSR_PNL011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL011"                                                                     
                                                                                
  DXCCSR_PNL012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL012"                                                                     
                                                                                
  DXCCSR_PNL013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL013"                                                                     
                                                                                
  DXCCSR_PNL014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL014"                                                                     
                                                                                
  DXCCSR_PNL015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PNL015"                                                                     
                                                                                
  DXCCSR_PRG001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG001"                                                                     
                                                                                
  DXCCSR_PRG002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG002"                                                                     
                                                                                
  DXCCSR_PRG003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG003"                                                                     
                                                                                
  DXCCSR_PRG004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG004"                                                                     
                                                                                
  DXCCSR_PRG005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG005"                                                                     
                                                                                
  DXCCSR_PRG006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG006"                                                                     
                                                                                
  DXCCSR_PRG007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG007"                                                                     
                                                                                
  DXCCSR_PRG008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG008"                                                                     
                                                                                
  DXCCSR_PRG009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG009"                                                                     
                                                                                
  DXCCSR_PRG010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG010"                                                                     
                                                                                
  DXCCSR_PRG011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG011"                                                                     
                                                                                
  DXCCSR_PRG012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG012"                                                                     
                                                                                
  DXCCSR_PRG013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG013"                                                                     
                                                                                
  DXCCSR_PRG014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG014"                                                                     
                                                                                
  DXCCSR_PRG015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG015"                                                                     
                                                                                
  DXCCSR_PRG016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG016"                                                                     
                                                                                
  DXCCSR_PRG017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG017"                                                                     
                                                                                
  DXCCSR_PRG018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG018"                                                                     
                                                                                
  DXCCSR_PRG019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG019"                                                                     
                                                                                
  DXCCSR_PRG020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG020"                                                                     
                                                                                
  DXCCSR_PRG021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG021"                                                                     
                                                                                
  DXCCSR_PRG022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG022"                                                                     
                                                                                
  DXCCSR_PRG023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG023"                                                                     
                                                                                
  DXCCSR_PRG024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG024"                                                                     
                                                                                
  DXCCSR_PRG025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG025"                                                                     
                                                                                
  DXCCSR_PRG026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG026"                                                                     
                                                                                
  DXCCSR_PRG027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG027"                                                                     
                                                                                
  DXCCSR_PRG028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG028"                                                                     
                                                                                
  DXCCSR_PRG029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG029"                                                                     
                                                                                
  DXCCSR_PRG030              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR PRG030"                                                                     
                                                                                
  DXCCSR_RSP001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP001"                                                                     
                                                                                
  DXCCSR_RSP002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP002"                                                                     
                                                                                
  DXCCSR_RSP003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP003"                                                                     
                                                                                
  DXCCSR_RSP004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP004"                                                                     
                                                                                
  DXCCSR_RSP005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP005"                                                                     
                                                                                
  DXCCSR_RSP006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP006"                                                                     
                                                                                
  DXCCSR_RSP007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP007"                                                                     
                                                                                
  DXCCSR_RSP008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP008"                                                                     
                                                                                
  DXCCSR_RSP009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP009"                                                                     
                                                                                
  DXCCSR_RSP010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP010"                                                                     
                                                                                
  DXCCSR_RSP011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP011"                                                                     
                                                                                
  DXCCSR_RSP012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP012"                                                                     
                                                                                
  DXCCSR_RSP013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP013"                                                                     
                                                                                
  DXCCSR_RSP014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP014"                                                                     
                                                                                
  DXCCSR_RSP015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP015"                                                                     
                                                                                
  DXCCSR_RSP016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP016"                                                                     
                                                                                
  DXCCSR_RSP017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR RSP017"                                                                     
                                                                                
  DXCCSR_SKN001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SKN001"                                                                     
                                                                                
  DXCCSR_SKN002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SKN002"                                                                     
                                                                                
  DXCCSR_SKN003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SKN003"                                                                     
                                                                                
  DXCCSR_SKN004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SKN004"                                                                     
                                                                                
  DXCCSR_SKN005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SKN005"                                                                     
                                                                                
  DXCCSR_SKN006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SKN006"                                                                     
                                                                                
  DXCCSR_SKN007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SKN007"                                                                     
                                                                                
  DXCCSR_SYM001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM001"                                                                     
                                                                                
  DXCCSR_SYM002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM002"                                                                     
                                                                                
  DXCCSR_SYM003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM003"                                                                     
                                                                                
  DXCCSR_SYM004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM004"                                                                     
                                                                                
  DXCCSR_SYM005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM005"                                                                     
                                                                                
  DXCCSR_SYM006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM006"                                                                     
                                                                                
  DXCCSR_SYM007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM007"                                                                     
                                                                                
  DXCCSR_SYM008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM008"                                                                     
                                                                                
  DXCCSR_SYM009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM009"                                                                     
                                                                                
  DXCCSR_SYM010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM010"                                                                     
                                                                                
  DXCCSR_SYM011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM011"                                                                     
                                                                                
  DXCCSR_SYM012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM012"                                                                     
                                                                                
  DXCCSR_SYM013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM013"                                                                     
                                                                                
  DXCCSR_SYM014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM014"                                                                     
                                                                                
  DXCCSR_SYM015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM015"                                                                     
                                                                                
  DXCCSR_SYM016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM016"                                                                     
                                                                                
  DXCCSR_SYM017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-CM diagnosis on the record is included in C
CSR SYM017"                                                                     
                                                                                
  DXCCSR_VERSION             LENGTH=$6                                          
  LABEL="Version of CCSR for ICD-10-CM diagnoses"                               
                                                                                
  PRCCSR_ADM001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM001"                                                                    
                                                                                
  PRCCSR_ADM002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM002"                                                                    
                                                                                
  PRCCSR_ADM003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM003"                                                                    
                                                                                
  PRCCSR_ADM004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM004"                                                                    
                                                                                
  PRCCSR_ADM005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM005"                                                                    
                                                                                
  PRCCSR_ADM006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM006"                                                                    
                                                                                
  PRCCSR_ADM007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM007"                                                                    
                                                                                
  PRCCSR_ADM008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM008"                                                                    
                                                                                
  PRCCSR_ADM009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM009"                                                                    
                                                                                
  PRCCSR_ADM010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM010"                                                                    
                                                                                
  PRCCSR_ADM011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM011"                                                                    
                                                                                
  PRCCSR_ADM012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM012"                                                                    
                                                                                
  PRCCSR_ADM013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM013"                                                                    
                                                                                
  PRCCSR_ADM014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM014"                                                                    
                                                                                
  PRCCSR_ADM015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM015"                                                                    
                                                                                
  PRCCSR_ADM016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM016"                                                                    
                                                                                
  PRCCSR_ADM017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM017"                                                                    
                                                                                
  PRCCSR_ADM018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM018"                                                                    
                                                                                
  PRCCSR_ADM019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM019"                                                                    
                                                                                
  PRCCSR_ADM020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM020"                                                                    
                                                                                
  PRCCSR_ADM021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM021"                                                                    
                                                                                
  PRCCSR_ADM022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ADM022"                                                                    
                                                                                
  PRCCSR_CAR001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR001"                                                                    
                                                                                
  PRCCSR_CAR002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR002"                                                                    
                                                                                
  PRCCSR_CAR003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR003"                                                                    
                                                                                
  PRCCSR_CAR004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR004"                                                                    
                                                                                
  PRCCSR_CAR005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR005"                                                                    
                                                                                
  PRCCSR_CAR006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR006"                                                                    
                                                                                
  PRCCSR_CAR007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR007"                                                                    
                                                                                
  PRCCSR_CAR008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR008"                                                                    
                                                                                
  PRCCSR_CAR009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR009"                                                                    
                                                                                
  PRCCSR_CAR010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR010"                                                                    
                                                                                
  PRCCSR_CAR011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR011"                                                                    
                                                                                
  PRCCSR_CAR012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR012"                                                                    
                                                                                
  PRCCSR_CAR013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR013"                                                                    
                                                                                
  PRCCSR_CAR014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR014"                                                                    
                                                                                
  PRCCSR_CAR015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR015"                                                                    
                                                                                
  PRCCSR_CAR016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR016"                                                                    
                                                                                
  PRCCSR_CAR017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR017"                                                                    
                                                                                
  PRCCSR_CAR018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR018"                                                                    
                                                                                
  PRCCSR_CAR019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR019"                                                                    
                                                                                
  PRCCSR_CAR020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR020"                                                                    
                                                                                
  PRCCSR_CAR021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR021"                                                                    
                                                                                
  PRCCSR_CAR022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR022"                                                                    
                                                                                
  PRCCSR_CAR023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR023"                                                                    
                                                                                
  PRCCSR_CAR024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR024"                                                                    
                                                                                
  PRCCSR_CAR025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR025"                                                                    
                                                                                
  PRCCSR_CAR026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR026"                                                                    
                                                                                
  PRCCSR_CAR027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR027"                                                                    
                                                                                
  PRCCSR_CAR028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR028"                                                                    
                                                                                
  PRCCSR_CAR029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CAR029"                                                                    
                                                                                
  PRCCSR_CHP001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CHP001"                                                                    
                                                                                
  PRCCSR_CNS001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS001"                                                                    
                                                                                
  PRCCSR_CNS002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS002"                                                                    
                                                                                
  PRCCSR_CNS003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS003"                                                                    
                                                                                
  PRCCSR_CNS004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS004"                                                                    
                                                                                
  PRCCSR_CNS005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS005"                                                                    
                                                                                
  PRCCSR_CNS006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS006"                                                                    
                                                                                
  PRCCSR_CNS007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS007"                                                                    
                                                                                
  PRCCSR_CNS008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS008"                                                                    
                                                                                
  PRCCSR_CNS009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS009"                                                                    
                                                                                
  PRCCSR_CNS010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS010"                                                                    
                                                                                
  PRCCSR_CNS011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS011"                                                                    
                                                                                
  PRCCSR_CNS012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS012"                                                                    
                                                                                
  PRCCSR_CNS013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS013"                                                                    
                                                                                
  PRCCSR_CNS014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR CNS014"                                                                    
                                                                                
  PRCCSR_ENP001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENP001"                                                                    
                                                                                
  PRCCSR_ENP002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENP002"                                                                    
                                                                                
  PRCCSR_ENP003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENP003"                                                                    
                                                                                
  PRCCSR_ENP004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENP004"                                                                    
                                                                                
  PRCCSR_ENP005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENP005"                                                                    
                                                                                
  PRCCSR_ENP006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENP006"                                                                    
                                                                                
  PRCCSR_ENT001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT001"                                                                    
                                                                                
  PRCCSR_ENT002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT002"                                                                    
                                                                                
  PRCCSR_ENT003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT003"                                                                    
                                                                                
  PRCCSR_ENT004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT004"                                                                    
                                                                                
  PRCCSR_ENT005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT005"                                                                    
                                                                                
  PRCCSR_ENT006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT006"                                                                    
                                                                                
  PRCCSR_ENT007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT007"                                                                    
                                                                                
  PRCCSR_ENT008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT008"                                                                    
                                                                                
  PRCCSR_ENT009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT009"                                                                    
                                                                                
  PRCCSR_ENT010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT010"                                                                    
                                                                                
  PRCCSR_ENT011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT011"                                                                    
                                                                                
  PRCCSR_ENT012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT012"                                                                    
                                                                                
  PRCCSR_ENT013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT013"                                                                    
                                                                                
  PRCCSR_ENT014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT014"                                                                    
                                                                                
  PRCCSR_ENT015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT015"                                                                    
                                                                                
  PRCCSR_ENT016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT016"                                                                    
                                                                                
  PRCCSR_ENT017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ENT017"                                                                    
                                                                                
  PRCCSR_ESA001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA001"                                                                    
                                                                                
  PRCCSR_ESA002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA002"                                                                    
                                                                                
  PRCCSR_ESA003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA003"                                                                    
                                                                                
  PRCCSR_ESA004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA004"                                                                    
                                                                                
  PRCCSR_ESA005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA005"                                                                    
                                                                                
  PRCCSR_ESA006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA006"                                                                    
                                                                                
  PRCCSR_ESA007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA007"                                                                    
                                                                                
  PRCCSR_ESA008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA008"                                                                    
                                                                                
  PRCCSR_ESA009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA009"                                                                    
                                                                                
  PRCCSR_ESA010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA010"                                                                    
                                                                                
  PRCCSR_ESA011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR ESA011"                                                                    
                                                                                
  PRCCSR_EST001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR EST001"                                                                    
                                                                                
  PRCCSR_EST002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR EST002"                                                                    
                                                                                
  PRCCSR_EST003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR EST003"                                                                    
                                                                                
  PRCCSR_EST004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR EST004"                                                                    
                                                                                
  PRCCSR_EST005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR EST005"                                                                    
                                                                                
  PRCCSR_EYP001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR EYP001"                                                                    
                                                                                
  PRCCSR_EYP002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR EYP002"                                                                    
                                                                                
  PRCCSR_FRS001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS001"                                                                    
                                                                                
  PRCCSR_FRS002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS002"                                                                    
                                                                                
  PRCCSR_FRS003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS003"                                                                    
                                                                                
  PRCCSR_FRS004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS004"                                                                    
                                                                                
  PRCCSR_FRS005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS005"                                                                    
                                                                                
  PRCCSR_FRS006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS006"                                                                    
                                                                                
  PRCCSR_FRS007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS007"                                                                    
                                                                                
  PRCCSR_FRS008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS008"                                                                    
                                                                                
  PRCCSR_FRS009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS009"                                                                    
                                                                                
  PRCCSR_FRS010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS010"                                                                    
                                                                                
  PRCCSR_FRS011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS011"                                                                    
                                                                                
  PRCCSR_FRS012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS012"                                                                    
                                                                                
  PRCCSR_FRS013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS013"                                                                    
                                                                                
  PRCCSR_FRS014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS014"                                                                    
                                                                                
  PRCCSR_FRS015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR FRS015"                                                                    
                                                                                
  PRCCSR_GIS001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS001"                                                                    
                                                                                
  PRCCSR_GIS002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS002"                                                                    
                                                                                
  PRCCSR_GIS003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS003"                                                                    
                                                                                
  PRCCSR_GIS004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS004"                                                                    
                                                                                
  PRCCSR_GIS005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS005"                                                                    
                                                                                
  PRCCSR_GIS006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS006"                                                                    
                                                                                
  PRCCSR_GIS007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS007"                                                                    
                                                                                
  PRCCSR_GIS008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS008"                                                                    
                                                                                
  PRCCSR_GIS009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS009"                                                                    
                                                                                
  PRCCSR_GIS010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS010"                                                                    
                                                                                
  PRCCSR_GIS011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS011"                                                                    
                                                                                
  PRCCSR_GIS012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS012"                                                                    
                                                                                
  PRCCSR_GIS013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS013"                                                                    
                                                                                
  PRCCSR_GIS014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS014"                                                                    
                                                                                
  PRCCSR_GIS015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS015"                                                                    
                                                                                
  PRCCSR_GIS016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS016"                                                                    
                                                                                
  PRCCSR_GIS017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS017"                                                                    
                                                                                
  PRCCSR_GIS018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS018"                                                                    
                                                                                
  PRCCSR_GIS019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS019"                                                                    
                                                                                
  PRCCSR_GIS020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS020"                                                                    
                                                                                
  PRCCSR_GIS021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS021"                                                                    
                                                                                
  PRCCSR_GIS022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS022"                                                                    
                                                                                
  PRCCSR_GIS023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS023"                                                                    
                                                                                
  PRCCSR_GIS024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS024"                                                                    
                                                                                
  PRCCSR_GIS025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS025"                                                                    
                                                                                
  PRCCSR_GIS026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS026"                                                                    
                                                                                
  PRCCSR_GIS027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS027"                                                                    
                                                                                
  PRCCSR_GIS028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS028"                                                                    
                                                                                
  PRCCSR_GIS029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GIS029"                                                                    
                                                                                
  PRCCSR_GNR001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR001"                                                                    
                                                                                
  PRCCSR_GNR002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR002"                                                                    
                                                                                
  PRCCSR_GNR003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR003"                                                                    
                                                                                
  PRCCSR_GNR004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR004"                                                                    
                                                                                
  PRCCSR_GNR005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR005"                                                                    
                                                                                
  PRCCSR_GNR006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR006"                                                                    
                                                                                
  PRCCSR_GNR007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR007"                                                                    
                                                                                
  PRCCSR_GNR008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR008"                                                                    
                                                                                
  PRCCSR_GNR009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR009"                                                                    
                                                                                
  PRCCSR_GNR010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR GNR010"                                                                    
                                                                                
  PRCCSR_HEP001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP001"                                                                    
                                                                                
  PRCCSR_HEP002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP002"                                                                    
                                                                                
  PRCCSR_HEP003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP003"                                                                    
                                                                                
  PRCCSR_HEP004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP004"                                                                    
                                                                                
  PRCCSR_HEP005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP005"                                                                    
                                                                                
  PRCCSR_HEP006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP006"                                                                    
                                                                                
  PRCCSR_HEP007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP007"                                                                    
                                                                                
  PRCCSR_HEP008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP008"                                                                    
                                                                                
  PRCCSR_HEP009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP009"                                                                    
                                                                                
  PRCCSR_HEP010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP010"                                                                    
                                                                                
  PRCCSR_HEP011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP011"                                                                    
                                                                                
  PRCCSR_HEP012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP012"                                                                    
                                                                                
  PRCCSR_HEP013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR HEP013"                                                                    
                                                                                
  PRCCSR_IMG001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG001"                                                                    
                                                                                
  PRCCSR_IMG002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG002"                                                                    
                                                                                
  PRCCSR_IMG003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG003"                                                                    
                                                                                
  PRCCSR_IMG004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG004"                                                                    
                                                                                
  PRCCSR_IMG005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG005"                                                                    
                                                                                
  PRCCSR_IMG006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG006"                                                                    
                                                                                
  PRCCSR_IMG007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG007"                                                                    
                                                                                
  PRCCSR_IMG008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG008"                                                                    
                                                                                
  PRCCSR_IMG009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG009"                                                                    
                                                                                
  PRCCSR_IMG010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR IMG010"                                                                    
                                                                                
  PRCCSR_LYM001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM001"                                                                    
                                                                                
  PRCCSR_LYM002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM002"                                                                    
                                                                                
  PRCCSR_LYM003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM003"                                                                    
                                                                                
  PRCCSR_LYM004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM004"                                                                    
                                                                                
  PRCCSR_LYM005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM005"                                                                    
                                                                                
  PRCCSR_LYM006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM006"                                                                    
                                                                                
  PRCCSR_LYM007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM007"                                                                    
                                                                                
  PRCCSR_LYM008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM008"                                                                    
                                                                                
  PRCCSR_LYM009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM009"                                                                    
                                                                                
  PRCCSR_LYM010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM010"                                                                    
                                                                                
  PRCCSR_LYM011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR LYM011"                                                                    
                                                                                
  PRCCSR_MAM001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM001"                                                                    
                                                                                
  PRCCSR_MAM002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM002"                                                                    
                                                                                
  PRCCSR_MAM003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM003"                                                                    
                                                                                
  PRCCSR_MAM004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM004"                                                                    
                                                                                
  PRCCSR_MAM005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM005"                                                                    
                                                                                
  PRCCSR_MAM006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM006"                                                                    
                                                                                
  PRCCSR_MAM007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM007"                                                                    
                                                                                
  PRCCSR_MAM008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM008"                                                                    
                                                                                
  PRCCSR_MAM009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM009"                                                                    
                                                                                
  PRCCSR_MAM010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM010"                                                                    
                                                                                
  PRCCSR_MAM011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM011"                                                                    
                                                                                
  PRCCSR_MAM012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM012"                                                                    
                                                                                
  PRCCSR_MAM013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM013"                                                                    
                                                                                
  PRCCSR_MAM014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM014"                                                                    
                                                                                
  PRCCSR_MAM015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MAM015"                                                                    
                                                                                
  PRCCSR_MHT001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MHT001"                                                                    
                                                                                
  PRCCSR_MHT002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MHT002"                                                                    
                                                                                
  PRCCSR_MHT003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MHT003"                                                                    
                                                                                
  PRCCSR_MHT004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MHT004"                                                                    
                                                                                
  PRCCSR_MHT005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MHT005"                                                                    
                                                                                
  PRCCSR_MRS001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MRS001"                                                                    
                                                                                
  PRCCSR_MRS002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MRS002"                                                                    
                                                                                
  PRCCSR_MRS003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MRS003"                                                                    
                                                                                
  PRCCSR_MRS004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MRS004"                                                                    
                                                                                
  PRCCSR_MRS005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MRS005"                                                                    
                                                                                
  PRCCSR_MRS006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MRS006"                                                                    
                                                                                
  PRCCSR_MRS007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MRS007"                                                                    
                                                                                
  PRCCSR_MST001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST001"                                                                    
                                                                                
  PRCCSR_MST002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST002"                                                                    
                                                                                
  PRCCSR_MST003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST003"                                                                    
                                                                                
  PRCCSR_MST004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST004"                                                                    
                                                                                
  PRCCSR_MST005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST005"                                                                    
                                                                                
  PRCCSR_MST006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST006"                                                                    
                                                                                
  PRCCSR_MST007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST007"                                                                    
                                                                                
  PRCCSR_MST008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST008"                                                                    
                                                                                
  PRCCSR_MST009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST009"                                                                    
                                                                                
  PRCCSR_MST010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST010"                                                                    
                                                                                
  PRCCSR_MST011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST011"                                                                    
                                                                                
  PRCCSR_MST012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST012"                                                                    
                                                                                
  PRCCSR_MST013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST013"                                                                    
                                                                                
  PRCCSR_MST014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST014"                                                                    
                                                                                
  PRCCSR_MST015              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST015"                                                                    
                                                                                
  PRCCSR_MST016              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST016"                                                                    
                                                                                
  PRCCSR_MST017              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST017"                                                                    
                                                                                
  PRCCSR_MST018              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST018"                                                                    
                                                                                
  PRCCSR_MST019              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST019"                                                                    
                                                                                
  PRCCSR_MST020              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST020"                                                                    
                                                                                
  PRCCSR_MST021              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST021"                                                                    
                                                                                
  PRCCSR_MST022              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST022"                                                                    
                                                                                
  PRCCSR_MST023              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST023"                                                                    
                                                                                
  PRCCSR_MST024              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST024"                                                                    
                                                                                
  PRCCSR_MST025              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST025"                                                                    
                                                                                
  PRCCSR_MST026              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST026"                                                                    
                                                                                
  PRCCSR_MST027              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST027"                                                                    
                                                                                
  PRCCSR_MST028              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST028"                                                                    
                                                                                
  PRCCSR_MST029              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST029"                                                                    
                                                                                
  PRCCSR_MST030              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR MST030"                                                                    
                                                                                
  PRCCSR_NCM001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR NCM001"                                                                    
                                                                                
  PRCCSR_NCM002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR NCM002"                                                                    
                                                                                
  PRCCSR_NCM003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR NCM003"                                                                    
                                                                                
  PRCCSR_NCM004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR NCM004"                                                                    
                                                                                
  PRCCSR_OST001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR OST001"                                                                    
                                                                                
  PRCCSR_OTR001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR OTR001"                                                                    
                                                                                
  PRCCSR_OTR002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR OTR002"                                                                    
                                                                                
  PRCCSR_OTR003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR OTR003"                                                                    
                                                                                
  PRCCSR_OTR004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR OTR004"                                                                    
                                                                                
  PRCCSR_OTR005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR OTR005"                                                                    
                                                                                
  PRCCSR_PGN001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PGN001"                                                                    
                                                                                
  PRCCSR_PGN002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PGN002"                                                                    
                                                                                
  PRCCSR_PGN003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PGN003"                                                                    
                                                                                
  PRCCSR_PGN004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PGN004"                                                                    
                                                                                
  PRCCSR_PGN005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PGN005"                                                                    
                                                                                
  PRCCSR_PGN006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PGN006"                                                                    
                                                                                
  PRCCSR_PGN007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PGN007"                                                                    
                                                                                
  PRCCSR_PGN008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PGN008"                                                                    
                                                                                
  PRCCSR_PGN009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PGN009"                                                                    
                                                                                
  PRCCSR_PLC001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PLC001"                                                                    
                                                                                
  PRCCSR_PLC002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PLC002"                                                                    
                                                                                
  PRCCSR_PNS001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PNS001"                                                                    
                                                                                
  PRCCSR_PNS002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PNS002"                                                                    
                                                                                
  PRCCSR_PNS003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PNS003"                                                                    
                                                                                
  PRCCSR_PNS004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PNS004"                                                                    
                                                                                
  PRCCSR_PNS005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PNS005"                                                                    
                                                                                
  PRCCSR_PNS006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR PNS006"                                                                    
                                                                                
  PRCCSR_RAD001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RAD001"                                                                    
                                                                                
  PRCCSR_RAD002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RAD002"                                                                    
                                                                                
  PRCCSR_RAD003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RAD003"                                                                    
                                                                                
  PRCCSR_RAD004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RAD004"                                                                    
                                                                                
  PRCCSR_RES001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES001"                                                                    
                                                                                
  PRCCSR_RES002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES002"                                                                    
                                                                                
  PRCCSR_RES003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES003"                                                                    
                                                                                
  PRCCSR_RES004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES004"                                                                    
                                                                                
  PRCCSR_RES005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES005"                                                                    
                                                                                
  PRCCSR_RES006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES006"                                                                    
                                                                                
  PRCCSR_RES007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES007"                                                                    
                                                                                
  PRCCSR_RES008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES008"                                                                    
                                                                                
  PRCCSR_RES009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES009"                                                                    
                                                                                
  PRCCSR_RES010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES010"                                                                    
                                                                                
  PRCCSR_RES011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES011"                                                                    
                                                                                
  PRCCSR_RES012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES012"                                                                    
                                                                                
  PRCCSR_RES013              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES013"                                                                    
                                                                                
  PRCCSR_RES014              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RES014"                                                                    
                                                                                
  PRCCSR_RHB001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RHB001"                                                                    
                                                                                
  PRCCSR_RHB002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RHB002"                                                                    
                                                                                
  PRCCSR_RHB003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RHB003"                                                                    
                                                                                
  PRCCSR_RHB004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR RHB004"                                                                    
                                                                                
  PRCCSR_SKB001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB001"                                                                    
                                                                                
  PRCCSR_SKB002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB002"                                                                    
                                                                                
  PRCCSR_SKB003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB003"                                                                    
                                                                                
  PRCCSR_SKB004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB004"                                                                    
                                                                                
  PRCCSR_SKB005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB005"                                                                    
                                                                                
  PRCCSR_SKB006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB006"                                                                    
                                                                                
  PRCCSR_SKB007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB007"                                                                    
                                                                                
  PRCCSR_SKB008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB008"                                                                    
                                                                                
  PRCCSR_SKB009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB009"                                                                    
                                                                                
  PRCCSR_SKB010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SKB010"                                                                    
                                                                                
  PRCCSR_SUD001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SUD001"                                                                    
                                                                                
  PRCCSR_SUD002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SUD002"                                                                    
                                                                                
  PRCCSR_SUD003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SUD003"                                                                    
                                                                                
  PRCCSR_SUD004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR SUD004"                                                                    
                                                                                
  PRCCSR_URN001              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN001"                                                                    
                                                                                
  PRCCSR_URN002              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN002"                                                                    
                                                                                
  PRCCSR_URN003              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN003"                                                                    
                                                                                
  PRCCSR_URN004              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN004"                                                                    
                                                                                
  PRCCSR_URN005              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN005"                                                                    
                                                                                
  PRCCSR_URN006              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN006"                                                                    
                                                                                
  PRCCSR_URN007              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN007"                                                                    
                                                                                
  PRCCSR_URN008              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN008"                                                                    
                                                                                
  PRCCSR_URN009              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN009"                                                                    
                                                                                
  PRCCSR_URN010              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN010"                                                                    
                                                                                
  PRCCSR_URN011              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN011"                                                                    
                                                                                
  PRCCSR_URN012              LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Indication that at least one ICD-10-PCS procedure on the record is included in 
CCSR URN012"                                                                    
                                                                                
  PRCCSR_VERSION             LENGTH=$6                                          
  LABEL="Version of CCSR for ICD-10-PCS procedures"                             
  ;                                                                             
                                                                                
                                                                                
*** Input the variables from the ASCII file ***;                                
INPUT                                                                           
      @1      CCIR_VERSION                  $CHAR6.                             
      @7      CCIR1                         N3PF.                               
      @10     CCIR2                         N3PF.                               
      @13     CCIR3                         N3PF.                               
      @16     CCIR4                         N3PF.                               
      @19     CCIR5                         N3PF.                               
      @22     CCIR6                         N3PF.                               
      @25     CCIR7                         N3PF.                               
      @28     CCIR8                         N3PF.                               
      @31     CCIR9                         N3PF.                               
      @34     CCIR10                        N3PF.                               
      @37     CCIR11                        N3PF.                               
      @40     CCIR12                        N3PF.                               
      @43     CCIR13                        N3PF.                               
      @46     CCIR14                        N3PF.                               
      @49     CCIR15                        N3PF.                               
      @52     CCIR16                        N3PF.                               
      @55     CCIR17                        N3PF.                               
      @58     CCIR18                        N3PF.                               
      @61     CCIR19                        N3PF.                               
      @64     CCIR20                        N3PF.                               
      @67     CCIR21                        N3PF.                               
      @70     CCIR22                        N3PF.                               
      @73     CCIR23                        N3PF.                               
      @76     CCIR24                        N3PF.                               
      @79     CCIR25                        N3PF.                               
      @82     CCIR26                        N3PF.                               
      @85     CCIR27                        N3PF.                               
      @88     CCIR28                        N3PF.                               
      @91     CCIR29                        N3PF.                               
      @94     CCIR30                        N3PF.                               
      @97     CCIR31                        N3PF.                               
      @100    CCIR32                        N3PF.                               
      @103    CCIR33                        N3PF.                               
      @106    CCIR34                        N3PF.                               
      @109    CCIR35                        N3PF.                               
      @112    CCIR36                        N3PF.                               
      @115    CCIR37                        N3PF.                               
      @118    CCIR38                        N3PF.                               
      @121    CCIR39                        N3PF.                               
      @124    CCIR40                        N3PF.                               
      @127    CCIR41                        N3PF.                               
      @130    CCIR42                        N3PF.                               
      @133    CCIR43                        N3PF.                               
      @136    CCIR44                        N3PF.                               
      @139    CCIR45                        N3PF.                               
      @142    CCIR46                        N3PF.                               
      @145    CCIR47                        N3PF.                               
      @148    CCIR48                        N3PF.                               
      @151    CCIR49                        N3PF.                               
      @154    CCIR50                        N3PF.                               
      @157    CCIR51                        N3PF.                               
      @160    CCIR52                        N3PF.                               
      @163    CCIR53                        N3PF.                               
      @166    CCIR54                        N3PF.                               
      @169    CCIR55                        N3PF.                               
      @172    CCIR56                        N3PF.                               
      @175    CCIR57                        N3PF.                               
      @178    CCIR58                        N3PF.                               
      @181    CCIR59                        N3PF.                               
      @184    CCIR60                        N3PF.                               
      @187    CCIR61                        N3PF.                               
      @190    CCIR62                        N3PF.                               
      @193    CCIR63                        N3PF.                               
      @196    CCIR64                        N3PF.                               
      @199    CCIR65                        N3PF.                               
      @202    CCIR66                        N3PF.                               
      @205    CCIR67                        N3PF.                               
      @208    CCIR68                        N3PF.                               
      @211    CCIR69                        N3PF.                               
      @214    CCIR70                        N3PF.                               
      @217    CCIR71                        N3PF.                               
      @220    CCIR72                        N3PF.                               
      @223    CCIR73                        N3PF.                               
      @226    CCIR74                        N3PF.                               
      @229    CCIR75                        N3PF.                               
      @232    CCIR76                        N3PF.                               
      @235    CCIR77                        N3PF.                               
      @238    CCIR78                        N3PF.                               
      @241    CCIR79                        N3PF.                               
      @244    CCIR80                        N3PF.                               
      @247    CCIR81                        N3PF.                               
      @250    CCIR82                        N3PF.                               
      @253    CCIR83                        N3PF.                               
      @256    CCIR84                        N3PF.                               
      @259    CCIR85                        N3PF.                               
      @262    CCIR86                        N3PF.                               
      @265    CCIR87                        N3PF.                               
      @268    CCIR88                        N3PF.                               
      @271    CCIR89                        N3PF.                               
      @274    CCIR90                        N3PF.                               
      @277    CCIR91                        N3PF.                               
      @280    CCIR92                        N3PF.                               
      @283    CCIR93                        N3PF.                               
      @286    CCIR94                        N3PF.                               
      @289    CCIR95                        N3PF.                               
      @292    CCIR96                        N3PF.                               
      @295    CCIR97                        N3PF.                               
      @298    CCIR98                        N3PF.                               
      @301    CCIR99                        N3PF.                               
      @304    CCIR100                       N3PF.                               
      @307    CCIR101                       N3PF.                               
      @310    CCIR102                       N3PF.                               
      @313    CCIR103                       N3PF.                               
      @316    CCIR104                       N3PF.                               
      @319    CCIR105                       N3PF.                               
      @322    CCIR106                       N3PF.                               
      @325    CCIR107                       N3PF.                               
      @328    CCIR108                       N3PF.                               
      @331    CCIR109                       N3PF.                               
      @334    CCIR110                       N3PF.                               
      @337    CCIR111                       N3PF.                               
      @340    CCIR112                       N3PF.                               
      @343    CCIR113                       N3PF.                               
      @346    CCIR114                       N3PF.                               
      @349    CCIR115                       N3PF.                               
      @352    CCIR116                       N3PF.                               
      @355    CCIR117                       N3PF.                               
      @358    CCIR118                       N3PF.                               
      @361    CCIR119                       N3PF.                               
      @364    CCIR120                       N3PF.                               
      @367    CCIR121                       N3PF.                               
      @370    CCIR122                       N3PF.                               
      @373    CCIR123                       N3PF.                               
      @376    CCIR124                       N3PF.                               
      @379    CCIR125                       N3PF.                               
      @382    CCIR126                       N3PF.                               
      @385    CCIR127                       N3PF.                               
      @388    CCIR128                       N3PF.                               
      @391    CCIR129                       N3PF.                               
      @394    CCIR130                       N3PF.                               
      @397    CCIR131                       N3PF.                               
      @400    CCIR132                       N3PF.                               
      @403    CCIR133                       N3PF.                               
      @406    CCIR134                       N3PF.                               
      @409    CCIR135                       N3PF.                               
      @412    CCIR136                       N3PF.                               
      @415    CMR_AIDS                      N2PF.                               
      @417    CMR_ALCOHOL                   N2PF.                               
      @419    CMR_ANEMDEF                   N2PF.                               
      @421    CMR_AUTOIMMUNE                N2PF.                               
      @423    CMR_BLDLOSS                   N2PF.                               
      @425    CMR_CANCER_LEUK               N2PF.                               
      @427    CMR_CANCER_LYMPH              N2PF.                               
      @429    CMR_CANCER_METS               N2PF.                               
      @431    CMR_CANCER_NSITU              N2PF.                               
      @433    CMR_CANCER_SOLID              N2PF.                               
      @435    CMR_CBVD                      N2PF.                               
      @437    CMR_COAG                      N2PF.                               
      @439    CMR_DEMENTIA                  N2PF.                               
      @441    CMR_DEPRESS                   N2PF.                               
      @443    CMR_DIAB_CX                   N2PF.                               
      @445    CMR_DIAB_UNCX                 N2PF.                               
      @447    CMR_DRUG_ABUSE                N2PF.                               
      @449    CMR_HF                        N2PF.                               
      @451    CMR_HTN_CX                    N2PF.                               
      @453    CMR_HTN_UNCX                  N2PF.                               
      @455    CMR_LIVER_MLD                 N2PF.                               
      @457    CMR_LIVER_SEV                 N2PF.                               
      @459    CMR_LUNG_CHRONIC              N2PF.                               
      @461    CMR_NEURO_MOVT                N2PF.                               
      @463    CMR_NEURO_OTH                 N2PF.                               
      @465    CMR_NEURO_SEIZ                N2PF.                               
      @467    CMR_OBESE                     N2PF.                               
      @469    CMR_PARALYSIS                 N2PF.                               
      @471    CMR_PERIVASC                  N2PF.                               
      @473    CMR_PSYCHOSES                 N2PF.                               
      @475    CMR_PULMCIRC                  N2PF.                               
      @477    CMR_RENLFL_MOD                N2PF.                               
      @479    CMR_RENLFL_SEV                N2PF.                               
      @481    CMR_THYROID_HYPO              N2PF.                               
      @483    CMR_THYROID_OTH               N2PF.                               
      @485    CMR_ULCER_PEPTIC              N2PF.                               
      @487    CMR_VALVE                     N2PF.                               
      @489    CMR_VERSION                   $CHAR6.                             
      @495    CMR_WGHTLOSS                  N2PF.                               
      @497    I10_INJURY                    N2PF.                               
      @499    I10_INJURY_CUT                N2PF.                               
      @501    I10_INJURY_DROWN              N2PF.                               
      @503    I10_INJURY_FALL               N2PF.                               
      @505    I10_INJURY_FIRE               N2PF.                               
      @507    I10_INJURY_FIREARM            N2PF.                               
      @509    I10_INJURY_MACHINERY          N2PF.                               
      @511    I10_INJURY_MVT                N2PF.                               
      @513    I10_INJURY_NATURE             N2PF.                               
      @515    I10_INJURY_OVEREXERTION       N2PF.                               
      @517    I10_INJURY_POISON             N2PF.                               
      @519    I10_INJURY_STRUCK             N2PF.                               
      @521    I10_INJURY_SUFFOCATION        N2PF.                               
      @523    I10_INTENT_ASSAULT            N2PF.                               
      @525    I10_INTENT_SELF_HARM          N2PF.                               
      @527    I10_INTENT_UNINTENTIONAL      N2PF.                               
      @529    I10_MULTINJURY                N2PF.                               
      @531    KEY                           15.                                 
      @546    PCLASS_VERSION                $CHAR6.                             
      @552    PCLASS1                       N2PF.                               
      @554    PCLASS2                       N2PF.                               
      @556    PCLASS3                       N2PF.                               
      @558    PCLASS4                       N2PF.                               
      @560    PCLASS5                       N2PF.                               
      @562    PCLASS6                       N2PF.                               
      @564    PCLASS7                       N2PF.                               
      @566    PCLASS8                       N2PF.                               
      @568    PCLASS9                       N2PF.                               
      @570    PCLASS10                      N2PF.                               
      @572    PCLASS11                      N2PF.                               
      @574    PCLASS12                      N2PF.                               
      @576    PCLASS13                      N2PF.                               
      @578    PCLASS14                      N2PF.                               
      @580    PCLASS15                      N2PF.                               
      @582    PCLASS16                      N2PF.                               
      @584    PCLASS17                      N2PF.                               
      @586    PCLASS18                      N2PF.                               
      @588    PCLASS19                      N2PF.                               
      @590    PCLASS20                      N2PF.                               
      @592    PCLASS21                      N2PF.                               
      @594    PCLASS22                      N2PF.                               
      @596    PCLASS23                      N2PF.                               
      @598    PCLASS24                      N2PF.                               
      @600    PCLASS25                      N2PF.                               
      @602    PCLASS26                      N2PF.                               
      @604    PCLASS27                      N2PF.                               
      @606    PCLASS28                      N2PF.                               
      @608    PCLASS29                      N2PF.                               
      @610    PCLASS30                      N2PF.                               
      @612    PCLASS31                      N2PF.                               
      @614    PCLASS32                      N2PF.                               
      @616    PCLASS33                      N2PF.                               
      @618    PCLASS34                      N2PF.                               
      @620    PCLASS35                      N2PF.                               
      @622    PCLASS36                      N2PF.                               
      @624    PCLASS37                      N2PF.                               
      @626    PCLASS38                      N2PF.                               
      @628    PCLASS39                      N2PF.                               
      @630    PCLASS40                      N2PF.                               
      @632    PCLASS41                      N2PF.                               
      @634    PCLASS42                      N2PF.                               
      @636    PCLASS43                      N2PF.                               
      @638    PCLASS44                      N2PF.                               
      @640    PCLASS45                      N2PF.                               
      @642    PCLASS46                      N2PF.                               
      @644    PCLASS47                      N2PF.                               
      @646    PCLASS48                      N2PF.                               
      @648    PCLASS49                      N2PF.                               
      @650    PCLASS50                      N2PF.                               
      @652    PCLASS51                      N2PF.                               
      @654    PCLASS52                      N2PF.                               
      @656    PCLASS53                      N2PF.                               
      @658    PCLASS54                      N2PF.                               
      @660    PCLASS55                      N2PF.                               
      @662    PCLASS56                      N2PF.                               
      @664    PCLASS57                      N2PF.                               
      @666    PCLASS58                      N2PF.                               
      @668    PCLASS59                      N2PF.                               
      @670    PCLASS60                      N2PF.                               
      @672    PCLASS61                      N2PF.                               
      @674    PCLASS62                      N2PF.                               
      @676    PCLASS63                      N2PF.                               
      @678    PCLASS64                      N2PF.                               
      @680    PCLASS65                      N2PF.                               
      @682    PCLASS66                      N2PF.                               
      @684    PCLASS67                      N2PF.                               
      @686    PCLASS68                      N2PF.                               
      @688    PCLASS69                      N2PF.                               
      @690    PCLASS70                      N2PF.                               
      @692    PCLASS71                      N2PF.                               
      @694    PCLASS72                      N2PF.                               
      @696    PCLASS73                      N2PF.                               
      @698    PCLASS74                      N2PF.                               
      @700    PCLASS75                      N2PF.                               
      @702    PCLASS76                      N2PF.                               
      @704    PCLASS77                      N2PF.                               
      @706    PCLASS78                      N2PF.                               
      @708    PCLASS79                      N2PF.                               
      @710    PCLASS80                      N2PF.                               
      @712    PCLASS81                      N2PF.                               
      @714    PCLASS82                      N2PF.                               
      @716    PCLASS83                      N2PF.                               
      @718    PCLASS84                      N2PF.                               
      @720    PCLASS85                      N2PF.                               
      @722    PCLASS86                      N2PF.                               
      @724    PCLASS87                      N2PF.                               
      @726    PCLASS88                      N2PF.                               
      @728    PCLASS89                      N2PF.                               
      @730    PCLASS90                      N2PF.                               
      @732    PCLASS91                      N2PF.                               
      @734    PCLASS92                      N2PF.                               
      @736    PCLASS93                      N2PF.                               
      @738    PCLASS94                      N2PF.                               
      @740    PCLASS95                      N2PF.                               
      @742    PCLASS96                      N2PF.                               
      @744    PCLASS97                      N2PF.                               
      @746    PCLASS98                      N2PF.                               
      @748    PCLASS99                      N2PF.                               
      @750    PCLASS100                     N2PF.                               
      @752    PCLASS101                     N2PF.                               
      @754    PCLASS102                     N2PF.                               
      @756    PCLASS103                     N2PF.                               
      @758    PCLASS104                     N2PF.                               
      @760    PCLASS105                     N2PF.                               
      @762    PCLASS106                     N2PF.                               
      @764    PCLASS107                     N2PF.                               
      @766    PCLASS108                     N2PF.                               
      @768    PCLASS109                     N2PF.                               
      @770    PCLASS110                     N2PF.                               
      @772    PCLASS111                     N2PF.                               
      @774    PCLASS112                     N2PF.                               
      @776    PCLASS113                     N2PF.                               
      @778    PCLASS114                     N2PF.                               
      @780    PCLASS115                     N2PF.                               
      @782    PCLASS116                     N2PF.                               
      @784    PCLASS117                     N2PF.                               
      @786    PCLASS118                     N2PF.                               
      @788    PCLASS119                     N2PF.                               
      @790    PCLASS120                     N2PF.                               
      @792    PCLASS121                     N2PF.                               
      @794    PCLASS122                     N2PF.                               
      @796    PCLASS123                     N2PF.                               
      @798    PCLASS124                     N2PF.                               
      @800    PCLASS125                     N2PF.                               
      @802    PCLASS126                     N2PF.                               
      @804    PCLASS127                     N2PF.                               
      @806    PCLASS128                     N2PF.                               
      @808    PCLASS129                     N2PF.                               
      @810    PCLASS130                     N2PF.                               
      @812    PCLASS131                     N2PF.                               
      @814    PCLASS132                     N2PF.                               
      @816    PCLASS133                     N2PF.                               
      @818    PCLASS134                     N2PF.                               
      @820    PCLASS135                     N2PF.                               
      @822    PCLASS136                     N2PF.                               
      @824    PCLASS137                     N2PF.                               
      @826    PCLASS138                     N2PF.                               
      @828    PCLASS139                     N2PF.                               
      @830    PCLASS140                     N2PF.                               
      @832    PCLASS141                     N2PF.                               
      @834    PCLASS142                     N2PF.                               
      @836    PCLASS143                     N2PF.                               
      @838    PCLASS144                     N2PF.                               
      @840    PCLASS145                     N2PF.                               
      @842    PCLASS146                     N2PF.                               
      @844    PCLASS147                     N2PF.                               
      @846    PCLASS148                     N2PF.                               
      @848    PCLASS149                     N2PF.                               
      @850    PCLASS150                     N2PF.                               
      @852    PCLASS151                     N2PF.                               
      @854    PCLASS152                     N2PF.                               
      @856    PCLASS153                     N2PF.                               
      @858    PCLASS154                     N2PF.                               
      @860    PCLASS155                     N2PF.                               
      @862    PCLASS156                     N2PF.                               
      @864    PCLASS157                     N2PF.                               
      @866    PCLASS158                     N2PF.                               
      @868    PCLASS159                     N2PF.                               
      @870    PCLASS160                     N2PF.                               
      @872    PCLASS161                     N2PF.                               
      @874    PCLASS162                     N2PF.                               
      @876    PCLASS163                     N2PF.                               
      @878    PCLASS164                     N2PF.                               
      @880    PCLASS165                     N2PF.                               
      @882    PCLASS166                     N2PF.                               
      @884    PCLASS167                     N2PF.                               
      @886    PCLASS168                     N2PF.                               
      @888    PCLASS169                     N2PF.                               
      @890    PCLASS170                     N2PF.                               
      @892    PCLASS171                     N2PF.                               
      @894    PCLASS172                     N2PF.                               
      @896    PCLASS173                     N2PF.                               
      @898    PCLASS174                     N2PF.                               
      @900    PCLASS175                     N2PF.                               
      @902    PCLASS176                     N2PF.                               
      @904    PCLASS177                     N2PF.                               
      @906    PCLASS178                     N2PF.                               
      @908    PCLASS179                     N2PF.                               
      @910    PCLASS180                     N2PF.                               
      @912    PCLASS181                     N2PF.                               
      @914    PCLASS182                     N2PF.                               
      @916    PCLASS183                     N2PF.                               
      @918    PCLASS184                     N2PF.                               
      @920    PCLASS185                     N2PF.                               
      @922    PCLASS186                     N2PF.                               
      @924    PCLASS187                     N2PF.                               
      @926    PCLASS188                     N2PF.                               
      @928    PCLASS189                     N2PF.                               
      @930    PCLASS190                     N2PF.                               
      @932    PCLASS191                     N2PF.                               
      @934    PCLASS192                     N2PF.                               
      @936    PCLASS193                     N2PF.                               
      @938    PCLASS194                     N2PF.                               
      @940    PCLASS195                     N2PF.                               
      @942    PCLASS196                     N2PF.                               
      @944    PCLASS197                     N2PF.                               
      @946    PCLASS198                     N2PF.                               
      @948    PCLASS199                     N2PF.                               
      @950    PCLASS200                     N2PF.                               
      @952    DXCCSR_Default_DX1            $CHAR6.                             
      @958    DXCCSR_BLD001                 N3PF.                               
      @961    DXCCSR_BLD002                 N3PF.                               
      @964    DXCCSR_BLD003                 N3PF.                               
      @967    DXCCSR_BLD004                 N3PF.                               
      @970    DXCCSR_BLD005                 N3PF.                               
      @973    DXCCSR_BLD006                 N3PF.                               
      @976    DXCCSR_BLD007                 N3PF.                               
      @979    DXCCSR_BLD008                 N3PF.                               
      @982    DXCCSR_BLD009                 N3PF.                               
      @985    DXCCSR_BLD010                 N3PF.                               
      @988    DXCCSR_CIR001                 N3PF.                               
      @991    DXCCSR_CIR002                 N3PF.                               
      @994    DXCCSR_CIR003                 N3PF.                               
      @997    DXCCSR_CIR004                 N3PF.                               
      @1000   DXCCSR_CIR005                 N3PF.                               
      @1003   DXCCSR_CIR006                 N3PF.                               
      @1006   DXCCSR_CIR007                 N3PF.                               
      @1009   DXCCSR_CIR008                 N3PF.                               
      @1012   DXCCSR_CIR009                 N3PF.                               
      @1015   DXCCSR_CIR010                 N3PF.                               
      @1018   DXCCSR_CIR011                 N3PF.                               
      @1021   DXCCSR_CIR012                 N3PF.                               
      @1024   DXCCSR_CIR013                 N3PF.                               
      @1027   DXCCSR_CIR014                 N3PF.                               
      @1030   DXCCSR_CIR015                 N3PF.                               
      @1033   DXCCSR_CIR016                 N3PF.                               
      @1036   DXCCSR_CIR017                 N3PF.                               
      @1039   DXCCSR_CIR018                 N3PF.                               
      @1042   DXCCSR_CIR019                 N3PF.                               
      @1045   DXCCSR_CIR020                 N3PF.                               
      @1048   DXCCSR_CIR021                 N3PF.                               
      @1051   DXCCSR_CIR022                 N3PF.                               
      @1054   DXCCSR_CIR023                 N3PF.                               
      @1057   DXCCSR_CIR024                 N3PF.                               
      @1060   DXCCSR_CIR025                 N3PF.                               
      @1063   DXCCSR_CIR026                 N3PF.                               
      @1066   DXCCSR_CIR027                 N3PF.                               
      @1069   DXCCSR_CIR028                 N3PF.                               
      @1072   DXCCSR_CIR029                 N3PF.                               
      @1075   DXCCSR_CIR030                 N3PF.                               
      @1078   DXCCSR_CIR031                 N3PF.                               
      @1081   DXCCSR_CIR032                 N3PF.                               
      @1084   DXCCSR_CIR033                 N3PF.                               
      @1087   DXCCSR_CIR034                 N3PF.                               
      @1090   DXCCSR_CIR035                 N3PF.                               
      @1093   DXCCSR_CIR036                 N3PF.                               
      @1096   DXCCSR_CIR037                 N3PF.                               
      @1099   DXCCSR_CIR038                 N3PF.                               
      @1102   DXCCSR_CIR039                 N3PF.                               
      @1105   DXCCSR_DEN001                 N3PF.                               
      @1108   DXCCSR_DEN002                 N3PF.                               
      @1111   DXCCSR_DEN003                 N3PF.                               
      @1114   DXCCSR_DIG001                 N3PF.                               
      @1117   DXCCSR_DIG002                 N3PF.                               
      @1120   DXCCSR_DIG003                 N3PF.                               
      @1123   DXCCSR_DIG004                 N3PF.                               
      @1126   DXCCSR_DIG005                 N3PF.                               
      @1129   DXCCSR_DIG006                 N3PF.                               
      @1132   DXCCSR_DIG007                 N3PF.                               
      @1135   DXCCSR_DIG008                 N3PF.                               
      @1138   DXCCSR_DIG009                 N3PF.                               
      @1141   DXCCSR_DIG010                 N3PF.                               
      @1144   DXCCSR_DIG011                 N3PF.                               
      @1147   DXCCSR_DIG012                 N3PF.                               
      @1150   DXCCSR_DIG013                 N3PF.                               
      @1153   DXCCSR_DIG014                 N3PF.                               
      @1156   DXCCSR_DIG015                 N3PF.                               
      @1159   DXCCSR_DIG016                 N3PF.                               
      @1162   DXCCSR_DIG017                 N3PF.                               
      @1165   DXCCSR_DIG018                 N3PF.                               
      @1168   DXCCSR_DIG019                 N3PF.                               
      @1171   DXCCSR_DIG020                 N3PF.                               
      @1174   DXCCSR_DIG021                 N3PF.                               
      @1177   DXCCSR_DIG022                 N3PF.                               
      @1180   DXCCSR_DIG023                 N3PF.                               
      @1183   DXCCSR_DIG024                 N3PF.                               
      @1186   DXCCSR_DIG025                 N3PF.                               
      @1189   DXCCSR_EAR001                 N3PF.                               
      @1192   DXCCSR_EAR002                 N3PF.                               
      @1195   DXCCSR_EAR003                 N3PF.                               
      @1198   DXCCSR_EAR004                 N3PF.                               
      @1201   DXCCSR_EAR005                 N3PF.                               
      @1204   DXCCSR_EAR006                 N3PF.                               
      @1207   DXCCSR_END001                 N3PF.                               
      @1210   DXCCSR_END002                 N3PF.                               
      @1213   DXCCSR_END003                 N3PF.                               
      @1216   DXCCSR_END004                 N3PF.                               
      @1219   DXCCSR_END005                 N3PF.                               
      @1222   DXCCSR_END006                 N3PF.                               
      @1225   DXCCSR_END007                 N3PF.                               
      @1228   DXCCSR_END008                 N3PF.                               
      @1231   DXCCSR_END009                 N3PF.                               
      @1234   DXCCSR_END010                 N3PF.                               
      @1237   DXCCSR_END011                 N3PF.                               
      @1240   DXCCSR_END012                 N3PF.                               
      @1243   DXCCSR_END013                 N3PF.                               
      @1246   DXCCSR_END014                 N3PF.                               
      @1249   DXCCSR_END015                 N3PF.                               
      @1252   DXCCSR_END016                 N3PF.                               
      @1255   DXCCSR_END017                 N3PF.                               
      @1258   DXCCSR_EXT001                 N3PF.                               
      @1261   DXCCSR_EXT002                 N3PF.                               
      @1264   DXCCSR_EXT003                 N3PF.                               
      @1267   DXCCSR_EXT004                 N3PF.                               
      @1270   DXCCSR_EXT005                 N3PF.                               
      @1273   DXCCSR_EXT006                 N3PF.                               
      @1276   DXCCSR_EXT007                 N3PF.                               
      @1279   DXCCSR_EXT008                 N3PF.                               
      @1282   DXCCSR_EXT009                 N3PF.                               
      @1285   DXCCSR_EXT010                 N3PF.                               
      @1288   DXCCSR_EXT011                 N3PF.                               
      @1291   DXCCSR_EXT012                 N3PF.                               
      @1294   DXCCSR_EXT013                 N3PF.                               
      @1297   DXCCSR_EXT014                 N3PF.                               
      @1300   DXCCSR_EXT015                 N3PF.                               
      @1303   DXCCSR_EXT016                 N3PF.                               
      @1306   DXCCSR_EXT017                 N3PF.                               
      @1309   DXCCSR_EXT018                 N3PF.                               
      @1312   DXCCSR_EXT019                 N3PF.                               
      @1315   DXCCSR_EXT020                 N3PF.                               
      @1318   DXCCSR_EXT021                 N3PF.                               
      @1321   DXCCSR_EXT022                 N3PF.                               
      @1324   DXCCSR_EXT023                 N3PF.                               
      @1327   DXCCSR_EXT024                 N3PF.                               
      @1330   DXCCSR_EXT025                 N3PF.                               
      @1333   DXCCSR_EXT026                 N3PF.                               
      @1336   DXCCSR_EXT027                 N3PF.                               
      @1339   DXCCSR_EXT028                 N3PF.                               
      @1342   DXCCSR_EXT029                 N3PF.                               
      @1345   DXCCSR_EXT030                 N3PF.                               
      @1348   DXCCSR_EYE001                 N3PF.                               
      @1351   DXCCSR_EYE002                 N3PF.                               
      @1354   DXCCSR_EYE003                 N3PF.                               
      @1357   DXCCSR_EYE004                 N3PF.                               
      @1360   DXCCSR_EYE005                 N3PF.                               
      @1363   DXCCSR_EYE006                 N3PF.                               
      @1366   DXCCSR_EYE007                 N3PF.                               
      @1369   DXCCSR_EYE008                 N3PF.                               
      @1372   DXCCSR_EYE009                 N3PF.                               
      @1375   DXCCSR_EYE010                 N3PF.                               
      @1378   DXCCSR_EYE011                 N3PF.                               
      @1381   DXCCSR_EYE012                 N3PF.                               
      @1384   DXCCSR_FAC001                 N3PF.                               
      @1387   DXCCSR_FAC002                 N3PF.                               
      @1390   DXCCSR_FAC003                 N3PF.                               
      @1393   DXCCSR_FAC004                 N3PF.                               
      @1396   DXCCSR_FAC005                 N3PF.                               
      @1399   DXCCSR_FAC006                 N3PF.                               
      @1402   DXCCSR_FAC007                 N3PF.                               
      @1405   DXCCSR_FAC008                 N3PF.                               
      @1408   DXCCSR_FAC009                 N3PF.                               
      @1411   DXCCSR_FAC010                 N3PF.                               
      @1414   DXCCSR_FAC011                 N3PF.                               
      @1417   DXCCSR_FAC012                 N3PF.                               
      @1420   DXCCSR_FAC013                 N3PF.                               
      @1423   DXCCSR_FAC014                 N3PF.                               
      @1426   DXCCSR_FAC015                 N3PF.                               
      @1429   DXCCSR_FAC016                 N3PF.                               
      @1432   DXCCSR_FAC017                 N3PF.                               
      @1435   DXCCSR_FAC018                 N3PF.                               
      @1438   DXCCSR_FAC019                 N3PF.                               
      @1441   DXCCSR_FAC020                 N3PF.                               
      @1444   DXCCSR_FAC021                 N3PF.                               
      @1447   DXCCSR_FAC022                 N3PF.                               
      @1450   DXCCSR_FAC023                 N3PF.                               
      @1453   DXCCSR_FAC024                 N3PF.                               
      @1456   DXCCSR_FAC025                 N3PF.                               
      @1459   DXCCSR_GEN001                 N3PF.                               
      @1462   DXCCSR_GEN002                 N3PF.                               
      @1465   DXCCSR_GEN003                 N3PF.                               
      @1468   DXCCSR_GEN004                 N3PF.                               
      @1471   DXCCSR_GEN005                 N3PF.                               
      @1474   DXCCSR_GEN006                 N3PF.                               
      @1477   DXCCSR_GEN007                 N3PF.                               
      @1480   DXCCSR_GEN008                 N3PF.                               
      @1483   DXCCSR_GEN009                 N3PF.                               
      @1486   DXCCSR_GEN010                 N3PF.                               
      @1489   DXCCSR_GEN011                 N3PF.                               
      @1492   DXCCSR_GEN012                 N3PF.                               
      @1495   DXCCSR_GEN013                 N3PF.                               
      @1498   DXCCSR_GEN014                 N3PF.                               
      @1501   DXCCSR_GEN015                 N3PF.                               
      @1504   DXCCSR_GEN016                 N3PF.                               
      @1507   DXCCSR_GEN017                 N3PF.                               
      @1510   DXCCSR_GEN018                 N3PF.                               
      @1513   DXCCSR_GEN019                 N3PF.                               
      @1516   DXCCSR_GEN020                 N3PF.                               
      @1519   DXCCSR_GEN021                 N3PF.                               
      @1522   DXCCSR_GEN022                 N3PF.                               
      @1525   DXCCSR_GEN023                 N3PF.                               
      @1528   DXCCSR_GEN024                 N3PF.                               
      @1531   DXCCSR_GEN025                 N3PF.                               
      @1534   DXCCSR_GEN026                 N3PF.                               
      @1537   DXCCSR_INF001                 N3PF.                               
      @1540   DXCCSR_INF002                 N3PF.                               
      @1543   DXCCSR_INF003                 N3PF.                               
      @1546   DXCCSR_INF004                 N3PF.                               
      @1549   DXCCSR_INF005                 N3PF.                               
      @1552   DXCCSR_INF006                 N3PF.                               
      @1555   DXCCSR_INF007                 N3PF.                               
      @1558   DXCCSR_INF008                 N3PF.                               
      @1561   DXCCSR_INF009                 N3PF.                               
      @1564   DXCCSR_INF010                 N3PF.                               
      @1567   DXCCSR_INF011                 N3PF.                               
      @1570   DXCCSR_INF012                 N3PF.                               
      @1573   DXCCSR_INJ001                 N3PF.                               
      @1576   DXCCSR_INJ002                 N3PF.                               
      @1579   DXCCSR_INJ003                 N3PF.                               
      @1582   DXCCSR_INJ004                 N3PF.                               
      @1585   DXCCSR_INJ005                 N3PF.                               
      @1588   DXCCSR_INJ006                 N3PF.                               
      @1591   DXCCSR_INJ007                 N3PF.                               
      @1594   DXCCSR_INJ008                 N3PF.                               
      @1597   DXCCSR_INJ009                 N3PF.                               
      @1600   DXCCSR_INJ010                 N3PF.                               
      @1603   DXCCSR_INJ011                 N3PF.                               
      @1606   DXCCSR_INJ012                 N3PF.                               
      @1609   DXCCSR_INJ013                 N3PF.                               
      @1612   DXCCSR_INJ014                 N3PF.                               
      @1615   DXCCSR_INJ015                 N3PF.                               
      @1618   DXCCSR_INJ016                 N3PF.                               
      @1621   DXCCSR_INJ017                 N3PF.                               
      @1624   DXCCSR_INJ018                 N3PF.                               
      @1627   DXCCSR_INJ019                 N3PF.                               
      @1630   DXCCSR_INJ020                 N3PF.                               
      @1633   DXCCSR_INJ021                 N3PF.                               
      @1636   DXCCSR_INJ022                 N3PF.                               
      @1639   DXCCSR_INJ023                 N3PF.                               
      @1642   DXCCSR_INJ024                 N3PF.                               
      @1645   DXCCSR_INJ025                 N3PF.                               
      @1648   DXCCSR_INJ026                 N3PF.                               
      @1651   DXCCSR_INJ027                 N3PF.                               
      @1654   DXCCSR_INJ028                 N3PF.                               
      @1657   DXCCSR_INJ029                 N3PF.                               
      @1660   DXCCSR_INJ030                 N3PF.                               
      @1663   DXCCSR_INJ031                 N3PF.                               
      @1666   DXCCSR_INJ032                 N3PF.                               
      @1669   DXCCSR_INJ033                 N3PF.                               
      @1672   DXCCSR_INJ034                 N3PF.                               
      @1675   DXCCSR_INJ035                 N3PF.                               
      @1678   DXCCSR_INJ036                 N3PF.                               
      @1681   DXCCSR_INJ037                 N3PF.                               
      @1684   DXCCSR_INJ038                 N3PF.                               
      @1687   DXCCSR_INJ039                 N3PF.                               
      @1690   DXCCSR_INJ040                 N3PF.                               
      @1693   DXCCSR_INJ041                 N3PF.                               
      @1696   DXCCSR_INJ042                 N3PF.                               
      @1699   DXCCSR_INJ043                 N3PF.                               
      @1702   DXCCSR_INJ044                 N3PF.                               
      @1705   DXCCSR_INJ045                 N3PF.                               
      @1708   DXCCSR_INJ046                 N3PF.                               
      @1711   DXCCSR_INJ047                 N3PF.                               
      @1714   DXCCSR_INJ048                 N3PF.                               
      @1717   DXCCSR_INJ049                 N3PF.                               
      @1720   DXCCSR_INJ050                 N3PF.                               
      @1723   DXCCSR_INJ051                 N3PF.                               
      @1726   DXCCSR_INJ052                 N3PF.                               
      @1729   DXCCSR_INJ053                 N3PF.                               
      @1732   DXCCSR_INJ054                 N3PF.                               
      @1735   DXCCSR_INJ055                 N3PF.                               
      @1738   DXCCSR_INJ056                 N3PF.                               
      @1741   DXCCSR_INJ057                 N3PF.                               
      @1744   DXCCSR_INJ058                 N3PF.                               
      @1747   DXCCSR_INJ059                 N3PF.                               
      @1750   DXCCSR_INJ060                 N3PF.                               
      @1753   DXCCSR_INJ061                 N3PF.                               
      @1756   DXCCSR_INJ062                 N3PF.                               
      @1759   DXCCSR_INJ063                 N3PF.                               
      @1762   DXCCSR_INJ064                 N3PF.                               
      @1765   DXCCSR_INJ065                 N3PF.                               
      @1768   DXCCSR_INJ066                 N3PF.                               
      @1771   DXCCSR_INJ067                 N3PF.                               
      @1774   DXCCSR_INJ068                 N3PF.                               
      @1777   DXCCSR_INJ069                 N3PF.                               
      @1780   DXCCSR_INJ070                 N3PF.                               
      @1783   DXCCSR_INJ071                 N3PF.                               
      @1786   DXCCSR_INJ072                 N3PF.                               
      @1789   DXCCSR_INJ073                 N3PF.                               
      @1792   DXCCSR_INJ074                 N3PF.                               
      @1795   DXCCSR_INJ075                 N3PF.                               
      @1798   DXCCSR_INJ076                 N3PF.                               
      @1801   DXCCSR_MAL001                 N3PF.                               
      @1804   DXCCSR_MAL002                 N3PF.                               
      @1807   DXCCSR_MAL003                 N3PF.                               
      @1810   DXCCSR_MAL004                 N3PF.                               
      @1813   DXCCSR_MAL005                 N3PF.                               
      @1816   DXCCSR_MAL006                 N3PF.                               
      @1819   DXCCSR_MAL007                 N3PF.                               
      @1822   DXCCSR_MAL008                 N3PF.                               
      @1825   DXCCSR_MAL009                 N3PF.                               
      @1828   DXCCSR_MAL010                 N3PF.                               
      @1831   DXCCSR_MBD001                 N3PF.                               
      @1834   DXCCSR_MBD002                 N3PF.                               
      @1837   DXCCSR_MBD003                 N3PF.                               
      @1840   DXCCSR_MBD004                 N3PF.                               
      @1843   DXCCSR_MBD005                 N3PF.                               
      @1846   DXCCSR_MBD006                 N3PF.                               
      @1849   DXCCSR_MBD007                 N3PF.                               
      @1852   DXCCSR_MBD008                 N3PF.                               
      @1855   DXCCSR_MBD009                 N3PF.                               
      @1858   DXCCSR_MBD010                 N3PF.                               
      @1861   DXCCSR_MBD011                 N3PF.                               
      @1864   DXCCSR_MBD012                 N3PF.                               
      @1867   DXCCSR_MBD013                 N3PF.                               
      @1870   DXCCSR_MBD014                 N3PF.                               
      @1873   DXCCSR_MBD017                 N3PF.                               
      @1876   DXCCSR_MBD018                 N3PF.                               
      @1879   DXCCSR_MBD019                 N3PF.                               
      @1882   DXCCSR_MBD020                 N3PF.                               
      @1885   DXCCSR_MBD021                 N3PF.                               
      @1888   DXCCSR_MBD022                 N3PF.                               
      @1891   DXCCSR_MBD023                 N3PF.                               
      @1894   DXCCSR_MBD024                 N3PF.                               
      @1897   DXCCSR_MBD025                 N3PF.                               
      @1900   DXCCSR_MBD026                 N3PF.                               
      @1903   DXCCSR_MBD027                 N3PF.                               
      @1906   DXCCSR_MBD028                 N3PF.                               
      @1909   DXCCSR_MBD029                 N3PF.                               
      @1912   DXCCSR_MBD030                 N3PF.                               
      @1915   DXCCSR_MBD031                 N3PF.                               
      @1918   DXCCSR_MBD032                 N3PF.                               
      @1921   DXCCSR_MBD033                 N3PF.                               
      @1924   DXCCSR_MBD034                 N3PF.                               
      @1927   DXCCSR_MUS001                 N3PF.                               
      @1930   DXCCSR_MUS002                 N3PF.                               
      @1933   DXCCSR_MUS003                 N3PF.                               
      @1936   DXCCSR_MUS004                 N3PF.                               
      @1939   DXCCSR_MUS005                 N3PF.                               
      @1942   DXCCSR_MUS006                 N3PF.                               
      @1945   DXCCSR_MUS007                 N3PF.                               
      @1948   DXCCSR_MUS008                 N3PF.                               
      @1951   DXCCSR_MUS009                 N3PF.                               
      @1954   DXCCSR_MUS010                 N3PF.                               
      @1957   DXCCSR_MUS011                 N3PF.                               
      @1960   DXCCSR_MUS012                 N3PF.                               
      @1963   DXCCSR_MUS013                 N3PF.                               
      @1966   DXCCSR_MUS014                 N3PF.                               
      @1969   DXCCSR_MUS015                 N3PF.                               
      @1972   DXCCSR_MUS016                 N3PF.                               
      @1975   DXCCSR_MUS017                 N3PF.                               
      @1978   DXCCSR_MUS018                 N3PF.                               
      @1981   DXCCSR_MUS019                 N3PF.                               
      @1984   DXCCSR_MUS020                 N3PF.                               
      @1987   DXCCSR_MUS021                 N3PF.                               
      @1990   DXCCSR_MUS022                 N3PF.                               
      @1993   DXCCSR_MUS023                 N3PF.                               
      @1996   DXCCSR_MUS024                 N3PF.                               
      @1999   DXCCSR_MUS025                 N3PF.                               
      @2002   DXCCSR_MUS026                 N3PF.                               
      @2005   DXCCSR_MUS027                 N3PF.                               
      @2008   DXCCSR_MUS028                 N3PF.                               
      @2011   DXCCSR_MUS029                 N3PF.                               
      @2014   DXCCSR_MUS030                 N3PF.                               
      @2017   DXCCSR_MUS031                 N3PF.                               
      @2020   DXCCSR_MUS032                 N3PF.                               
      @2023   DXCCSR_MUS033                 N3PF.                               
      @2026   DXCCSR_MUS034                 N3PF.                               
      @2029   DXCCSR_MUS035                 N3PF.                               
      @2032   DXCCSR_MUS036                 N3PF.                               
      @2035   DXCCSR_MUS037                 N3PF.                               
      @2038   DXCCSR_MUS038                 N3PF.                               
      @2041   DXCCSR_NEO001                 N3PF.                               
      @2044   DXCCSR_NEO002                 N3PF.                               
      @2047   DXCCSR_NEO003                 N3PF.                               
      @2050   DXCCSR_NEO004                 N3PF.                               
      @2053   DXCCSR_NEO005                 N3PF.                               
      @2056   DXCCSR_NEO006                 N3PF.                               
      @2059   DXCCSR_NEO007                 N3PF.                               
      @2062   DXCCSR_NEO008                 N3PF.                               
      @2065   DXCCSR_NEO009                 N3PF.                               
      @2068   DXCCSR_NEO010                 N3PF.                               
      @2071   DXCCSR_NEO011                 N3PF.                               
      @2074   DXCCSR_NEO012                 N3PF.                               
      @2077   DXCCSR_NEO013                 N3PF.                               
      @2080   DXCCSR_NEO014                 N3PF.                               
      @2083   DXCCSR_NEO015                 N3PF.                               
      @2086   DXCCSR_NEO016                 N3PF.                               
      @2089   DXCCSR_NEO017                 N3PF.                               
      @2092   DXCCSR_NEO018                 N3PF.                               
      @2095   DXCCSR_NEO019                 N3PF.                               
      @2098   DXCCSR_NEO020                 N3PF.                               
      @2101   DXCCSR_NEO021                 N3PF.                               
      @2104   DXCCSR_NEO022                 N3PF.                               
      @2107   DXCCSR_NEO023                 N3PF.                               
      @2110   DXCCSR_NEO024                 N3PF.                               
      @2113   DXCCSR_NEO025                 N3PF.                               
      @2116   DXCCSR_NEO026                 N3PF.                               
      @2119   DXCCSR_NEO027                 N3PF.                               
      @2122   DXCCSR_NEO028                 N3PF.                               
      @2125   DXCCSR_NEO029                 N3PF.                               
      @2128   DXCCSR_NEO030                 N3PF.                               
      @2131   DXCCSR_NEO031                 N3PF.                               
      @2134   DXCCSR_NEO032                 N3PF.                               
      @2137   DXCCSR_NEO033                 N3PF.                               
      @2140   DXCCSR_NEO034                 N3PF.                               
      @2143   DXCCSR_NEO035                 N3PF.                               
      @2146   DXCCSR_NEO036                 N3PF.                               
      @2149   DXCCSR_NEO037                 N3PF.                               
      @2152   DXCCSR_NEO038                 N3PF.                               
      @2155   DXCCSR_NEO039                 N3PF.                               
      @2158   DXCCSR_NEO040                 N3PF.                               
      @2161   DXCCSR_NEO041                 N3PF.                               
      @2164   DXCCSR_NEO042                 N3PF.                               
      @2167   DXCCSR_NEO043                 N3PF.                               
      @2170   DXCCSR_NEO044                 N3PF.                               
      @2173   DXCCSR_NEO045                 N3PF.                               
      @2176   DXCCSR_NEO046                 N3PF.                               
      @2179   DXCCSR_NEO047                 N3PF.                               
      @2182   DXCCSR_NEO048                 N3PF.                               
      @2185   DXCCSR_NEO049                 N3PF.                               
      @2188   DXCCSR_NEO050                 N3PF.                               
      @2191   DXCCSR_NEO051                 N3PF.                               
      @2194   DXCCSR_NEO052                 N3PF.                               
      @2197   DXCCSR_NEO053                 N3PF.                               
      @2200   DXCCSR_NEO054                 N3PF.                               
      @2203   DXCCSR_NEO055                 N3PF.                               
      @2206   DXCCSR_NEO056                 N3PF.                               
      @2209   DXCCSR_NEO057                 N3PF.                               
      @2212   DXCCSR_NEO058                 N3PF.                               
      @2215   DXCCSR_NEO059                 N3PF.                               
      @2218   DXCCSR_NEO060                 N3PF.                               
      @2221   DXCCSR_NEO061                 N3PF.                               
      @2224   DXCCSR_NEO062                 N3PF.                               
      @2227   DXCCSR_NEO063                 N3PF.                               
      @2230   DXCCSR_NEO064                 N3PF.                               
      @2233   DXCCSR_NEO065                 N3PF.                               
      @2236   DXCCSR_NEO066                 N3PF.                               
      @2239   DXCCSR_NEO067                 N3PF.                               
      @2242   DXCCSR_NEO068                 N3PF.                               
      @2245   DXCCSR_NEO069                 N3PF.                               
      @2248   DXCCSR_NEO070                 N3PF.                               
      @2251   DXCCSR_NEO071                 N3PF.                               
      @2254   DXCCSR_NEO072                 N3PF.                               
      @2257   DXCCSR_NEO073                 N3PF.                               
      @2260   DXCCSR_NEO074                 N3PF.                               
      @2263   DXCCSR_NVS001                 N3PF.                               
      @2266   DXCCSR_NVS002                 N3PF.                               
      @2269   DXCCSR_NVS003                 N3PF.                               
      @2272   DXCCSR_NVS004                 N3PF.                               
      @2275   DXCCSR_NVS005                 N3PF.                               
      @2278   DXCCSR_NVS006                 N3PF.                               
      @2281   DXCCSR_NVS007                 N3PF.                               
      @2284   DXCCSR_NVS008                 N3PF.                               
      @2287   DXCCSR_NVS009                 N3PF.                               
      @2290   DXCCSR_NVS010                 N3PF.                               
      @2293   DXCCSR_NVS011                 N3PF.                               
      @2296   DXCCSR_NVS012                 N3PF.                               
      @2299   DXCCSR_NVS013                 N3PF.                               
      @2302   DXCCSR_NVS014                 N3PF.                               
      @2305   DXCCSR_NVS015                 N3PF.                               
      @2308   DXCCSR_NVS016                 N3PF.                               
      @2311   DXCCSR_NVS017                 N3PF.                               
      @2314   DXCCSR_NVS018                 N3PF.                               
      @2317   DXCCSR_NVS019                 N3PF.                               
      @2320   DXCCSR_NVS020                 N3PF.                               
      @2323   DXCCSR_NVS021                 N3PF.                               
      @2326   DXCCSR_NVS022                 N3PF.                               
      @2329   DXCCSR_PNL001                 N3PF.                               
      @2332   DXCCSR_PNL002                 N3PF.                               
      @2335   DXCCSR_PNL003                 N3PF.                               
      @2338   DXCCSR_PNL004                 N3PF.                               
      @2341   DXCCSR_PNL005                 N3PF.                               
      @2344   DXCCSR_PNL006                 N3PF.                               
      @2347   DXCCSR_PNL007                 N3PF.                               
      @2350   DXCCSR_PNL008                 N3PF.                               
      @2353   DXCCSR_PNL009                 N3PF.                               
      @2356   DXCCSR_PNL010                 N3PF.                               
      @2359   DXCCSR_PNL011                 N3PF.                               
      @2362   DXCCSR_PNL012                 N3PF.                               
      @2365   DXCCSR_PNL013                 N3PF.                               
      @2368   DXCCSR_PNL014                 N3PF.                               
      @2371   DXCCSR_PNL015                 N3PF.                               
      @2374   DXCCSR_PRG001                 N3PF.                               
      @2377   DXCCSR_PRG002                 N3PF.                               
      @2380   DXCCSR_PRG003                 N3PF.                               
      @2383   DXCCSR_PRG004                 N3PF.                               
      @2386   DXCCSR_PRG005                 N3PF.                               
      @2389   DXCCSR_PRG006                 N3PF.                               
      @2392   DXCCSR_PRG007                 N3PF.                               
      @2395   DXCCSR_PRG008                 N3PF.                               
      @2398   DXCCSR_PRG009                 N3PF.                               
      @2401   DXCCSR_PRG010                 N3PF.                               
      @2404   DXCCSR_PRG011                 N3PF.                               
      @2407   DXCCSR_PRG012                 N3PF.                               
      @2410   DXCCSR_PRG013                 N3PF.                               
      @2413   DXCCSR_PRG014                 N3PF.                               
      @2416   DXCCSR_PRG015                 N3PF.                               
      @2419   DXCCSR_PRG016                 N3PF.                               
      @2422   DXCCSR_PRG017                 N3PF.                               
      @2425   DXCCSR_PRG018                 N3PF.                               
      @2428   DXCCSR_PRG019                 N3PF.                               
      @2431   DXCCSR_PRG020                 N3PF.                               
      @2434   DXCCSR_PRG021                 N3PF.                               
      @2437   DXCCSR_PRG022                 N3PF.                               
      @2440   DXCCSR_PRG023                 N3PF.                               
      @2443   DXCCSR_PRG024                 N3PF.                               
      @2446   DXCCSR_PRG025                 N3PF.                               
      @2449   DXCCSR_PRG026                 N3PF.                               
      @2452   DXCCSR_PRG027                 N3PF.                               
      @2455   DXCCSR_PRG028                 N3PF.                               
      @2458   DXCCSR_PRG029                 N3PF.                               
      @2461   DXCCSR_PRG030                 N3PF.                               
      @2464   DXCCSR_RSP001                 N3PF.                               
      @2467   DXCCSR_RSP002                 N3PF.                               
      @2470   DXCCSR_RSP003                 N3PF.                               
      @2473   DXCCSR_RSP004                 N3PF.                               
      @2476   DXCCSR_RSP005                 N3PF.                               
      @2479   DXCCSR_RSP006                 N3PF.                               
      @2482   DXCCSR_RSP007                 N3PF.                               
      @2485   DXCCSR_RSP008                 N3PF.                               
      @2488   DXCCSR_RSP009                 N3PF.                               
      @2491   DXCCSR_RSP010                 N3PF.                               
      @2494   DXCCSR_RSP011                 N3PF.                               
      @2497   DXCCSR_RSP012                 N3PF.                               
      @2500   DXCCSR_RSP013                 N3PF.                               
      @2503   DXCCSR_RSP014                 N3PF.                               
      @2506   DXCCSR_RSP015                 N3PF.                               
      @2509   DXCCSR_RSP016                 N3PF.                               
      @2512   DXCCSR_RSP017                 N3PF.                               
      @2515   DXCCSR_SKN001                 N3PF.                               
      @2518   DXCCSR_SKN002                 N3PF.                               
      @2521   DXCCSR_SKN003                 N3PF.                               
      @2524   DXCCSR_SKN004                 N3PF.                               
      @2527   DXCCSR_SKN005                 N3PF.                               
      @2530   DXCCSR_SKN006                 N3PF.                               
      @2533   DXCCSR_SKN007                 N3PF.                               
      @2536   DXCCSR_SYM001                 N3PF.                               
      @2539   DXCCSR_SYM002                 N3PF.                               
      @2542   DXCCSR_SYM003                 N3PF.                               
      @2545   DXCCSR_SYM004                 N3PF.                               
      @2548   DXCCSR_SYM005                 N3PF.                               
      @2551   DXCCSR_SYM006                 N3PF.                               
      @2554   DXCCSR_SYM007                 N3PF.                               
      @2557   DXCCSR_SYM008                 N3PF.                               
      @2560   DXCCSR_SYM009                 N3PF.                               
      @2563   DXCCSR_SYM010                 N3PF.                               
      @2566   DXCCSR_SYM011                 N3PF.                               
      @2569   DXCCSR_SYM012                 N3PF.                               
      @2572   DXCCSR_SYM013                 N3PF.                               
      @2575   DXCCSR_SYM014                 N3PF.                               
      @2578   DXCCSR_SYM015                 N3PF.                               
      @2581   DXCCSR_SYM016                 N3PF.                               
      @2584   DXCCSR_SYM017                 N3PF.                               
      @2587   DXCCSR_VERSION                $CHAR6.                             
      @2593   PRCCSR_ADM001                 N3PF.                               
      @2596   PRCCSR_ADM002                 N3PF.                               
      @2599   PRCCSR_ADM003                 N3PF.                               
      @2602   PRCCSR_ADM004                 N3PF.                               
      @2605   PRCCSR_ADM005                 N3PF.                               
      @2608   PRCCSR_ADM006                 N3PF.                               
      @2611   PRCCSR_ADM007                 N3PF.                               
      @2614   PRCCSR_ADM008                 N3PF.                               
      @2617   PRCCSR_ADM009                 N3PF.                               
      @2620   PRCCSR_ADM010                 N3PF.                               
      @2623   PRCCSR_ADM011                 N3PF.                               
      @2626   PRCCSR_ADM012                 N3PF.                               
      @2629   PRCCSR_ADM013                 N3PF.                               
      @2632   PRCCSR_ADM014                 N3PF.                               
      @2635   PRCCSR_ADM015                 N3PF.                               
      @2638   PRCCSR_ADM016                 N3PF.                               
      @2641   PRCCSR_ADM017                 N3PF.                               
      @2644   PRCCSR_ADM018                 N3PF.                               
      @2647   PRCCSR_ADM019                 N3PF.                               
      @2650   PRCCSR_ADM020                 N3PF.                               
      @2653   PRCCSR_ADM021                 N3PF.                               
      @2656   PRCCSR_ADM022                 N3PF.                               
      @2659   PRCCSR_CAR001                 N3PF.                               
      @2662   PRCCSR_CAR002                 N3PF.                               
      @2665   PRCCSR_CAR003                 N3PF.                               
      @2668   PRCCSR_CAR004                 N3PF.                               
      @2671   PRCCSR_CAR005                 N3PF.                               
      @2674   PRCCSR_CAR006                 N3PF.                               
      @2677   PRCCSR_CAR007                 N3PF.                               
      @2680   PRCCSR_CAR008                 N3PF.                               
      @2683   PRCCSR_CAR009                 N3PF.                               
      @2686   PRCCSR_CAR010                 N3PF.                               
      @2689   PRCCSR_CAR011                 N3PF.                               
      @2692   PRCCSR_CAR012                 N3PF.                               
      @2695   PRCCSR_CAR013                 N3PF.                               
      @2698   PRCCSR_CAR014                 N3PF.                               
      @2701   PRCCSR_CAR015                 N3PF.                               
      @2704   PRCCSR_CAR016                 N3PF.                               
      @2707   PRCCSR_CAR017                 N3PF.                               
      @2710   PRCCSR_CAR018                 N3PF.                               
      @2713   PRCCSR_CAR019                 N3PF.                               
      @2716   PRCCSR_CAR020                 N3PF.                               
      @2719   PRCCSR_CAR021                 N3PF.                               
      @2722   PRCCSR_CAR022                 N3PF.                               
      @2725   PRCCSR_CAR023                 N3PF.                               
      @2728   PRCCSR_CAR024                 N3PF.                               
      @2731   PRCCSR_CAR025                 N3PF.                               
      @2734   PRCCSR_CAR026                 N3PF.                               
      @2737   PRCCSR_CAR027                 N3PF.                               
      @2740   PRCCSR_CAR028                 N3PF.                               
      @2743   PRCCSR_CAR029                 N3PF.                               
      @2746   PRCCSR_CHP001                 N3PF.                               
      @2749   PRCCSR_CNS001                 N3PF.                               
      @2752   PRCCSR_CNS002                 N3PF.                               
      @2755   PRCCSR_CNS003                 N3PF.                               
      @2758   PRCCSR_CNS004                 N3PF.                               
      @2761   PRCCSR_CNS005                 N3PF.                               
      @2764   PRCCSR_CNS006                 N3PF.                               
      @2767   PRCCSR_CNS007                 N3PF.                               
      @2770   PRCCSR_CNS008                 N3PF.                               
      @2773   PRCCSR_CNS009                 N3PF.                               
      @2776   PRCCSR_CNS010                 N3PF.                               
      @2779   PRCCSR_CNS011                 N3PF.                               
      @2782   PRCCSR_CNS012                 N3PF.                               
      @2785   PRCCSR_CNS013                 N3PF.                               
      @2788   PRCCSR_CNS014                 N3PF.                               
      @2791   PRCCSR_ENP001                 N3PF.                               
      @2794   PRCCSR_ENP002                 N3PF.                               
      @2797   PRCCSR_ENP003                 N3PF.                               
      @2800   PRCCSR_ENP004                 N3PF.                               
      @2803   PRCCSR_ENP005                 N3PF.                               
      @2806   PRCCSR_ENP006                 N3PF.                               
      @2809   PRCCSR_ENT001                 N3PF.                               
      @2812   PRCCSR_ENT002                 N3PF.                               
      @2815   PRCCSR_ENT003                 N3PF.                               
      @2818   PRCCSR_ENT004                 N3PF.                               
      @2821   PRCCSR_ENT005                 N3PF.                               
      @2824   PRCCSR_ENT006                 N3PF.                               
      @2827   PRCCSR_ENT007                 N3PF.                               
      @2830   PRCCSR_ENT008                 N3PF.                               
      @2833   PRCCSR_ENT009                 N3PF.                               
      @2836   PRCCSR_ENT010                 N3PF.                               
      @2839   PRCCSR_ENT011                 N3PF.                               
      @2842   PRCCSR_ENT012                 N3PF.                               
      @2845   PRCCSR_ENT013                 N3PF.                               
      @2848   PRCCSR_ENT014                 N3PF.                               
      @2851   PRCCSR_ENT015                 N3PF.                               
      @2854   PRCCSR_ENT016                 N3PF.                               
      @2857   PRCCSR_ENT017                 N3PF.                               
      @2860   PRCCSR_ESA001                 N3PF.                               
      @2863   PRCCSR_ESA002                 N3PF.                               
      @2866   PRCCSR_ESA003                 N3PF.                               
      @2869   PRCCSR_ESA004                 N3PF.                               
      @2872   PRCCSR_ESA005                 N3PF.                               
      @2875   PRCCSR_ESA006                 N3PF.                               
      @2878   PRCCSR_ESA007                 N3PF.                               
      @2881   PRCCSR_ESA008                 N3PF.                               
      @2884   PRCCSR_ESA009                 N3PF.                               
      @2887   PRCCSR_ESA010                 N3PF.                               
      @2890   PRCCSR_ESA011                 N3PF.                               
      @2893   PRCCSR_EST001                 N3PF.                               
      @2896   PRCCSR_EST002                 N3PF.                               
      @2899   PRCCSR_EST003                 N3PF.                               
      @2902   PRCCSR_EST004                 N3PF.                               
      @2905   PRCCSR_EST005                 N3PF.                               
      @2908   PRCCSR_EYP001                 N3PF.                               
      @2911   PRCCSR_EYP002                 N3PF.                               
      @2914   PRCCSR_FRS001                 N3PF.                               
      @2917   PRCCSR_FRS002                 N3PF.                               
      @2920   PRCCSR_FRS003                 N3PF.                               
      @2923   PRCCSR_FRS004                 N3PF.                               
      @2926   PRCCSR_FRS005                 N3PF.                               
      @2929   PRCCSR_FRS006                 N3PF.                               
      @2932   PRCCSR_FRS007                 N3PF.                               
      @2935   PRCCSR_FRS008                 N3PF.                               
      @2938   PRCCSR_FRS009                 N3PF.                               
      @2941   PRCCSR_FRS010                 N3PF.                               
      @2944   PRCCSR_FRS011                 N3PF.                               
      @2947   PRCCSR_FRS012                 N3PF.                               
      @2950   PRCCSR_FRS013                 N3PF.                               
      @2953   PRCCSR_FRS014                 N3PF.                               
      @2956   PRCCSR_FRS015                 N3PF.                               
      @2959   PRCCSR_GIS001                 N3PF.                               
      @2962   PRCCSR_GIS002                 N3PF.                               
      @2965   PRCCSR_GIS003                 N3PF.                               
      @2968   PRCCSR_GIS004                 N3PF.                               
      @2971   PRCCSR_GIS005                 N3PF.                               
      @2974   PRCCSR_GIS006                 N3PF.                               
      @2977   PRCCSR_GIS007                 N3PF.                               
      @2980   PRCCSR_GIS008                 N3PF.                               
      @2983   PRCCSR_GIS009                 N3PF.                               
      @2986   PRCCSR_GIS010                 N3PF.                               
      @2989   PRCCSR_GIS011                 N3PF.                               
      @2992   PRCCSR_GIS012                 N3PF.                               
      @2995   PRCCSR_GIS013                 N3PF.                               
      @2998   PRCCSR_GIS014                 N3PF.                               
      @3001   PRCCSR_GIS015                 N3PF.                               
      @3004   PRCCSR_GIS016                 N3PF.                               
      @3007   PRCCSR_GIS017                 N3PF.                               
      @3010   PRCCSR_GIS018                 N3PF.                               
      @3013   PRCCSR_GIS019                 N3PF.                               
      @3016   PRCCSR_GIS020                 N3PF.                               
      @3019   PRCCSR_GIS021                 N3PF.                               
      @3022   PRCCSR_GIS022                 N3PF.                               
      @3025   PRCCSR_GIS023                 N3PF.                               
      @3028   PRCCSR_GIS024                 N3PF.                               
      @3031   PRCCSR_GIS025                 N3PF.                               
      @3034   PRCCSR_GIS026                 N3PF.                               
      @3037   PRCCSR_GIS027                 N3PF.                               
      @3040   PRCCSR_GIS028                 N3PF.                               
      @3043   PRCCSR_GIS029                 N3PF.                               
      @3046   PRCCSR_GNR001                 N3PF.                               
      @3049   PRCCSR_GNR002                 N3PF.                               
      @3052   PRCCSR_GNR003                 N3PF.                               
      @3055   PRCCSR_GNR004                 N3PF.                               
      @3058   PRCCSR_GNR005                 N3PF.                               
      @3061   PRCCSR_GNR006                 N3PF.                               
      @3064   PRCCSR_GNR007                 N3PF.                               
      @3067   PRCCSR_GNR008                 N3PF.                               
      @3070   PRCCSR_GNR009                 N3PF.                               
      @3073   PRCCSR_GNR010                 N3PF.                               
      @3076   PRCCSR_HEP001                 N3PF.                               
      @3079   PRCCSR_HEP002                 N3PF.                               
      @3082   PRCCSR_HEP003                 N3PF.                               
      @3085   PRCCSR_HEP004                 N3PF.                               
      @3088   PRCCSR_HEP005                 N3PF.                               
      @3091   PRCCSR_HEP006                 N3PF.                               
      @3094   PRCCSR_HEP007                 N3PF.                               
      @3097   PRCCSR_HEP008                 N3PF.                               
      @3100   PRCCSR_HEP009                 N3PF.                               
      @3103   PRCCSR_HEP010                 N3PF.                               
      @3106   PRCCSR_HEP011                 N3PF.                               
      @3109   PRCCSR_HEP012                 N3PF.                               
      @3112   PRCCSR_HEP013                 N3PF.                               
      @3115   PRCCSR_IMG001                 N3PF.                               
      @3118   PRCCSR_IMG002                 N3PF.                               
      @3121   PRCCSR_IMG003                 N3PF.                               
      @3124   PRCCSR_IMG004                 N3PF.                               
      @3127   PRCCSR_IMG005                 N3PF.                               
      @3130   PRCCSR_IMG006                 N3PF.                               
      @3133   PRCCSR_IMG007                 N3PF.                               
      @3136   PRCCSR_IMG008                 N3PF.                               
      @3139   PRCCSR_IMG009                 N3PF.                               
      @3142   PRCCSR_IMG010                 N3PF.                               
      @3145   PRCCSR_LYM001                 N3PF.                               
      @3148   PRCCSR_LYM002                 N3PF.                               
      @3151   PRCCSR_LYM003                 N3PF.                               
      @3154   PRCCSR_LYM004                 N3PF.                               
      @3157   PRCCSR_LYM005                 N3PF.                               
      @3160   PRCCSR_LYM006                 N3PF.                               
      @3163   PRCCSR_LYM007                 N3PF.                               
      @3166   PRCCSR_LYM008                 N3PF.                               
      @3169   PRCCSR_LYM009                 N3PF.                               
      @3172   PRCCSR_LYM010                 N3PF.                               
      @3175   PRCCSR_LYM011                 N3PF.                               
      @3178   PRCCSR_MAM001                 N3PF.                               
      @3181   PRCCSR_MAM002                 N3PF.                               
      @3184   PRCCSR_MAM003                 N3PF.                               
      @3187   PRCCSR_MAM004                 N3PF.                               
      @3190   PRCCSR_MAM005                 N3PF.                               
      @3193   PRCCSR_MAM006                 N3PF.                               
      @3196   PRCCSR_MAM007                 N3PF.                               
      @3199   PRCCSR_MAM008                 N3PF.                               
      @3202   PRCCSR_MAM009                 N3PF.                               
      @3205   PRCCSR_MAM010                 N3PF.                               
      @3208   PRCCSR_MAM011                 N3PF.                               
      @3211   PRCCSR_MAM012                 N3PF.                               
      @3214   PRCCSR_MAM013                 N3PF.                               
      @3217   PRCCSR_MAM014                 N3PF.                               
      @3220   PRCCSR_MAM015                 N3PF.                               
      @3223   PRCCSR_MHT001                 N3PF.                               
      @3226   PRCCSR_MHT002                 N3PF.                               
      @3229   PRCCSR_MHT003                 N3PF.                               
      @3232   PRCCSR_MHT004                 N3PF.                               
      @3235   PRCCSR_MHT005                 N3PF.                               
      @3238   PRCCSR_MRS001                 N3PF.                               
      @3241   PRCCSR_MRS002                 N3PF.                               
      @3244   PRCCSR_MRS003                 N3PF.                               
      @3247   PRCCSR_MRS004                 N3PF.                               
      @3250   PRCCSR_MRS005                 N3PF.                               
      @3253   PRCCSR_MRS006                 N3PF.                               
      @3256   PRCCSR_MRS007                 N3PF.                               
      @3259   PRCCSR_MST001                 N3PF.                               
      @3262   PRCCSR_MST002                 N3PF.                               
      @3265   PRCCSR_MST003                 N3PF.                               
      @3268   PRCCSR_MST004                 N3PF.                               
      @3271   PRCCSR_MST005                 N3PF.                               
      @3274   PRCCSR_MST006                 N3PF.                               
      @3277   PRCCSR_MST007                 N3PF.                               
      @3280   PRCCSR_MST008                 N3PF.                               
      @3283   PRCCSR_MST009                 N3PF.                               
      @3286   PRCCSR_MST010                 N3PF.                               
      @3289   PRCCSR_MST011                 N3PF.                               
      @3292   PRCCSR_MST012                 N3PF.                               
      @3295   PRCCSR_MST013                 N3PF.                               
      @3298   PRCCSR_MST014                 N3PF.                               
      @3301   PRCCSR_MST015                 N3PF.                               
      @3304   PRCCSR_MST016                 N3PF.                               
      @3307   PRCCSR_MST017                 N3PF.                               
      @3310   PRCCSR_MST018                 N3PF.                               
      @3313   PRCCSR_MST019                 N3PF.                               
      @3316   PRCCSR_MST020                 N3PF.                               
      @3319   PRCCSR_MST021                 N3PF.                               
      @3322   PRCCSR_MST022                 N3PF.                               
      @3325   PRCCSR_MST023                 N3PF.                               
      @3328   PRCCSR_MST024                 N3PF.                               
      @3331   PRCCSR_MST025                 N3PF.                               
      @3334   PRCCSR_MST026                 N3PF.                               
      @3337   PRCCSR_MST027                 N3PF.                               
      @3340   PRCCSR_MST028                 N3PF.                               
      @3343   PRCCSR_MST029                 N3PF.                               
      @3346   PRCCSR_MST030                 N3PF.                               
      @3349   PRCCSR_NCM001                 N3PF.                               
      @3352   PRCCSR_NCM002                 N3PF.                               
      @3355   PRCCSR_NCM003                 N3PF.                               
      @3358   PRCCSR_NCM004                 N3PF.                               
      @3361   PRCCSR_OST001                 N3PF.                               
      @3364   PRCCSR_OTR001                 N3PF.                               
      @3367   PRCCSR_OTR002                 N3PF.                               
      @3370   PRCCSR_OTR003                 N3PF.                               
      @3373   PRCCSR_OTR004                 N3PF.                               
      @3376   PRCCSR_OTR005                 N3PF.                               
      @3379   PRCCSR_PGN001                 N3PF.                               
      @3382   PRCCSR_PGN002                 N3PF.                               
      @3385   PRCCSR_PGN003                 N3PF.                               
      @3388   PRCCSR_PGN004                 N3PF.                               
      @3391   PRCCSR_PGN005                 N3PF.                               
      @3394   PRCCSR_PGN006                 N3PF.                               
      @3397   PRCCSR_PGN007                 N3PF.                               
      @3400   PRCCSR_PGN008                 N3PF.                               
      @3403   PRCCSR_PGN009                 N3PF.                               
      @3406   PRCCSR_PLC001                 N3PF.                               
      @3409   PRCCSR_PLC002                 N3PF.                               
      @3412   PRCCSR_PNS001                 N3PF.                               
      @3415   PRCCSR_PNS002                 N3PF.                               
      @3418   PRCCSR_PNS003                 N3PF.                               
      @3421   PRCCSR_PNS004                 N3PF.                               
      @3424   PRCCSR_PNS005                 N3PF.                               
      @3427   PRCCSR_PNS006                 N3PF.                               
      @3430   PRCCSR_RAD001                 N3PF.                               
      @3433   PRCCSR_RAD002                 N3PF.                               
      @3436   PRCCSR_RAD003                 N3PF.                               
      @3439   PRCCSR_RAD004                 N3PF.                               
      @3442   PRCCSR_RES001                 N3PF.                               
      @3445   PRCCSR_RES002                 N3PF.                               
      @3448   PRCCSR_RES003                 N3PF.                               
      @3451   PRCCSR_RES004                 N3PF.                               
      @3454   PRCCSR_RES005                 N3PF.                               
      @3457   PRCCSR_RES006                 N3PF.                               
      @3460   PRCCSR_RES007                 N3PF.                               
      @3463   PRCCSR_RES008                 N3PF.                               
      @3466   PRCCSR_RES009                 N3PF.                               
      @3469   PRCCSR_RES010                 N3PF.                               
      @3472   PRCCSR_RES011                 N3PF.                               
      @3475   PRCCSR_RES012                 N3PF.                               
      @3478   PRCCSR_RES013                 N3PF.                               
      @3481   PRCCSR_RES014                 N3PF.                               
      @3484   PRCCSR_RHB001                 N3PF.                               
      @3487   PRCCSR_RHB002                 N3PF.                               
      @3490   PRCCSR_RHB003                 N3PF.                               
      @3493   PRCCSR_RHB004                 N3PF.                               
      @3496   PRCCSR_SKB001                 N3PF.                               
      @3499   PRCCSR_SKB002                 N3PF.                               
      @3502   PRCCSR_SKB003                 N3PF.                               
      @3505   PRCCSR_SKB004                 N3PF.                               
      @3508   PRCCSR_SKB005                 N3PF.                               
      @3511   PRCCSR_SKB006                 N3PF.                               
      @3514   PRCCSR_SKB007                 N3PF.                               
      @3517   PRCCSR_SKB008                 N3PF.                               
      @3520   PRCCSR_SKB009                 N3PF.                               
      @3523   PRCCSR_SKB010                 N3PF.                               
      @3526   PRCCSR_SUD001                 N3PF.                               
      @3529   PRCCSR_SUD002                 N3PF.                               
      @3532   PRCCSR_SUD003                 N3PF.                               
      @3535   PRCCSR_SUD004                 N3PF.                               
      @3538   PRCCSR_URN001                 N3PF.                               
      @3541   PRCCSR_URN002                 N3PF.                               
      @3544   PRCCSR_URN003                 N3PF.                               
      @3547   PRCCSR_URN004                 N3PF.                               
      @3550   PRCCSR_URN005                 N3PF.                               
      @3553   PRCCSR_URN006                 N3PF.                               
      @3556   PRCCSR_URN007                 N3PF.                               
      @3559   PRCCSR_URN008                 N3PF.                               
      @3562   PRCCSR_URN009                 N3PF.                               
      @3565   PRCCSR_URN010                 N3PF.                               
      @3568   PRCCSR_URN011                 N3PF.                               
      @3571   PRCCSR_URN012                 N3PF.                               
      @3574   PRCCSR_VERSION                $CHAR6.                             
      ;                                                                         
                                                                                
                                                                                
RUN;
