/*******************************************************************
*   AR_SID_2004_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'AR_SID_2004_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEDAY                    18-  20
 AGEMONTH                  21-  23
 AHOUR                     24-  27
 AMONTH                    28-  29
 ASOURCE                   30-  31
 ASOURCE_                  32     (A)
 ASOURCEU                  33     (A)
 ATYPE                     34-  35
 AWEEKEND                  36-  37
 BILLTYPE                  38-  40 (A)
 BWT                       41-  44
 DHOUR                     45-  48
 DIED                      49-  50
 DISP_X                    51-  52 (A)
 DISPUB92                  53-  54
 DISPUNIF                  55-  56
 DQTR                      57-  58
 DRG                       59-  61
 DRG18                     62-  64
 DRGVER                    65-  66
 DSHOSPID                  67-  79 (A)
 DX1                       80-  84 (A)
 DX2                       85-  89 (A)
 DX3                       90-  94 (A)
 DX4                       95-  99 (A)
 DX5                      100- 104 (A)
 DX6                      105- 109 (A)
 DX7                      110- 114 (A)
 DX8                      115- 119 (A)
 DX9                      120- 124 (A)
 DXCCS1                   125- 128
 DXCCS2                   129- 132
 DXCCS3                   133- 136
 DXCCS4                   137- 140
 DXCCS5                   141- 144
 DXCCS6                   145- 148
 DXCCS7                   149- 152
 DXCCS8                   153- 156
 DXCCS9                   157- 160
 ECODE1                   161- 165 (A)
 ECODE2                   166- 170 (A)
 ECODE3                   171- 175 (A)
 ECODE4                   176- 180 (A)
 ECODE5                   181- 185 (A)
 ECODE6                   186- 190 (A)
 E_CCS1                   191- 194
 E_CCS2                   195- 198
 E_CCS3                   199- 202
 E_CCS4                   203- 206
 E_CCS5                   207- 210
 E_CCS6                   211- 214
 FEMALE                   215- 216
 HISPANIC                 217     (A)
 HOSPST                   218- 219 (A)
 LOS                      220- 224
 LOS_X                    225- 230
 MARITALS                 231     (A)
 MDC                      232- 233
 MDC18                    234- 235
 MDNUM1_R                 236- 244
 MDNUMTYP                 245     (A)
 MDNUM2_R                 246- 254
 MDNUM3_R                 255- 263
 MDNUM4_R                 264- 272
 MRN_R                    273- 281
 NDX                      282- 283
 NECODE                   284- 285
 NEOMAT                   286- 287
 NPR                      288- 289
 PAY1                     290- 291
 PAY2                     292- 293
 PAY1_X                   294- 295 (A)
 PAY2_X                   296- 297 (A)
 PAY3_X                   298- 299 (A)
 PL_CBSA                  300- 302
 PL_MSA19                 303- 305
 PL_RUCA                  306- 309
 PL_RUCA1                 310- 311
 PL_RUCA4                 312- 313
 PL_RUCC2                 314- 315
 PL_UIC20                 316- 317
 PL_UR_CA                 318- 319
 PL_UR_CA                 320- 321
 PNUM_R                   322- 330
 PR1                      331- 334 (A)
 PR2                      335- 338 (A)
 PR3                      339- 342 (A)
 PR4                      343- 346 (A)
 PR5                      347- 350 (A)
 PR6                      351- 354 (A)
 PRCCS1                   355- 357
 PRCCS2                   358- 360
 PRCCS3                   361- 363
 PRCCS4                   364- 366
 PRCCS5                   367- 369
 PRCCS6                   370- 372
 PRDAY1                   373- 377
 PSTATE                   378- 379 (A)
 PSTCO2                   380- 384
 RACE                     385- 386
 RACE_X                   387     (A)
 TOTCHG                   388- 397
 TOTCHG_X                 398- 412
 YEAR                     413- 416
 ZIP3                     417- 419 (A)
 ZIP_S                    420- 424 (A)
 AYEAR                    425- 428
 DMONTH                   429- 430
 BMONTH                   431- 432
 BYEAR                    433- 436
 PRMNTH1                  437- 438
 PRMNTH2                  439- 440
 PRMNTH3                  441- 442
 PRMNTH4                  443- 444
 PRMNTH5                  445- 446
 PRMNTH6                  447- 448
 PRYEAR1                  449- 452
 PRYEAR2                  453- 456
 PRYEAR3                  457- 460
 PRYEAR4                  461- 464
 PRYEAR5                  465- 468
 PRYEAR6                  469- 472.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG18                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 FEMALE                  (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC18                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MDNUM3_R                (F5.0) /
 MDNUM4_R                (F5.0) /
 MRN_R                   (F5.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_RUCA                 (F4.1) /
 PL_RUCA1                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRDAY1                  (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AHOUR     "Admission Hour"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 BILLTYPE  "UB-92 bill type"
 BWT       "Birth weight in grams"
 DHOUR     "Discharge Hour"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRGVER    "DRG grouper version used on discharge date"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 FEMALE    "Indicator of sex"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MARITALS  "Patient's marital status"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUMTYP  "Physician 1 number type"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MDNUM3_R  "Physician 3 number (re-identified)"
 MDNUM4_R  "Physician 4 number (re-identified)"
 MRN_R     "Medical record number (re-identified)"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PAY3_X    "Tertiary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA   "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PNUM_R    "Person number (re-identified)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRDAY1    "Number of days from admission to PR1"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 ZIP_S     "Patient ZIP Code (synthetic)"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'AR_SID_2004_CORE.SAV' /COMPRESSED.
