/*******************************************************************
* Creation Date: 06/03/2020   
*   AR_SID_2015q4_AHAL.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY AHAL FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'AR_SID_2015q4_AHAL.ASC' FIXED SKIP=2 / 
 AHAID                           1-   7 (A)
 DSHOSPID                        8-  24 (A)
 HOSPID                         25-  29
 COMMUNITY_NONREHAB_NONLTAC     30-  33
 HFIPSSTCO                      34-  38
 HOSPST                         39-  40 (A)
 YEAR                           41-  44.


***  Specify write formats  ***.
FORMATS
 HOSPID                       (F4.0) /
 COMMUNITY_NONREHAB_NONLTAC   (F3.0) /
 HFIPSSTCO                    (F4.0) /
 YEAR                         (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AHAID                        "AHA hospital identifier with the leading 6"
 DSHOSPID                     "Data source hospital identifier"
 HOSPID                       "HCUP hospital identification number"
 COMMUNITY_NONREHAB_NONLTAC
"Indicator of U.S. community hospital that is not a rehabilitation or long-term acute care hospital (Z997)"
 HFIPSSTCO                    "Hospital FIPS state/county code"
 HOSPST                       "Hospital state postal code"
 YEAR                         "Calendar year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE COMMUNITY_NONREHAB_NONLTAC
 (-999,-888,-666,-555=SYSMIS).
RECODE HFIPSSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).



SAVE OUTFILE = 'AR_SID_2015q4_AHAL.SAV' /COMPRESSED.
